/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.destination;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.destination.RandomPortalDestination;
import org.mvplugins.multiverse.portals.utils.PortalManager;

public class RandomPortalDestinationInstance
extends DestinationInstance<RandomPortalDestinationInstance, RandomPortalDestination> {
    private final PortalManager portalManager;
    private final List<String> portalNames;

    public RandomPortalDestinationInstance(@NotNull RandomPortalDestination destination, @NotNull PortalManager portalManager, @NotNull List<String> portalNames) {
        super((Destination)destination);
        this.portalManager = portalManager;
        this.portalNames = portalNames;
    }

    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        List<String> portalNames = this.portalNames.isEmpty() ? this.portalManager.getAllPortals().stream().map(MVPortal::getName).toList() : this.portalNames;
        String targetPortalName = portalNames.get(ACFUtil.RANDOM.nextInt(portalNames.size()));
        return Option.of((Object)this.portalManager.getPortal(targetPortalName)).map(MVPortal::getSafePlayerSpawnLocation);
    }

    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    public boolean checkTeleportSafety() {
        return true;
    }

    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.none();
    }

    @NotNull
    protected String serialise() {
        return String.join((CharSequence)",", this.portalNames);
    }
}

