/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.WorldEditConnection;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.event.MVPortalEvent;
import org.mvplugins.multiverse.portals.listeners.PlayerListenerHelper;
import org.mvplugins.multiverse.portals.listeners.PortalsListener;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalFiller;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
public class MVPPlayerListener
implements PortalsListener {
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;
    private final PortalFiller filler;
    private final PortalManager portalManager;
    private final PlayerListenerHelper helper;
    private final LocationManipulation locationManipulation;
    private final WorldManager worldManager;
    private final BlockSafety blockSafety;
    private final MVEconomist economist;

    @Inject
    MVPPlayerListener(@NotNull MultiversePortals plugin, @NotNull PortalsConfig portalsConfig, @NotNull PlayerListenerHelper helper, @NotNull PortalManager portalManager, @NotNull PortalFiller filler, @NotNull LocationManipulation locationManipulation, @NotNull WorldManager worldManager, @NotNull BlockSafety blockSafety, @NotNull MVEconomist economist) {
        this.plugin = plugin;
        this.portalsConfig = portalsConfig;
        this.helper = helper;
        this.portalManager = portalManager;
        this.filler = filler;
        this.locationManipulation = locationManipulation;
        this.worldManager = worldManager;
        this.blockSafety = blockSafety;
        this.economist = economist;
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        this.plugin.destroyPortalSession(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerTeleportEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        ps.playerDidTeleport(event.getTo());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerBucketFill(PlayerBucketFillEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerBucketFillEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        MVPLogging.finer("Fill: ", new Object[0]);
        MVPLogging.finer("Block Clicked: " + String.valueOf(event.getBlockClicked()) + ":" + String.valueOf(event.getBlockClicked().getType()), new Object[0]);
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), event.getBlockClicked().getLocation());
        if (portal != null) {
            if (ps.isDebugModeOn()) {
                ps.showDebugInfo(portal);
                event.setCancelled(true);
            } else {
                Material fillMaterial = Material.AIR;
                MVPLogging.finer("Fill Material: " + String.valueOf(fillMaterial), new Object[0]);
                this.filler.fillRegion(portal.getPortalLocation().getRegion(), event.getBlockClicked().getLocation(), fillMaterial, event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerBucketEmptyEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        if (!this.portalsConfig.getBucketFilling()) {
            MVPLogging.fine("The bucket filling functionality has been disabled in config, doing nothing", new Object[0]);
            return;
        }
        Location translatedLocation = this.getTranslatedLocation(event.getBlockClicked(), event.getBlockFace());
        MVPLogging.finer("Fill: ", new Object[0]);
        MVPLogging.finer("Block Clicked: " + String.valueOf(event.getBlockClicked()) + ":" + String.valueOf(event.getBlockClicked().getType()), new Object[0]);
        MVPLogging.finer("Translated Block: " + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation)) + ":" + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation).getType()), new Object[0]);
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), translatedLocation);
        if (portal != null) {
            if (ps.isDebugModeOn()) {
                ps.showDebugInfo(portal);
                event.setCancelled(true);
            } else {
                if (!portal.playerCanFillPortal(event.getPlayer())) {
                    event.setCancelled(true);
                    return;
                }
                Material fillMaterial = Material.WATER;
                if (event.getBucket().equals((Object)Material.LAVA_BUCKET)) {
                    fillMaterial = Material.LAVA;
                }
                MVPLogging.finer("Fill Material: " + String.valueOf(fillMaterial), new Object[0]);
                this.filler.fillRegion(portal.getPortalLocation().getRegion(), translatedLocation, fillMaterial, event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("The PlayerInteractEvent was already cancelled. Doing nothing.", new Object[0]);
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getMaterial() == Material.FLINT_AND_STEEL) {
            MVPLogging.finer("Player is lighting block: " + this.locationManipulation.strCoordsRaw(event.getClickedBlock().getLocation()), new Object[0]);
            PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
            Location translatedLocation = this.getTranslatedLocation(event.getClickedBlock(), event.getBlockFace());
            if (!this.portalManager.isPortal(translatedLocation)) {
                return;
            }
            MVPortal portal = this.portalManager.getPortal(event.getPlayer(), translatedLocation);
            if (event.getItem() == null) {
                return;
            }
            if (!event.getPlayer().hasPermission("multiverse.portal.create")) {
                return;
            }
            Material inHand = event.getItem().getType();
            if (portal != null) {
                if (!portal.isFrameValid(translatedLocation)) {
                    return;
                }
                MVPLogging.finer("Right Clicked: ", new Object[0]);
                MVPLogging.finer("Block Clicked: " + String.valueOf(event.getClickedBlock()) + ":" + String.valueOf(event.getClickedBlock().getType()), new Object[0]);
                MVPLogging.finer("Translated Block: " + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation)) + ":" + String.valueOf(event.getPlayer().getWorld().getBlockAt(translatedLocation).getType()), new Object[0]);
                MVPLogging.finer("In Hand: " + String.valueOf(inHand), new Object[0]);
                if (ps.isDebugModeOn()) {
                    ps.showDebugInfo(portal);
                    event.setCancelled(true);
                } else {
                    Material fillMaterial = Material.NETHER_PORTAL;
                    if (translatedLocation.getWorld().getBlockAt(translatedLocation).getType() == Material.NETHER_PORTAL) {
                        fillMaterial = Material.AIR;
                    }
                    MVPLogging.finer("Fill Material: " + String.valueOf(fillMaterial), new Object[0]);
                    event.setCancelled(this.filler.fillRegion(portal.getPortalLocation().getRegion(), translatedLocation, fillMaterial, event.getPlayer()));
                }
            }
            return;
        }
        Material itemType = this.portalsConfig.getWandMaterial();
        WorldEditConnection worldEdit = this.plugin.getWorldEditConnection();
        if (worldEdit != null && worldEdit.isConnected() || event.getPlayer().getInventory().getItemInMainHand().getType() != itemType || !event.getPlayer().hasPermission("multiverse.portal.create") || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            LoadedMultiverseWorld world = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(event.getPlayer().getWorld().getName()).getOrNull();
            event.setCancelled(this.plugin.getPortalSession(event.getPlayer()).setLeftClickSelection(event.getClickedBlock().getLocation().toVector(), world));
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            LoadedMultiverseWorld world = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(event.getPlayer().getWorld().getName()).getOrNull();
            event.setCancelled(this.plugin.getPortalSession(event.getPlayer()).setRightClickSelection(event.getClickedBlock().getLocation().toVector(), world));
        }
    }

    private Location getTranslatedLocation(Block clickedBlock, BlockFace face) {
        Location clickedLoc = clickedBlock.getLocation();
        Location newLoc = new Location(clickedBlock.getWorld(), (double)(face.getModX() + clickedLoc.getBlockX()), (double)(face.getModY() + clickedLoc.getBlockY()), (double)(face.getModZ() + clickedLoc.getBlockZ()));
        MVPLogging.finest("Clicked Block: " + String.valueOf(clickedBlock.getLocation()), new Object[0]);
        MVPLogging.finest("Translated Block: " + String.valueOf(newLoc), new Object[0]);
        return newLoc;
    }

    @EventHandler
    public void playerPortal(PlayerPortalEvent event) {
        if (event.isCancelled()) {
            MVPLogging.fine("This Portal event was already cancelled.", new Object[0]);
            return;
        }
        MVPLogging.finer("onPlayerPortal called!", new Object[0]);
        Location playerPortalLoc = event.getPlayer().getLocation();
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), playerPortalLoc, false);
        Player p = event.getPlayer();
        if (portal == null && (playerPortalLoc = this.blockSafety.findPortalBlockNextTo(event.getFrom())) != null) {
            MVPLogging.finer("Player was outside of portal, The location has been successfully translated.", new Object[0]);
            portal = this.portalManager.getPortal(event.getPlayer(), playerPortalLoc, false);
        }
        if (portal != null) {
            MVPLogging.finer("There was a portal found!", new Object[0]);
            DestinationInstance<?, ?> portalDest = portal.getDestination();
            if (portalDest != null) {
                event.setCancelled(true);
                if (!portal.isFrameValid(playerPortalLoc)) {
                    event.getPlayer().sendMessage("This portal's frame is made of an " + String.valueOf(ChatColor.RED) + "incorrect material." + String.valueOf(ChatColor.RED) + " You should exit it now.");
                    return;
                }
                Location destLocation = (Location)portalDest.getLocation((Entity)event.getPlayer()).getOrNull();
                if (destLocation == null) {
                    MVPLogging.fine("Unable to teleport player because destination is null!", new Object[0]);
                    return;
                }
                if (!this.worldManager.isLoadedWorld(destLocation.getWorld())) {
                    MVPLogging.fine("Unable to teleport player because the destination world is not managed by Multiverse!", new Object[0]);
                    return;
                }
                if (portal.getCheckDestinationSafety() && portalDest.checkTeleportSafety()) {
                    Location safeLocation = this.blockSafety.findSafeSpawnLocation((Location)portalDest.getLocation((Entity)event.getPlayer()).getOrNull());
                    if (safeLocation == null) {
                        event.setCancelled(true);
                        MVPLogging.warning("Portal " + portal.getName() + " destination is not safe!", new Object[0]);
                        event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Portal " + portal.getName() + " destination is not safe!");
                        return;
                    }
                    destLocation = safeLocation;
                }
                event.setTo(destLocation);
                PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
                if (ps.checkAndSendCooldownMessage()) {
                    MVPLogging.fine("Player denied teleportation due to cooldown.", new Object[0]);
                    return;
                }
                if (this.portalsConfig.getEnforcePortalAccess() && !event.getPlayer().hasPermission(portal.getPermission())) {
                    this.helper.stateFailure(p.getDisplayName(), portal.getName());
                    return;
                }
                boolean shouldPay = false;
                double price = portal.getPrice();
                Material currency = portal.getCurrency();
                if (price != 0.0 && !p.hasPermission(portal.getExempt())) {
                    shouldPay = true;
                    if (price > 0.0 && !this.economist.isPlayerWealthyEnough(p, price, currency)) {
                        p.sendMessage(this.economist.getNSFMessage(currency, "You need " + this.economist.formatPrice(price, currency) + " to enter the " + portal.getName() + " portal."));
                        return;
                    }
                }
                MVPortalEvent portalEvent = new MVPortalEvent(portalDest, event.getPlayer(), portal);
                this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
                if (portalEvent.isCancelled()) {
                    MVPLogging.fine("Someone cancelled the MVPlayerPortal Event!", new Object[0]);
                    return;
                }
                if (shouldPay) {
                    if (price < 0.0) {
                        this.economist.deposit(p, -price, currency);
                    } else {
                        this.economist.withdraw(p, price, currency);
                    }
                    p.sendMessage(String.format("You have %s %s for using %s.", price > 0.0 ? "been charged" : "earned", this.economist.formatPrice(price, currency), portal.getName()));
                }
                event.getPlayer().teleport(event.getTo());
            } else if (!this.portalsConfig.getPortalsDefaultToNether()) {
                event.getPlayer().sendMessage(String.format("This portal %sdoesn't go anywhere. You should exit it now.", ChatColor.RED));
                MVPLogging.fine("Event canceled because this was a MVPortal with an invalid destination. But you had 'portalsdefaulttonether' set to false!", new Object[0]);
                event.setCancelled(true);
            }
        }
    }
}

