/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.generator.interfaces;

import de.xtkq.voidgen.generator.settings.ChunkGenSettings;
import de.xtkq.voidgen.libs.gson.Gson;
import de.xtkq.voidgen.libs.gson.GsonBuilder;
import de.xtkq.voidgen.libs.gson.JsonSyntaxException;
import de.xtkq.voidgen.libs.gson.Strictness;
import de.xtkq.voidgen.utils.ChunkGenAdapter;
import java.lang.reflect.Type;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkGen
extends ChunkGenerator {
    private final JavaPlugin javaPlugin;
    protected ChunkGenSettings chunkGenSettings;

    public ChunkGen(JavaPlugin javaPlugin, String paramIdentifier, String worldName) {
        this.javaPlugin = javaPlugin;
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)ChunkGenSettings.class), new ChunkGenAdapter(this.javaPlugin));
        builder.setStrictness(Strictness.LENIENT);
        Gson gson = builder.create();
        this.javaPlugin.getLogger().info("");
        this.javaPlugin.getLogger().info("> \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014[ " + worldName + " ]\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        this.javaPlugin.getLogger().info("> ");
        if (paramIdentifier == null || paramIdentifier.isBlank()) {
            this.chunkGenSettings = new ChunkGenSettings(this.getDefaultBiome());
            this.javaPlugin.getLogger().info("> Generator settings have not been set, we will use the default settings:");
        } else {
            try {
                this.chunkGenSettings = gson.fromJson(paramIdentifier, ChunkGenSettings.class);
                this.javaPlugin.getLogger().info("> Generator settings have been loaded:");
            }
            catch (JsonSyntaxException jse) {
                this.chunkGenSettings = new ChunkGenSettings(this.getDefaultBiome());
                this.javaPlugin.getLogger().info("> Generator settings syntax is not valid, we will use the default settings:");
            }
        }
        this.javaPlugin.getLogger().info("> " + gson.toJson(this.chunkGenSettings));
        this.javaPlugin.getLogger().info("> ");
        this.javaPlugin.getLogger().info("> \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014[ " + worldName + " ]\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        this.javaPlugin.getLogger().info("");
    }

    public abstract Biome getDefaultBiome();

    public Location getFixedSpawnLocation(@NotNull World world, @NotNull Random random) {
        return new Location(world, 0.0, 64.0, 0.0);
    }

    public boolean shouldGenerateCaves() {
        return this.chunkGenSettings.isCaves();
    }

    public boolean shouldGenerateDecorations() {
        return this.chunkGenSettings.isDecoration();
    }

    public boolean shouldGenerateMobs() {
        return this.chunkGenSettings.isMobs();
    }

    public boolean shouldGenerateStructures() {
        return this.chunkGenSettings.isStructures();
    }

    public boolean shouldGenerateNoise() {
        return this.chunkGenSettings.isNoise();
    }

    public boolean shouldGenerateSurface() {
        return this.chunkGenSettings.isSurface();
    }

    public boolean shouldGenerateBedrock() {
        return this.chunkGenSettings.isBedrock();
    }

    public void generateBedrock(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        boolean x = false;
        int y = 64;
        boolean z = false;
        if (0 >= chunkX * 16 && 0 < (chunkX + 1) * 16 && 0 >= chunkZ * 16 && 0 < (chunkZ + 1) * 16) {
            chunkData.setBlock(0, 64, 0, Material.BEDROCK);
        }
    }
}

