/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.settings;

import de.xtkq.voidgen.libs.gson.Gson;
import de.xtkq.voidgen.libs.gson.GsonBuilder;
import de.xtkq.voidgen.settings.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final Logger LOGGER;
    private final File CONFIGURATION_FILE;
    private Configuration configuration;

    public ConfigManager(JavaPlugin paramPlugin) {
        this.LOGGER = paramPlugin.getLogger();
        this.CONFIGURATION_FILE = new File(paramPlugin.getDataFolder(), "configuration.json");
        this.CONFIGURATION_FILE.getParentFile().mkdirs();
        this.initConfiguration();
    }

    public Configuration getConfiguration() {
        if (Objects.isNull(this.configuration)) {
            this.LOGGER.log(Level.WARNING, "Configuration is Null. The configuration on disk will not be used.");
            return new Configuration();
        }
        return this.configuration;
    }

    private void initConfiguration() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileReader fileReader = new FileReader(this.CONFIGURATION_FILE);
            this.configuration = gson.fromJson((Reader)fileReader, Configuration.class);
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.LOGGER.log(Level.INFO, "The file:\"" + this.CONFIGURATION_FILE.getName() + "\"was not found.");
            this.LOGGER.log(Level.INFO, "A new file will be generated and the default configuration will be used instead.");
            this.configuration = new Configuration();
        }
        catch (IOException ioException) {
            this.LOGGER.log(Level.WARNING, "An IOException was thrown. The FileReader was unable to read the file:\"configuration.json\"", ioException);
        }
        try {
            FileWriter fileWriter = new FileWriter(this.CONFIGURATION_FILE);
            gson.toJson((Object)this.configuration, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (IOException ioException) {
            this.LOGGER.log(Level.WARNING, "An IOException was thrown. The FileWriter was unable to write to the file:\"configuration.json\"", ioException);
        }
    }
}

