/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.utils;

import de.xtkq.voidgen.VoidGen;
import de.xtkq.voidgen.libs.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;

public class UpdateUtils {
    private static final String GITHUB_API = "https://api.github.com/repos/NicoNekoDev/%s/releases/latest";
    private static boolean updateAvailable = false;
    private static String latestRelease;
    private static String latestReleaseURL;
    private final VoidGen voidGen;

    public UpdateUtils(VoidGen voidGen) {
        this.voidGen = voidGen;
        latestRelease = voidGen.getDescription().getVersion();
    }

    public void checkForUpdates() {
        this.voidGen.getFoliaLib().getScheduler().runTimerAsync(() -> {
            Gson gson = new Gson();
            try {
                URL url = new URI(String.format(GITHUB_API, this.voidGen.getName())).toURL();
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
                httpsURLConnection.setRequestMethod("GET");
                httpsURLConnection.setRequestProperty("accept", "application/vnd.github.v3+json");
                if (httpsURLConnection.getResponseCode() == 200) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
                    Map map = gson.fromJson(bufferedReader.readLine(), Map.class);
                    bufferedReader.close();
                    if (this.isUpdateAvailable(this.voidGen.getDescription().getVersion(), ((String)map.get("name")).substring(1))) {
                        updateAvailable = true;
                        latestRelease = ((String)map.get("name")).substring(1);
                        latestReleaseURL = (String)map.get("html_url");
                        this.voidGen.getLogger().warning("Update v" + latestRelease + " is available: " + latestReleaseURL);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 2L, 180L, TimeUnit.MINUTES);
    }

    private boolean isUpdateAvailable(String paramPluginVersion, String paramGithubVersion) {
        int result;
        int i;
        String[] localVersion = paramPluginVersion.split("\\.");
        String[] serverVersion = paramGithubVersion.split("\\.");
        for (i = 0; i < localVersion.length && i < serverVersion.length && localVersion[i].equals(serverVersion[i]); ++i) {
        }
        if (i < localVersion.length && i < serverVersion.length) {
            int diff = Integer.valueOf(localVersion[i]).compareTo(Integer.valueOf(serverVersion[i]));
            result = Integer.signum(diff);
        } else {
            result = Integer.signum(localVersion.length - serverVersion.length);
        }
        return result == -1;
    }

    @Generated
    public static boolean isUpdateAvailable() {
        return updateAvailable;
    }

    @Generated
    public static String getLatestRelease() {
        return latestRelease;
    }

    @Generated
    public static String getLatestReleaseURL() {
        return latestReleaseURL;
    }
}

