/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.Arrays;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class RemoveWorldsCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;

    @Inject
    RemoveWorldsCommand(@NotNull WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="remove-worlds")
    @CommandPermission(value="multiverse.inventories.removeworlds")
    @CommandCompletion(value="@worldGroups @worldGroupWorlds")
    @Syntax(value="<group>, <world[,extra]>")
    @Description(value="Adds a World to a World Group.")
    void onRemoveWorldCommand(MVCommandIssuer issuer, @Syntax(value="<group>") @Description(value="Group you want to remove the world from.") @NotNull WorldGroup group, @Single @Syntax(value="<world[,extra]>") @Description(value="World name to remove.") String worldNames) {
        List<String> worldNamesArr = Arrays.stream(worldNames.split(",")).toList();
        if (!group.removeWorlds(worldNamesArr)) {
            issuer.sendError((MessageKeyProvider)MVInvi18n.REMOVEWORLD_WORLDNOTINGROUP, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{world}").with((Object)worldNames)});
            return;
        }
        this.worldGroupManager.updateGroup(group);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.REMOVEWORLD_WORLDREMOVED, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{world}").with((Object)worldNames)});
    }
}

