/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.share.ProfileEntry;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.SharableSerializer;
import org.mvplugins.multiverse.inventories.utils.InvLogging;
import org.mvplugins.multiverse.inventories.utils.minidev.json.JSONObject;
import org.mvplugins.multiverse.inventories.utils.minidev.json.parser.JSONParser;
import org.mvplugins.multiverse.inventories.utils.minidev.json.parser.ParseException;

final class PlayerProfileJsonSerializer {
    PlayerProfileJsonSerializer() {
    }

    static Map<String, Object> serialize(PlayerProfile playerProfile) {
        LinkedHashMap<String, Object> playerData = new LinkedHashMap<String, Object>();
        JSONObject jsonStats = new JSONObject();
        for (Map.Entry<Sharable, Object> entry : playerProfile.getData().entrySet()) {
            Sharable sharable = entry.getKey();
            Object sharableValue = entry.getValue();
            if (sharableValue == null) continue;
            SharableSerializer<Object> serializer = sharable.getSerializer();
            ProfileEntry profileEntry = sharable.getProfileEntry();
            if (serializer == null || profileEntry == null) continue;
            String fileTag = profileEntry.fileTag();
            Object serializedValue = serializer.serialize(sharableValue);
            if (profileEntry.isStat()) {
                jsonStats.put(fileTag, serializedValue);
                continue;
            }
            playerData.put(fileTag, serializedValue);
        }
        if (!jsonStats.isEmpty()) {
            playerData.put("stats", jsonStats);
        }
        return playerData;
    }

    static PlayerProfile deserialize(ProfileKey pKey, Map playerData) {
        PlayerProfile profile = PlayerProfile.newProfile(pKey);
        for (Object keyObj : playerData.keySet()) {
            String key = keyObj.toString();
            Object value = playerData.get(key);
            if (value == null) {
                InvLogging.fine("Player data '" + key + "' is null for: " + pKey.getPlayerName(), new Object[0]);
                continue;
            }
            if (key.equalsIgnoreCase("stats")) {
                if (value instanceof String) {
                    PlayerProfileJsonSerializer.parseJsonPlayerStatsIntoProfile((String)value, profile);
                    continue;
                }
                if (value instanceof Map) {
                    PlayerProfileJsonSerializer.parsePlayerStatsIntoProfile((Map)value, profile);
                    continue;
                }
                InvLogging.warning("Could not parse stats for " + pKey.getPlayerName(), new Object[0]);
                continue;
            }
            try {
                Sharable sharable = ProfileEntry.lookup(false, key);
                if (sharable == null) {
                    InvLogging.fine("Player fileTag '" + key + "' is unrecognized!", new Object[0]);
                    continue;
                }
                profile.set(sharable, sharable.getSerializer().deserialize(playerData.get(key)));
            }
            catch (Exception e) {
                InvLogging.fine("Could not parse fileTag: '" + key + "' with value '" + String.valueOf(playerData.get(key)) + "'", new Object[0]);
                InvLogging.getLogger().log(Level.FINE, "Exception: ", e);
                e.printStackTrace();
            }
        }
        InvLogging.finer("Created player profile from map for '" + pKey.getPlayerName() + "'.", new Object[0]);
        return profile;
    }

    private static void parsePlayerStatsIntoProfile(Map stats, PlayerProfile profile) {
        for (Object key : stats.keySet()) {
            Sharable sharable = ProfileEntry.lookup(true, key.toString());
            if (sharable != null) {
                profile.set(sharable, sharable.getSerializer().deserialize(stats.get(key).toString()));
                continue;
            }
            InvLogging.warning("Could not parse stat: '" + String.valueOf(key) + "' for player '" + profile.getPlayerName() + "' for " + String.valueOf((Object)profile.getContainerType()) + " '" + profile.getContainerName() + "'", new Object[0]);
        }
    }

    private static void parseJsonPlayerStatsIntoProfile(String stats, PlayerProfile profile) {
        if (stats.isEmpty()) {
            return;
        }
        JSONObject jsonStats = null;
        try {
            jsonStats = (JSONObject)new JSONParser(528).parse(stats);
        }
        catch (ClassCastException | ParseException e) {
            InvLogging.warning("Could not parse stats for player'" + profile.getPlayerName() + "' for " + String.valueOf((Object)profile.getContainerType()) + " '" + profile.getContainerName() + "': " + e.getMessage(), new Object[0]);
        }
        if (jsonStats == null) {
            InvLogging.warning("Could not parse stats for player'" + profile.getPlayerName() + "' for " + String.valueOf((Object)profile.getContainerType()) + " '" + profile.getContainerName() + "'", new Object[0]);
            return;
        }
        PlayerProfileJsonSerializer.parsePlayerStatsIntoProfile(jsonStats, profile);
    }
}

