/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.group;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.event.EventPriority;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class WorldGroup {
    private final WorldGroupManager worldGroupManager;
    private final ProfileContainerStoreProvider profileContainerStoreProvider;
    private final InventoriesConfig inventoriesConfig;
    private final String name;
    private final HashSet<String> worlds = new HashSet();
    private final Shares shares = Sharables.noneOf();
    private final Shares disabledShares = Sharables.noneOf();
    private Shares applicableShares = Sharables.noneOf();
    private String spawnWorld = null;
    private EventPriority spawnPriority = EventPriority.NORMAL;

    WorldGroup(WorldGroupManager worldGroupManager, ProfileContainerStoreProvider profileContainerStoreProvider, InventoriesConfig inventoriesConfig, String name) {
        this.worldGroupManager = worldGroupManager;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.inventoriesConfig = inventoriesConfig;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addWorld(String worldName) {
        this.addWorld(worldName, true);
    }

    public void addWorld(String worldName, boolean updateConfig) {
        this.getWorlds().add(worldName.toLowerCase());
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public void addWorld(World world) {
        this.addWorld(world.getName());
    }

    public void addWorlds(Collection<String> worlds) {
        this.addWorlds(worlds, true);
    }

    public void addWorlds(Collection<String> worlds, boolean updateConfig) {
        worlds.forEach(worldName -> this.addWorld((String)worldName, false));
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public void removeWorld(String worldName) {
        this.removeWorld(worldName, true);
    }

    public void removeWorld(String worldName, boolean updateConfig) {
        this.getWorlds().remove(worldName.toLowerCase());
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public void removeWorld(World world) {
        this.removeWorld(world.getName());
    }

    public boolean removeWorlds(Collection<String> removeWorlds) {
        return this.getWorlds().removeAll(removeWorlds);
    }

    public void removeAllWorlds() {
        this.removeAllWorlds(true);
    }

    public void removeAllWorlds(boolean updateConfig) {
        this.worlds.clear();
        if (updateConfig) {
            this.worldGroupManager.updateGroup(this);
        }
    }

    public Set<String> getWorlds() {
        return this.worlds;
    }

    public boolean isSharing(Sharable sharable) {
        return this.getApplicableShares().isSharing(sharable);
    }

    public Shares getShares() {
        return this.shares;
    }

    public Shares getDisabledShares() {
        return this.disabledShares;
    }

    public Shares getApplicableShares() {
        return this.applicableShares;
    }

    public void recalculateApplicableShares() {
        this.applicableShares = Sharables.fromShares(this.shares);
        this.applicableShares.removeAll(this.disabledShares);
        Shares disabledOptionalShares = Sharables.optionalOf();
        disabledOptionalShares.removeAll(this.inventoriesConfig.getActiveOptionalShares());
        this.applicableShares.removeAll(disabledOptionalShares);
        InvLogging.finest("Applicable shares for " + this.getName() + ": " + String.valueOf(this.applicableShares), new Object[0]);
    }

    public boolean containsWorld(String worldName) {
        return this.getWorlds().contains(worldName.toLowerCase());
    }

    public String getSpawnWorld() {
        return this.spawnWorld;
    }

    public void setSpawnWorld(String worldName) {
        this.spawnWorld = worldName.toLowerCase();
    }

    public EventPriority getSpawnPriority() {
        return this.spawnPriority;
    }

    public void setSpawnPriority(EventPriority priority) {
        this.spawnPriority = priority;
    }

    public boolean isDefault() {
        return "default".equals(this.getName());
    }

    public ProfileContainer getGroupProfileContainer() {
        return this.profileContainerStoreProvider.getStore(ContainerType.GROUP).getContainer(this.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append(": {Worlds: [");
        String[] worldsString = this.getWorlds().toArray(new String[0]);
        for (int i = 0; i < worldsString.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(worldsString[i]);
        }
        builder.append("], Shares: [").append(this.getShares()).append("]");
        if (this.getSpawnWorld() != null) {
            builder.append(", Spawn World: ").append(this.getSpawnWorld());
            builder.append(", Spawn Priority: ").append(this.getSpawnPriority().toString());
        }
        builder.append("}");
        return builder.toString();
    }
}

