/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.share;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.mvplugins.multiverse.inventories.share.SharableSerializer;
import org.mvplugins.multiverse.inventories.util.ItemStackConverter;
import org.mvplugins.multiverse.inventories.util.MinecraftTools;

final class InventorySerializer
implements SharableSerializer<ItemStack[]> {
    private final int inventorySize;

    public InventorySerializer(int inventorySize) {
        this.inventorySize = inventorySize;
    }

    @Override
    public ItemStack[] deserialize(Object obj) {
        return this.unmapSlots(obj);
    }

    @Override
    public Object serialize(ItemStack[] itemStacks) {
        return this.mapSlots(itemStacks);
    }

    private Map<String, Object> mapSlots(ItemStack[] itemStacks) {
        HashMap<String, Object> result = new HashMap<String, Object>(itemStacks.length);
        for (int i = 0; i < itemStacks.length; ++i) {
            Object serialize = ItemStackConverter.serialize(itemStacks[i]);
            if (serialize == null) continue;
            result.put(Integer.toString(i), serialize);
        }
        return result;
    }

    private ItemStack[] unmapSlots(Object obj) {
        ItemStack[] inventory = new ItemStack[this.inventorySize];
        if (!(obj instanceof Map)) {
            return MinecraftTools.fillWithAir(inventory);
        }
        Map invMap = (Map)obj;
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item;
            Object value = invMap.get(Integer.toString(i));
            inventory[i] = value == null ? new ItemStack(Material.AIR) : ((item = ItemStackConverter.deserialize(value)) == null ? new ItemStack(Material.AIR) : item);
        }
        return inventory;
    }
}

