/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.md_5.ss.SyntheticFinder;
import net.md_5.ss.mapping.CompactSearge;
import net.md_5.ss.mapping.MappingData;
import net.md_5.ss.mapping.Proguard;
import net.md_5.ss.model.ClassInfo;
import net.md_5.ss.model.ItemInfo;
import net.md_5.ss.model.Resource;
import net.md_5.ss.output.JarOutput;
import net.md_5.ss.output.Output;
import net.md_5.ss.remapper.EnhancedMethodRemapper;
import net.md_5.ss.remapper.EnhancedRemapper;
import net.md_5.ss.repo.AggregateRepo;
import net.md_5.ss.repo.JarRepo;
import net.md_5.ss.repo.RuntimeRepo;

public class SpecialSource {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("SpecialSource 2.0: (compare|map) [args]");
            return;
        }
        String[] taskArgs = Arrays.copyOfRange(args, 1, args.length);
        OptionParser help = null;
        switch (args[0]) {
            case "compare": {
                throw new UnsupportedOperationException();
            }
            case "map": {
                help = SpecialSource.map(taskArgs);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (help != null) {
            help.printHelpOn(System.err);
        }
    }

    private static OptionParser map(String[] args) throws IOException {
        OptionParser parser = new OptionParser(){
            {
                this.acceptsAll(Arrays.asList("i", "in-jar"), "Input JAR").withRequiredArg().ofType(File.class);
                this.acceptsAll(Arrays.asList("o", "out-jar"), "Output JAR").withRequiredArg().ofType(File.class);
                this.acceptsAll(Arrays.asList("m", "mappings"), "Mappings").withRequiredArg().ofType(File.class).withValuesSeparatedBy(',');
                this.acceptsAll(Arrays.asList("e", "excludes"), "Excludes").withRequiredArg().ofType(File.class);
                this.acceptsAll(Arrays.asList("auto-lvt"), "Fix LVT automatically in the specified style").withRequiredArg().ofType(EnhancedMethodRemapper.LVTStyle.class).defaultsTo(EnhancedMethodRemapper.LVTStyle.NONE, (EnhancedMethodRemapper.LVTStyle[])new EnhancedMethodRemapper.LVTStyle[0]);
                this.acceptsAll(Arrays.asList("auto-member"), "Automatically generate names for the given member types").withRequiredArg().ofType(EnhancedRemapper.AutoMember.class);
                this.acceptsAll(Arrays.asList("only"), "Map only the specified packages").withRequiredArg().ofType(String.class);
            }
        };
        OptionSet set = parser.parse(args);
        File inJar = (File)set.valueOf("in-jar");
        AggregateRepo inRepo = new AggregateRepo(new JarRepo(new JarFile(inJar)), RuntimeRepo.getInstance());
        JarOutput out = new JarOutput((File)set.valueOf("out-jar"));
        for (File file : set.valuesOf("mappings")) {
            MappingData mappingData = new MappingData();
            switch (SpecialSource.extension(file)) {
                case "csrg": {
                    new CompactSearge().load(file, mappingData);
                    break;
                }
                case "prg": 
                case "txt": {
                    new Proguard().load(file, mappingData);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mappings format");
                }
            }
            EnhancedRemapper remapper = new EnhancedRemapper(inRepo, mappingData, set.valuesOf("auto-member"), (EnhancedMethodRemapper.LVTStyle)((Object)set.valueOf("auto-lvt")));
            HashSet<String> includes = new HashSet<String>(set.valuesOf("only"));
            HashSet<String> excludes = new HashSet<String>();
            if (set.has("excludes")) {
                excludes.addAll(Files.readLines((File)set.valueOf("excludes"), Charsets.UTF_8));
            }
            if (remapper.getAutoMember().contains((Object)EnhancedRemapper.AutoMember.SYNTHETIC)) {
                for (ItemInfo item : inRepo) {
                    if (SpecialSource.shouldHandle(item, includes, excludes) != HandleType.REMAP || !(item instanceof ClassInfo)) continue;
                    SyntheticFinder.addSynthetics(((ClassInfo)item).getNode(), remapper, mappingData);
                }
            }
            for (ItemInfo item : inRepo) {
                HandleType handle = SpecialSource.shouldHandle(item, includes, excludes);
                if (item instanceof ClassInfo) {
                    ClassInfo c = (ClassInfo)item;
                    switch (handle) {
                        case REMAP: {
                            ((Output)out).write(c.getVersionBase() + remapper.map(c.getName()) + ".class", c.remap(remapper));
                            break;
                        }
                        case INCLUDE: {
                            ((Output)out).write(c.getVersionBase() + c.getName() + ".class", c.toByteArray());
                            break;
                        }
                        case EXCLUDE: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown handle status");
                        }
                    }
                    continue;
                }
                if (!(item instanceof Resource)) continue;
                Resource r = (Resource)item;
                ((Output)out).write(r.getPath(), r.getData());
            }
            System.out.println(mappingData.printUnused());
        }
        ((Output)out).close();
        return null;
    }

    private static HandleType shouldHandle(ItemInfo item, Set<String> includes, Set<String> excludes) {
        String thing;
        if (item instanceof ClassInfo) {
            thing = ((ClassInfo)item).getName();
        } else if (item instanceof Resource) {
            thing = ((Resource)item).getPath();
        } else {
            return HandleType.REMAP;
        }
        if (!excludes.isEmpty()) {
            String excludeName = thing;
            int dollar = excludeName.indexOf(36);
            if (dollar != -1) {
                excludeName = excludeName.substring(0, dollar);
            }
            if (excludes.contains(excludeName)) {
                return HandleType.EXCLUDE;
            }
        }
        if (includes.isEmpty()) {
            return HandleType.REMAP;
        }
        for (String match : includes) {
            if (match.equals(".") && !thing.contains("/")) {
                return HandleType.REMAP;
            }
            if (!thing.startsWith(match)) continue;
            return HandleType.REMAP;
        }
        return HandleType.INCLUDE;
    }

    private static String extension(File file) {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        return dotIndex == -1 ? name : name.substring(dotIndex + 1);
    }

    private static enum HandleType {
        REMAP,
        INCLUDE,
        EXCLUDE;

    }
}

