/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import net.md_5.ss.mapping.MappingData;
import net.md_5.ss.remapper.EnhancedRemapper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class SyntheticFinder {
    public static void addSynthetics(ClassNode node, EnhancedRemapper remapper, MappingData mappings) {
        block0: for (MethodNode method : node.methods) {
            if ((method.access & 0x1000) == 0 || (method.access & 0x40) != 0 || (method.access & 2) != 0 || method.name.contains("$")) continue;
            AbstractInsnNode insn = null;
            UnmodifiableIterator<AbstractInsnNode> iter = Iterators.filter(method.instructions.iterator(), new Predicate<AbstractInsnNode>(){

                @Override
                public boolean apply(AbstractInsnNode input) {
                    return !(input instanceof LabelNode) && !(input instanceof LineNumberNode) && !(input instanceof TypeInsnNode);
                }
            });
            int expected = 0;
            while (iter.hasNext() && (insn = (AbstractInsnNode)iter.next()) instanceof VarInsnNode) {
                VarInsnNode load = (VarInsnNode)insn;
                if (load.var != expected) break;
                expected += load.getOpcode() == 22 || load.getOpcode() == 24 ? 2 : 1;
            }
            if (insn == null || insn.getOpcode() != 182 && insn.getOpcode() != 185) continue;
            MethodInsnNode invoke = (MethodInsnNode)insn;
            insn = (AbstractInsnNode)iter.next();
            if (172 > insn.getOpcode() || insn.getOpcode() > 177 || iter.hasNext() || !node.name.equals(invoke.owner) || method.name.equals(invoke.name) || method.desc.equals(invoke.desc)) continue;
            Type methodType = Type.getMethodType(method.desc);
            Type invokeType = Type.getMethodType(invoke.desc);
            if (methodType.getArgumentTypes().length != invokeType.getArgumentTypes().length) continue;
            for (MethodNode sibling : node.methods) {
                if (!method.name.equals(sibling.name) || !invoke.desc.equals(sibling.desc) || sibling.signature == null) continue;
                continue block0;
            }
            mappings.addMethodMap(invoke.owner, invoke.name, invoke.desc, method.name);
        }
    }

    private SyntheticFinder() {
    }
}

