/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.mapping;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.ss.mapping.MappingData;
import net.md_5.ss.mapping.MappingsFormat;

public class Proguard
extends MappingsFormat {
    private static final Pattern MEMBER_PATTERN = Pattern.compile("(?:\\d+:\\d+:)?(.*?) (.*?) \\-> (.*)");
    private String lastClass;

    @Override
    protected void load(MappingData data, String line) {
        this.load(data, line, false);
    }

    @Override
    protected void loadStep2(MappingData data, String line) {
        this.load(data, line, true);
    }

    private void load(MappingData data, String line, boolean addMethods) {
        if (line.endsWith(":")) {
            String obf;
            String[] parts = line.split(" -> ");
            String orig = parts[0].replace('.', '/');
            this.lastClass = obf = parts[1].substring(0, parts[1].length() - 1).replace('.', '/');
            data.addClassMap(obf, orig);
        } else if (addMethods) {
            Matcher matcher = MEMBER_PATTERN.matcher(line);
            matcher.find();
            String nameDesc = matcher.group(2);
            if (nameDesc.contains("(")) {
                String sig = Proguard.csrgDesc(data, nameDesc.substring(nameDesc.indexOf(40)), matcher.group(1));
                String mojName = nameDesc.substring(0, nameDesc.indexOf(40));
                data.addMethodMap(this.lastClass, matcher.group(3), sig, mojName);
            } else {
                data.addFieldMap(this.lastClass, matcher.group(3), nameDesc);
            }
        }
    }

    private static String csrgDesc(MappingData data, String args, String ret) {
        String[] parts = args.substring(1, args.length() - 1).split(",");
        StringBuilder desc = new StringBuilder("(");
        for (String part : parts) {
            if (part.isEmpty()) continue;
            desc.append(Proguard.toJVMType(data, part));
        }
        desc.append(")");
        desc.append(Proguard.toJVMType(data, ret));
        return desc.toString();
    }

    private static String toJVMType(MappingData data, String type) {
        switch (type) {
            case "byte": {
                return "B";
            }
            case "char": {
                return "C";
            }
            case "double": {
                return "D";
            }
            case "float": {
                return "F";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "short": {
                return "S";
            }
            case "boolean": {
                return "Z";
            }
            case "void": {
                return "V";
            }
        }
        if (type.endsWith("[]")) {
            return "[" + Proguard.toJVMType(data, type.substring(0, type.length() - 2));
        }
        String clazzType = type.replace('.', '/');
        String mappedType = data.getClassMapInverse(clazzType);
        return "L" + (mappedType != null ? mappedType : clazzType) + ";";
    }
}

