/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.ss.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import net.md_5.ss.output.Output;

public class JarOutput
extends Output {
    private final JarOutputStream jar;

    public JarOutput(File file) throws IOException {
        super(file);
        this.jar = new JarOutputStream(new FileOutputStream(file));
    }

    @Override
    public void write(String fileName, byte[] data) throws IOException {
        JarEntry entry = new JarEntry(fileName);
        entry.setTime(0L);
        entry.setSize(data.length);
        this.jar.putNextEntry(entry);
        this.jar.write(data);
        this.jar.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }

    public JarOutputStream getJar() {
        return this.jar;
    }

    @Override
    public String toString() {
        return "JarOutput(jar=" + this.getJar() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JarOutput)) {
            return false;
        }
        JarOutput other = (JarOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JarOutputStream this$jar = this.getJar();
        JarOutputStream other$jar = other.getJar();
        return !(this$jar == null ? other$jar != null : !this$jar.equals(other$jar));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JarOutput;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JarOutputStream $jar = this.getJar();
        result = result * 59 + ($jar == null ? 43 : $jar.hashCode());
        return result;
    }
}

