/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class RegistryMaterials<T>
implements IRegistryWritable<T> {
    private static final Logger b = LogUtils.getLogger();
    final ResourceKey<? extends IRegistry<T>> c;
    private final ObjectList<Holder.c<T>> d = new ObjectArrayList(256);
    private final Reference2IntMap<T> e = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(), (? super T var0) -> var0.defaultReturnValue(-1));
    private final Map<MinecraftKey, Holder.c<T>> f = new HashMap<MinecraftKey, Holder.c<T>>();
    private final Map<ResourceKey<T>, Holder.c<T>> g = new HashMap<ResourceKey<T>, Holder.c<T>>();
    private final Map<T, Holder.c<T>> h = new IdentityHashMap<T, Holder.c<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> i = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle j;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> k = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean l;
    @Nullable
    private Map<T, Holder.c<T>> m;
    private final HolderLookup.b<T> n = new HolderLookup.b<T>(){

        @Override
        public ResourceKey<? extends IRegistry<? extends T>> f() {
            return RegistryMaterials.this.c;
        }

        @Override
        public Lifecycle g() {
            return RegistryMaterials.this.e();
        }

        @Override
        public Optional<Holder.c<T>> a(ResourceKey<T> var0) {
            return RegistryMaterials.this.b(var0);
        }

        @Override
        public Stream<Holder.c<T>> b() {
            return RegistryMaterials.this.i();
        }

        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
            return RegistryMaterials.this.b(var0);
        }

        @Override
        public Stream<HolderSet.Named<T>> d() {
            return RegistryMaterials.this.j().map(Pair::getSecond);
        }
    };
    private final Object o = new Object();

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1) {
        this(var0, var1, false);
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, boolean var2) {
        this.c = var02;
        this.j = var1;
        if (var2) {
            this.m = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    @Override
    public ResourceKey<? extends IRegistry<T>> d() {
        return this.c;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.c) + " (" + String.valueOf(this.j) + ")]";
    }

    private void b() {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void h(ResourceKey<T> var0) {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(var0) + ")");
        }
    }

    @Override
    public Holder.c<T> a(ResourceKey<T> var02, T var1, RegistrationInfo var2) {
        Holder.c var3;
        this.h(var02);
        Objects.requireNonNull(var02);
        Objects.requireNonNull(var1);
        if (this.f.containsKey(var02.a())) {
            SystemUtils.b(new IllegalStateException("Adding duplicate key '" + String.valueOf(var02) + "' to registry"));
        }
        if (this.h.containsKey(var1)) {
            SystemUtils.b(new IllegalStateException("Adding duplicate value '" + String.valueOf(var1) + "' to registry"));
        }
        if (this.m != null) {
            var3 = this.m.remove(var1);
            if (var3 == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(var02) + ":" + String.valueOf(var1)));
            }
            var3.b(var02);
        } else {
            var3 = this.g.computeIfAbsent(var02, var0 -> Holder.c.a(this.p(), var0));
        }
        this.g.put(var02, var3);
        this.f.put(var02.a(), var3);
        this.h.put(var1, var3);
        int var4 = this.d.size();
        this.d.add((Object)var3);
        this.e.put(var1, var4);
        this.i.put(var02, var2);
        this.j = this.j.add(var2.b());
        return var3;
    }

    @Override
    @Nullable
    public MinecraftKey b(T var0) {
        Holder.c<T> var1 = this.h.get(var0);
        return var1 != null ? var1.h().a() : null;
    }

    @Override
    public Optional<ResourceKey<T>> d(T var0) {
        return Optional.ofNullable(this.h.get(var0)).map(Holder.c::h);
    }

    @Override
    public int a(@Nullable T var0) {
        return this.e.getInt(var0);
    }

    @Override
    @Nullable
    public T a(@Nullable ResourceKey<T> var0) {
        return RegistryMaterials.a(this.g.get(var0));
    }

    @Override
    @Nullable
    public T a(int var0) {
        if (var0 < 0 || var0 >= this.d.size()) {
            return null;
        }
        return ((Holder.c)this.d.get(var0)).a();
    }

    @Override
    public Optional<Holder.c<T>> c(int var0) {
        if (var0 < 0 || var0 >= this.d.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder.c)this.d.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> c(MinecraftKey var0) {
        return Optional.ofNullable(this.f.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> b(ResourceKey<T> var0) {
        return Optional.ofNullable(this.g.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> a() {
        return this.d.isEmpty() ? Optional.empty() : Optional.of((Holder.c)this.d.getFirst());
    }

    @Override
    public Holder<T> e(T var0) {
        Holder.c<T> var1 = this.h.get(var0);
        return var1 != null ? var1 : Holder.a(var0);
    }

    Holder.c<T> i(ResourceKey<T> var02) {
        return this.g.computeIfAbsent(var02, var0 -> {
            if (this.m != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.h((ResourceKey<T>)var0);
            return Holder.c.a(this.p(), var0);
        });
    }

    @Override
    public int c() {
        return this.g.size();
    }

    @Override
    public Optional<RegistrationInfo> c(ResourceKey<T> var0) {
        return Optional.ofNullable(this.i.get(var0));
    }

    @Override
    public Lifecycle e() {
        return this.j;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.d.iterator(), Holder::a);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey var0) {
        Holder.c<T> var1 = this.f.get(var0);
        return RegistryMaterials.a(var1);
    }

    @Nullable
    private static <T> T a(@Nullable Holder.c<T> var0) {
        return var0 != null ? (T)var0.a() : null;
    }

    @Override
    public Set<MinecraftKey> f() {
        return Collections.unmodifiableSet(this.f.keySet());
    }

    @Override
    public Set<ResourceKey<T>> g() {
        return Collections.unmodifiableSet(this.g.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> h() {
        return Collections.unmodifiableSet(Maps.transformValues(this.g, Holder::a).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> i() {
        return this.d.stream();
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> j() {
        return this.k.entrySet().stream().map(var0 -> Pair.of((Object)((TagKey)var0.getKey()), (Object)((HolderSet.Named)var0.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HolderSet.Named<T> a(TagKey<T> var0) {
        HolderSet.Named<T> var1 = this.k.get(var0);
        if (var1 != null) {
            return var1;
        }
        Object object = this.o;
        synchronized (object) {
            var1 = this.k.get(var0);
            if (var1 != null) {
                return var1;
            }
            var1 = this.d(var0);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var3 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
            var3.put(var0, var1);
            this.k = var3;
        }
        return var1;
    }

    private HolderSet.Named<T> d(TagKey<T> var0) {
        return new HolderSet.Named<T>(this.p(), var0);
    }

    @Override
    public Stream<TagKey<T>> k() {
        return this.k.keySet().stream();
    }

    @Override
    public boolean l() {
        return this.g.isEmpty();
    }

    @Override
    public Optional<Holder.c<T>> a(RandomSource var0) {
        return SystemUtils.b(this.d, var0);
    }

    @Override
    public boolean d(MinecraftKey var0) {
        return this.f.containsKey(var0);
    }

    @Override
    public boolean d(ResourceKey<T> var0) {
        return this.g.containsKey(var0);
    }

    @Override
    public IRegistry<T> m() {
        if (this.l) {
            return this;
        }
        this.l = true;
        this.h.forEach((? super K var0, ? super V var1) -> var1.b(var0));
        List<MinecraftKey> var02 = this.g.entrySet().stream().filter(var0 -> !((Holder.c)var0.getValue()).b()).map(var0 -> ((ResourceKey)var0.getKey()).a()).sorted().toList();
        if (!var02.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.d()) + ": " + String.valueOf(var02));
        }
        if (this.m != null) {
            if (!this.m.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.m.values()));
            }
            this.m = null;
        }
        return this;
    }

    @Override
    public Holder.c<T> f(T var02) {
        if (this.m == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.b();
        return this.m.computeIfAbsent(var02, var0 -> Holder.c.a(this.q(), var0));
    }

    @Override
    public Optional<HolderSet.Named<T>> b(TagKey<T> var0) {
        return Optional.ofNullable(this.k.get(var0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(Map<TagKey<T>, List<Holder<T>>> var02) {
        IdentityHashMap<Holder.c, List> var12 = new IdentityHashMap<Holder.c, List>();
        this.g.values().forEach(var1 -> var12.put((Holder.c)var1, new ArrayList()));
        var02.forEach((? super K var1, ? super V var2) -> {
            for (Holder var4 : var2) {
                if (!var4.a(this.q())) {
                    throw new IllegalStateException("Can't create named set " + String.valueOf(var1) + " containing value " + String.valueOf(var4) + " from outside registry " + String.valueOf(this));
                }
                if (var4 instanceof Holder.c) {
                    Holder.c var5 = (Holder.c)var4;
                    ((List)var12.get(var5)).add(var1);
                    continue;
                }
                throw new IllegalStateException("Found direct holder " + String.valueOf(var4) + " value in tag " + String.valueOf(var1));
            }
        });
        Sets.SetView var22 = Sets.difference(this.k.keySet(), var02.keySet());
        if (!var22.isEmpty()) {
            b.warn("Not all defined tags for registry {} are present in data pack: {}", this.d(), (Object)var22.stream().map(var0 -> var0.b().toString()).sorted().collect(Collectors.joining(", ")));
        }
        Object object = this.o;
        synchronized (object) {
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var4 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
            var02.forEach((? super K var1, ? super V var2) -> var4.computeIfAbsent((TagKey<T>)var1, this::d).b(var2));
            var12.forEach(Holder.c::a);
            this.k = var4;
        }
    }

    @Override
    public void n() {
        this.k.values().forEach(var0 -> var0.b(List.of()));
        this.g.values().forEach(var0 -> var0.a(Set.of()));
    }

    @Override
    public HolderGetter<T> o() {
        this.b();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> var0) {
                return Optional.of(this.b(var0));
            }

            @Override
            public Holder.c<T> b(ResourceKey<T> var0) {
                return RegistryMaterials.this.i(var0);
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
                return Optional.of(this.b(var0));
            }

            @Override
            public HolderSet.Named<T> b(TagKey<T> var0) {
                return RegistryMaterials.this.a(var0);
            }
        };
    }

    @Override
    public HolderOwner<T> p() {
        return this.n;
    }

    @Override
    public HolderLookup.b<T> q() {
        return this.n;
    }
}

