/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.network.chat.IChatBaseComponent;

public class MojangsonParser {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.nbt.expected.value"));
    public static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.b("argument.nbt.list.mixed", var0, var1));
    public static final Dynamic2CommandExceptionType e = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.b("argument.nbt.array.mixed", var0, var1));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("argument.nbt.array.invalid", var0));
    public static final char g = ',';
    public static final char h = ':';
    private static final char k = '[';
    private static final char l = ']';
    private static final char m = '}';
    private static final char n = '{';
    private static final Pattern o = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern p = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern q = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern r = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern s = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern t = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern u = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    public static final Codec<NBTTagCompound> i = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)new MojangsonParser(new StringReader(var0)).a(), (Lifecycle)Lifecycle.stable());
        }
        catch (CommandSyntaxException var1) {
            return DataResult.error(() -> ((CommandSyntaxException)var1).getMessage());
        }
    }, NBTTagCompound::toString);
    public static final Codec<NBTTagCompound> j = Codec.withAlternative(i, NBTTagCompound.a);
    private final StringReader v;

    public static NBTTagCompound a(String var0) throws CommandSyntaxException {
        return new MojangsonParser(new StringReader(var0)).a();
    }

    @VisibleForTesting
    NBTTagCompound a() throws CommandSyntaxException {
        NBTTagCompound var0 = this.f();
        this.v.skipWhitespace();
        if (this.v.canRead()) {
            throw a.createWithContext((ImmutableStringReader)this.v);
        }
        return var0;
    }

    public MojangsonParser(StringReader var0) {
        this.v = var0;
    }

    protected String b() throws CommandSyntaxException {
        this.v.skipWhitespace();
        if (!this.v.canRead()) {
            throw b.createWithContext((ImmutableStringReader)this.v);
        }
        return this.v.readString();
    }

    protected NBTBase c() throws CommandSyntaxException {
        this.v.skipWhitespace();
        int var0 = this.v.getCursor();
        if (StringReader.isQuotedStringStart((char)this.v.peek())) {
            return NBTTagString.a(this.v.readQuotedString());
        }
        String var1 = this.v.readUnquotedString();
        if (var1.isEmpty()) {
            this.v.setCursor(var0);
            throw c.createWithContext((ImmutableStringReader)this.v);
        }
        return this.b(var1);
    }

    public NBTBase b(String var0) {
        try {
            if (q.matcher(var0).matches()) {
                return NBTTagFloat.a(Float.parseFloat(var0.substring(0, var0.length() - 1)));
            }
            if (r.matcher(var0).matches()) {
                return NBTTagByte.a(Byte.parseByte(var0.substring(0, var0.length() - 1)));
            }
            if (s.matcher(var0).matches()) {
                return NBTTagLong.a(Long.parseLong(var0.substring(0, var0.length() - 1)));
            }
            if (t.matcher(var0).matches()) {
                return NBTTagShort.a(Short.parseShort(var0.substring(0, var0.length() - 1)));
            }
            if (u.matcher(var0).matches()) {
                return NBTTagInt.a(Integer.parseInt(var0));
            }
            if (p.matcher(var0).matches()) {
                return NBTTagDouble.a(Double.parseDouble(var0.substring(0, var0.length() - 1)));
            }
            if (o.matcher(var0).matches()) {
                return NBTTagDouble.a(Double.parseDouble(var0));
            }
            if ("true".equalsIgnoreCase(var0)) {
                return NBTTagByte.c;
            }
            if ("false".equalsIgnoreCase(var0)) {
                return NBTTagByte.b;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NBTTagString.a(var0);
    }

    public NBTBase d() throws CommandSyntaxException {
        this.v.skipWhitespace();
        if (!this.v.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.v);
        }
        char var0 = this.v.peek();
        if (var0 == '{') {
            return this.f();
        }
        if (var0 == '[') {
            return this.e();
        }
        return this.c();
    }

    protected NBTBase e() throws CommandSyntaxException {
        if (this.v.canRead(3) && !StringReader.isQuotedStringStart((char)this.v.peek(1)) && this.v.peek(2) == ';') {
            return this.h();
        }
        return this.g();
    }

    public NBTTagCompound f() throws CommandSyntaxException {
        this.a('{');
        NBTTagCompound var0 = new NBTTagCompound();
        this.v.skipWhitespace();
        while (this.v.canRead() && this.v.peek() != '}') {
            int var1 = this.v.getCursor();
            String var2 = this.b();
            if (var2.isEmpty()) {
                this.v.setCursor(var1);
                throw b.createWithContext((ImmutableStringReader)this.v);
            }
            this.a(':');
            var0.a(var2, this.d());
            if (!this.i()) break;
            if (this.v.canRead()) continue;
            throw b.createWithContext((ImmutableStringReader)this.v);
        }
        this.a('}');
        return var0;
    }

    private NBTBase g() throws CommandSyntaxException {
        this.a('[');
        this.v.skipWhitespace();
        if (!this.v.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.v);
        }
        NBTTagList var0 = new NBTTagList();
        NBTTagType<?> var1 = null;
        while (this.v.peek() != ']') {
            int var2 = this.v.getCursor();
            NBTBase var3 = this.d();
            NBTTagType<?> var4 = var3.c();
            if (var1 == null) {
                var1 = var4;
            } else if (var4 != var1) {
                this.v.setCursor(var2);
                throw d.createWithContext((ImmutableStringReader)this.v, (Object)var4.b(), (Object)var1.b());
            }
            var0.add(var3);
            if (!this.i()) break;
            if (this.v.canRead()) continue;
            throw c.createWithContext((ImmutableStringReader)this.v);
        }
        this.a(']');
        return var0;
    }

    public NBTBase h() throws CommandSyntaxException {
        this.a('[');
        int var0 = this.v.getCursor();
        char var1 = this.v.read();
        this.v.read();
        this.v.skipWhitespace();
        if (!this.v.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.v);
        }
        if (var1 == 'B') {
            return new NBTTagByteArray(this.a(NBTTagByteArray.a, NBTTagByte.a));
        }
        if (var1 == 'L') {
            return new NBTTagLongArray(this.a(NBTTagLongArray.a, NBTTagLong.a));
        }
        if (var1 == 'I') {
            return new NBTTagIntArray(this.a(NBTTagIntArray.a, NBTTagInt.a));
        }
        this.v.setCursor(var0);
        throw f.createWithContext((ImmutableStringReader)this.v, (Object)String.valueOf(var1));
    }

    private <T extends Number> List<T> a(NBTTagType<?> var0, NBTTagType<?> var1) throws CommandSyntaxException {
        ArrayList var2 = Lists.newArrayList();
        while (this.v.peek() != ']') {
            int var3 = this.v.getCursor();
            NBTBase var4 = this.d();
            NBTTagType<?> var5 = var4.c();
            if (var5 != var1) {
                this.v.setCursor(var3);
                throw e.createWithContext((ImmutableStringReader)this.v, (Object)var5.b(), (Object)var0.b());
            }
            if (var1 == NBTTagByte.a) {
                var2.add(((NBTNumber)var4).i());
            } else if (var1 == NBTTagLong.a) {
                var2.add(((NBTNumber)var4).f());
            } else {
                var2.add(((NBTNumber)var4).g());
            }
            if (!this.i()) break;
            if (this.v.canRead()) continue;
            throw c.createWithContext((ImmutableStringReader)this.v);
        }
        this.a(']');
        return var2;
    }

    private boolean i() {
        this.v.skipWhitespace();
        if (this.v.canRead() && this.v.peek() == ',') {
            this.v.skip();
            this.v.skipWhitespace();
            return true;
        }
        return false;
    }

    private void a(char var0) throws CommandSyntaxException {
        this.v.skipWhitespace();
        this.v.expect(var0);
    }
}

