/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;

public class ClientboundLevelChunkPacketData {
    private static final int a = 0x200000;
    private final NBTTagCompound b;
    private final byte[] c;
    private final List<a> d;

    public ClientboundLevelChunkPacketData(Chunk var0) {
        this.b = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : var0.e()) {
            if (!entry.getKey().b()) continue;
            this.b.a(entry.getKey().a(), new NBTTagLongArray(entry.getValue().a()));
        }
        this.c = new byte[ClientboundLevelChunkPacketData.a(var0)];
        ClientboundLevelChunkPacketData.a(new PacketDataSerializer(this.c()), var0);
        this.d = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : var0.G().entrySet()) {
            this.d.add(net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.a((TileEntity)entry.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(RegistryFriendlyByteBuf var0, int var1, int var2) {
        this.b = var0.o();
        if (this.b == null) {
            throw new RuntimeException("Can't read heightmap in packet for [" + var1 + ", " + var2 + "]");
        }
        int var3 = var0.l();
        if (var3 > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.c = new byte[var3];
        var0.b(this.c);
        this.d = (List)net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.b.decode(var0);
    }

    public void a(RegistryFriendlyByteBuf var0) {
        var0.a(this.b);
        var0.c(this.c.length);
        var0.c(this.c);
        net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.b.encode(var0, this.d);
    }

    private static int a(Chunk var0) {
        int var1 = 0;
        for (ChunkSection var5 : var0.d()) {
            var1 += var5.j();
        }
        return var1;
    }

    private ByteBuf c() {
        ByteBuf var0 = Unpooled.wrappedBuffer((byte[])this.c);
        var0.writerIndex(0);
        return var0;
    }

    public static void a(PacketDataSerializer var0, Chunk var1) {
        for (ChunkSection var5 : var1.d()) {
            var5.c(var0);
        }
    }

    public Consumer<b> a(int var0, int var1) {
        return var2 -> this.a((b)var2, var0, var1);
    }

    private void a(b var0, int var1, int var2) {
        int var3 = 16 * var1;
        int var4 = 16 * var2;
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (a var7 : this.d) {
            int var8 = var3 + SectionPosition.b(var7.c >> 4);
            int var9 = var4 + SectionPosition.b(var7.c);
            var5.d(var8, var7.d, var9);
            var0.accept(var5, var7.e, var7.f);
        }
    }

    public PacketDataSerializer a() {
        return new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])this.c));
    }

    public NBTTagCompound b() {
        return this.b;
    }

    static class a {
        public static final StreamCodec<RegistryFriendlyByteBuf, a> a = StreamCodec.a(a::a, a::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<a>> b = a.a(ByteBufCodecs.a());
        final int c;
        final int d;
        final TileEntityTypes<?> e;
        @Nullable
        final NBTTagCompound f;

        private a(int var0, int var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3) {
            this.c = var0;
            this.d = var1;
            this.e = var2;
            this.f = var3;
        }

        private a(RegistryFriendlyByteBuf var0) {
            this.c = var0.readByte();
            this.d = var0.readShort();
            this.e = (TileEntityTypes)ByteBufCodecs.a(Registries.h).decode(var0);
            this.f = var0.o();
        }

        private void a(RegistryFriendlyByteBuf var0) {
            var0.k(this.c);
            var0.l(this.d);
            ByteBufCodecs.a(Registries.h).encode(var0, this.e);
            var0.a(this.f);
        }

        static a a(TileEntity var0) {
            NBTTagCompound var1 = var0.a(var0.i().H_());
            BlockPosition var2 = var0.aD_();
            int var3 = SectionPosition.b(var2.u()) << 4 | SectionPosition.b(var2.w());
            return new a(var3, var2.v(), var0.r(), var1.g() ? null : var1);
        }
    }

    @FunctionalInterface
    public static interface b {
        public void accept(BlockPosition var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3);
    }
}

