/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ChatDeserializer;

public final class MinecraftKey
implements Comparable<MinecraftKey> {
    public static final Codec<MinecraftKey> a = Codec.STRING.comapFlatMap(MinecraftKey::d, MinecraftKey::toString).stable();
    public static final StreamCodec<ByteBuf, MinecraftKey> b = ByteBufCodecs.l.a(MinecraftKey::a, MinecraftKey::toString);
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.id.invalid"));
    public static final char d = ':';
    public static final String e = "minecraft";
    public static final String f = "realms";
    private final String h;
    private final String i;

    private MinecraftKey(String var0, String var1) {
        assert (MinecraftKey.j(var0));
        assert (MinecraftKey.i(var1));
        this.h = var0;
        this.i = var1;
    }

    private static MinecraftKey d(String var0, String var1) {
        return new MinecraftKey(MinecraftKey.e(var0, var1), MinecraftKey.f(var0, var1));
    }

    public static MinecraftKey a(String var0, String var1) {
        return MinecraftKey.d(var0, var1);
    }

    public static MinecraftKey a(String var0) {
        return MinecraftKey.a(var0, ':');
    }

    public static MinecraftKey b(String var0) {
        return new MinecraftKey(e, MinecraftKey.f(e, var0));
    }

    @Nullable
    public static MinecraftKey c(String var0) {
        return MinecraftKey.b(var0, ':');
    }

    @Nullable
    public static MinecraftKey b(String var0, String var1) {
        if (MinecraftKey.j(var0) && MinecraftKey.i(var1)) {
            return new MinecraftKey(var0, var1);
        }
        return null;
    }

    public static MinecraftKey a(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return MinecraftKey.d(var4, var3);
            }
            return MinecraftKey.b(var3);
        }
        return MinecraftKey.b(var0);
    }

    @Nullable
    public static MinecraftKey b(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (!MinecraftKey.i(var3)) {
                return null;
            }
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return MinecraftKey.j(var4) ? new MinecraftKey(var4, var3) : null;
            }
            return new MinecraftKey(e, var3);
        }
        return MinecraftKey.i(var0) ? new MinecraftKey(e, var0) : null;
    }

    public static DataResult<MinecraftKey> d(String var0) {
        try {
            return DataResult.success((Object)MinecraftKey.a(var0));
        }
        catch (ResourceKeyInvalidException var1) {
            return DataResult.error(() -> "Not a valid resource location: " + var0 + " " + var1.getMessage());
        }
    }

    public String a() {
        return this.i;
    }

    public String b() {
        return this.h;
    }

    public MinecraftKey e(String var0) {
        return new MinecraftKey(this.h, MinecraftKey.f(this.h, var0));
    }

    public MinecraftKey a(UnaryOperator<String> var0) {
        return this.e((String)var0.apply(this.i));
    }

    public MinecraftKey f(String var0) {
        return this.e(var0 + this.i);
    }

    public MinecraftKey g(String var0) {
        return this.e(this.i + var0);
    }

    public String toString() {
        return this.h + ":" + this.i;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof MinecraftKey) {
            MinecraftKey var1 = (MinecraftKey)var0;
            return this.h.equals(var1.h) && this.i.equals(var1.i);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.h.hashCode() + this.i.hashCode();
    }

    public int a(MinecraftKey var0) {
        int var1 = this.i.compareTo(var0.i);
        if (var1 == 0) {
            var1 = this.h.compareTo(var0.h);
        }
        return var1;
    }

    public String c() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String d() {
        return this.h + "." + this.i;
    }

    public String e() {
        return this.h.equals(e) ? this.i : this.d();
    }

    public String h(String var0) {
        return var0 + "." + this.d();
    }

    public String c(String var0, String var1) {
        return var0 + "." + this.d() + "." + var1;
    }

    private static String c(StringReader var0) {
        int var1 = var0.getCursor();
        while (var0.canRead() && MinecraftKey.a(var0.peek())) {
            var0.skip();
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    public static MinecraftKey a(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = MinecraftKey.c(var0);
        try {
            return MinecraftKey.a(var2);
        }
        catch (ResourceKeyInvalidException var3) {
            var0.setCursor(var1);
            throw c.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static MinecraftKey b(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = MinecraftKey.c(var0);
        if (var2.isEmpty()) {
            throw c.createWithContext((ImmutableStringReader)var0);
        }
        try {
            return MinecraftKey.a(var2);
        }
        catch (ResourceKeyInvalidException var3) {
            var0.setCursor(var1);
            throw c.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static boolean a(char var0) {
        return var0 >= '0' && var0 <= '9' || var0 >= 'a' && var0 <= 'z' || var0 == '_' || var0 == ':' || var0 == '/' || var0 == '.' || var0 == '-';
    }

    public static boolean i(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (MinecraftKey.b(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    public static boolean j(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (MinecraftKey.c(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    private static String e(String var0, String var1) {
        if (!MinecraftKey.j(var0)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9_.-] character in namespace of location: " + var0 + ":" + var1);
        }
        return var0;
    }

    public static boolean b(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '/' || var0 == '.';
    }

    private static boolean c(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '.';
    }

    private static String f(String var0, String var1) {
        if (!MinecraftKey.i(var1)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9/._-] character in path of location: " + var0 + ":" + var1);
        }
        return var1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.a((MinecraftKey)object);
    }

    public static class a
    implements JsonDeserializer<MinecraftKey>,
    JsonSerializer<MinecraftKey> {
        public MinecraftKey a(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            return MinecraftKey.a(ChatDeserializer.a(var0, "location"));
        }

        public JsonElement a(MinecraftKey var0, Type var1, JsonSerializationContext var2) {
            return new JsonPrimitive(var0.toString());
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.a((MinecraftKey)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.a(jsonElement, type, jsonDeserializationContext);
        }
    }
}

