/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class AdvancementDataWorld
extends ResourceDataJson {
    private static final Logger a = LogUtils.getLogger();
    public static final Gson b = new GsonBuilder().create();
    public Map<MinecraftKey, AdvancementHolder> c = new HashMap<MinecraftKey, AdvancementHolder>();
    private AdvancementTree d = new AdvancementTree();
    private final HolderLookup.a e;

    public AdvancementDataWorld(HolderLookup.a holderlookup_a) {
        super(b, Registries.c(Registries.bf));
        this.e = holderlookup_a;
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> map, IResourceManager iresourcemanager, GameProfilerFiller gameprofilerfiller) {
        RegistryOps registryops = this.e.a(JsonOps.INSTANCE);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((minecraftkey, jsonelement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(minecraftkey.toString()) || SpigotConfig.disabledAdvancements.contains(minecraftkey.b()))) {
                return;
            }
            try {
                Advancement advancement = (Advancement)Advancement.a.parse((DynamicOps)registryops, jsonelement).getOrThrow(JsonParseException::new);
                this.a((MinecraftKey)minecraftkey, advancement);
                builder.put(minecraftkey, (Object)new AdvancementHolder((MinecraftKey)minecraftkey, advancement));
            }
            catch (Exception exception) {
                a.error("Parsing error loading custom advancement {}: {}", minecraftkey, (Object)exception.getMessage());
            }
        });
        this.c = new HashMap<MinecraftKey, AdvancementHolder>((Map<MinecraftKey, AdvancementHolder>)builder.buildOrThrow());
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.a(this.c.values());
        for (AdvancementNode advancementnode : advancementtree.b()) {
            if (!advancementnode.b().b().c().isPresent()) continue;
            TreeNodePosition.a(advancementnode);
        }
        this.d = advancementtree;
    }

    private void a(MinecraftKey minecraftkey, Advancement advancement) {
        ProblemReporter.a problemreporter_a = new ProblemReporter.a();
        advancement.a(problemreporter_a, this.e.b());
        problemreporter_a.b().ifPresent(s2 -> a.warn("Found validation problems in advancement {}: \n{}", (Object)minecraftkey, s2));
    }

    @Nullable
    public AdvancementHolder a(MinecraftKey minecraftkey) {
        return this.c.get(minecraftkey);
    }

    public AdvancementTree a() {
        return this.d;
    }

    public Collection<AdvancementHolder> b() {
        return this.c.values();
    }
}

