/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;

public class ScoreboardServer
extends Scoreboard {
    private final MinecraftServer b;
    private final Set<ScoreboardObjective> c = Sets.newHashSet();
    private final List<Runnable> d = Lists.newArrayList();

    public ScoreboardServer(MinecraftServer minecraftserver) {
        this.b = minecraftserver;
    }

    @Override
    protected void a(ScoreHolder scoreholder, ScoreboardObjective scoreboardobjective, ScoreboardScore scoreboardscore) {
        super.a(scoreholder, scoreboardobjective, scoreboardscore);
        if (this.c.contains(scoreboardobjective)) {
            this.broadcastAll(new PacketPlayOutScoreboardScore(scoreholder.cB(), scoreboardobjective.b(), scoreboardscore.a(), Optional.ofNullable(scoreboardscore.d()), Optional.ofNullable(scoreboardscore.c())));
        }
        this.a();
    }

    @Override
    protected void a(ScoreHolder scoreholder, ScoreboardObjective scoreboardobjective) {
        super.a(scoreholder, scoreboardobjective);
        this.a();
    }

    @Override
    public void a(ScoreHolder scoreholder) {
        super.a(scoreholder);
        this.broadcastAll(new ClientboundResetScorePacket(scoreholder.cB(), null));
        this.a();
    }

    @Override
    public void b(ScoreHolder scoreholder, ScoreboardObjective scoreboardobjective) {
        super.b(scoreholder, scoreboardobjective);
        if (this.c.contains(scoreboardobjective)) {
            this.broadcastAll(new ClientboundResetScorePacket(scoreholder.cB(), scoreboardobjective.b()));
        }
        this.a();
    }

    @Override
    public void a(DisplaySlot displayslot, @Nullable ScoreboardObjective scoreboardobjective) {
        ScoreboardObjective scoreboardobjective1 = this.a(displayslot);
        super.a(displayslot, scoreboardobjective);
        if (scoreboardobjective1 != scoreboardobjective && scoreboardobjective1 != null) {
            if (this.h(scoreboardobjective1) > 0) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
            } else {
                this.g(scoreboardobjective1);
            }
        }
        if (scoreboardobjective != null) {
            if (this.c.contains(scoreboardobjective)) {
                this.broadcastAll(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
            } else {
                this.e(scoreboardobjective);
            }
        }
        this.a();
    }

    @Override
    public boolean a(String s2, ScoreboardTeam scoreboardteam) {
        if (super.a(s2, scoreboardteam)) {
            this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, s2, PacketPlayOutScoreboardTeam.a.a));
            this.a();
            return true;
        }
        return false;
    }

    @Override
    public void b(String s2, ScoreboardTeam scoreboardteam) {
        super.b(s2, scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, s2, PacketPlayOutScoreboardTeam.a.b));
        this.a();
    }

    @Override
    public void a(ScoreboardObjective scoreboardobjective) {
        super.a(scoreboardobjective);
        this.a();
    }

    @Override
    public void b(ScoreboardObjective scoreboardobjective) {
        super.b(scoreboardobjective);
        if (this.c.contains(scoreboardobjective)) {
            this.broadcastAll(new PacketPlayOutScoreboardObjective(scoreboardobjective, 2));
        }
        this.a();
    }

    @Override
    public void c(ScoreboardObjective scoreboardobjective) {
        super.c(scoreboardobjective);
        if (this.c.contains(scoreboardobjective)) {
            this.g(scoreboardobjective);
        }
        this.a();
    }

    @Override
    public void a(ScoreboardTeam scoreboardteam) {
        super.a(scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        this.a();
    }

    @Override
    public void b(ScoreboardTeam scoreboardteam) {
        super.b(scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam, false));
        this.a();
    }

    @Override
    public void c(ScoreboardTeam scoreboardteam) {
        super.c(scoreboardteam);
        this.broadcastAll(PacketPlayOutScoreboardTeam.a(scoreboardteam));
        this.a();
    }

    public void a(Runnable runnable) {
        this.d.add(runnable);
    }

    protected void a() {
        for (Runnable runnable : this.d) {
            runnable.run();
        }
    }

    public List<Packet<?>> d(ScoreboardObjective scoreboardobjective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(scoreboardobjective, 0));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != scoreboardobjective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
        }
        for (PlayerScoreEntry playerscoreentry : this.i(scoreboardobjective)) {
            list.add(new PacketPlayOutScoreboardScore(playerscoreentry.c(), scoreboardobjective.b(), playerscoreentry.d(), Optional.ofNullable(playerscoreentry.e()), Optional.ofNullable(playerscoreentry.f())));
        }
        return list;
    }

    public void e(ScoreboardObjective scoreboardobjective) {
        List<Packet<?>> list = this.d(scoreboardobjective);
        for (EntityPlayer entityplayer : this.b.ah().t()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.c.b(packet);
            }
        }
        this.c.add(scoreboardobjective);
    }

    public List<Packet<?>> f(ScoreboardObjective scoreboardobjective) {
        ArrayList list = Lists.newArrayList();
        list.add(new PacketPlayOutScoreboardObjective(scoreboardobjective, 1));
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != scoreboardobjective) continue;
            list.add(new PacketPlayOutScoreboardDisplayObjective(displayslot, scoreboardobjective));
        }
        return list;
    }

    public void g(ScoreboardObjective scoreboardobjective) {
        List<Packet<?>> list = this.f(scoreboardobjective);
        for (EntityPlayer entityplayer : this.b.ah().t()) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            for (Packet<?> packet : list) {
                entityplayer.c.b(packet);
            }
        }
        this.c.remove(scoreboardobjective);
    }

    public int h(ScoreboardObjective scoreboardobjective) {
        int i2 = 0;
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            if (this.a(displayslot) != scoreboardobjective) continue;
            ++i2;
        }
        return i2;
    }

    public PersistentBase.a<PersistentScoreboard> b() {
        return new PersistentBase.a<PersistentScoreboard>(this::h, this::a, DataFixTypes.n);
    }

    private PersistentScoreboard h() {
        PersistentScoreboard persistentscoreboard = new PersistentScoreboard(this);
        Objects.requireNonNull(persistentscoreboard);
        this.a(persistentscoreboard::c);
        return persistentscoreboard;
    }

    private PersistentScoreboard a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        return this.h().b(nbttagcompound, holderlookup_a);
    }

    private void broadcastAll(Packet packet) {
        for (EntityPlayer entityplayer : this.b.ah().l) {
            if (entityplayer.getBukkitEntity().getScoreboard().getHandle() != this) continue;
            entityplayer.c.b(packet);
        }
    }

    public static enum Action {
        a,
        b;

    }
}

