/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandTeleport {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.teleport.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalcommandnode = commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("teleport").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), VectorPosition.d(), null)))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facingEntity", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new b(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("facingAnchor", ArgumentAnchor.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new b(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.a("facingLocation", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new c(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination")))))));
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("tp").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).redirect(literalcommandnode)));
    }

    private static int a(CommandListenerWrapper commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, net.minecraft.world.entity.Entity entity) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity2 : collection) {
            CommandTeleport.a(commandlistenerwrapper, entity2, (WorldServer)entity.dO(), entity.dt(), entity.dv(), entity.dz(), EnumSet.noneOf(RelativeMovement.class), entity.dE(), entity.dG(), null);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).S_(), entity.S_()), true);
        } else {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.multiple", collection.size(), entity.S_()), true);
        }
        return collection.size();
    }

    private static int a(CommandListenerWrapper commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, WorldServer worldserver, IVectorPosition ivectorposition, @Nullable IVectorPosition ivectorposition1, @Nullable a commandteleport_a) throws CommandSyntaxException {
        Vec3D vec3d = ivectorposition.a(commandlistenerwrapper);
        Vec2F vec2f = ivectorposition1 == null ? null : ivectorposition1.b(commandlistenerwrapper);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (ivectorposition.a()) {
            set.add(RelativeMovement.a);
        }
        if (ivectorposition.b()) {
            set.add(RelativeMovement.b);
        }
        if (ivectorposition.c()) {
            set.add(RelativeMovement.c);
        }
        if (ivectorposition1 == null) {
            set.add(RelativeMovement.e);
            set.add(RelativeMovement.d);
        } else {
            if (ivectorposition1.a()) {
                set.add(RelativeMovement.e);
            }
            if (ivectorposition1.b()) {
                set.add(RelativeMovement.d);
            }
        }
        for (net.minecraft.world.entity.Entity entity : collection) {
            if (ivectorposition1 == null) {
                CommandTeleport.a(commandlistenerwrapper, entity, worldserver, vec3d.c, vec3d.d, vec3d.e, set, entity.dE(), entity.dG(), commandteleport_a);
                continue;
            }
            CommandTeleport.a(commandlistenerwrapper, entity, worldserver, vec3d.c, vec3d.d, vec3d.e, set, vec2f.j, vec2f.i, commandteleport_a);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).S_(), CommandTeleport.a(vec3d.c), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e)), true);
        } else {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.teleport.success.location.multiple", collection.size(), CommandTeleport.a(vec3d.c), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e)), true);
        }
        return collection.size();
    }

    private static String a(double d0) {
        return String.format(Locale.ROOT, "%f", d0);
    }

    private static void a(CommandListenerWrapper commandlistenerwrapper, net.minecraft.world.entity.Entity entity, WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, @Nullable a commandteleport_a) throws CommandSyntaxException {
        boolean result;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        if (!World.l(blockposition)) {
            throw a.create();
        }
        float f22 = MathHelper.g(f2);
        float f3 = MathHelper.g(f1);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            result = player.teleportTo(worldserver, d0, d1, d2, set, f22, f3, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((org.bukkit.World)worldserver.getWorld(), d0, d1, d2, f22, f3);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), to);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f22 = to.getYaw();
            f3 = to.getPitch();
            worldserver = ((CraftWorld)to.getWorld()).getHandle();
            result = entity.a(worldserver, d0, d1, d2, set, f22, f3);
        }
        if (result) {
            EntityLiving entityliving;
            if (commandteleport_a != null) {
                commandteleport_a.perform(commandlistenerwrapper, entity);
            }
            if (!(entity instanceof EntityLiving) || !(entityliving = (EntityLiving)entity).fA()) {
                entity.i(entity.dr().d(1.0, 0.0, 1.0));
                entity.d(true);
            }
            if (entity instanceof EntityCreature) {
                EntityCreature entitycreature = (EntityCreature)entity;
                entitycreature.N().n();
            }
        }
    }

    @FunctionalInterface
    private static interface a {
        public void perform(CommandListenerWrapper var1, net.minecraft.world.entity.Entity var2);
    }

    private record c(Vec3D a) implements a
    {
        @Override
        public void perform(CommandListenerWrapper commandlistenerwrapper, net.minecraft.world.entity.Entity entity) {
            entity.a(commandlistenerwrapper.m(), this.a);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "position", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "position", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "position", "a"}, this, o2);
        }
    }

    private record b(net.minecraft.world.entity.Entity a, ArgumentAnchor.Anchor b) implements a
    {
        @Override
        public void perform(CommandListenerWrapper commandlistenerwrapper, net.minecraft.world.entity.Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(commandlistenerwrapper.m(), this.a, this.b);
            } else {
                entity.a(commandlistenerwrapper.m(), this.b.a(this.a));
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "entity;anchor", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "entity;anchor", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "entity;anchor", "a", "b"}, this, o2);
        }
    }
}

