/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.TimeRange;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class ThreadWatchdog
implements Runnable {
    private static final Logger a = LogUtils.getLogger();
    private static final long b = 10000L;
    private static final int c = 1;
    private final DedicatedServer d;
    private final long e;

    public ThreadWatchdog(DedicatedServer var0) {
        this.d = var0;
        this.e = var0.bv() * TimeRange.b;
    }

    @Override
    public void run() {
        while (this.d.x()) {
            long var0 = this.d.aC();
            long var2 = SystemUtils.d();
            long var4 = var2 - var0;
            if (var4 > this.e) {
                a.error(LogUtils.FATAL_MARKER, "A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var4 / (float)TimeRange.a)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(this.d.aQ().g() / (float)TimeRange.c)));
                a.error(LogUtils.FATAL_MARKER, "Considering it to be crashed, server will forcibly shutdown.");
                ThreadMXBean var6 = ManagementFactory.getThreadMXBean();
                ThreadInfo[] var7 = var6.dumpAllThreads(true, true);
                StringBuilder var8 = new StringBuilder();
                Error var9 = new Error("Watchdog");
                for (ThreadInfo threadInfo : var7) {
                    if (threadInfo.getThreadId() == this.d.az().getId()) {
                        var9.setStackTrace(threadInfo.getStackTrace());
                    }
                    var8.append(threadInfo);
                    var8.append("\n");
                }
                CrashReport var10 = new CrashReport("Watching Server", var9);
                this.d.b(var10.f());
                CrashReportSystemDetails var11 = var10.a("Thread Dump");
                var11.a("Threads", var8);
                CrashReportSystemDetails var12 = var10.a("Performance stats");
                var12.a("Random tick rate", () -> this.d.bb().o().a(GameRules.o).toString());
                var12.a("Level stats", () -> Streams.stream(this.d.K()).map(var0 -> String.valueOf(var0.af()) + ": " + var0.F()).collect(Collectors.joining(",\n")));
                DispenserRegistry.a("Crash report:\n" + var10.a(ReportType.a));
                Path path = this.d.D().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
                if (var10.a(path, ReportType.a)) {
                    a.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
                } else {
                    a.error("We were unable to save this crash report to disk.");
                }
                this.a();
            }
            try {
                Thread.sleep((var0 + this.e - var2) / TimeRange.b);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void a() {
        try {
            Timer var0 = new Timer();
            var0.schedule(new TimerTask(this){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable var0) {
            Runtime.getRuntime().halt(1);
        }
    }
}

