/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import org.slf4j.Logger;

public abstract class ChunkMapDistance {
    static final Logger a = LogUtils.getLogger();
    static final int b = ChunkLevel.a(FullChunkStatus.d);
    private static final int c = 4;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> d = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> e = new Long2ObjectOpenHashMap();
    private final a f = new a();
    private final b g = new b(8);
    private final TickingTracker h = new TickingTracker();
    private final c i = new c(32);
    final Set<PlayerChunk> j = Sets.newHashSet();
    final ChunkTaskQueueSorter k;
    final Mailbox<ChunkTaskQueueSorter.a<Runnable>> l;
    final Mailbox<ChunkTaskQueueSorter.b> m;
    final LongSet n = new LongOpenHashSet();
    final Executor o;
    private long p;
    public int q = 10;

    protected ChunkMapDistance(Executor executor, Executor executor1) {
        ChunkTaskQueueSorter chunktaskqueuesorter;
        Objects.requireNonNull(executor1);
        Mailbox<Runnable> mailbox = Mailbox.a("player ticket throttler", executor1::execute);
        this.k = chunktaskqueuesorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(mailbox), executor, 4);
        this.l = chunktaskqueuesorter.a(mailbox, true);
        this.m = chunktaskqueuesorter.a(mailbox);
        this.o = executor1;
    }

    protected void a() {
        ++this.p;
        ObjectIterator objectiterator = this.e.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((ArraySetSorted)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!ticket.b(this.p)) continue;
                iterator.remove();
                flag = true;
                this.h.b(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.f.b(entry.getLongKey(), ChunkMapDistance.a((ArraySetSorted)entry.getValue()), false);
            }
            if (!((ArraySetSorted)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int a(ArraySetSorted<Ticket<?>> arraysetsorted) {
        return !arraysetsorted.isEmpty() ? arraysetsorted.b().b() : ChunkLevel.b + 1;
    }

    protected abstract boolean a(long var1);

    @Nullable
    protected abstract PlayerChunk b(long var1);

    @Nullable
    protected abstract PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean a(PlayerChunkMap playerchunkmap) {
        boolean flag;
        this.g.a();
        this.h.a();
        this.i.a();
        int i2 = Integer.MAX_VALUE - this.f.a(Integer.MAX_VALUE);
        boolean bl = flag = i2 != 0;
        if (flag) {
            // empty if block
        }
        if (!this.j.isEmpty()) {
            this.j.forEach(playerchunk -> playerchunk.callEventIfUnloading(playerchunkmap));
            this.j.forEach(playerchunk -> playerchunk.a(playerchunkmap));
            this.j.forEach(playerchunk -> playerchunk.a(playerchunkmap, this.o));
            this.j.clear();
            return true;
        }
        if (!this.n.isEmpty()) {
            LongIterator longiterator = this.n.iterator();
            while (longiterator.hasNext()) {
                long j2 = longiterator.nextLong();
                if (!this.g(j2).stream().anyMatch(ticket -> ticket.a() == TicketType.c)) continue;
                PlayerChunk playerchunk2 = playerchunkmap.a(j2);
                if (playerchunk2 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<Chunk>> completablefuture = playerchunk2.b();
                completablefuture.thenAccept(chunkresult -> this.o.execute(() -> this.m.a(ChunkTaskQueueSorter.a(() -> {}, j2, false))));
            }
            this.n.clear();
        }
        return flag;
    }

    boolean addTicket(long i2, Ticket<?> ticket) {
        ArraySetSorted<Ticket<?>> arraysetsorted = this.g(i2);
        int j2 = ChunkMapDistance.a(arraysetsorted);
        Ticket<?> ticket1 = arraysetsorted.a(ticket);
        ticket1.a(this.p);
        if (ticket.b() < j2) {
            this.f.b(i2, ticket.b(), true);
        }
        return ticket == ticket1;
    }

    boolean removeTicket(long i2, Ticket<?> ticket) {
        ArraySetSorted<Ticket<?>> arraysetsorted = this.g(i2);
        boolean removed = false;
        if (arraysetsorted.remove(ticket)) {
            removed = true;
        }
        if (arraysetsorted.isEmpty()) {
            this.e.remove(i2);
        }
        this.f.b(i2, ChunkMapDistance.a(arraysetsorted), false);
        return removed;
    }

    public <T> void a(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.addTicket(chunkcoordintpair.a(), new Ticket<T>(tickettype, i2, t0));
    }

    public <T> void b(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, i2, t0);
        this.removeTicket(chunkcoordintpair.a(), ticket);
    }

    public <T> void c(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.addRegionTicketAtDistance(tickettype, chunkcoordintpair, i2, t0);
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, ChunkLevel.a(FullChunkStatus.b) - i2, t0);
        long j2 = chunkcoordintpair.a();
        boolean added = this.addTicket(j2, ticket);
        this.h.a(j2, ticket);
        return added;
    }

    public <T> void d(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.removeRegionTicketAtDistance(tickettype, chunkcoordintpair, i2, t0);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, ChunkLevel.a(FullChunkStatus.b) - i2, t0);
        long j2 = chunkcoordintpair.a();
        boolean removed = this.removeTicket(j2, ticket);
        this.h.b(j2, ticket);
        return removed;
    }

    private ArraySetSorted<Ticket<?>> g(long i2) {
        return (ArraySetSorted)this.e.computeIfAbsent(i2, j2 -> ArraySetSorted.a(4));
    }

    protected void a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.d, PlayerChunkMap.c, chunkcoordintpair);
        long i2 = chunkcoordintpair.a();
        if (flag) {
            this.addTicket(i2, ticket);
            this.h.a(i2, ticket);
        } else {
            this.removeTicket(i2, ticket);
            this.h.b(i2, ticket);
        }
    }

    public void a(SectionPosition sectionposition, EntityPlayer entityplayer) {
        ChunkCoordIntPair chunkcoordintpair = sectionposition.r();
        long i2 = chunkcoordintpair.a();
        ((ObjectSet)this.d.computeIfAbsent(i2, j2 -> new ObjectOpenHashSet())).add((Object)entityplayer);
        this.g.b(i2, 0, true);
        this.i.b(i2, 0, true);
        this.h.a(TicketType.c, chunkcoordintpair, this.g(), chunkcoordintpair);
    }

    public void b(SectionPosition sectionposition, EntityPlayer entityplayer) {
        ChunkCoordIntPair chunkcoordintpair = sectionposition.r();
        long i2 = chunkcoordintpair.a();
        ObjectSet objectset = (ObjectSet)this.d.get(i2);
        if (objectset == null) {
            return;
        }
        objectset.remove((Object)entityplayer);
        if (objectset.isEmpty()) {
            this.d.remove(i2);
            this.g.b(i2, Integer.MAX_VALUE, false);
            this.i.b(i2, Integer.MAX_VALUE, false);
            this.h.b(TicketType.c, chunkcoordintpair, this.g(), chunkcoordintpair);
        }
    }

    private int g() {
        return Math.max(0, ChunkLevel.a(FullChunkStatus.d) - this.q);
    }

    public boolean c(long i2) {
        return ChunkLevel.d(this.h.c(i2));
    }

    public boolean d(long i2) {
        return ChunkLevel.e(this.h.c(i2));
    }

    protected String e(long i2) {
        ArraySetSorted arraysetsorted = (ArraySetSorted)this.e.get(i2);
        return arraysetsorted != null && !arraysetsorted.isEmpty() ? ((Ticket)arraysetsorted.b()).toString() : "no_ticket";
    }

    protected void a(int i2) {
        this.i.a(i2);
    }

    public void b(int i2) {
        if (i2 != this.q) {
            this.q = i2;
            this.h.a(this.g());
        }
    }

    public int b() {
        this.g.a();
        return this.g.a.size();
    }

    public boolean f(long i2) {
        this.g.a();
        return this.g.a.containsKey(i2);
    }

    public String c() {
        return this.k.b();
    }

    private void a(String s2) {
        try (FileOutputStream fileoutputstream = new FileOutputStream(new File(s2));){
            for (Long2ObjectMap.Entry entry : this.e.long2ObjectEntrySet()) {
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(entry.getLongKey());
                for (Ticket ticket : (ArraySetSorted)entry.getValue()) {
                    fileoutputstream.write((chunkcoordintpair.e + "\t" + chunkcoordintpair.f + "\t" + String.valueOf(ticket.a()) + "\t" + ticket.b() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException ioexception) {
            a.error("Failed to dump tickets to {}", (Object)s2, (Object)ioexception);
        }
    }

    @VisibleForTesting
    TickingTracker d() {
        return this.h;
    }

    public void e() {
        ImmutableSet immutableset = ImmutableSet.of(TicketType.g, TicketType.f);
        ObjectIterator objectiterator = this.e.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((ArraySetSorted)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (immutableset.contains(ticket.a())) continue;
                iterator.remove();
                flag = true;
                this.h.b(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.f.b(entry.getLongKey(), ChunkMapDistance.a((ArraySetSorted)entry.getValue()), false);
            }
            if (!((ArraySetSorted)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    public boolean f() {
        return !this.e.isEmpty();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        Ticket<T> target = new Ticket<T>(ticketType, ticketLevel, ticketIdentifier);
        ObjectIterator iterator = this.e.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            ArraySetSorted tickets = (ArraySetSorted)entry.getValue();
            if (!tickets.remove(target)) continue;
            this.f.b(entry.getLongKey(), ChunkMapDistance.a(tickets), false);
            if (!tickets.isEmpty()) continue;
            iterator.remove();
        }
    }

    private class a
    extends ChunkMap {
        private static final int b = ChunkLevel.b + 1;

        public a() {
            super(b + 1, 16, 256);
        }

        @Override
        protected int b(long i2) {
            ArraySetSorted arraysetsorted = (ArraySetSorted)ChunkMapDistance.this.e.get(i2);
            return arraysetsorted == null ? Integer.MAX_VALUE : (arraysetsorted.isEmpty() ? Integer.MAX_VALUE : ((Ticket)arraysetsorted.b()).b());
        }

        @Override
        protected int c(long i2) {
            PlayerChunk playerchunk;
            if (!ChunkMapDistance.this.a(i2) && (playerchunk = ChunkMapDistance.this.b(i2)) != null) {
                return playerchunk.i();
            }
            return b;
        }

        @Override
        protected void a(long i2, int j2) {
            int k2;
            PlayerChunk playerchunk = ChunkMapDistance.this.b(i2);
            int n2 = k2 = playerchunk == null ? b : playerchunk.i();
            if (k2 != j2 && (playerchunk = ChunkMapDistance.this.a(i2, j2, playerchunk, k2)) != null) {
                ChunkMapDistance.this.j.add(playerchunk);
            }
        }

        public int a(int i2) {
            return this.b(i2);
        }
    }

    private class b
    extends ChunkMap {
        protected final Long2ByteMap a;
        protected final int b;

        protected b(int i2) {
            super(i2 + 2, 16, 256);
            this.a = new Long2ByteOpenHashMap();
            this.b = i2;
            this.a.defaultReturnValue((byte)(i2 + 2));
        }

        @Override
        protected int c(long i2) {
            return this.a.get(i2);
        }

        @Override
        protected void a(long i2, int j2) {
            byte b0 = j2 > this.b ? this.a.remove(i2) : this.a.put(i2, (byte)j2);
            this.a(i2, (int)b0, j2);
        }

        protected void a(long i2, int j2, int k2) {
        }

        @Override
        protected int b(long i2) {
            return this.d(i2) ? 0 : Integer.MAX_VALUE;
        }

        private boolean d(long i2) {
            ObjectSet objectset = (ObjectSet)ChunkMapDistance.this.d.get(i2);
            return objectset != null && !objectset.isEmpty();
        }

        public void a() {
            this.b(Integer.MAX_VALUE);
        }

        private void a(String s2) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(s2));){
                for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.a.long2ByteEntrySet()) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey());
                    String s1 = Byte.toString(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue());
                    fileoutputstream.write((chunkcoordintpair.e + "\t" + chunkcoordintpair.f + "\t" + s1 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                a.error("Failed to dump chunks to {}", (Object)s2, (Object)ioexception);
            }
        }
    }

    private class c
    extends b {
        private int g;
        private final Long2IntMap h;
        private final LongSet i;

        protected c(int i2) {
            super(i2);
            this.g = 0;
            this.h = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.i = new LongOpenHashSet();
            this.h.defaultReturnValue(i2 + 2);
        }

        @Override
        protected void a(long i2, int j2, int k2) {
            this.i.add(i2);
        }

        public void a(int i2) {
            for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.a.long2ByteEntrySet()) {
                byte b0 = it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue();
                long j2 = it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey();
                this.a(j2, b0, this.c(b0), b0 <= i2);
            }
            this.g = i2;
        }

        private void a(long i2, int j2, boolean flag, boolean flag1) {
            if (flag != flag1) {
                Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.c, b, new ChunkCoordIntPair(i2));
                if (flag1) {
                    ChunkMapDistance.this.l.a(ChunkTaskQueueSorter.a(() -> ChunkMapDistance.this.o.execute(() -> {
                        if (this.c(this.c(i2))) {
                            ChunkMapDistance.this.addTicket(i2, ticket);
                            ChunkMapDistance.this.n.add(i2);
                        } else {
                            ChunkMapDistance.this.m.a(ChunkTaskQueueSorter.a(() -> {}, i2, false));
                        }
                    }), i2, () -> j2));
                } else {
                    ChunkMapDistance.this.m.a(ChunkTaskQueueSorter.a(() -> ChunkMapDistance.this.o.execute(() -> ChunkMapDistance.this.removeTicket(i2, ticket)), i2, true));
                }
            }
        }

        @Override
        public void a() {
            super.a();
            if (!this.i.isEmpty()) {
                LongIterator longiterator = this.i.iterator();
                while (longiterator.hasNext()) {
                    int k2;
                    long i2 = longiterator.nextLong();
                    int j2 = this.h.get(i2);
                    if (j2 == (k2 = this.c(i2))) continue;
                    ChunkMapDistance.this.k.onLevelChange(new ChunkCoordIntPair(i2), () -> this.h.get(i2), k2, l2 -> {
                        if (l2 >= this.h.defaultReturnValue()) {
                            this.h.remove(i2);
                        } else {
                            this.h.put(i2, l2);
                        }
                    });
                    this.a(i2, k2, this.c(j2), this.c(k2));
                }
                this.i.clear();
            }
        }

        private boolean c(int i2) {
            return i2 <= this.g;
        }
    }
}

