/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.b,
GeneratingChunkMap {
    private static final ChunkResult<List<IChunkAccess>> f = ChunkResult.a("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> g = CompletableFuture.completedFuture(f);
    private static final byte h = -1;
    private static final byte i = 0;
    private static final byte j = 1;
    private static final Logger k = LogUtils.getLogger();
    private static final int l = 200;
    private static final int m = 20;
    private static final int n = 10000;
    public static final int a = 2;
    public static final int b = 32;
    public static final int c = ChunkLevel.a(FullChunkStatus.d);
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> o = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> p;
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> q;
    private final List<ChunkGenerationTask> r;
    public final WorldServer s;
    private final LightEngineThreaded t;
    private final IAsyncTaskHandler<Runnable> u;
    private final RandomState v;
    private final ChunkGeneratorStructureState w;
    private final Supplier<WorldPersistentData> x;
    private final VillagePlace y;
    public final LongSet z;
    private boolean A;
    private final ChunkTaskQueueSorter B;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> C;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> D;
    public final WorldLoadListener E;
    private final ChunkStatusUpdateListener F;
    public final a G;
    private final AtomicInteger H;
    private final String I;
    private final PlayerMap J;
    public final Int2ObjectMap<EntityTracker> K;
    private final Long2ByteMap L;
    private final Long2LongMap M;
    private final Queue<Runnable> N;
    public int O;
    private final WorldGenContext P;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public PlayerChunkMap(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, IAsyncTaskHandler<Runnable> iasynctaskhandler, ILightAccess ilightaccess, ChunkGenerator chunkgenerator, WorldLoadListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier, int i2, boolean flag) {
        super(new RegionStorageInfo(convertable_conversionsession.f(), worldserver.af(), "chunk"), convertable_conversionsession.a(worldserver.af()).resolve("region"), datafixer, flag);
        this.p = this.o.clone();
        this.q = new Long2ObjectLinkedOpenHashMap();
        this.r = new ArrayList<ChunkGenerationTask>();
        this.z = new LongOpenHashSet();
        this.H = new AtomicInteger();
        this.J = new PlayerMap();
        this.K = new Int2ObjectOpenHashMap();
        this.L = new Long2ByteOpenHashMap();
        this.M = new Long2LongOpenHashMap();
        this.N = Queues.newConcurrentLinkedQueue();
        Path path = convertable_conversionsession.a(worldserver.af());
        this.I = path.getFileName().toString();
        this.s = worldserver;
        IRegistryCustom iregistrycustom = worldserver.H_();
        long j2 = worldserver.C();
        ChunkGenerator randomGenerator = chunkgenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)randomGenerator;
            this.v = RandomState.a(chunkgeneratorabstract.h().a(), iregistrycustom.b(Registries.aP), j2);
        } else {
            this.v = RandomState.a(GeneratorSettingBase.e(), iregistrycustom.b(Registries.aP), j2);
        }
        this.w = chunkgenerator.createState(iregistrycustom.b(Registries.aT), this.v, j2, worldserver.spigotConfig);
        this.u = iasynctaskhandler;
        ThreadedMailbox<Runnable> threadedmailbox = ThreadedMailbox.a(executor, "worldgen");
        Objects.requireNonNull(iasynctaskhandler);
        Mailbox<Runnable> mailbox = Mailbox.a("main", iasynctaskhandler::i);
        this.E = worldloadlistener;
        this.F = chunkstatusupdatelistener;
        ThreadedMailbox<Runnable> threadedmailbox1 = ThreadedMailbox.a(executor, "light");
        this.B = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(threadedmailbox, mailbox, threadedmailbox1), executor, Integer.MAX_VALUE);
        this.C = this.B.a(threadedmailbox, false);
        this.D = this.B.a(mailbox, false);
        this.t = new LightEngineThreaded(ilightaccess, this, this.s.D_().g(), threadedmailbox1, this.B.a(threadedmailbox1, false));
        this.G = new a(executor, iasynctaskhandler);
        this.x = supplier;
        this.y = new VillagePlace(new RegionStorageInfo(convertable_conversionsession.f(), worldserver.af(), "poi"), path.resolve("poi"), datafixer, flag, iregistrycustom, worldserver.o(), worldserver);
        this.a(i2);
        this.P = new WorldGenContext(worldserver, chunkgenerator, structuretemplatemanager, this.t, this.D);
    }

    protected ChunkGenerator a() {
        return this.P.b();
    }

    protected ChunkGeneratorStructureState b() {
        return this.w;
    }

    protected RandomState c() {
        return this.v;
    }

    private static double a(ChunkCoordIntPair chunkcoordintpair, Entity entity) {
        double d0 = SectionPosition.a(chunkcoordintpair.e, 8);
        double d1 = SectionPosition.a(chunkcoordintpair.f, 8);
        double d2 = d0 - entity.dt();
        double d3 = d1 - entity.dz();
        return d2 * d2 + d3 * d3;
    }

    boolean a(EntityPlayer entityplayer, int i2, int j2) {
        return entityplayer.X().a(i2, j2) && !entityplayer.c.g.a(ChunkCoordIntPair.c(i2, j2));
    }

    private boolean b(EntityPlayer entityplayer, int i2, int j2) {
        if (!this.a(entityplayer, i2, j2)) {
            return false;
        }
        for (int k2 = -1; k2 <= 1; ++k2) {
            for (int l2 = -1; l2 <= 1; ++l2) {
                if (k2 == 0 && l2 == 0 || this.a(entityplayer, i2 + k2, j2 + l2)) continue;
                return true;
            }
        }
        return false;
    }

    protected LightEngineThreaded d() {
        return this.t;
    }

    @Nullable
    protected PlayerChunk a(long i2) {
        return (PlayerChunk)this.o.get(i2);
    }

    @Nullable
    protected PlayerChunk b(long i2) {
        return (PlayerChunk)this.p.get(i2);
    }

    protected IntSupplier c(long i2) {
        return () -> {
            PlayerChunk playerchunk = this.b(i2);
            return playerchunk == null ? ChunkTaskQueue.a - 1 : Math.min(playerchunk.j(), ChunkTaskQueue.a - 1);
        };
    }

    public String a(ChunkCoordIntPair chunkcoordintpair) {
        PlayerChunk playerchunk = this.b(chunkcoordintpair.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.i() + "\n";
        ChunkStatus chunkstatus = playerchunk.u();
        IChunkAccess ichunkaccess = playerchunk.p();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.b() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.j().b() + String.valueOf(ichunkaccess.j()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.s();
        s2 = s2 + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s2 + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<IChunkAccess>>> a(PlayerChunk playerchunk, int i2, IntFunction<ChunkStatus> intfunction) {
        if (i2 == 0) {
            ChunkStatus chunkstatus = intfunction.apply(0);
            return playerchunk.a(chunkstatus, this).thenApply(chunkresult -> chunkresult.a(List::of));
        }
        ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>> list = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>();
        ChunkCoordIntPair chunkcoordintpair = playerchunk.r();
        for (int j2 = -i2; j2 <= i2; ++j2) {
            for (int k2 = -i2; k2 <= i2; ++k2) {
                int l2 = Math.max(Math.abs(k2), Math.abs(j2));
                long i1 = ChunkCoordIntPair.c(chunkcoordintpair.e + k2, chunkcoordintpair.f + j2);
                PlayerChunk playerchunk1 = this.a(i1);
                if (playerchunk1 == null) {
                    return g;
                }
                ChunkStatus chunkstatus1 = intfunction.apply(l2);
                list.add(playerchunk1.a(chunkstatus1, this));
            }
        }
        return SystemUtils.d(list).thenApply(list1 -> {
            ArrayList list2 = Lists.newArrayList();
            for (ChunkResult chunkresult : list1) {
                if (chunkresult == null) {
                    throw this.a(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                IChunkAccess ichunkaccess = chunkresult.b(null);
                if (ichunkaccess == null) {
                    return f;
                }
                list2.add(ichunkaccess);
            }
            return ChunkResult.a(list2);
        });
    }

    public ReportedException a(IllegalStateException illegalstateexception, String s2) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.t().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.r()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.o.values().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.p.values().forEach(consumer);
        CrashReport crashreport = CrashReport.a(illegalstateexception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", s2);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<Chunk>> a(PlayerChunk playerchunk) {
        return this.a(playerchunk, 2, (int i2) -> ChunkStatus.n).thenApplyAsync(chunkresult -> chunkresult.a((T list) -> (Chunk)list.get(list.size() / 2)), (Executor)this.u);
    }

    @Nullable
    PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
        if (!ChunkLevel.f(k2) && !ChunkLevel.f(j2)) {
            return playerchunk;
        }
        if (playerchunk != null) {
            playerchunk.a(j2);
        }
        if (playerchunk != null) {
            if (!ChunkLevel.f(j2)) {
                this.z.add(i2);
            } else {
                this.z.remove(i2);
            }
        }
        if (ChunkLevel.f(j2) && playerchunk == null) {
            playerchunk = (PlayerChunk)this.q.remove(i2);
            if (playerchunk != null) {
                playerchunk.a(j2);
            } else {
                playerchunk = new PlayerChunk(new ChunkCoordIntPair(i2), j2, this.s, this.t, this.B, this);
            }
            this.o.put(i2, (Object)playerchunk);
            this.A = true;
        }
        return playerchunk;
    }

    @Override
    public void close() throws IOException {
        try {
            this.B.close();
            this.y.close();
        }
        finally {
            super.close();
        }
    }

    protected void a(boolean flag) {
        if (flag) {
            List<PlayerChunk> list = this.p.values().stream().filter(PlayerChunk::k).peek(PlayerChunk::l).toList();
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    IAsyncTaskHandler<Runnable> iasynctaskhandler = this.u;
                    Objects.requireNonNull(playerchunk);
                    iasynctaskhandler.b(playerchunk::h);
                    return playerchunk.p();
                }).filter(ichunkaccess -> ichunkaccess instanceof ProtoChunkExtension || ichunkaccess instanceof Chunk).filter(this::a).forEach(ichunkaccess -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.b(() -> true);
            this.o();
        } else {
            this.p.values().forEach(this::d);
        }
    }

    protected void a(BooleanSupplier booleansupplier) {
        GameProfilerFiller gameprofilerfiller = this.s.ag();
        gameprofilerfiller.a("poi");
        this.y.a(booleansupplier);
        gameprofilerfiller.b("chunk_unload");
        if (!this.s.t()) {
            this.b(booleansupplier);
        }
        gameprofilerfiller.c();
    }

    public boolean e() {
        return this.t.K_() || !this.q.isEmpty() || !this.o.isEmpty() || this.y.a() || !this.z.isEmpty() || !this.N.isEmpty() || this.B.a() || this.G.f();
    }

    private void b(BooleanSupplier booleansupplier) {
        Runnable runnable;
        LongIterator longiterator = this.z.iterator();
        int i2 = 0;
        while (longiterator.hasNext() && (booleansupplier.getAsBoolean() || i2 < 200 || this.z.size() > 2000)) {
            long j2 = longiterator.nextLong();
            PlayerChunk playerchunk = (PlayerChunk)this.o.get(j2);
            if (playerchunk != null) {
                if (playerchunk.o() != 0) continue;
                this.o.remove(j2);
                this.q.put(j2, (Object)playerchunk);
                this.A = true;
                ++i2;
                this.a(j2, playerchunk);
            }
            longiterator.remove();
        }
        for (int k2 = Math.max(0, this.N.size() - 2000); (booleansupplier.getAsBoolean() || k2 > 0) && (runnable = this.N.poll()) != null; --k2) {
            runnable.run();
        }
        int l2 = 0;
        ObjectIterator objectiterator = this.p.values().iterator();
        while (l2 < 20 && booleansupplier.getAsBoolean() && objectiterator.hasNext()) {
            if (!this.d((PlayerChunk)objectiterator.next())) continue;
            ++l2;
        }
    }

    private void a(long i2, PlayerChunk playerchunk) {
        CompletableFuture<?> completablefuture = playerchunk.g();
        Runnable runnable = () -> {
            if (!playerchunk.h()) {
                this.a(i2, playerchunk);
            } else {
                IChunkAccess ichunkaccess = playerchunk.p();
                if (this.q.remove(i2, (Object)playerchunk) && ichunkaccess != null) {
                    Chunk chunk;
                    if (ichunkaccess instanceof Chunk) {
                        chunk = (Chunk)ichunkaccess;
                        chunk.c(false);
                    }
                    this.a(ichunkaccess);
                    if (ichunkaccess instanceof Chunk) {
                        chunk = (Chunk)ichunkaccess;
                        this.s.a(chunk);
                    }
                    this.t.a(ichunkaccess.f());
                    this.t.b();
                    this.E.a(ichunkaccess.f(), null);
                    this.M.remove(ichunkaccess.f().a());
                }
            }
        };
        Queue<Runnable> queue = this.N;
        Objects.requireNonNull(this.N);
        ((CompletableFuture)completablefuture.thenRunAsync(runnable, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                k.error("Failed to save chunk {}", (Object)playerchunk.r(), throwable);
            }
        });
    }

    protected boolean f() {
        if (!this.A) {
            return false;
        }
        this.p = this.o.clone();
        this.A = false;
        return true;
    }

    private CompletableFuture<IChunkAccess> f(ChunkCoordIntPair chunkcoordintpair) {
        return ((CompletableFuture)((CompletableFuture)this.j(chunkcoordintpair).thenApply(optional -> optional.filter(nbttagcompound -> {
            boolean flag = PlayerChunkMap.b(nbttagcompound);
            if (!flag) {
                k.error("Chunk file at {} is missing level data, skipping", (Object)chunkcoordintpair);
            }
            return flag;
        }))).thenApplyAsync(optional -> {
            this.s.ag().d("chunkLoad");
            if (optional.isPresent()) {
                ProtoChunk protochunk = ChunkRegionLoader.a(this.s, this.y, this.q(), chunkcoordintpair, (NBTTagCompound)optional.get());
                this.a(chunkcoordintpair, protochunk.j().d());
                return protochunk;
            }
            return this.g(chunkcoordintpair);
        }, (Executor)this.u)).exceptionallyAsync(throwable -> this.a((Throwable)throwable, chunkcoordintpair), (Executor)this.u);
    }

    private static boolean b(NBTTagCompound nbttagcompound) {
        return nbttagcompound.b("Status", 8);
    }

    private IChunkAccess a(Throwable throwable, ChunkCoordIntPair chunkcoordintpair) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.s.o().a(throwable3, this.q(), chunkcoordintpair);
            return this.g(chunkcoordintpair);
        }
        CrashReport crashreport = CrashReport.a(throwable, "Exception loading chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk being loaded");
        crashreportsystemdetails.a("pos", chunkcoordintpair);
        this.h(chunkcoordintpair);
        throw new ReportedException(crashreport);
    }

    private IChunkAccess g(ChunkCoordIntPair chunkcoordintpair) {
        this.h(chunkcoordintpair);
        return new ProtoChunk(chunkcoordintpair, ChunkConverter.a, this.s, this.s.H_().d(Registries.aF), null);
    }

    private void h(ChunkCoordIntPair chunkcoordintpair) {
        this.L.put(chunkcoordintpair.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair chunkcoordintpair, ChunkType chunktype) {
        return this.L.put(chunkcoordintpair.a(), (byte)(chunktype == ChunkType.a ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder d(long i2) {
        PlayerChunk playerchunk = (PlayerChunk)this.o.get(i2);
        playerchunk.m();
        return playerchunk;
    }

    @Override
    public void a(GenerationChunkHolder generationchunkholder) {
        generationchunkholder.n();
    }

    @Override
    public CompletableFuture<IChunkAccess> a(GenerationChunkHolder generationchunkholder, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d) {
        ChunkCoordIntPair chunkcoordintpair = generationchunkholder.r();
        if (chunkstep.a() == ChunkStatus.c) {
            return this.f(chunkcoordintpair);
        }
        try {
            GenerationChunkHolder generationchunkholder1 = staticcache2d.a(chunkcoordintpair.e, chunkcoordintpair.f);
            IChunkAccess ichunkaccess = generationchunkholder1.a(chunkstep.a().c());
            if (ichunkaccess == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            CompletableFuture<IChunkAccess> completablefuture = chunkstep.a(this.P, staticcache2d, ichunkaccess);
            this.E.a(chunkcoordintpair, chunkstep.a());
            return completablefuture;
        }
        catch (Exception exception) {
            exception.getStackTrace();
            CrashReport crashreport = CrashReport.a(exception, "Exception generating new chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk to be generated");
            crashreportsystemdetails.a("Status being generated", () -> chunkstep.a().f());
            crashreportsystemdetails.a("Location", String.format(Locale.ROOT, "%d,%d", chunkcoordintpair.e, chunkcoordintpair.f));
            crashreportsystemdetails.a("Position hash", ChunkCoordIntPair.c(chunkcoordintpair.e, chunkcoordintpair.f));
            crashreportsystemdetails.a("Generator", this.a());
            this.u.execute(() -> {
                throw new ReportedException(crashreport);
            });
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public ChunkGenerationTask a(ChunkStatus chunkstatus, ChunkCoordIntPair chunkcoordintpair) {
        ChunkGenerationTask chunkgenerationtask = ChunkGenerationTask.a((GeneratingChunkMap)this, chunkstatus, chunkcoordintpair);
        this.r.add(chunkgenerationtask);
        return chunkgenerationtask;
    }

    private void a(ChunkGenerationTask chunkgenerationtask) {
        this.C.a(ChunkTaskQueueSorter.a(chunkgenerationtask.c(), () -> {
            CompletableFuture<?> completablefuture = chunkgenerationtask.a();
            if (completablefuture != null) {
                completablefuture.thenRun(() -> this.a(chunkgenerationtask));
            }
        }));
    }

    @Override
    public void g() {
        this.r.forEach(this::a);
        this.r.clear();
    }

    public CompletableFuture<ChunkResult<Chunk>> b(PlayerChunk playerchunk) {
        CompletableFuture<ChunkResult<List<IChunkAccess>>> completablefuture = this.a(playerchunk, 1, (int i2) -> ChunkStatus.n);
        CompletionStage completablefuture1 = ((CompletableFuture)completablefuture.thenApplyAsync(chunkresult -> chunkresult.a((T list) -> (Chunk)list.get(list.size() / 2)), runnable -> this.D.a(ChunkTaskQueueSorter.a((GenerationChunkHolder)playerchunk, runnable)))).thenApplyAsync(chunkresult -> chunkresult.a((T chunk) -> {
            chunk.H();
            this.s.b((Chunk)chunk);
            CompletableFuture<?> completablefuture2 = playerchunk.f();
            if (completablefuture2.isDone()) {
                this.a((Chunk)chunk);
            } else {
                completablefuture2.thenAcceptAsync(object -> this.a((Chunk)chunk), (Executor)this.u);
            }
        }), (Executor)this.u);
        ((CompletableFuture)completablefuture1).handle((chunkresult, throwable) -> {
            this.H.getAndIncrement();
            return null;
        });
        return completablefuture1;
    }

    private void a(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        for (EntityPlayer entityplayer : this.J.a()) {
            if (!entityplayer.X().a(chunkcoordintpair)) continue;
            PlayerChunkMap.a(entityplayer, chunk);
        }
    }

    public CompletableFuture<ChunkResult<Chunk>> c(PlayerChunk playerchunk) {
        return this.a(playerchunk, 1, ChunkLevel::b).thenApplyAsync(chunkresult -> chunkresult.a((T list) -> (Chunk)list.get(list.size() / 2)), runnable -> this.D.a(ChunkTaskQueueSorter.a((GenerationChunkHolder)playerchunk, runnable)));
    }

    public int h() {
        return this.H.get();
    }

    private boolean d(PlayerChunk playerchunk) {
        if (playerchunk.k() && playerchunk.h()) {
            IChunkAccess ichunkaccess = playerchunk.p();
            if (!(ichunkaccess instanceof ProtoChunkExtension) && !(ichunkaccess instanceof Chunk)) {
                return false;
            }
            long i2 = ichunkaccess.f().a();
            long j2 = this.M.getOrDefault(i2, -1L);
            long k2 = System.currentTimeMillis();
            if (k2 < j2) {
                return false;
            }
            boolean flag = this.a(ichunkaccess);
            playerchunk.l();
            if (flag) {
                this.M.put(i2, k2 + 10000L);
            }
            return flag;
        }
        return false;
    }

    public boolean a(IChunkAccess ichunkaccess) {
        this.y.a(ichunkaccess.f());
        if (!ichunkaccess.i()) {
            return false;
        }
        ichunkaccess.a(false);
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        try {
            ChunkStatus chunkstatus = ichunkaccess.j();
            if (chunkstatus.d() != ChunkType.b) {
                if (this.i(chunkcoordintpair)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.c && ichunkaccess.g().values().stream().noneMatch(StructureStart::b)) {
                    return false;
                }
            }
            this.s.ag().d("chunkSave");
            NBTTagCompound nbttagcompound = ChunkRegionLoader.a(this.s, ichunkaccess);
            this.a(chunkcoordintpair, nbttagcompound).exceptionally(throwable -> {
                this.s.o().b((Throwable)throwable, this.q(), chunkcoordintpair);
                return null;
            });
            this.a(chunkcoordintpair, chunkstatus.d());
            return true;
        }
        catch (Exception exception) {
            this.s.o().b(exception, this.q(), chunkcoordintpair);
            return false;
        }
    }

    private boolean i(ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound;
        byte b0 = this.L.get(chunkcoordintpair.a());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.j(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound == null) {
                this.h(chunkcoordintpair);
                return false;
            }
        }
        catch (Exception exception) {
            k.error("Failed to read chunk {}", (Object)chunkcoordintpair, (Object)exception);
            this.h(chunkcoordintpair);
            return false;
        }
        ChunkType chunktype = ChunkRegionLoader.a(nbttagcompound);
        return this.a(chunkcoordintpair, chunktype) == 1;
    }

    protected void a(int i2) {
        int j2 = MathHelper.a(i2, 2, 32);
        if (j2 != this.O) {
            this.O = j2;
            this.G.a(this.O);
            for (EntityPlayer entityplayer : this.J.a()) {
                this.e(entityplayer);
            }
        }
    }

    int b(EntityPlayer entityplayer) {
        return MathHelper.a(entityplayer.F(), 2, this.O);
    }

    private void a(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        Chunk chunk = this.e(chunkcoordintpair.a());
        if (chunk != null) {
            PlayerChunkMap.a(entityplayer, chunk);
        }
    }

    private static void a(EntityPlayer entityplayer, Chunk chunk) {
        entityplayer.c.g.a(chunk);
    }

    private static void b(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        entityplayer.c.g.a(entityplayer, chunkcoordintpair);
    }

    @Nullable
    public Chunk e(long i2) {
        PlayerChunk playerchunk = this.b(i2);
        return playerchunk == null ? null : playerchunk.e();
    }

    public int i() {
        return this.p.size();
    }

    public ChunkMapDistance j() {
        return this.G;
    }

    protected Iterable<PlayerChunk> k() {
        return Iterables.unmodifiableIterable((Iterable)this.p.values());
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        TickingTracker tickingtracker = this.G.d();
        for (Long2ObjectMap.Entry entry : this.p.long2ObjectEntrySet()) {
            long i2 = entry.getLongKey();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            PlayerChunk playerchunk = (PlayerChunk)entry.getValue();
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.p());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.a(chunkcoordintpair.e, chunkcoordintpair.f, playerchunk.i(), optional.isPresent(), optional.map(IChunkAccess::j).orElse(null), optional1.map(Chunk::D).orElse(null), PlayerChunkMap.a(playerchunk.c()), PlayerChunkMap.a(playerchunk.a()), PlayerChunkMap.a(playerchunk.b()), this.G.e(i2), this.b(chunkcoordintpair), optional1.map(chunk -> chunk.G().size()).orElse(0), tickingtracker.d(i2), tickingtracker.c(i2), optional1.map(chunk -> chunk.o().a()).orElse(0), optional1.map(chunk -> chunk.p().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<ChunkResult<Chunk>> completablefuture) {
        try {
            ChunkResult chunkresult = completablefuture.getNow(null);
            return chunkresult != null ? (chunkresult.a() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> j(ChunkCoordIntPair chunkcoordintpair) {
        return this.d(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((NBTTagCompound)nbttagcompound, chunkcoordintpair)), (Executor)SystemUtils.g());
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(this.s.getTypeKey(), this.x, nbttagcompound, this.a().c(), chunkcoordintpair, this.s);
    }

    boolean b(ChunkCoordIntPair chunkcoordintpair) {
        return this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        EntityPlayer entityplayer;
        double blockRange;
        int chunkRange = this.s.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.s.spigotConfig.viewDistance ? (int)this.s.spigotConfig.viewDistance : chunkRange;
        chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double d2 = blockRange = reducedRange ? Math.pow(chunkRange << 4, 2.0) : 16384.0;
        if (!this.G.f(chunkcoordintpair.a())) {
            return false;
        }
        Iterator<EntityPlayer> iterator = this.J.a().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!this.playerIsCloseEnoughForSpawning(entityplayer = iterator.next(), chunkcoordintpair, blockRange));
        return true;
    }

    public List<EntityPlayer> c(ChunkCoordIntPair chunkcoordintpair) {
        long i2 = chunkcoordintpair.a();
        if (!this.G.f(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.J.a()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.R_()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean c(EntityPlayer entityplayer) {
        return entityplayer.R_() && !this.s.ab().b(GameRules.r);
    }

    void a(EntityPlayer entityplayer, boolean flag) {
        boolean flag1 = this.c(entityplayer);
        boolean flag2 = this.J.d(entityplayer);
        if (flag) {
            this.J.a(entityplayer, flag1);
            this.d(entityplayer);
            if (!flag1) {
                this.G.a(SectionPosition.a(entityplayer), entityplayer);
            }
            entityplayer.a(ChunkTrackingView.a);
            this.e(entityplayer);
        } else {
            SectionPosition sectionposition = entityplayer.W();
            this.J.a(entityplayer);
            if (!flag2) {
                this.G.b(sectionposition, entityplayer);
            }
            this.a(entityplayer, ChunkTrackingView.a);
        }
    }

    private void d(EntityPlayer entityplayer) {
        SectionPosition sectionposition = SectionPosition.a(entityplayer);
        entityplayer.a(sectionposition);
    }

    public void a(EntityPlayer entityplayer) {
        boolean flag2;
        for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
            if (playerchunkmap_entitytracker.c == entityplayer) {
                playerchunkmap_entitytracker.a(this.s.x());
                continue;
            }
            playerchunkmap_entitytracker.b(entityplayer);
        }
        SectionPosition sectionposition = entityplayer.W();
        SectionPosition sectionposition1 = SectionPosition.a(entityplayer);
        boolean flag = this.J.e(entityplayer);
        boolean flag1 = this.c(entityplayer);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.d(entityplayer);
            if (!flag) {
                this.G.b(sectionposition, entityplayer);
            }
            if (!flag1) {
                this.G.a(sectionposition1, entityplayer);
            }
            if (!flag && flag1) {
                this.J.b(entityplayer);
            }
            if (flag && !flag1) {
                this.J.c(entityplayer);
            }
            this.e(entityplayer);
        }
    }

    private void e(EntityPlayer entityplayer) {
        ChunkTrackingView.a chunktrackingview_a;
        ChunkCoordIntPair chunkcoordintpair = entityplayer.dq();
        int i2 = this.b(entityplayer);
        ChunkTrackingView chunktrackingview = entityplayer.X();
        if (chunktrackingview instanceof ChunkTrackingView.a && (chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview).a().equals(chunkcoordintpair) && chunktrackingview_a.b() == i2) {
            return;
        }
        this.a(entityplayer, ChunkTrackingView.a(chunkcoordintpair, i2));
    }

    private void a(EntityPlayer entityplayer, ChunkTrackingView chunktrackingview) {
        if (entityplayer.dO() == this.s) {
            ChunkTrackingView chunktrackingview1 = entityplayer.X();
            if (chunktrackingview instanceof ChunkTrackingView.a) {
                ChunkTrackingView.a chunktrackingview_a1;
                ChunkTrackingView.a chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview;
                if (!(chunktrackingview1 instanceof ChunkTrackingView.a) || !(chunktrackingview_a1 = (ChunkTrackingView.a)chunktrackingview1).a().equals(chunktrackingview_a.a())) {
                    entityplayer.c.b(new PacketPlayOutViewCentre(chunktrackingview_a.a().e, chunktrackingview_a.a().f));
                }
            }
            ChunkTrackingView.a(chunktrackingview1, chunktrackingview, chunkcoordintpair -> this.a(entityplayer, (ChunkCoordIntPair)chunkcoordintpair), chunkcoordintpair -> PlayerChunkMap.b(entityplayer, chunkcoordintpair));
            entityplayer.a(chunktrackingview);
        }
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Set<EntityPlayer> set = this.J.a();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : set) {
            if ((!flag || !this.b(entityplayer, chunkcoordintpair.e, chunkcoordintpair.f)) && (flag || !this.a(entityplayer, chunkcoordintpair.e, chunkcoordintpair.f))) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    protected void a(Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.am();
            int i2 = entitytypes.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                int j2 = entitytypes.p();
                if (this.K.containsKey(entity.an())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                EntityTracker playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.q());
                this.K.put(entity.an(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.a(this.s.x());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.K.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.K.remove(entity.an())) != null) {
            playerchunkmap_entitytracker1.a();
        }
    }

    protected void l() {
        for (EntityPlayer entityplayer : this.J.a()) {
            this.e(entityplayer);
        }
        ArrayList list = Lists.newArrayList();
        List<EntityPlayer> list1 = this.s.x();
        for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
            boolean flag;
            SectionPosition sectionposition = playerchunkmap_entitytracker.e;
            SectionPosition sectionposition1 = SectionPosition.a(playerchunkmap_entitytracker.c);
            boolean bl = flag = !Objects.equals(sectionposition, sectionposition1);
            if (flag) {
                playerchunkmap_entitytracker.a(list1);
                Entity entity = playerchunkmap_entitytracker.c;
                if (entity instanceof EntityPlayer) {
                    list.add((EntityPlayer)entity);
                }
                playerchunkmap_entitytracker.e = sectionposition1;
            }
            if (!flag && !this.G.c(sectionposition1.r().a())) continue;
            playerchunkmap_entitytracker.b.a();
        }
        if (!list.isEmpty()) {
            for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
                playerchunkmap_entitytracker.a(list);
            }
        }
    }

    public void a(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.an());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    protected void b(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.an());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    public void a(List<IChunkAccess> list) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : list) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.s.d(chunkcoordintpair.e, chunkcoordintpair.f);
            for (EntityPlayer entityplayer : this.a(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.c.b(ClientboundChunksBiomesPacket.a(list1)));
    }

    protected VillagePlace m() {
        return this.y;
    }

    public String n() {
        return this.I;
    }

    void a(ChunkCoordIntPair chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        this.F.onChunkStatusChange(chunkcoordintpair, fullchunkstatus);
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        int j2 = i2 + 1;
        ChunkCoordIntPair.a(chunkcoordintpair, j2).forEach(chunkcoordintpair1 -> {
            PlayerChunk playerchunk = this.b(chunkcoordintpair1.a());
            if (playerchunk != null) {
                playerchunk.a(this.t.a(chunkcoordintpair1.e, chunkcoordintpair1.f));
            }
        });
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    private class a
    extends ChunkMapDistance {
        protected a(Executor executor, Executor executor1) {
            super(executor, executor1);
        }

        @Override
        protected boolean a(long i2) {
            return PlayerChunkMap.this.z.contains(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk b(long i2) {
            return PlayerChunkMap.this.a(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
            return PlayerChunkMap.this.a(i2, j2, playerchunk, k2);
        }
    }

    public class EntityTracker {
        public final EntityTrackerEntry b;
        final Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = Sets.newIdentityHashSet();

        public EntityTracker(Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.s, entity, j2, flag, this::a, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.an() == this.c.an() : false;
        }

        public int hashCode() {
            return this.c.an();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.b(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).c.b(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.o());
            }
        }

        public void a(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(entityplayer.c)) {
                this.b.a(entityplayer);
            }
        }

        public void b(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker update");
            if (entityplayer != this.c) {
                boolean flag;
                Vec3D vec3d = entityplayer.dm().d(this.c.dm());
                int i2 = PlayerChunkMap.this.b(entityplayer);
                double d1 = vec3d.c * vec3d.c + vec3d.e * vec3d.e;
                double d0 = Math.min(this.b(), i2 * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.c.a(entityplayer) && PlayerChunkMap.this.a(entityplayer, this.c.dq().e, this.c.dq().f);
                if (!entityplayer.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(entityplayer.c)) {
                        this.b.b(entityplayer);
                    }
                } else if (this.f.remove(entityplayer.c)) {
                    this.b.a(entityplayer);
                }
            }
        }

        private int a(int i2) {
            return PlayerChunkMap.this.s.o().b(i2);
        }

        private int b() {
            int i2 = this.d;
            for (Entity entity : this.c.cW()) {
                int j2 = entity.am().o() * 16;
                if (j2 <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> list) {
            for (EntityPlayer entityplayer : list) {
                this.b(entityplayer);
            }
        }
    }
}

