/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Locale;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyProtocolUtils;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.server.ServerListPingEvent;
import org.slf4j.Logger;

public class LegacyPingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger a = LogUtils.getLogger();
    private final ServerInfo b;

    public LegacyPingHandler(ServerInfo serverinfo) {
        this.b = serverinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void channelRead(ChannelHandlerContext channelhandlercontext, Object object) {
        block13: {
            block14: {
                block11: {
                    block12: {
                        block16: {
                            block9: {
                                block10: {
                                    bytebuf = (ByteBuf)object;
                                    bytebuf.markReaderIndex();
                                    flag = true;
                                    if (bytebuf.readUnsignedByte() == 254) break block9;
                                    if (!flag) break block10;
                                    bytebuf.resetReaderIndex();
                                    channelhandlercontext.channel().pipeline().remove((ChannelHandler)this);
                                    channelhandlercontext.fireChannelRead(object);
                                }
                                return;
                            }
                            socketaddress = channelhandlercontext.channel().remoteAddress();
                            i = bytebuf.readableBytes();
                            event = CraftEventFactory.callServerListPingEvent(socketaddress, this.b.af(), this.b.M(), this.b.N());
                            if (i != 0) break block16;
                            LegacyPingHandler.a.debug("Ping: (<1.3.x) from {}", (Object)socketaddress);
                            s = LegacyPingHandler.createVersion0Response(this.b, event);
                            LegacyPingHandler.a(channelhandlercontext, LegacyPingHandler.a(channelhandlercontext.alloc(), s));
                            ** GOTO lbl59
                        }
                        if (bytebuf.readUnsignedByte() == 1) break block11;
                        if (!flag) break block12;
                        bytebuf.resetReaderIndex();
                        channelhandlercontext.channel().pipeline().remove((ChannelHandler)this);
                        channelhandlercontext.fireChannelRead(object);
                    }
                    return;
                }
                if (!bytebuf.isReadable()) ** GOTO lbl55
                if (LegacyPingHandler.a(bytebuf)) break block13;
                if (!flag) break block14;
                bytebuf.resetReaderIndex();
                channelhandlercontext.channel().pipeline().remove((ChannelHandler)this);
                channelhandlercontext.fireChannelRead(object);
            }
            return;
        }
        try {
            try {
                block17: {
                    LegacyPingHandler.a.debug("Ping: (1.6) from {}", (Object)socketaddress);
                    break block17;
lbl55:
                    // 1 sources

                    LegacyPingHandler.a.debug("Ping: (1.4-1.5.x) from {}", (Object)socketaddress);
                }
                s = LegacyPingHandler.createVersion1Response(this.b, event);
                LegacyPingHandler.a(channelhandlercontext, LegacyPingHandler.a(channelhandlercontext.alloc(), s));
lbl59:
                // 2 sources

                bytebuf.release();
                flag = false;
            }
            catch (RuntimeException var5_6) {
                // empty catch block
            }
        }
        catch (Throwable var9_11) {
            throw var9_11;
        }
        finally {
            if (flag) {
                bytebuf.resetReaderIndex();
                channelhandlercontext.channel().pipeline().remove((ChannelHandler)this);
                channelhandlercontext.fireChannelRead(object);
            }
        }
    }

    private static boolean a(ByteBuf bytebuf) {
        short short0 = bytebuf.readUnsignedByte();
        if (short0 != 250) {
            return false;
        }
        String s2 = LegacyProtocolUtils.a(bytebuf);
        if (!"MC|PingHost".equals(s2)) {
            return false;
        }
        int i2 = bytebuf.readUnsignedShort();
        if (bytebuf.readableBytes() != i2) {
            return false;
        }
        short short1 = bytebuf.readUnsignedByte();
        if (short1 < 73) {
            return false;
        }
        String s1 = LegacyProtocolUtils.a(bytebuf);
        int j2 = bytebuf.readInt();
        return j2 <= 65535;
    }

    private static String createVersion0Response(ServerInfo serverinfo, ServerListPingEvent event) {
        return String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", event.getMotd(), event.getNumPlayers(), event.getMaxPlayers());
    }

    private static String createVersion1Response(ServerInfo serverinfo, ServerListPingEvent event) {
        return String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, serverinfo.L(), event.getMotd(), event.getNumPlayers(), event.getMaxPlayers());
    }

    private static void a(ChannelHandlerContext channelhandlercontext, ByteBuf bytebuf) {
        channelhandlercontext.pipeline().firstContext().writeAndFlush((Object)bytebuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static ByteBuf a(ByteBufAllocator bytebufallocator, String s2) {
        ByteBuf bytebuf = bytebufallocator.buffer();
        bytebuf.writeByte(255);
        LegacyProtocolUtils.a(bytebuf, s2);
        return bytebuf;
    }
}

