/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.ExpirableListEntry;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class NameReferencingFileConverter {
    static final Logger e = LogUtils.getLogger();
    public static final File a = new File("banned-ips.txt");
    public static final File b = new File("banned-players.txt");
    public static final File c = new File("ops.txt");
    public static final File d = new File("white-list.txt");

    static List<String> a(File file, Map<String, String[]> map) throws IOException {
        List list = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        for (String s2 : list) {
            if ((s2 = s2.trim()).startsWith("#") || s2.length() < 1) continue;
            String[] astring = s2.split("\\|");
            map.put(astring[0].toLowerCase(Locale.ROOT), astring);
        }
        return list;
    }

    private static void a(MinecraftServer minecraftserver, Collection<String> collection, ProfileLookupCallback profilelookupcallback) {
        String[] astring = (String[])collection.stream().filter(s2 -> !UtilColor.b(s2)).toArray(String[]::new);
        if (minecraftserver.Z() || SpigotConfig.bungee) {
            minecraftserver.at().findProfilesByNames(astring, profilelookupcallback);
        } else {
            String[] astring1 = astring;
            int i2 = astring.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                String s3 = astring1[j2];
                profilelookupcallback.onProfileLookupSucceeded(UUIDUtil.b(s3));
            }
        }
    }

    public static boolean a(final MinecraftServer minecraftserver) {
        final GameProfileBanList gameprofilebanlist = new GameProfileBanList(PlayerList.a);
        if (b.exists() && b.isFile()) {
            if (gameprofilebanlist.b().exists()) {
                try {
                    gameprofilebanlist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)gameprofilebanlist.b().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.a(b, map);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.au().a(gameprofile);
                        String[] astring = (String[])map.get(gameprofile.getName().toLowerCase(Locale.ROOT));
                        if (astring == null) {
                            e.warn("Could not convert user banlist entry for {}", (Object)gameprofile.getName());
                            throw new FileConversionException("Profile not in the conversionlist");
                        }
                        Date date = astring.length > 1 ? NameReferencingFileConverter.a(astring[1], (Date)null) : null;
                        String s2 = astring.length > 2 ? astring[2] : null;
                        Date date1 = astring.length > 3 ? NameReferencingFileConverter.a(astring[3], (Date)null) : null;
                        String s1 = astring.length > 4 ? astring[4] : null;
                        gameprofilebanlist.a(new GameProfileBanEntry(gameprofile, date, s2, date1, s1));
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        e.warn("Could not lookup user banlist entry for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(minecraftserver, map.keySet(), profilelookupcallback);
                gameprofilebanlist.e();
                NameReferencingFileConverter.b(b);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not read old user banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean b(MinecraftServer minecraftserver) {
        IpBanList ipbanlist = new IpBanList(PlayerList.b);
        if (a.exists() && a.isFile()) {
            if (ipbanlist.b().exists()) {
                try {
                    ipbanlist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)ipbanlist.b().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.a(a, map);
                for (String s2 : map.keySet()) {
                    String[] astring = (String[])map.get(s2);
                    Date date = astring.length > 1 ? NameReferencingFileConverter.a(astring[1], (Date)null) : null;
                    String s1 = astring.length > 2 ? astring[2] : null;
                    Date date1 = astring.length > 3 ? NameReferencingFileConverter.a(astring[3], (Date)null) : null;
                    String s22 = astring.length > 4 ? astring[4] : null;
                    ipbanlist.a(new IpBanEntry(s2, date, s1, date1, s22));
                }
                ipbanlist.e();
                NameReferencingFileConverter.b(a);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not parse old ip banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
        }
        return true;
    }

    public static boolean c(final MinecraftServer minecraftserver) {
        final OpList oplist = new OpList(PlayerList.c);
        if (c.exists() && c.isFile()) {
            if (oplist.b().exists()) {
                try {
                    oplist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)oplist.b().getName());
                }
            }
            try {
                List list = Files.readLines((File)c, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.au().a(gameprofile);
                        oplist.a(new OpListEntry(gameprofile, minecraftserver.k(), false));
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        e.warn("Could not lookup oplist entry for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(minecraftserver, list, profilelookupcallback);
                oplist.e();
                NameReferencingFileConverter.b(c);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not read old oplist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean d(final MinecraftServer minecraftserver) {
        final WhiteList whitelist = new WhiteList(PlayerList.d);
        if (d.exists() && d.isFile()) {
            if (whitelist.b().exists()) {
                try {
                    whitelist.f();
                }
                catch (IOException ioexception) {
                    e.warn("Could not load existing file {}", (Object)whitelist.b().getName());
                }
            }
            try {
                List list = Files.readLines((File)d, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.au().a(gameprofile);
                        whitelist.a(new WhiteListEntry(gameprofile));
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        e.warn("Could not lookup user whitelist entry for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(minecraftserver, list, profilelookupcallback);
                whitelist.e();
                NameReferencingFileConverter.b(d);
                return true;
            }
            catch (IOException ioexception1) {
                e.warn("Could not read old whitelist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID a(final MinecraftServer minecraftserver, String s2) {
        if (!UtilColor.b(s2) && s2.length() <= 16) {
            Optional<UUID> optional = minecraftserver.au().a(s2).map(GameProfile::getId);
            if (optional.isPresent()) {
                return optional.get();
            }
            if (!minecraftserver.T() && minecraftserver.Z()) {
                final ArrayList list = Lists.newArrayList();
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.au().a(gameprofile);
                        list.add(gameprofile);
                    }

                    public void onProfileLookupFailed(String s1, Exception exception) {
                        e.warn("Could not lookup user whitelist entry for {}", (Object)s1, (Object)exception);
                    }
                };
                NameReferencingFileConverter.a(minecraftserver, Lists.newArrayList((Object[])new String[]{s2}), profilelookupcallback);
                return !list.isEmpty() ? ((GameProfile)list.get(0)).getId() : null;
            }
            return UUIDUtil.a(s2);
        }
        try {
            return UUID.fromString(s2);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public static boolean a(final DedicatedServer dedicatedserver) {
        final File file = NameReferencingFileConverter.g(dedicatedserver);
        final File file1 = new File(file.getParentFile(), "playerdata");
        final File file2 = new File(file.getParentFile(), "unknownplayers");
        if (file.exists() && file.isDirectory()) {
            File[] afile = file.listFiles();
            ArrayList list = Lists.newArrayList();
            File[] afile1 = afile;
            int i2 = afile.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                String s1;
                File file3 = afile1[j2];
                String s2 = file3.getName();
                if (!s2.toLowerCase(Locale.ROOT).endsWith(".dat") || (s1 = s2.substring(0, s2.length() - ".dat".length())).isEmpty()) continue;
                list.add(s1);
            }
            try {
                Object[] astring = list.toArray(new String[list.size()]);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){
                    final /* synthetic */ String[] val$astring;
                    {
                        this.val$astring = stringArray;
                    }

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        dedicatedserver.au().a(gameprofile);
                        UUID uuid = gameprofile.getId();
                        this.a(file1, this.a(gameprofile.getName()), uuid.toString());
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        e.warn("Could not lookup user uuid for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                        String s3 = this.a(s2);
                        this.a(file2, s3, s3);
                    }

                    private void a(File file4, String s2, String s3) {
                        File file5 = new File(file, s2 + ".dat");
                        File file6 = new File(file4, s3 + ".dat");
                        NBTTagCompound root = null;
                        try {
                            root = NBTCompressedStreamTools.a(new FileInputStream(file5), NBTReadLimiter.a());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (root != null) {
                            if (!root.e("bukkit")) {
                                root.a("bukkit", new NBTTagCompound());
                            }
                            NBTTagCompound data = root.p("bukkit");
                            data.a("lastKnownName", s2);
                            try {
                                NBTCompressedStreamTools.a(root, new FileOutputStream(file2));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        NameReferencingFileConverter.a(file4);
                        if (!file5.renameTo(file6)) {
                            throw new FileConversionException("Could not convert file for " + s2);
                        }
                    }

                    private String a(String s2) {
                        String s3 = null;
                        for (String s4 : this.val$astring) {
                            if (s4 == null || !s4.equalsIgnoreCase(s2)) continue;
                            s3 = s4;
                            break;
                        }
                        if (s3 == null) {
                            throw new FileConversionException("Could not find the filename for " + s2 + " anymore");
                        }
                        return s3;
                    }
                };
                NameReferencingFileConverter.a(dedicatedserver, Lists.newArrayList((Object[])astring), profilelookupcallback);
                return true;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                e.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    static void a(File file) {
        if (file.exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new FileConversionException("Can't create directory " + file.getName() + " in world save directory.");
        }
    }

    public static boolean e(MinecraftServer minecraftserver) {
        boolean flag = NameReferencingFileConverter.a();
        flag = flag && NameReferencingFileConverter.f(minecraftserver);
        return flag;
    }

    private static boolean a() {
        boolean flag = false;
        if (b.exists() && b.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (a.exists() && a.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (c.exists() && c.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (d.exists() && d.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        e.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
        e.warn("** please remove the following files and restart the server:");
        if (flag) {
            e.warn("* {}", (Object)b.getName());
        }
        if (flag1) {
            e.warn("* {}", (Object)a.getName());
        }
        if (flag2) {
            e.warn("* {}", (Object)c.getName());
        }
        if (flag3) {
            e.warn("* {}", (Object)d.getName());
        }
        return false;
    }

    private static boolean f(MinecraftServer minecraftserver) {
        File file = NameReferencingFileConverter.g(minecraftserver);
        if (file.exists() && file.isDirectory() && (file.list().length > 0 || !file.delete())) {
            e.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            e.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            e.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
            return false;
        }
        return true;
    }

    private static File g(MinecraftServer minecraftserver) {
        return minecraftserver.a(SavedFile.d).toFile();
    }

    private static void b(File file) {
        File file1 = new File(file.getName() + ".converted");
        file.renameTo(file1);
    }

    static Date a(String s2, Date date) {
        Date date1;
        try {
            date1 = ExpirableListEntry.a.parse(s2);
        }
        catch (ParseException parseexception) {
            date1 = date;
        }
        return date1;
    }

    private static class FileConversionException
    extends RuntimeException {
        FileConversionException(String s2, Throwable throwable) {
            super(s2, throwable);
        }

        FileConversionException(String s2) {
            super(s2);
        }
    }
}

