/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    private static final int b = 6000;
    private static final int c = 20;
    private static final int d = 8;
    private static final int e = 40;
    private static final double f = 0.5;
    private int g;
    private int h = 5;
    public int i;
    private int j = 1;
    private EntityHuman k;

    public EntityExperienceOrb(World world, double d0, double d1, double d2, int i2) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.M, world);
        this.a_(d0, d1, d2);
        this.t((float)(this.ah.j() * 360.0));
        this.n((this.ah.j() * (double)0.2f - (double)0.1f) * 2.0, this.ah.j() * 0.2 * 2.0, (this.ah.j() * (double)0.2f - (double)0.1f) * 2.0);
        this.i = i2;
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> entitytypes, World world) {
        super(entitytypes, world);
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
    }

    @Override
    protected double aZ() {
        return 0.03;
    }

    @Override
    public void l() {
        Vec3D vec3d;
        double d0;
        super.l();
        EntityHuman prevTarget = this.k;
        this.L = this.dt();
        this.M = this.dv();
        this.N = this.dz();
        if (this.a(TagsFluid.a)) {
            this.v();
        } else {
            this.bb();
        }
        if (this.dO().b_(this.do()).a(TagsFluid.b)) {
            this.n((this.ah.i() - this.ah.i()) * 0.2f, 0.2f, (this.ah.i() - this.ah.i()) * 0.2f);
        }
        if (!this.dO().b(this.cK())) {
            this.m(this.dt(), (this.cK().b + this.cK().e) / 2.0, this.dz());
        }
        if (this.ai % 20 == 1) {
            this.t();
        }
        if (this.k != null && (this.k.R_() || this.k.ex())) {
            this.k = null;
        }
        boolean cancelled = false;
        if (this.k != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.k, this.k != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.k = prevTarget;
            } else {
                EntityHuman entityHuman = this.k = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.k != null && !cancelled && (d0 = (vec3d = new Vec3D(this.k.dt() - this.dt(), this.k.dv() + (double)this.k.cL() / 2.0 - this.dv(), this.k.dz() - this.dz())).g()) < 64.0) {
            double d1 = 1.0 - Math.sqrt(d0) / 8.0;
            this.i(this.dr().e(vec3d.d().a(d1 * d1 * 0.1)));
        }
        this.a(EnumMoveType.a, this.dr());
        float f2 = 0.98f;
        if (this.aF()) {
            f2 = this.dO().a_(this.aL()).b().h() * 0.98f;
        }
        this.i(this.dr().d(f2, 0.98, f2));
        if (this.aF()) {
            this.i(this.dr().d(1.0, -0.9, 1.0));
        }
        ++this.g;
        if (this.g >= 6000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition aL() {
        return this.e(0.999999f);
    }

    private void t() {
        if (this.k == null || this.k.g(this) > 64.0) {
            this.k = this.dO().a((Entity)this, 8.0);
        }
        if (this.dO() instanceof WorldServer) {
            List<EntityExperienceOrb> list = this.dO().a(EntityTypeTest.a(EntityExperienceOrb.class), this.cK().g(0.5), this::a);
            for (EntityExperienceOrb entityexperienceorb : list) {
                this.b(entityexperienceorb);
            }
        }
    }

    public static void a(WorldServer worldserver, Vec3D vec3d, int i2) {
        while (i2 > 0) {
            int j2 = EntityExperienceOrb.b(i2);
            i2 -= j2;
            if (EntityExperienceOrb.b(worldserver, vec3d, j2)) continue;
            worldserver.b(new EntityExperienceOrb(worldserver, vec3d.a(), vec3d.b(), vec3d.c(), j2));
        }
    }

    private static boolean b(WorldServer worldserver, Vec3D vec3d, int i2) {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(vec3d, 1.0, 1.0, 1.0);
        int j2 = worldserver.E_().a(40);
        List<EntityExperienceOrb> list = worldserver.a(EntityTypeTest.a(EntityExperienceOrb.class), axisalignedbb, (? super T entityexperienceorb) -> EntityExperienceOrb.a(entityexperienceorb, j2, i2));
        if (!list.isEmpty()) {
            EntityExperienceOrb entityexperienceorb2 = list.get(0);
            ++entityexperienceorb2.j;
            entityexperienceorb2.g = 0;
            return true;
        }
        return false;
    }

    private boolean a(EntityExperienceOrb entityexperienceorb) {
        return entityexperienceorb != this && EntityExperienceOrb.a(entityexperienceorb, this.an(), this.i);
    }

    private static boolean a(EntityExperienceOrb entityexperienceorb, int i2, int j2) {
        return !entityexperienceorb.dJ() && (entityexperienceorb.an() - i2) % 40 == 0 && entityexperienceorb.i == j2;
    }

    private void b(EntityExperienceOrb entityexperienceorb) {
        this.j += entityexperienceorb.j;
        this.g = Math.min(this.g, entityexperienceorb.g);
        entityexperienceorb.discard(EntityRemoveEvent.Cause.MERGE);
    }

    private void v() {
        Vec3D vec3d = this.dr();
        this.n(vec3d.c * (double)0.99f, Math.min(vec3d.d + (double)5.0E-4f, (double)0.06f), vec3d.e * (double)0.99f);
    }

    @Override
    protected void bo() {
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        if (this.dO().B) {
            return true;
        }
        this.bw();
        this.h = (int)((float)this.h - f2);
        if (this.h <= 0) {
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Health", (short)this.h);
        nbttagcompound.a("Age", (short)this.g);
        nbttagcompound.a("Value", (short)this.i);
        nbttagcompound.a("Count", this.j);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.h = nbttagcompound.g("Health");
        this.g = nbttagcompound.g("Age");
        this.i = nbttagcompound.g("Value");
        this.j = Math.max(nbttagcompound.h("Count"), 1);
    }

    @Override
    public void b_(EntityHuman entityhuman) {
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            if (entityhuman.ci == 0) {
                entityhuman.ci = CraftEventFactory.callPlayerXpCooldownEvent(entityhuman, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
                entityhuman.a((Entity)this, 1);
                int i2 = this.a(entityplayer, this.i);
                if (i2 > 0) {
                    entityhuman.d(CraftEventFactory.callPlayerExpChangeEvent(entityhuman, i2).getAmount());
                }
                --this.j;
                if (this.j == 0) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                }
            }
        }
    }

    private int a(EntityPlayer entityplayer, int i2) {
        Optional<EnchantedItemInUse> optional = EnchantmentManager.a(EnchantmentEffectComponents.z, (EntityLiving)entityplayer, ItemStack::m);
        if (optional.isPresent()) {
            int l2;
            ItemStack itemstack = optional.get().a();
            int j2 = EnchantmentManager.c(entityplayer.A(), itemstack, i2);
            int k2 = Math.min(j2, itemstack.n());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(entityplayer, this, itemstack, optional.get().b(), k2);
            k2 = event.getRepairAmount();
            if (event.isCancelled()) {
                return i2;
            }
            itemstack.b(itemstack.n() - k2);
            if (k2 > 0 && (l2 = i2 - k2 * i2 / j2) > 0) {
                this.i = l2;
                return this.a(entityplayer, l2);
            }
            return 0;
        }
        return i2;
    }

    public int p() {
        return this.i;
    }

    public int s() {
        return this.i >= 2477 ? 10 : (this.i >= 1237 ? 9 : (this.i >= 617 ? 8 : (this.i >= 307 ? 7 : (this.i >= 149 ? 6 : (this.i >= 73 ? 5 : (this.i >= 37 ? 4 : (this.i >= 17 ? 3 : (this.i >= 7 ? 2 : (this.i >= 3 ? 1 : 0)))))))));
    }

    public static int b(int i2) {
        if (i2 > 162670129) {
            return i2 - 100000;
        }
        if (i2 > 81335063) {
            return 81335063;
        }
        if (i2 > 40667527) {
            return 40667527;
        }
        if (i2 > 20333759) {
            return 20333759;
        }
        if (i2 > 10166857) {
            return 10166857;
        }
        if (i2 > 5083423) {
            return 5083423;
        }
        if (i2 > 2541701) {
            return 2541701;
        }
        if (i2 > 1270849) {
            return 1270849;
        }
        if (i2 > 635413) {
            return 635413;
        }
        if (i2 > 317701) {
            return 317701;
        }
        if (i2 > 158849) {
            return 158849;
        }
        if (i2 > 79423) {
            return 79423;
        }
        if (i2 > 39709) {
            return 39709;
        }
        if (i2 > 19853) {
            return 19853;
        }
        if (i2 > 9923) {
            return 9923;
        }
        if (i2 > 4957) {
            return 4957;
        }
        return i2 >= 2477 ? 2477 : (i2 >= 1237 ? 1237 : (i2 >= 617 ? 617 : (i2 >= 307 ? 307 : (i2 >= 149 ? 149 : (i2 >= 73 ? 73 : (i2 >= 37 ? 37 : (i2 >= 17 ? 17 : (i2 >= 7 ? 7 : (i2 >= 3 ? 3 : 1)))))))));
    }

    @Override
    public boolean cu() {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntityExperienceOrb(this, entitytrackerentry);
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.i;
    }
}

