/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class EntityTypes<T extends Entity>
implements FeatureElement,
EntityTypeTest<Entity, T> {
    private static final Logger bB = LogUtils.getLogger();
    private final Holder.c<EntityTypes<?>> bC = BuiltInRegistries.f.f(this);
    private static final float bD = 1.3964844f;
    private static final int bE = 10;
    public static final EntityTypes<Allay> a = EntityTypes.a("allay", Builder.a(Allay::new, EnumCreatureType.b).a(0.35f, 0.6f).b(0.36f).c(0.04f).a(8).b(2));
    public static final EntityTypes<EntityAreaEffectCloud> b = EntityTypes.a("area_effect_cloud", Builder.a(EntityAreaEffectCloud::new, EnumCreatureType.h).c().a(6.0f, 0.5f).a(10).b(10));
    public static final EntityTypes<Armadillo> c = EntityTypes.a("armadillo", Builder.a(Armadillo::new, EnumCreatureType.b).a(0.7f, 0.65f).b(0.26f).a(10));
    public static final EntityTypes<EntityArmorStand> d = EntityTypes.a("armor_stand", Builder.a(EntityArmorStand::new, EnumCreatureType.h).a(0.5f, 1.975f).b(1.7775f).a(10));
    public static final EntityTypes<EntityTippedArrow> e = EntityTypes.a("arrow", Builder.a(EntityTippedArrow::new, EnumCreatureType.h).a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<Axolotl> f = EntityTypes.a("axolotl", Builder.a(Axolotl::new, EnumCreatureType.d).a(0.75f, 0.42f).b(0.2751f).a(10));
    public static final EntityTypes<EntityBat> g = EntityTypes.a("bat", Builder.a(EntityBat::new, EnumCreatureType.c).a(0.5f, 0.9f).b(0.45f).a(5));
    public static final EntityTypes<EntityBee> h = EntityTypes.a("bee", Builder.a(EntityBee::new, EnumCreatureType.b).a(0.7f, 0.6f).b(0.3f).a(8));
    public static final EntityTypes<EntityBlaze> i = EntityTypes.a("blaze", Builder.a(EntityBlaze::new, EnumCreatureType.a).c().a(0.6f, 1.8f).a(8));
    public static final EntityTypes<Display.BlockDisplay> j = EntityTypes.a("block_display", Builder.a(Display.BlockDisplay::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityBoat> k = EntityTypes.a("boat", Builder.a(EntityBoat::new, EnumCreatureType.h).a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Bogged> l = EntityTypes.a("bogged", Builder.a(Bogged::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<Breeze> m = EntityTypes.a("breeze", Builder.a(Breeze::new, EnumCreatureType.a).a(0.6f, 1.77f).b(1.3452f).a(10));
    public static final EntityTypes<BreezeWindCharge> n = EntityTypes.a("breeze_wind_charge", Builder.a(BreezeWindCharge::new, EnumCreatureType.h).a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<Camel> o = EntityTypes.a("camel", Builder.a(Camel::new, EnumCreatureType.b).a(1.7f, 2.375f).b(2.275f).a(10));
    public static final EntityTypes<EntityCat> p = EntityTypes.a("cat", Builder.a(EntityCat::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.35f).a(new float[]{0.5125f}).a(8));
    public static final EntityTypes<EntityCaveSpider> q = EntityTypes.a("cave_spider", Builder.a(EntityCaveSpider::new, EnumCreatureType.a).a(0.7f, 0.5f).b(0.45f).a(8));
    public static final EntityTypes<ChestBoat> r = EntityTypes.a("chest_boat", Builder.a(ChestBoat::new, EnumCreatureType.h).a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityMinecartChest> s = EntityTypes.a("chest_minecart", Builder.a(EntityMinecartChest::new, EnumCreatureType.h).a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityChicken> t = EntityTypes.a("chicken", Builder.a(EntityChicken::new, EnumCreatureType.b).a(0.4f, 0.7f).b(0.644f).a(new Vec3D[]{new Vec3D(0.0, 0.7, -0.1)}).a(10));
    public static final EntityTypes<EntityCod> u = EntityTypes.a("cod", Builder.a(EntityCod::new, EnumCreatureType.g).a(0.5f, 0.3f).b(0.195f).a(4));
    public static final EntityTypes<EntityMinecartCommandBlock> v = EntityTypes.a("command_block_minecart", Builder.a(EntityMinecartCommandBlock::new, EnumCreatureType.h).a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityCow> w = EntityTypes.a("cow", Builder.a(EntityCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<EntityCreeper> x = EntityTypes.a("creeper", Builder.a(EntityCreeper::new, EnumCreatureType.a).a(0.6f, 1.7f).a(8));
    public static final EntityTypes<EntityDolphin> y = EntityTypes.a("dolphin", Builder.a(EntityDolphin::new, EnumCreatureType.f).a(0.9f, 0.6f).b(0.3f));
    public static final EntityTypes<EntityHorseDonkey> z = EntityTypes.a("donkey", Builder.a(EntityHorseDonkey::new, EnumCreatureType.b).a(1.3964844f, 1.5f).b(1.425f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityDragonFireball> A = EntityTypes.a("dragon_fireball", Builder.a(EntityDragonFireball::new, EnumCreatureType.h).a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityDrowned> B = EntityTypes.a("drowned", Builder.a(EntityDrowned::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityEgg> C = EntityTypes.a("egg", Builder.a(EntityEgg::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityGuardianElder> D = EntityTypes.a("elder_guardian", Builder.a(EntityGuardianElder::new, EnumCreatureType.a).a(1.9975f, 1.9975f).b(0.99875f).a(new float[]{2.350625f}).a(10));
    public static final EntityTypes<EntityEnderCrystal> E = EntityTypes.a("end_crystal", Builder.a(EntityEnderCrystal::new, EnumCreatureType.h).c().a(2.0f, 2.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityEnderDragon> F = EntityTypes.a("ender_dragon", Builder.a(EntityEnderDragon::new, EnumCreatureType.a).c().a(16.0f, 8.0f).a(new float[]{3.0f}).a(10));
    public static final EntityTypes<EntityEnderPearl> G = EntityTypes.a("ender_pearl", Builder.a(EntityEnderPearl::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityEnderman> H = EntityTypes.a("enderman", Builder.a(EntityEnderman::new, EnumCreatureType.a).a(0.6f, 2.9f).b(2.55f).a(new float[]{2.80625f}).a(8));
    public static final EntityTypes<EntityEndermite> I = EntityTypes.a("endermite", Builder.a(EntityEndermite::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntityEvoker> J = EntityTypes.a("evoker", Builder.a(EntityEvoker::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityEvokerFangs> K = EntityTypes.a("evoker_fangs", Builder.a(EntityEvokerFangs::new, EnumCreatureType.h).a(0.5f, 0.8f).a(6).b(2));
    public static final EntityTypes<EntityThrownExpBottle> L = EntityTypes.a("experience_bottle", Builder.a(EntityThrownExpBottle::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityExperienceOrb> M = EntityTypes.a("experience_orb", Builder.a(EntityExperienceOrb::new, EnumCreatureType.h).a(0.5f, 0.5f).a(6).b(20));
    public static final EntityTypes<EntityEnderSignal> N = EntityTypes.a("eye_of_ender", Builder.a(EntityEnderSignal::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(4));
    public static final EntityTypes<EntityFallingBlock> O = EntityTypes.a("falling_block", Builder.a(EntityFallingBlock::new, EnumCreatureType.h).a(0.98f, 0.98f).a(10).b(20));
    public static final EntityTypes<EntityFireworks> P = EntityTypes.a("firework_rocket", Builder.a(EntityFireworks::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityFox> Q = EntityTypes.a("fox", Builder.a(EntityFox::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.6375, -0.25)}).a(8).a(Blocks.oi));
    public static final EntityTypes<Frog> R = EntityTypes.a("frog", Builder.a(Frog::new, EnumCreatureType.b).a(0.5f, 0.5f).a(new Vec3D[]{new Vec3D(0.0, 0.375, -0.25)}).a(10));
    public static final EntityTypes<EntityMinecartFurnace> S = EntityTypes.a("furnace_minecart", Builder.a(EntityMinecartFurnace::new, EnumCreatureType.h).a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityGhast> T = EntityTypes.a("ghast", Builder.a(EntityGhast::new, EnumCreatureType.a).c().a(4.0f, 4.0f).b(2.6f).a(new float[]{4.0625f}).c(0.5f).a(10));
    public static final EntityTypes<EntityGiantZombie> U = EntityTypes.a("giant", Builder.a(EntityGiantZombie::new, EnumCreatureType.a).a(3.6f, 12.0f).b(10.44f).c(-3.75f).a(10));
    public static final EntityTypes<GlowItemFrame> V = EntityTypes.a("glow_item_frame", Builder.a(GlowItemFrame::new, EnumCreatureType.h).a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<GlowSquid> W = EntityTypes.a("glow_squid", Builder.a(GlowSquid::new, EnumCreatureType.e).a(0.8f, 0.8f).b(0.4f).a(10));
    public static final EntityTypes<Goat> X = EntityTypes.a("goat", Builder.a(Goat::new, EnumCreatureType.b).a(0.9f, 1.3f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityGuardian> Y = EntityTypes.a("guardian", Builder.a(EntityGuardian::new, EnumCreatureType.a).a(0.85f, 0.85f).b(0.425f).a(new float[]{0.975f}).a(8));
    public static final EntityTypes<EntityHoglin> Z = EntityTypes.a("hoglin", Builder.a(EntityHoglin::new, EnumCreatureType.a).a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityMinecartHopper> aa = EntityTypes.a("hopper_minecart", Builder.a(EntityMinecartHopper::new, EnumCreatureType.h).a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityHorse> ab = EntityTypes.a("horse", Builder.a(EntityHorse::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.44375f}).a(10));
    public static final EntityTypes<EntityZombieHusk> ac = EntityTypes.a("husk", Builder.a(EntityZombieHusk::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.075f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityIllagerIllusioner> ad = EntityTypes.a("illusioner", Builder.a(EntityIllagerIllusioner::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<Interaction> ae = EntityTypes.a("interaction", Builder.a(Interaction::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10));
    public static final EntityTypes<EntityIronGolem> af = EntityTypes.a("iron_golem", Builder.a(EntityIronGolem::new, EnumCreatureType.h).a(1.4f, 2.7f).a(10));
    public static final EntityTypes<EntityItem> ag = EntityTypes.a("item", Builder.a(EntityItem::new, EnumCreatureType.h).a(0.25f, 0.25f).b(0.2125f).a(6).b(20));
    public static final EntityTypes<Display.ItemDisplay> ah = EntityTypes.a("item_display", Builder.a(Display.ItemDisplay::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityItemFrame> ai = EntityTypes.a("item_frame", Builder.a(EntityItemFrame::new, EnumCreatureType.h).a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<OminousItemSpawner> aj = EntityTypes.a("ominous_item_spawner", Builder.a(OminousItemSpawner::new, EnumCreatureType.h).a(0.25f, 0.25f).a(8));
    public static final EntityTypes<EntityLargeFireball> ak = EntityTypes.a("fireball", Builder.a(EntityLargeFireball::new, EnumCreatureType.h).a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityLeash> al = EntityTypes.a("leash_knot", Builder.a(EntityLeash::new, EnumCreatureType.h).b().a(0.375f, 0.5f).b(0.0625f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLightning> am = EntityTypes.a("lightning_bolt", Builder.a(EntityLightning::new, EnumCreatureType.h).b().a(0.0f, 0.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLlama> an = EntityTypes.a("llama", Builder.a(EntityLlama::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityLlamaSpit> ao = EntityTypes.a("llama_spit", Builder.a(EntityLlamaSpit::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMagmaCube> ap = EntityTypes.a("magma_cube", Builder.a(EntityMagmaCube::new, EnumCreatureType.a).c().a(0.52f, 0.52f).b(0.325f).a(4.0f).a(8));
    public static final EntityTypes<Marker> aq = EntityTypes.a("marker", Builder.a(Marker::new, EnumCreatureType.h).a(0.0f, 0.0f).a(0));
    public static final EntityTypes<EntityMinecartRideable> ar = EntityTypes.a("minecart", Builder.a(EntityMinecartRideable::new, EnumCreatureType.h).a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityMushroomCow> as = EntityTypes.a("mooshroom", Builder.a(EntityMushroomCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<EntityHorseMule> at = EntityTypes.a("mule", Builder.a(EntityHorseMule::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.2125f}).a(8));
    public static final EntityTypes<EntityOcelot> au = EntityTypes.a("ocelot", Builder.a(EntityOcelot::new, EnumCreatureType.b).a(0.6f, 0.7f).a(new float[]{0.6375f}).a(10));
    public static final EntityTypes<EntityPainting> av = EntityTypes.a("painting", Builder.a(EntityPainting::new, EnumCreatureType.h).a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityPanda> aw = EntityTypes.a("panda", Builder.a(EntityPanda::new, EnumCreatureType.b).a(1.3f, 1.25f).a(10));
    public static final EntityTypes<EntityParrot> ax = EntityTypes.a("parrot", Builder.a(EntityParrot::new, EnumCreatureType.b).a(0.5f, 0.9f).b(0.54f).a(new float[]{0.4625f}).a(8));
    public static final EntityTypes<EntityPhantom> ay = EntityTypes.a("phantom", Builder.a(EntityPhantom::new, EnumCreatureType.a).a(0.9f, 0.5f).b(0.175f).a(new float[]{0.3375f}).c(-0.125f).a(8));
    public static final EntityTypes<EntityPig> az = EntityTypes.a("pig", Builder.a(EntityPig::new, EnumCreatureType.b).a(0.9f, 0.9f).a(new float[]{0.86875f}).a(10));
    public static final EntityTypes<EntityPiglin> aA = EntityTypes.a("piglin", Builder.a(EntityPiglin::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPiglinBrute> aB = EntityTypes.a("piglin_brute", Builder.a(EntityPiglinBrute::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPillager> aC = EntityTypes.a("pillager", Builder.a(EntityPillager::new, EnumCreatureType.a).d().a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityPolarBear> aD = EntityTypes.a("polar_bear", Builder.a(EntityPolarBear::new, EnumCreatureType.b).a(Blocks.qP).a(1.4f, 1.4f).a(10));
    public static final EntityTypes<EntityPotion> aE = EntityTypes.a("potion", Builder.a(EntityPotion::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityPufferFish> aF = EntityTypes.a("pufferfish", Builder.a(EntityPufferFish::new, EnumCreatureType.g).a(0.7f, 0.7f).b(0.455f).a(4));
    public static final EntityTypes<EntityRabbit> aG = EntityTypes.a("rabbit", Builder.a(EntityRabbit::new, EnumCreatureType.b).a(0.4f, 0.5f).a(8));
    public static final EntityTypes<EntityRavager> aH = EntityTypes.a("ravager", Builder.a(EntityRavager::new, EnumCreatureType.a).a(1.95f, 2.2f).a(new Vec3D[]{new Vec3D(0.0, 2.2625, -0.0625)}).a(10));
    public static final EntityTypes<EntitySalmon> aI = EntityTypes.a("salmon", Builder.a(EntitySalmon::new, EnumCreatureType.g).a(0.7f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntitySheep> aJ = EntityTypes.a("sheep", Builder.a(EntitySheep::new, EnumCreatureType.b).a(0.9f, 1.3f).b(1.235f).a(new float[]{1.2375f}).a(10));
    public static final EntityTypes<EntityShulker> aK = EntityTypes.a("shulker", Builder.a(EntityShulker::new, EnumCreatureType.a).c().d().a(1.0f, 1.0f).b(0.5f).a(10));
    public static final EntityTypes<EntityShulkerBullet> aL = EntityTypes.a("shulker_bullet", Builder.a(EntityShulkerBullet::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(8));
    public static final EntityTypes<EntitySilverfish> aM = EntityTypes.a("silverfish", Builder.a(EntitySilverfish::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntitySkeleton> aN = EntityTypes.a("skeleton", Builder.a(EntitySkeleton::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseSkeleton> aO = EntityTypes.a("skeleton_horse", Builder.a(EntityHorseSkeleton::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntitySlime> aP = EntityTypes.a("slime", Builder.a(EntitySlime::new, EnumCreatureType.a).a(0.52f, 0.52f).b(0.325f).a(4.0f).a(10));
    public static final EntityTypes<EntitySmallFireball> aQ = EntityTypes.a("small_fireball", Builder.a(EntitySmallFireball::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<Sniffer> aR = EntityTypes.a("sniffer", Builder.a(Sniffer::new, EnumCreatureType.b).a(1.9f, 1.75f).b(1.05f).a(new float[]{2.09375f}).d(2.05f).a(10));
    public static final EntityTypes<EntitySnowman> aS = EntityTypes.a("snow_golem", Builder.a(EntitySnowman::new, EnumCreatureType.h).a(Blocks.qP).a(0.7f, 1.9f).b(1.7f).a(8));
    public static final EntityTypes<EntitySnowball> aT = EntityTypes.a("snowball", Builder.a(EntitySnowball::new, EnumCreatureType.h).a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMinecartMobSpawner> aU = EntityTypes.a("spawner_minecart", Builder.a(EntityMinecartMobSpawner::new, EnumCreatureType.h).a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntitySpectralArrow> aV = EntityTypes.a("spectral_arrow", Builder.a(EntitySpectralArrow::new, EnumCreatureType.h).a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntitySpider> aW = EntityTypes.a("spider", Builder.a(EntitySpider::new, EnumCreatureType.a).a(1.4f, 0.9f).b(0.65f).a(new float[]{0.765f}).a(8));
    public static final EntityTypes<EntitySquid> aX = EntityTypes.a("squid", Builder.a(EntitySquid::new, EnumCreatureType.f).a(0.8f, 0.8f).b(0.4f).a(8));
    public static final EntityTypes<EntitySkeletonStray> aY = EntityTypes.a("stray", Builder.a(EntitySkeletonStray::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(Blocks.qP).a(8));
    public static final EntityTypes<EntityStrider> aZ = EntityTypes.a("strider", Builder.a(EntityStrider::new, EnumCreatureType.b).c().a(0.9f, 1.7f).a(10));
    public static final EntityTypes<Tadpole> ba = EntityTypes.a("tadpole", Builder.a(Tadpole::new, EnumCreatureType.b).a(0.4f, 0.3f).b(0.19500001f).a(10));
    public static final EntityTypes<Display.TextDisplay> bb = EntityTypes.a("text_display", Builder.a(Display.TextDisplay::new, EnumCreatureType.h).a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityTNTPrimed> bc = EntityTypes.a("tnt", Builder.a(EntityTNTPrimed::new, EnumCreatureType.h).c().a(0.98f, 0.98f).b(0.15f).a(10).b(10));
    public static final EntityTypes<EntityMinecartTNT> bd = EntityTypes.a("tnt_minecart", Builder.a(EntityMinecartTNT::new, EnumCreatureType.h).a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityLlamaTrader> be = EntityTypes.a("trader_llama", Builder.a(EntityLlamaTrader::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityThrownTrident> bf = EntityTypes.a("trident", Builder.a(EntityThrownTrident::new, EnumCreatureType.h).a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntityTropicalFish> bg = EntityTypes.a("tropical_fish", Builder.a(EntityTropicalFish::new, EnumCreatureType.g).a(0.5f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntityTurtle> bh = EntityTypes.a("turtle", Builder.a(EntityTurtle::new, EnumCreatureType.b).a(1.2f, 0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.55625, -0.25)}).a(10));
    public static final EntityTypes<EntityVex> bi = EntityTypes.a("vex", Builder.a(EntityVex::new, EnumCreatureType.a).c().a(0.4f, 0.8f).b(0.51875f).a(new float[]{0.7375f}).c(0.04f).a(8));
    public static final EntityTypes<EntityVillager> bj = EntityTypes.a("villager", Builder.a(EntityVillager::new, EnumCreatureType.h).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<EntityVindicator> bk = EntityTypes.a("vindicator", Builder.a(EntityVindicator::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityVillagerTrader> bl = EntityTypes.a("wandering_trader", Builder.a(EntityVillagerTrader::new, EnumCreatureType.b).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<Warden> bm = EntityTypes.a("warden", Builder.a(Warden::new, EnumCreatureType.a).a(0.9f, 2.9f).a(new float[]{3.15f}).a(EntityAttachment.d, 0.0f, 1.6f, 0.0f).a(16).c());
    public static final EntityTypes<WindCharge> bn = EntityTypes.a("wind_charge", Builder.a(WindCharge::new, EnumCreatureType.h).a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<EntityWitch> bo = EntityTypes.a("witch", Builder.a(EntityWitch::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.62f).a(new float[]{2.2625f}).a(8));
    public static final EntityTypes<EntityWither> bp = EntityTypes.a("wither", Builder.a(EntityWither::new, EnumCreatureType.a).c().a(Blocks.cd).a(0.9f, 3.5f).a(10));
    public static final EntityTypes<EntitySkeletonWither> bq = EntityTypes.a("wither_skeleton", Builder.a(EntitySkeletonWither::new, EnumCreatureType.a).c().a(Blocks.cd).a(0.7f, 2.4f).b(2.1f).c(-0.875f).a(8));
    public static final EntityTypes<EntityWitherSkull> br = EntityTypes.a("wither_skull", Builder.a(EntityWitherSkull::new, EnumCreatureType.h).a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<EntityWolf> bs = EntityTypes.a("wolf", Builder.a(EntityWolf::new, EnumCreatureType.b).a(0.6f, 0.85f).b(0.68f).a(new Vec3D[]{new Vec3D(0.0, 0.81875, -0.0625)}).a(10));
    public static final EntityTypes<EntityZoglin> bt = EntityTypes.a("zoglin", Builder.a(EntityZoglin::new, EnumCreatureType.a).c().a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityZombie> bu = EntityTypes.a("zombie", Builder.a(EntityZombie::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseZombie> bv = EntityTypes.a("zombie_horse", Builder.a(EntityHorseZombie::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntityZombieVillager> bw = EntityTypes.a("zombie_villager", Builder.a(EntityZombieVillager::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.125f}).c(-0.7f).b(1.74f).a(8));
    public static final EntityTypes<EntityPigZombie> bx = EntityTypes.a("zombified_piglin", Builder.a(EntityPigZombie::new, EnumCreatureType.a).c().a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHuman> by = EntityTypes.a("player", Builder.a(EnumCreatureType.h).b().a().a(0.6f, 1.8f).b(1.62f).a(EntityHuman.bV).a(32).b(2));
    public static final EntityTypes<EntityFishingHook> bz = EntityTypes.a("fishing_bobber", Builder.a(EntityFishingHook::new, EnumCreatureType.h).b().a().a(0.25f, 0.25f).a(4).b(5));
    private final b<T> bF;
    private final EnumCreatureType bG;
    private final ImmutableSet<Block> bH;
    private final boolean bI;
    private final boolean bJ;
    private final boolean bK;
    private final boolean bL;
    private final int bM;
    private final int bN;
    @Nullable
    private String bO;
    @Nullable
    private IChatBaseComponent bP;
    @Nullable
    private ResourceKey<LootTable> bQ;
    private final EntitySize bR;
    private final float bS;
    private final FeatureFlagSet bT;

    private static <T extends Entity> EntityTypes<T> a(String s2, Builder entitytypes_builder) {
        return IRegistry.a(BuiltInRegistries.f, s2, entitytypes_builder.a(s2));
    }

    public static MinecraftKey a(EntityTypes<?> entitytypes) {
        return BuiltInRegistries.f.b(entitytypes);
    }

    public static Optional<EntityTypes<?>> a(String s2) {
        return BuiltInRegistries.f.b(MinecraftKey.c(s2));
    }

    public EntityTypes(b<T> entitytypes_b, EnumCreatureType enumcreaturetype, boolean flag, boolean flag1, boolean flag2, boolean flag3, ImmutableSet<Block> immutableset, EntitySize entitysize, float f2, int i2, int j2, FeatureFlagSet featureflagset) {
        this.bF = entitytypes_b;
        this.bG = enumcreaturetype;
        this.bL = flag3;
        this.bI = flag;
        this.bJ = flag1;
        this.bK = flag2;
        this.bH = immutableset;
        this.bR = entitysize;
        this.bS = f2;
        this.bM = i2;
        this.bN = j2;
        this.bT = featureflagset;
    }

    @Nullable
    public T a(WorldServer worldserver, @Nullable ItemStack itemstack, @Nullable EntityHuman entityhuman, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1) {
        return this.spawn(worldserver, itemstack, entityhuman, blockposition, enummobspawn, flag, flag1, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable ItemStack itemstack, @Nullable EntityHuman entityhuman, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        Consumer<Entity> consumer = itemstack != null ? EntityTypes.a(worldserver, itemstack, entityhuman) : entity -> {};
        return (T)this.spawn(worldserver, consumer, blockposition, enummobspawn, flag, flag1, spawnReason);
    }

    public static <T extends Entity> Consumer<T> a(WorldServer worldserver, ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        return EntityTypes.a((T entity) -> {}, worldserver, itemstack, entityhuman);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> consumer, WorldServer worldserver, ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        return EntityTypes.b(EntityTypes.a(consumer, itemstack), worldserver, itemstack, entityhuman);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> consumer, ItemStack itemstack) {
        IChatBaseComponent ichatbasecomponent = itemstack.a(DataComponents.g);
        return ichatbasecomponent != null ? consumer.andThen(entity -> entity.b(ichatbasecomponent)) : consumer;
    }

    public static <T extends Entity> Consumer<T> b(Consumer<T> consumer, WorldServer worldserver, ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        CustomData customdata = itemstack.a(DataComponents.M, CustomData.a);
        return !customdata.b() ? consumer.andThen(entity -> {
            try {
                EntityTypes.a(worldserver, entityhuman, entity, customdata);
            }
            catch (Throwable t2) {
                bB.warn("Error loading spawn egg NBT", t2);
            }
        }) : consumer;
    }

    @Nullable
    public T a(WorldServer worldserver, BlockPosition blockposition, EnumMobSpawn enummobspawn) {
        return this.spawn(worldserver, blockposition, enummobspawn, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, BlockPosition blockposition, EnumMobSpawn enummobspawn, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.spawn(worldserver, null, blockposition, enummobspawn, false, false, spawnReason);
    }

    @Nullable
    public T a(WorldServer worldserver, @Nullable Consumer<T> consumer, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1) {
        return this.spawn(worldserver, consumer, blockposition, enummobspawn, flag, flag1, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable Consumer<T> consumer, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        T t0 = this.b(worldserver, consumer, blockposition, enummobspawn, flag, flag1);
        if (t0 != null) {
            worldserver.addFreshEntityWithPassengers((Entity)t0, spawnReason);
            return (T)(!((Entity)t0).dJ() ? t0 : null);
        }
        return t0;
    }

    @Nullable
    public T b(WorldServer worldserver, @Nullable Consumer<T> consumer, BlockPosition blockposition, EnumMobSpawn enummobspawn, boolean flag, boolean flag1) {
        double d0;
        T t0 = this.a(worldserver);
        if (t0 == null) {
            return null;
        }
        if (flag) {
            ((Entity)t0).a_((double)blockposition.u() + 0.5, blockposition.v() + 1, (double)blockposition.w() + 0.5);
            d0 = EntityTypes.a((IWorldReader)worldserver, blockposition, flag1, ((Entity)t0).cK());
        } else {
            d0 = 0.0;
        }
        ((Entity)t0).b((double)blockposition.u() + 0.5, (double)blockposition.v() + d0, (double)blockposition.w() + 0.5, MathHelper.g(worldserver.z.i() * 360.0f), 0.0f);
        if (t0 instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)t0;
            entityinsentient.ba = entityinsentient.dE();
            entityinsentient.aY = entityinsentient.dE();
            entityinsentient.a((WorldAccess)worldserver, worldserver.d_(entityinsentient.do()), enummobspawn, (GroupDataEntity)null);
            entityinsentient.S();
        }
        if (consumer != null) {
            consumer.accept(t0);
        }
        return t0;
    }

    protected static double a(IWorldReader iworldreader, BlockPosition blockposition, boolean flag, AxisAlignedBB axisalignedbb) {
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(blockposition);
        if (flag) {
            axisalignedbb1 = axisalignedbb1.b(0.0, -1.0, 0.0);
        }
        Iterable<VoxelShape> iterable = iworldreader.d(null, axisalignedbb1);
        return 1.0 + VoxelShapes.a(EnumDirection.EnumAxis.b, axisalignedbb, iterable, flag ? -2.0 : -1.0);
    }

    public static void a(World world, @Nullable EntityHuman entityhuman, @Nullable Entity entity, CustomData customdata) {
        MinecraftServer minecraftserver = world.o();
        if (minecraftserver != null && entity != null && (world.B || !entity.cP() || entityhuman != null && minecraftserver.ah().f(entityhuman.fX()))) {
            customdata.a(entity);
        }
    }

    public boolean b() {
        return this.bI;
    }

    public boolean c() {
        return this.bJ;
    }

    public boolean d() {
        return this.bK;
    }

    public boolean e() {
        return this.bL;
    }

    public EnumCreatureType f() {
        return this.bG;
    }

    public String g() {
        if (this.bO == null) {
            this.bO = SystemUtils.a("entity", BuiltInRegistries.f.b(this));
        }
        return this.bO;
    }

    public IChatBaseComponent h() {
        if (this.bP == null) {
            this.bP = IChatBaseComponent.c(this.g());
        }
        return this.bP;
    }

    public String toString() {
        return this.g();
    }

    public String j() {
        int i2 = this.g().lastIndexOf(46);
        return i2 == -1 ? this.g() : this.g().substring(i2 + 1);
    }

    public ResourceKey<LootTable> k() {
        if (this.bQ == null) {
            MinecraftKey minecraftkey = BuiltInRegistries.f.b(this);
            this.bQ = ResourceKey.a(Registries.bc, minecraftkey.f("entities/"));
        }
        return this.bQ;
    }

    public float l() {
        return this.bR.a();
    }

    public float m() {
        return this.bR.b();
    }

    @Override
    public FeatureFlagSet i() {
        return this.bT;
    }

    @Override
    @Nullable
    public T a(World world) {
        return !this.a(world.J()) ? null : (T)this.bF.create(this, world);
    }

    public static Optional<Entity> a(NBTTagCompound nbttagcompound, World world) {
        return SystemUtils.a(EntityTypes.a(nbttagcompound).map(entitytypes -> entitytypes.a(world)), (T entity) -> entity.g(nbttagcompound), () -> bB.warn("Skipping Entity with id {}", (Object)nbttagcompound.l("id")));
    }

    public AxisAlignedBB a(double d0, double d1, double d2) {
        float f2 = this.bS * this.l() / 2.0f;
        float f1 = this.bS * this.m();
        return new AxisAlignedBB(d0 - (double)f2, d1, d2 - (double)f2, d0 + (double)f2, d1 + (double)f1, d2 + (double)f2);
    }

    @Override
    public boolean a(IBlockData iblockdata) {
        return this.bH.contains((Object)iblockdata.b()) ? false : (!this.bK && PathfinderAbstract.a(iblockdata) ? true : iblockdata.a(Blocks.cd) || iblockdata.a(Blocks.oi) || iblockdata.a(Blocks.dQ) || iblockdata.a(Blocks.qP));
    }

    public EntitySize n() {
        return this.bR;
    }

    public static Optional<EntityTypes<?>> a(NBTTagCompound nbttagcompound) {
        return BuiltInRegistries.f.b(MinecraftKey.a(nbttagcompound.l("id")));
    }

    @Nullable
    public static Entity a(NBTTagCompound nbttagcompound, World world, Function<Entity, Entity> function) {
        return EntityTypes.b(nbttagcompound, world).map(function).map(entity -> {
            if (nbttagcompound.b("Passengers", 9)) {
                NBTTagList nbttaglist = nbttagcompound.c("Passengers", 10);
                for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                    Entity entity1 = EntityTypes.a(nbttaglist.a(i2), world, function);
                    if (entity1 == null) continue;
                    entity1.a((Entity)entity, true);
                }
            }
            return entity;
        }).orElse(null);
    }

    public static Stream<Entity> a(final List<? extends NBTBase> list, final World world) {
        final Spliterator<? extends NBTBase> spliterator = list.spliterator();
        return StreamSupport.stream(new Spliterator<Entity>(){

            @Override
            public boolean tryAdvance(Consumer<? super Entity> consumer) {
                return spliterator.tryAdvance((? super T nbtbase) -> EntityTypes.a((NBTTagCompound)nbtbase, world, entity -> {
                    consumer.accept((Entity)entity);
                    return entity;
                }));
            }

            @Override
            public Spliterator<Entity> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return list.size();
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        }, false);
    }

    private static Optional<Entity> b(NBTTagCompound nbttagcompound, World world) {
        try {
            return EntityTypes.a(nbttagcompound, world);
        }
        catch (RuntimeException runtimeexception) {
            bB.warn("Exception loading entity: ", (Throwable)runtimeexception);
            return Optional.empty();
        }
    }

    public int o() {
        return this.bM;
    }

    public int p() {
        return this.bN;
    }

    public boolean q() {
        return this != by && this != ao && this != bp && this != g && this != ai && this != V && this != al && this != av && this != E && this != K;
    }

    @Override
    public boolean a(TagKey<EntityTypes<?>> tagkey) {
        return this.bC.a(tagkey);
    }

    @Override
    public boolean a(HolderSet<EntityTypes<?>> holderset) {
        return holderset.a(this.bC);
    }

    @Override
    @Nullable
    public T a(Entity entity) {
        return (T)(entity.am() == this ? entity : null);
    }

    @Override
    public Class<? extends Entity> a() {
        return Entity.class;
    }

    @Deprecated
    public Holder.c<EntityTypes<?>> r() {
        return this.bC;
    }

    public static class Builder<T extends Entity> {
        private final b<T> a;
        private final EnumCreatureType b;
        private ImmutableSet<Block> c = ImmutableSet.of();
        private boolean d = true;
        private boolean e = true;
        private boolean f;
        private boolean g;
        private int h = 5;
        private int i = 3;
        private EntitySize j = EntitySize.b(0.6f, 1.8f);
        private float k = 1.0f;
        private EntityAttachments.a l = EntityAttachments.a();
        private FeatureFlagSet m = FeatureFlags.f;

        private Builder(b<T> entitytypes_b, EnumCreatureType enumcreaturetype) {
            this.a = entitytypes_b;
            this.b = enumcreaturetype;
            this.g = enumcreaturetype == EnumCreatureType.b || enumcreaturetype == EnumCreatureType.h;
        }

        public static <T extends Entity> Builder<T> a(b entitytypes_b, EnumCreatureType enumcreaturetype) {
            return new Builder<T>(entitytypes_b, enumcreaturetype);
        }

        public static <T extends Entity> Builder<T> a(EnumCreatureType enumcreaturetype) {
            return new Builder<Entity>((entitytypes, world) -> null, enumcreaturetype);
        }

        public Builder<T> a(float f2, float f1) {
            this.j = EntitySize.b(f2, f1);
            return this;
        }

        public Builder<T> a(float f2) {
            this.k = f2;
            return this;
        }

        public Builder<T> b(float f2) {
            this.j = this.j.b(f2);
            return this;
        }

        public Builder<T> a(float ... afloat) {
            float[] afloat1 = afloat;
            int i2 = afloat.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                float f2 = afloat1[j2];
                this.l = this.l.a(EntityAttachment.a, 0.0f, f2, 0.0f);
            }
            return this;
        }

        public Builder<T> a(Vec3D ... avec3d) {
            Vec3D[] avec3d1 = avec3d;
            int i2 = avec3d.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d = avec3d1[j2];
                this.l = this.l.a(EntityAttachment.a, vec3d);
            }
            return this;
        }

        public Builder<T> a(Vec3D vec3d) {
            return this.a(EntityAttachment.b, vec3d);
        }

        public Builder<T> c(float f2) {
            return this.a(EntityAttachment.b, 0.0f, -f2, 0.0f);
        }

        public Builder<T> d(float f2) {
            return this.a(EntityAttachment.c, 0.0f, f2, 0.0f);
        }

        public Builder<T> a(EntityAttachment entityattachment, float f2, float f1, float f22) {
            this.l = this.l.a(entityattachment, f2, f1, f22);
            return this;
        }

        public Builder<T> a(EntityAttachment entityattachment, Vec3D vec3d) {
            this.l = this.l.a(entityattachment, vec3d);
            return this;
        }

        public Builder<T> a() {
            this.e = false;
            return this;
        }

        public Builder<T> b() {
            this.d = false;
            return this;
        }

        public Builder<T> c() {
            this.f = true;
            return this;
        }

        public Builder<T> a(Block ... ablock) {
            this.c = ImmutableSet.copyOf((Object[])ablock);
            return this;
        }

        public Builder<T> d() {
            this.g = true;
            return this;
        }

        public Builder<T> a(int i2) {
            this.h = i2;
            return this;
        }

        public Builder<T> b(int i2) {
            this.i = i2;
            return this;
        }

        public Builder<T> a(FeatureFlag ... afeatureflag) {
            this.m = FeatureFlags.d.a(afeatureflag);
            return this;
        }

        public EntityTypes<T> a(String s2) {
            if (this.d) {
                SystemUtils.a(DataConverterTypes.A, s2);
            }
            return new EntityTypes<T>(this.a, this.b, this.d, this.e, this.f, this.g, this.c, this.j.a(this.l), this.k, this.h, this.i, this.m);
        }
    }

    public static interface b<T extends Entity> {
        public T create(EntityTypes<T> var1, World var2);
    }
}

