/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap cc = new PathfinderGoalHorseTrap(this);
    private static final int cd = 18000;
    private static final EntitySize ce = EntityTypes.aO.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.aO.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean cg;
    public int ch;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> entitytypes, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)entitytypes, world);
    }

    public static AttributeProvider.Builder s() {
        return EntityHorseSkeleton.gK().a(GenericAttributes.s, 15.0).a(GenericAttributes.v, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return !EnumMobSpawn.a(enummobspawn) ? EntityAnimal.b(entitytypes, generatoraccess, enummobspawn, blockposition, randomsource) : EnumMobSpawn.b(enummobspawn) || EntityHorseSkeleton.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(RandomSource randomsource) {
        AttributeModifiable attributemodifiable = this.f(GenericAttributes.o);
        Objects.requireNonNull(randomsource);
        attributemodifiable.a(EntityHorseSkeleton.a(randomsource::j));
    }

    @Override
    protected void gA() {
    }

    @Override
    protected SoundEffect v() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.xi : SoundEffects.xe;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.xf;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.xg;
    }

    @Override
    protected SoundEffect aQ() {
        if (this.aF()) {
            if (!this.bT()) {
                return SoundEffects.xl;
            }
            ++this.cB;
            if (this.cB > 5 && this.cB % 3 == 0) {
                return SoundEffects.xj;
            }
            if (this.cB <= 5) {
                return SoundEffects.xl;
            }
        }
        return SoundEffects.xh;
    }

    @Override
    protected void f(float f2) {
        if (this.aF()) {
            super.f(0.3f);
        } else {
            super.f(Math.min(0.1f, f2 * 25.0f));
        }
    }

    @Override
    protected void gR() {
        if (this.bf()) {
            this.a(SoundEffects.xk, 0.4f, 1.0f);
        } else {
            super.gR();
        }
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.o_() ? ce : super.e(entitypose);
    }

    @Override
    public void m_() {
        super.m_();
        if (this.t() && this.ch++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("SkeletonTrap", this.t());
        nbttagcompound.a("SkeletonTrapTime", this.ch);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.x(nbttagcompound.q("SkeletonTrap"));
        this.ch = nbttagcompound.h("SkeletonTrapTime");
    }

    @Override
    protected float fh() {
        return 0.96f;
    }

    public boolean t() {
        return this.cg;
    }

    public void x(boolean flag) {
        if (flag != this.cg) {
            this.cg = flag;
            if (flag) {
                this.bW.a(1, this.cc);
            } else {
                this.bW.a(this.cc);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.aO.a(worldserver);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return !this.gz() ? EnumInteractionResult.e : super.b(entityhuman, enumhand);
    }
}

