/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger ch = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> b = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition ci = PathfinderTargetCondition.a().a(64.0);
    private static final int cj = 200;
    private static final int ck = 400;
    private static final float cl = 0.25f;
    private static final String cm = "DragonDeathTime";
    private static final String cn = "DragonPhase";
    public final double[][] c = new double[64][3];
    public int d = -1;
    public final EntityComplexPart[] co;
    public final EntityComplexPart e;
    private final EntityComplexPart cp;
    private final EntityComplexPart cq;
    private final EntityComplexPart cr;
    private final EntityComplexPart cs;
    private final EntityComplexPart ct;
    private final EntityComplexPart cu;
    private final EntityComplexPart cv;
    public float cb;
    public float cc;
    public boolean cd;
    public int ce;
    public float cf;
    @Nullable
    public EntityEnderCrystal cg;
    @Nullable
    private EnderDragonBattle cw;
    private BlockPosition cx = BlockPosition.c;
    private final DragonControllerManager cy;
    private int cz = 100;
    private float cA;
    private final PathPoint[] cB = new PathPoint[24];
    private final int[] cD = new int[24];
    private final Path cE = new Path();
    private final Explosion explosionSource;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.F, world);
        this.e = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cp = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.cq = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.cr = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cs = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.ct = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cu = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cv = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.co = new EntityComplexPart[]{this.e, this.cp, this.cq, this.cr, this.cs, this.ct, this.cu, this.cv};
        this.v(this.eN());
        this.ag = true;
        this.au = true;
        this.cy = new DragonControllerManager(this);
        this.explosionSource = new Explosion(world, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.Effect.b, Particles.w, Particles.v, SoundEffects.ke);
    }

    public void a(EnderDragonBattle enderdragonbattle) {
        this.cw = enderdragonbattle;
    }

    public void c(BlockPosition blockposition) {
        this.cx = blockposition;
    }

    public BlockPosition s() {
        return this.cx;
    }

    public static AttributeProvider.Builder t() {
        return EntityInsentient.C().a(GenericAttributes.s, 200.0);
    }

    @Override
    public boolean aW() {
        float f2 = MathHelper.b(this.cc * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.cb * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aV() {
        if (this.dO().B && !this.aX()) {
            this.dO().a(this.dt(), this.dv(), this.dz(), SoundEffects.id, this.de(), 5.0f, 0.8f + this.ah.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(b, DragonControllerPhase.k.b());
    }

    public double[] a(int i2, float f2) {
        if (this.ex()) {
            f2 = 0.0f;
        }
        f2 = 1.0f - f2;
        int j2 = this.d - i2 & 0x3F;
        int k2 = this.d - i2 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.c[j2][0];
        double d1 = MathHelper.d(this.c[k2][0] - d0);
        adouble[0] = d0 + d1 * (double)f2;
        d0 = this.c[j2][1];
        d1 = this.c[k2][1] - d0;
        adouble[1] = d0 + d1 * (double)f2;
        adouble[2] = MathHelper.d((double)f2, this.c[j2][2], this.c[k2][2]);
        return adouble;
    }

    @Override
    public void m_() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        this.aJ();
        if (this.dO().B) {
            this.v(this.ew());
            if (!this.aX() && !this.cy.a().a() && --this.cz < 0) {
                this.dO().a(this.dt(), this.dv(), this.dz(), SoundEffects.ie, this.de(), 2.5f, 0.8f + this.ah.i() * 0.3f, false);
                this.cz = 200 + this.ah.a(200);
            }
        }
        if (this.cw == null && (world = this.dO()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).D()) != null && this.cz().equals(enderdragonbattle.i())) {
            this.cw = enderdragonbattle;
        }
        this.cb = this.cc;
        if (this.ex()) {
            float f1 = (this.ah.i() - 0.5f) * 8.0f;
            float f2 = (this.ah.i() - 0.5f) * 4.0f;
            float f22 = (this.ah.i() - 0.5f) * 8.0f;
            this.dO().a(Particles.w, this.dt() + (double)f1, this.dv() + 2.0 + (double)f2, this.dz() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.gk();
            Vec3D vec3d = this.dr();
            float f3 = 0.2f / ((float)vec3d.h() * 10.0f + 1.0f);
            this.cc = this.cy.a().a() ? (this.cc += 0.1f) : (this.cd ? (this.cc += f3 * 0.5f) : (this.cc += (f3 *= (float)Math.pow(2.0, vec3d.d))));
            this.t(MathHelper.g(this.dE()));
            if (this.fZ()) {
                this.cc = 0.5f;
            } else {
                int k2;
                float f5;
                float f4;
                if (this.d < 0) {
                    for (int i2 = 0; i2 < this.c.length; ++i2) {
                        this.c[i2][0] = this.dE();
                        this.c[i2][1] = this.dv();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dE();
                this.c[this.d][1] = this.dv();
                if (this.dO().B) {
                    if (this.br > 0) {
                        this.a(this.br, this.bs, this.bt, this.bu, this.bv, this.bw);
                        --this.br;
                    }
                    this.cy.a().b();
                } else {
                    Vec3D vec3d1;
                    IDragonController idragoncontroller = this.cy.a();
                    idragoncontroller.c();
                    if (this.cy.a() != idragoncontroller) {
                        idragoncontroller = this.cy.a();
                        idragoncontroller.c();
                    }
                    if ((vec3d1 = idragoncontroller.g()) != null && idragoncontroller.i() != DragonControllerPhase.k) {
                        double d0 = vec3d1.c - this.dt();
                        double d1 = vec3d1.d - this.dv();
                        double d2 = vec3d1.e - this.dz();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.f();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = MathHelper.a(d1 / d4, (double)(-f6), (double)f6);
                        }
                        this.i(this.dr().b(0.0, d1 * 0.01, 0.0));
                        this.t(MathHelper.g(this.dE()));
                        Vec3D vec3d2 = vec3d1.a(this.dt(), this.dv(), this.dz()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dE() * ((float)Math.PI / 180)), this.dr().d, -MathHelper.b(this.dE() * ((float)Math.PI / 180))).d();
                        float f32 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = MathHelper.a(MathHelper.g(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dE()), -50.0f, 50.0f);
                            this.cf *= 0.8f;
                            this.cf += f4 * idragoncontroller.h();
                            this.t(this.dE() + this.cf * 0.1f);
                        }
                        f4 = (float)(2.0 / (d3 + 1.0));
                        f5 = 0.06f;
                        this.a(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.cd) {
                            this.a(EnumMoveType.a, this.dr().a((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dr());
                        }
                        Vec3D vec3d4 = this.dr().d();
                        double d5 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.i(this.dr().d(d5, 0.91f, d5));
                    }
                }
                this.aY = this.dE();
                Vec3D[] avec3d = new Vec3D[this.co.length];
                for (int j2 = 0; j2 < this.co.length; ++j2) {
                    avec3d[j2] = new Vec3D(this.co[j2].dt(), this.co[j2].dv(), this.co[j2].dz());
                }
                float f7 = (float)(this.a(5, 1.0f)[1] - this.a(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.b(f7);
                float f9 = MathHelper.a(f7);
                float f10 = this.dE() * ((float)Math.PI / 180);
                float f11 = MathHelper.a(f10);
                float f12 = MathHelper.b(f10);
                this.a(this.cq, (double)(f11 * 0.5f), 0.0, (double)(-f12 * 0.5f));
                this.a(this.cu, (double)(f12 * 4.5f), 2.0, (double)(f11 * 4.5f));
                this.a(this.cv, (double)(f12 * -4.5f), 2.0, (double)(f11 * -4.5f));
                World world1 = this.dO();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    if (this.aO == 0) {
                        this.a(worldserver1, worldserver1.a((Entity)this, this.cu.cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.a(worldserver1, worldserver1.a((Entity)this, this.cv.cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.b(worldserver1.a((Entity)this, this.e.cK().g(1.0), IEntitySelector.e));
                        this.b(worldserver1.a((Entity)this, this.cp.cK().g(1.0), IEntitySelector.e));
                    }
                }
                float f13 = MathHelper.a(this.dE() * ((float)Math.PI / 180) - this.cf * 0.01f);
                float f14 = MathHelper.b(this.dE() * ((float)Math.PI / 180) - this.cf * 0.01f);
                float f15 = this.gj();
                this.a(this.e, (double)(f13 * 6.5f * f8), (double)(f15 + f9 * 6.5f), (double)(-f14 * 6.5f * f8));
                this.a(this.cp, (double)(f13 * 5.5f * f8), (double)(f15 + f9 * 5.5f), (double)(-f14 * 5.5f * f8));
                double[] adouble = this.a(5, 1.0f);
                for (k2 = 0; k2 < 3; ++k2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (k2 == 0) {
                        entitycomplexpart = this.cr;
                    }
                    if (k2 == 1) {
                        entitycomplexpart = this.cs;
                    }
                    if (k2 == 2) {
                        entitycomplexpart = this.ct;
                    }
                    double[] adouble1 = this.a(12 + k2 * 2, 1.0f);
                    float f16 = this.dE() * ((float)Math.PI / 180) + this.i(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f33 = MathHelper.a(f16);
                    f4 = MathHelper.b(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f11 * 1.5f + f33 * f17) * f8), adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (double)((f12 * 1.5f + f4 * f17) * f8));
                }
                if (!this.dO().B) {
                    this.cd = this.b(this.e.cK()) | this.b(this.cp.cK()) | this.b(this.cq.cK());
                    if (this.cw != null) {
                        this.cw.b(this);
                    }
                }
                for (k2 = 0; k2 < this.co.length; ++k2) {
                    this.co[k2].L = avec3d[k2].c;
                    this.co[k2].M = avec3d[k2].d;
                    this.co[k2].N = avec3d[k2].e;
                    this.co[k2].ad = avec3d[k2].c;
                    this.co[k2].ae = avec3d[k2].d;
                    this.co[k2].af = avec3d[k2].e;
                }
            }
        }
    }

    private void a(EntityComplexPart entitycomplexpart, double d0, double d1, double d2) {
        entitycomplexpart.a_(this.dt() + d0, this.dv() + d1, this.dz() + d2);
    }

    private float gj() {
        if (this.cy.a().a()) {
            return -1.0f;
        }
        double[] adouble = this.a(5, 1.0f);
        double[] adouble1 = this.a(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void gk() {
        if (this.cg != null) {
            if (this.cg.dJ()) {
                this.cg = null;
            } else if (this.ai % 10 == 0 && this.ew() < this.eN()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.v((float)((double)this.ew() + event.getAmount()));
                }
            }
        }
        if (this.ah.a(10) == 0) {
            List<EntityEnderCrystal> list = this.dO().a(EntityEnderCrystal.class, this.cK().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.g(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.cg = entityendercrystal;
        }
    }

    private void a(WorldServer worldserver, List<Entity> list) {
        double d0 = (this.cq.cK().a + this.cq.cK().d) / 2.0;
        double d1 = (this.cq.cK().c + this.cq.cK().f) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            double d2 = entity.dt() - d0;
            double d3 = entity.dz() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.j(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.cy.a().a() || entityliving.ej() >= entity.ai - 2) continue;
            DamageSource damagesource = this.dP().b(this);
            entity.a(damagesource, 5.0f);
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private void b(List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damagesource = this.dP().b(this);
            entity.a(damagesource, 10.0f);
            World world = this.dO();
            if (!(world instanceof WorldServer)) continue;
            WorldServer worldserver = (WorldServer)world;
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private float i(double d0) {
        return (float)MathHelper.d(d0);
    }

    private boolean b(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.a(axisalignedbb.b);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.a(axisalignedbb.d);
        int i1 = MathHelper.a(axisalignedbb.e);
        int j1 = MathHelper.a(axisalignedbb.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = this.dO().a_(blockposition);
                    if (iblockdata.i() || iblockdata.a(TagsBlock.aE)) continue;
                    if (this.dO().ab().b(GameRules.c) && !iblockdata.a(TagsBlock.aD)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(this.dO(), blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.j());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.dO().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().t() ? this.dO().c_(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.dO()).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.l).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.dO(), blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.dO(), blockposition, ItemStack.l, false);
                }
                nmsBlock.a(this.dO(), blockposition, this.explosionSource);
                this.dO().a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.ah.a(l2 - i2 + 1), j2 + this.ah.a(i1 - j2 + 1), k2 + this.ah.a(j1 - k2 + 1));
            this.dO().c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(EntityComplexPart entitycomplexpart, DamageSource damagesource, float f2) {
        if (this.cy.a().i() == DragonControllerPhase.j) {
            return false;
        }
        f2 = this.cy.a().a(damagesource, f2);
        if (entitycomplexpart != this.e) {
            f2 = f2 / 4.0f + Math.min(f2, 1.0f);
        }
        if (f2 < 0.01f) {
            return false;
        }
        if (damagesource.d() instanceof EntityHuman || damagesource.a(DamageTypeTags.y)) {
            float f1 = this.ew();
            this.g(damagesource, f2);
            if (this.ex() && !this.cy.a().a()) {
                this.v(1.0f);
                this.cy.a(DragonControllerPhase.j);
            }
            if (this.cy.a().a()) {
                this.cA = this.cA + f1 - this.ew();
                if (this.cA > 0.25f * this.eN()) {
                    this.cA = 0.0f;
                    this.cy.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        return !this.dO().B ? this.a(this.cq, damagesource, f2) : false;
    }

    protected boolean g(DamageSource damagesource, float f2) {
        return super.a(damagesource, f2);
    }

    @Override
    public void ap() {
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        ((Entity)this).a(GameEvent.p);
        if (this.cw != null) {
            this.cw.b(this);
            this.cw.a(this);
        }
    }

    @Override
    public int getExpReward(Entity entity) {
        boolean flag = this.dO().ab().b(GameRules.f);
        int short0 = 500;
        if (this.cw != null && !this.cw.f()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void ed() {
        if (this.cw != null) {
            this.cw.b(this);
        }
        ++this.ce;
        if (this.ce >= 180 && this.ce <= 200) {
            float f2 = (this.ah.i() - 0.5f) * 8.0f;
            float f1 = (this.ah.i() - 0.5f) * 4.0f;
            float f22 = (this.ah.i() - 0.5f) * 8.0f;
            this.dO().a(Particles.v, this.dt() + (double)f2, this.dv() + 2.0 + (double)f1, this.dz() + (double)f22, 0.0, 0.0, 0.0);
        }
        int short0 = this.expToDrop;
        if (this.dO() instanceof WorldServer) {
            if (this.ce > 150 && this.ce % 5 == 0) {
                EntityExperienceOrb.a((WorldServer)this.dO(), this.dm(), MathHelper.d((float)short0 * 0.08f));
            }
            if (this.ce == 1 && !this.aX()) {
                int viewDistance = ((WorldServer)this.dO()).getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : this.dO().o().ah().l) {
                    double deltaX = this.dt() - player.dt();
                    double deltaZ = this.dz() - player.dz();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (this.dO().spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(this.dO().spigotConfig.dragonDeathSoundRadius * this.dO().spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dt() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dz() + deltaZ / deltaLength * (double)viewDistance;
                        player.c.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dv(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.c.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dt(), (int)this.dv(), (int)this.dz()), 0, true));
                }
            }
        }
        this.a(EnumMoveType.a, new Vec3D(0.0, 0.1f, 0.0));
        if (this.ce == 200 && this.dO() instanceof WorldServer) {
            EntityExperienceOrb.a((WorldServer)this.dO(), this.dm(), MathHelper.d((float)short0 * 0.2f));
            if (this.cw != null) {
                this.cw.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            ((Entity)this).a(GameEvent.p);
        }
    }

    public int x() {
        if (this.cB[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.dO().z_() + 10, this.dO().a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cB[i2] = new PathPoint(k2, j1, l2);
            }
            this.cD[0] = 6146;
            this.cD[1] = 8197;
            this.cD[2] = 8202;
            this.cD[3] = 16404;
            this.cD[4] = 32808;
            this.cD[5] = 32848;
            this.cD[6] = 65696;
            this.cD[7] = 131392;
            this.cD[8] = 131712;
            this.cD[9] = 263424;
            this.cD[10] = 526848;
            this.cD[11] = 525313;
            this.cD[12] = 1581057;
            this.cD[13] = 3166214;
            this.cD[14] = 2138120;
            this.cD[15] = 6373424;
            this.cD[16] = 4358208;
            this.cD[17] = 12910976;
            this.cD[18] = 9044480;
            this.cD[19] = 9706496;
            this.cD[20] = 15216640;
            this.cD[21] = 0xD0E000;
            this.cD[22] = 11763712;
            this.cD[23] = 0x7E0000;
        }
        return this.q(this.dt(), this.dv(), this.dz());
    }

    public int q(double d0, double d1, double d2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.a(d0), MathHelper.a(d1), MathHelper.a(d2));
        int b0 = 0;
        if (this.cw == null || this.cw.e() == 0) {
            b0 = 12;
        }
        for (int j2 = b0; j2 < 24; ++j2) {
            float f1;
            if (this.cB[j2] == null || !((f1 = this.cB[j2].c(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int i2, int j2, @Nullable PathPoint pathpoint) {
        PathPoint pathpoint1;
        for (int k2 = 0; k2 < 24; ++k2) {
            pathpoint1 = this.cB[k2];
            pathpoint1.i = false;
            pathpoint1.g = 0.0f;
            pathpoint1.e = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cB[i2];
        pathpoint1 = this.cB[j2];
        pathpoint2.e = 0.0f;
        pathpoint2.g = pathpoint2.f = pathpoint2.a(pathpoint1);
        this.cE.a();
        this.cE.a(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.cw == null || this.cw.e() == 0) {
            b0 = 12;
        }
        while (!this.cE.e()) {
            int i1;
            PathPoint pathpoint4 = this.cE.c();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathpoint != null) {
                    pathpoint.h = pathpoint1;
                    pathpoint1 = pathpoint;
                }
                return this.a(pathpoint2, pathpoint1);
            }
            if (pathpoint4.a(pathpoint1) < pathpoint3.a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.i = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.cB[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.cD[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.cB[i1];
                if (pathpoint5.i) continue;
                float f2 = pathpoint4.e + pathpoint4.a(pathpoint5);
                if (pathpoint5.c() && !(f2 < pathpoint5.e)) continue;
                pathpoint5.h = pathpoint4;
                pathpoint5.e = f2;
                pathpoint5.f = pathpoint5.a(pathpoint1);
                if (pathpoint5.c()) {
                    this.cE.a(pathpoint5, pathpoint5.e + pathpoint5.f);
                    continue;
                }
                pathpoint5.g = pathpoint5.e + pathpoint5.f;
                this.cE.a(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        ch.debug("Failed to find path from {} to {}", (Object)i2, (Object)j2);
        if (pathpoint != null) {
            pathpoint.h = pathpoint3;
            pathpoint3 = pathpoint;
        }
        return this.a(pathpoint2, pathpoint3);
    }

    private PathEntity a(PathPoint pathpoint, PathPoint pathpoint1) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = pathpoint1;
        list.add(0, pathpoint1);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(pathpoint1.a, pathpoint1.b, pathpoint1.c), true);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a(cn, this.cy.a().i().b());
        nbttagcompound.a(cm, this.ce);
        nbttagcompound.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.e(cn)) {
            this.cy.a(DragonControllerPhase.a(nbttagcompound.h(cn)));
        }
        if (nbttagcompound.e(cm)) {
            this.ce = nbttagcompound.h(cm);
        }
        if (nbttagcompound.e("Bukkit.expToDrop")) {
            this.expToDrop = nbttagcompound.h("Bukkit.expToDrop");
        }
    }

    @Override
    public void dA() {
    }

    public EntityComplexPart[] gg() {
        return this.co;
    }

    @Override
    public boolean bA() {
        return false;
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.ia;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.if;
    }

    @Override
    protected float fa() {
        return 5.0f;
    }

    public float a(int i2, double[] adouble, double[] adouble1) {
        double d0;
        IDragonController idragoncontroller = this.cy.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            d0 = idragoncontroller.a() ? (double)i2 : (i2 == 6 ? 0.0 : adouble1[1] - adouble[1]);
        } else {
            BlockPosition blockposition = this.dO().a(HeightMap.Type.f, WorldGenEndTrophy.a(this.cx));
            double d1 = Math.max(Math.sqrt(blockposition.b(this.dm())) / 4.0, 1.0);
            d0 = (double)i2 / d1;
        }
        return (float)d0;
    }

    public Vec3D H(float f2) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cy.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f22 = this.dG();
                float f1 = 1.5f;
                this.u(-45.0f);
                vec3d = this.g(f2);
                this.u(f22);
            } else {
                vec3d = this.g(f2);
            }
        } else {
            BlockPosition blockposition = this.dO().a(HeightMap.Type.f, WorldGenEndTrophy.a(this.cx));
            float f1 = Math.max((float)Math.sqrt(blockposition.b(this.dm())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.dG();
            float f5 = 1.5f;
            this.u(-f3 * 1.5f * 5.0f);
            vec3d = this.g(f2);
            this.u(f4);
        }
        return vec3d;
    }

    public void a(EntityEnderCrystal entityendercrystal, BlockPosition blockposition, DamageSource damagesource) {
        EntityHuman entityhuman = damagesource.d() instanceof EntityHuman ? (EntityHuman)damagesource.d() : this.dO().a(ci, (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        if (entityendercrystal == this.cg) {
            this.a(this.e, this.dP().d(entityendercrystal, entityhuman), 10.0f);
        }
        this.cy.a().a(entityendercrystal, blockposition, damagesource, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (b.equals(datawatcherobject) && this.dO().B) {
            this.cy.a(DragonControllerPhase.a(this.ar().a(b)));
        }
        super.a(datawatcherobject);
    }

    public DragonControllerManager gh() {
        return this.cy;
    }

    @Nullable
    public EnderDragonBattle gi() {
        return this.cw;
    }

    @Override
    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean flag) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        EntityComplexPart[] aentitycomplexpart = this.gg();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packetplayoutspawnentity.b());
        }
    }

    @Override
    public boolean c(EntityLiving entityliving) {
        return entityliving.ep();
    }

    @Override
    protected float b(float f2) {
        return 1.0f;
    }
}

