/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> f = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> g = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int e = 8;
    private static final float h = 0.0625f;
    private static final float i = 0.75f;
    private static final float j = 0.75f;
    public float k = 1.0f;
    public boolean l;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entitytypes, World world) {
        super((EntityTypes<? extends EntityHanging>)entitytypes, world);
    }

    public EntityItemFrame(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        this(EntityTypes.ai, world, blockposition, enumdirection);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entitytypes, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        super((EntityTypes<? extends EntityHanging>)entitytypes, world, blockposition);
        this.a(enumdirection);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(f, ItemStack.l);
        datawatcher_a.a(g, 0);
    }

    @Override
    public void a(EnumDirection enumdirection) {
        Validate.notNull((Object)enumdirection);
        this.d = enumdirection;
        if (enumdirection.o().d()) {
            this.u(0.0f);
            this.t(this.d.e() * 90);
        } else {
            this.u(-90 * enumdirection.f().a());
            this.t(0.0f);
        }
        this.P = this.dG();
        this.O = this.dE();
        this.p();
    }

    @Override
    protected AxisAlignedBB a(BlockPosition blockposition, EnumDirection enumdirection) {
        return EntityItemFrame.calculateBoundingBoxStatic(blockposition, enumdirection);
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition blockposition, EnumDirection enumdirection) {
        float f2 = 0.46875f;
        Vec3D vec3d = Vec3D.b(blockposition).a(enumdirection, -0.46875);
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        double d0 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? 0.0625 : 0.75;
        double d1 = enumdirection_enumaxis == EnumDirection.EnumAxis.b ? 0.0625 : 0.75;
        double d2 = enumdirection_enumaxis == EnumDirection.EnumAxis.c ? 0.0625 : 0.75;
        return AxisAlignedBB.a(vec3d, d0, d1, d2);
    }

    @Override
    public boolean s() {
        if (this.l) {
            return true;
        }
        if (!this.dO().g(this)) {
            return false;
        }
        IBlockData iblockdata = this.dO().a_(this.b.a(this.d.g()));
        return !iblockdata.e() && (!this.d.o().d() || !BlockDiodeAbstract.m(iblockdata)) ? false : this.dO().a((Entity)this, this.cK(), c).isEmpty();
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (!this.l) {
            super.a(enummovetype, vec3d);
        }
    }

    @Override
    public void j(double d0, double d1, double d2) {
        if (!this.l) {
            super.j(d0, d1, d2);
        }
    }

    @Override
    public void ap() {
        this.d(this.D());
        super.ap();
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.l) {
            return !damagesource.a(DamageTypeTags.d) && !damagesource.h() ? false : super.a(damagesource, f2);
        }
        if (this.b(damagesource)) {
            return false;
        }
        if (!damagesource.a(DamageTypeTags.l) && !this.D().e()) {
            if (!this.dO().B) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, false) || this.dJ()) {
                    return true;
                }
                this.b(damagesource.d(), false);
                this.a(GameEvent.c, damagesource.d());
                this.a(this.v(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.a(damagesource, f2);
    }

    public SoundEffect v() {
        return SoundEffects.nz;
    }

    @Override
    public boolean a(double d0) {
        double d1 = 16.0;
        return d0 < (d1 *= 64.0 * EntityItemFrame.cD()) * d1;
    }

    @Override
    public void b(@Nullable Entity entity) {
        this.a(this.w(), 1.0f, 1.0f);
        this.b(entity, true);
        this.a(GameEvent.c, entity);
    }

    public SoundEffect w() {
        return SoundEffects.nx;
    }

    @Override
    public void C() {
        this.a(this.x(), 1.0f, 1.0f);
    }

    public SoundEffect x() {
        return SoundEffects.ny;
    }

    private void b(@Nullable Entity entity, boolean flag) {
        if (!this.l) {
            ItemStack itemstack = this.D();
            this.c(ItemStack.l);
            if (!this.dO().ab().b(GameRules.i)) {
                if (entity == null) {
                    this.d(itemstack);
                }
            } else {
                EntityHuman entityhuman;
                if (entity instanceof EntityHuman && (entityhuman = (EntityHuman)entity).fL()) {
                    this.d(itemstack);
                    return;
                }
                if (flag) {
                    this.b(this.A());
                }
                if (!itemstack.e()) {
                    itemstack = itemstack.s();
                    this.d(itemstack);
                    if (this.ah.i() < this.k) {
                        this.b(itemstack);
                    }
                }
            }
        }
    }

    private void d(ItemStack itemstack) {
        WorldMap worldmap;
        MapId mapid = this.a(itemstack);
        if (mapid != null && (worldmap = ItemWorldMap.a(mapid, this.dO())) != null) {
            worldmap.a(this.b, this.an());
            worldmap.a(true);
        }
        itemstack.a((Entity)null);
    }

    public ItemStack D() {
        return this.ar().a(f);
    }

    @Nullable
    public MapId a(ItemStack itemstack) {
        return itemstack.a(DataComponents.B);
    }

    public boolean E() {
        return this.D().b(DataComponents.B);
    }

    public void c(ItemStack itemstack) {
        this.a(itemstack, true);
    }

    public void a(ItemStack itemstack, boolean flag) {
        this.setItem(itemstack, flag, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.e()) {
            itemstack = itemstack.c(1);
        }
        this.e(itemstack);
        this.ar().a(f, itemstack);
        if (!itemstack.e() && playSound) {
            this.a(this.y(), 1.0f, 1.0f);
        }
        if (flag && this.b != null) {
            this.dO().c(this.b, Blocks.a);
        }
    }

    public SoundEffect y() {
        return SoundEffects.nw;
    }

    @Override
    public SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::D, this::c) : super.a_(i2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (datawatcherobject.equals(f)) {
            this.e(this.D());
        }
    }

    private void e(ItemStack itemstack) {
        if (!itemstack.e() && itemstack.D() != this) {
            itemstack.a(this);
        }
        this.p();
    }

    public int F() {
        return this.ar().a(g);
    }

    public void b(int i2) {
        this.a(i2, true);
    }

    private void a(int i2, boolean flag) {
        this.ar().a(g, i2 % 8);
        if (flag && this.b != null) {
            this.dO().c(this.b, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        if (!this.D().e()) {
            nbttagcompound.a("Item", this.D().a(this.dQ()));
            nbttagcompound.a("ItemRotation", (byte)this.F());
            nbttagcompound.a("ItemDropChance", this.k);
        }
        nbttagcompound.a("Facing", (byte)this.d.d());
        nbttagcompound.a("Invisible", this.ci());
        nbttagcompound.a("Fixed", this.l);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        ItemStack itemstack;
        super.a(nbttagcompound);
        if (nbttagcompound.b("Item", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("Item");
            itemstack = ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound1).orElse(ItemStack.l);
        } else {
            itemstack = ItemStack.l;
        }
        ItemStack itemstack1 = this.D();
        if (!itemstack1.e() && !ItemStack.a(itemstack, itemstack1)) {
            this.d(itemstack1);
        }
        this.a(itemstack, false);
        if (!itemstack.e()) {
            this.a(nbttagcompound.f("ItemRotation"), false);
            if (nbttagcompound.b("ItemDropChance", 99)) {
                this.k = nbttagcompound.j("ItemDropChance");
            }
        }
        this.a(EnumDirection.a(nbttagcompound.f("Facing")));
        this.k(nbttagcompound.q("Invisible"));
        this.l = nbttagcompound.q("Fixed");
    }

    @Override
    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag1;
        ItemStack itemstack = entityhuman.b(enumhand);
        boolean flag = !this.D().e();
        boolean bl = flag1 = !itemstack.e();
        if (this.l) {
            return EnumInteractionResult.e;
        }
        if (!this.dO().B) {
            if (!flag) {
                if (flag1 && !this.dJ()) {
                    WorldMap worldmap;
                    if (itemstack.a(Items.rU) && (worldmap = ItemWorldMap.b(itemstack, this.dO())) != null && worldmap.a(256)) {
                        return EnumInteractionResult.f;
                    }
                    this.c(itemstack);
                    this.a(GameEvent.c, (Entity)entityhuman);
                    itemstack.a(1, (EntityLiving)entityhuman);
                }
            } else {
                this.a(this.z(), 1.0f, 1.0f);
                this.b(this.F() + 1);
                this.a(GameEvent.c, (Entity)entityhuman);
            }
            return EnumInteractionResult.c;
        }
        return !flag && !flag1 ? EnumInteractionResult.e : EnumInteractionResult.a;
    }

    public SoundEffect z() {
        return SoundEffects.nA;
    }

    public int H() {
        return this.D().e() ? 0 : this.F() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.d.d(), this.t());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.a(EnumDirection.a(packetplayoutspawnentity.p()));
    }

    @Override
    public ItemStack dB() {
        ItemStack itemstack = this.D();
        return itemstack.e() ? this.A() : itemstack.s();
    }

    protected ItemStack A() {
        return new ItemStack(Items.uc);
    }

    @Override
    public float dF() {
        EnumDirection enumdirection = this.cH();
        int i2 = enumdirection.o().b() ? 90 * enumdirection.f().a() : 0;
        return MathHelper.b(180 + enumdirection.e() * 90 + this.F() * 45 + i2);
    }
}

