/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> d = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float e = 0.1f;
    public static final float b = 0.2125f;
    private static final int f = 6000;
    private static final int g = Short.MAX_VALUE;
    private static final int h = Short.MIN_VALUE;
    public int i;
    public int j;
    private int k = 5;
    @Nullable
    public UUID l;
    @Nullable
    private Entity m;
    @Nullable
    public UUID n;
    public final float c;
    private int lastTick = MinecraftServer.currentTick - 1;

    public EntityItem(EntityTypes<? extends EntityItem> entitytypes, World world) {
        super(entitytypes, world);
        this.c = this.ah.i() * (float)Math.PI * 2.0f;
        this.t(this.ah.i() * 360.0f);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack, world.z.j() * 0.2 - 0.1, 0.2, world.z.j() * 0.2 - 0.1);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack, double d3, double d4, double d5) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ag, world);
        this.a_(d0, d1, d2);
        this.n(d3, d4, d5);
        this.a(itemstack);
    }

    private EntityItem(EntityItem entityitem) {
        super(entityitem.am(), entityitem.dO());
        this.a(entityitem.p().s());
        this.v(entityitem);
        this.i = entityitem.i;
        this.c = entityitem.c;
    }

    @Override
    public boolean bd() {
        return this.p().a(TagsItem.ba);
    }

    @Override
    @Nullable
    public Entity s() {
        World world;
        if (this.m != null && !this.m.dJ()) {
            return this.m;
        }
        if (this.l != null && (world = this.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.m = worldserver.a(this.l);
            return this.m;
        }
        return null;
    }

    @Override
    public void w(Entity entity) {
        super.w(entity);
        if (entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            this.m = entityitem.m;
        }
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(d, ItemStack.l);
    }

    @Override
    protected double aZ() {
        return 0.04;
    }

    @Override
    public void l() {
        if (this.p().e()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i2;
            super.l();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.j != Short.MAX_VALUE) {
                this.j -= elapsedTicks;
            }
            if (this.i != Short.MIN_VALUE) {
                this.i += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.L = this.dt();
            this.M = this.dv();
            this.N = this.dz();
            Vec3D vec3d = this.dr();
            if (this.bf() && this.b(TagsFluid.a) > (double)0.1f) {
                this.D();
            } else if (this.bt() && this.b(TagsFluid.b) > (double)0.1f) {
                this.E();
            } else {
                this.bb();
            }
            if (this.dO().B) {
                this.ag = false;
            } else {
                boolean bl = this.ag = !this.dO().a((Entity)this, this.cK().h(1.0E-7));
                if (this.ag) {
                    this.m(this.dt(), (this.cK().b + this.cK().e) / 2.0, this.dz());
                }
            }
            if (!this.aF() || this.dr().i() > (double)1.0E-5f || (this.ai + this.an()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dr());
                float f2 = 0.98f;
                if (this.aF()) {
                    f2 = this.dO().a_(this.aL()).b().h() * 0.98f;
                }
                this.i(this.dr().d(f2, 0.98, f2));
                if (this.aF()) {
                    Vec3D vec3d1 = this.dr();
                    if (vec3d1.d < 0.0) {
                        this.i(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.L) != MathHelper.a(this.dt()) || MathHelper.a(this.M) != MathHelper.a(this.dv()) || MathHelper.a(this.N) != MathHelper.a(this.dz());
            int n2 = i2 = flag ? 2 : 40;
            if (this.ai % i2 == 0 && !this.dO().B && this.H()) {
                this.F();
            }
            this.av |= this.bm();
            if (!this.dO().B && (d0 = this.dr().d(vec3d).g()) > 0.01) {
                this.av = true;
            }
            if (!this.dO().B && this.i >= this.dO().spigotConfig.itemDespawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.i = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.j != Short.MAX_VALUE) {
            this.j -= elapsedTicks;
        }
        if (this.i != Short.MIN_VALUE) {
            this.i += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.dO().B && this.i >= this.dO().spigotConfig.itemDespawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.i = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition aL() {
        return this.e(0.999999f);
    }

    private void D() {
        Vec3D vec3d = this.dr();
        this.n(vec3d.c * (double)0.99f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.99f);
    }

    private void E() {
        Vec3D vec3d = this.dr();
        this.n(vec3d.c * (double)0.95f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.95f);
    }

    private void F() {
        if (this.H()) {
            double radius = this.dO().spigotConfig.itemMerge;
            List<EntityItem> list = this.dO().a(EntityItem.class, this.cK().c(radius, radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.H());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.H()) continue;
                this.a(entityitem2);
                if (!this.dJ()) continue;
                break;
            }
        }
    }

    private boolean H() {
        ItemStack itemstack = this.p();
        return this.bE() && this.j != Short.MAX_VALUE && this.i != Short.MIN_VALUE && this.i < 6000 && itemstack.H() < itemstack.j();
    }

    private void a(EntityItem entityitem) {
        ItemStack itemstack = this.p();
        ItemStack itemstack1 = entityitem.p();
        if (Objects.equals(this.n, entityitem.n) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, entityitem, itemstack1);
        }
    }

    public static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack1.H() + itemstack.H() > itemstack1.j() ? false : ItemStack.c(itemstack, itemstack1);
    }

    public static ItemStack a(ItemStack itemstack, ItemStack itemstack1, int i2) {
        int j2 = Math.min(Math.min(itemstack.j(), i2) - itemstack.H(), itemstack1.H());
        ItemStack itemstack2 = itemstack.c(itemstack.H() + j2);
        itemstack1.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, ItemStack itemstack1) {
        ItemStack itemstack2 = EntityItem.a(itemstack, itemstack1, 64);
        entityitem.a(itemstack2);
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, EntityItem entityitem1, ItemStack itemstack1) {
        if (!CraftEventFactory.callItemMergeEvent(entityitem1, entityitem)) {
            return;
        }
        EntityItem.a(entityitem, itemstack, itemstack1);
        entityitem.j = Math.max(entityitem.j, entityitem1.j);
        entityitem.i = Math.min(entityitem.i, entityitem1.i);
        if (itemstack1.e()) {
            entityitem1.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean be() {
        return this.p().b(DataComponents.w) || super.be();
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        if (!this.p().e() && this.p().a(Items.us) && damagesource.a(DamageTypeTags.l)) {
            return false;
        }
        if (!this.p().a(damagesource)) {
            return false;
        }
        if (this.dO().B) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2)) {
            return false;
        }
        this.bw();
        this.k = (int)((float)this.k - f2);
        this.a(GameEvent.o, damagesource.d());
        if (this.k <= 0) {
            this.p().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Health", (short)this.k);
        nbttagcompound.a("Age", (short)this.i);
        nbttagcompound.a("PickupDelay", (short)this.j);
        if (this.l != null) {
            nbttagcompound.a("Thrower", this.l);
        }
        if (this.n != null) {
            nbttagcompound.a("Owner", this.n);
        }
        if (!this.p().e()) {
            nbttagcompound.a("Item", this.p().a(this.dQ()));
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.k = nbttagcompound.g("Health");
        this.i = nbttagcompound.g("Age");
        if (nbttagcompound.e("PickupDelay")) {
            this.j = nbttagcompound.g("PickupDelay");
        }
        if (nbttagcompound.b("Owner")) {
            this.n = nbttagcompound.a("Owner");
        }
        if (nbttagcompound.b("Thrower")) {
            this.l = nbttagcompound.a("Thrower");
            this.m = null;
        }
        if (nbttagcompound.b("Item", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p("Item");
            this.a(ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound1).orElse(ItemStack.l));
        } else {
            this.a(ItemStack.l);
        }
        if (this.p().e()) {
            this.discard(null);
        }
    }

    @Override
    public void b_(EntityHuman entityhuman) {
        if (!this.dO().B) {
            ItemStack itemstack = this.p();
            Item item = itemstack.g();
            int i2 = itemstack.H();
            int canHold = entityhuman.fY().canHold(itemstack);
            int remaining = i2 - canHold;
            if (this.j <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dO().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)entityhuman.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dO().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                ItemStack current = this.p();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.e(canHold + remaining);
                }
                this.j = 0;
            } else if (this.j == 0) {
                this.j = -1;
            }
            if (this.j == 0 && (this.n == null || this.n.equals(entityhuman.cz())) && entityhuman.fY().f(itemstack)) {
                entityhuman.a((Entity)this, i2);
                if (itemstack.e()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.e(i2);
                }
                entityhuman.a(StatisticList.e.b(item), i2);
                entityhuman.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ah() {
        IChatBaseComponent ichatbasecomponent = this.aj();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.c(this.p().t());
    }

    @Override
    public boolean cu() {
        return false;
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition dimensiontransition) {
        Entity entity = super.a(dimensiontransition);
        if (!this.dO().B && entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            entityitem.F();
        }
        return entity;
    }

    public ItemStack p() {
        return this.ar().a(d);
    }

    public void a(ItemStack itemstack) {
        this.ar().a(d, itemstack);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (d.equals(datawatcherobject)) {
            this.p().a((Entity)this);
        }
    }

    public void b(@Nullable UUID uuid) {
        this.n = uuid;
    }

    public void b(Entity entity) {
        this.l = entity.cz();
        this.m = entity;
    }

    public int t() {
        return this.i;
    }

    public void v() {
        this.j = 10;
    }

    public void w() {
        this.j = 0;
    }

    public void x() {
        this.j = Short.MAX_VALUE;
    }

    public void b(int i2) {
        this.j = i2;
    }

    public boolean y() {
        return this.j > 0;
    }

    public void z() {
        this.i = Short.MIN_VALUE;
    }

    public void A() {
        this.i = -6000;
    }

    public void B() {
        this.x();
        this.i = this.dO().spigotConfig.itemDespawnRate - 1;
    }

    public float a(float f2) {
        return ((float)this.t() + f2) / 20.0f + this.c;
    }

    public EntityItem C() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.i;
    }

    @Override
    public float dF() {
        return 180.0f - this.a(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::p, this::a) : super.a_(i2);
    }
}

