/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final MinecraftKey c = MinecraftKey.b("attacking");
    private static final AttributeModifier d = new AttributeModifier(c, 0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int cc = 600;
    private static final DataWatcherObject<Optional<IBlockData>> cd = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int cg = Integer.MIN_VALUE;
    private int ch;
    private static final UniformInt ci = TimeRange.a(20, 39);
    private int cj;
    @Nullable
    private UUID ck;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void B() {
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(1, new a(this));
        this.bW.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bW.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bW.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(8, new PathfinderGoalRandomLookaround(this));
        this.bW.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bW.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bX.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a_));
        this.bX.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bX.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gq().a(GenericAttributes.s, 40.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.c, 7.0).a(GenericAttributes.m, 64.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    public void h(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.p();
        AttributeModifiable attributemodifiable = this.f(GenericAttributes.v);
        if (entityliving == null) {
            this.ch = 0;
            this.ao.a(ce, false);
            this.ao.a(cf, false);
            attributemodifiable.c(c);
        } else {
            this.ch = this.ai;
            this.ao.a(ce, true);
            if (!attributemodifiable.b(c)) {
                attributemodifiable.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cd, Optional.empty());
        datawatcher_a.a(ce, false);
        datawatcher_a.a(cf, false);
    }

    @Override
    public void c() {
        this.a(ci.a(this.ah));
    }

    @Override
    public void a(int i2) {
        this.cj = i2;
    }

    @Override
    public int a() {
        return this.cj;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.ck = uuid;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.ck;
    }

    public void t() {
        if (this.ai >= this.cg + 400) {
            this.cg = this.ai;
            if (!this.aX()) {
                this.dO().a(this.dt(), this.dx(), this.dz(), SoundEffects.in, this.de(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (ce.equals(datawatcherobject) && this.gm() && this.dO().B) {
            this.t();
        }
        super.a(datawatcherobject);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        IBlockData iblockdata = this.gk();
        if (iblockdata != null) {
            nbttagcompound.a("carriedBlockState", GameProfileSerializer.a(iblockdata));
        }
        this.a_(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        IBlockData iblockdata = null;
        if (nbttagcompound.b("carriedBlockState", 10) && (iblockdata = GameProfileSerializer.a(this.dO().a(Registries.f), nbttagcompound.p("carriedBlockState"))).i()) {
            iblockdata = null;
        }
        this.c(iblockdata);
        this.a(this.dO(), nbttagcompound);
    }

    boolean f(EntityHuman entityhuman) {
        ItemStack itemstack = entityhuman.fY().i.get(3);
        if (itemstack.a(Blocks.ee.r())) {
            return false;
        }
        Vec3D vec3d = entityhuman.g(1.0f).d();
        Vec3D vec3d1 = new Vec3D(this.dt() - entityhuman.dt(), this.dx() - entityhuman.dx(), this.dz() - entityhuman.dz());
        double d0 = vec3d1.f();
        double d1 = vec3d.b(vec3d1 = vec3d1.d());
        return d1 > 1.0 - 0.025 / d0 ? entityhuman.F(this) : false;
    }

    @Override
    public void m_() {
        if (this.dO().B) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.dO().a(Particles.ac, this.d(0.5), this.dw() - 0.25, this.g(0.5), (this.ah.j() - 0.5) * 2.0, -this.ah.j(), (this.ah.j() - 0.5) * 2.0);
            }
        }
        this.bn = false;
        if (!this.dO().B) {
            this.a((WorldServer)this.dO(), true);
        }
        super.m_();
    }

    @Override
    public boolean fl() {
        return true;
    }

    @Override
    protected void ab() {
        float f2;
        if (this.dO().R() && this.ai >= this.ch + 600 && (f2 = this.bu()) > 0.5f && this.dO().h(this.do()) && this.ah.i() * 30.0f < (f2 - 0.4f) * 2.0f) {
            this.h((EntityLiving)null);
            this.x();
        }
        super.ab();
    }

    public boolean x() {
        if (!this.dO().x_() && this.bE()) {
            double d0 = this.dt() + (this.ah.j() - 0.5) * 64.0;
            double d1 = this.dv() + (double)(this.ah.a(64) - 32);
            double d2 = this.dz() + (this.ah.j() - 0.5) * 64.0;
            return this.q(d0, d1, d2);
        }
        return false;
    }

    public boolean c(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dt() - entity.dt(), this.e(0.5) - entity.dx(), this.dz() - entity.dz());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dt() + (this.ah.j() - 0.5) * 8.0 - vec3d.c * 16.0;
        double d2 = this.dv() + (double)(this.ah.a(16) - 8) - vec3d.d * 16.0;
        double d3 = this.dz() + (this.ah.j() - 0.5) * 8.0 - vec3d.e * 16.0;
        return this.q(d1, d2, d3);
    }

    private boolean q(double d0, double d1, double d2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(d0, d1, d2);
        while (blockposition_mutableblockposition.v() > this.dO().I_() && !this.dO().a_(blockposition_mutableblockposition).d()) {
            blockposition_mutableblockposition.c(EnumDirection.a);
        }
        IBlockData iblockdata = this.dO().a_(blockposition_mutableblockposition);
        boolean flag = iblockdata.d();
        boolean flag1 = iblockdata.u().a(TagsFluid.a);
        if (flag && !flag1) {
            Vec3D vec3d = this.dm();
            boolean flag2 = this.b(d0, d1, d2, true);
            if (flag2) {
                this.dO().a(GameEvent.R, vec3d, GameEvent.a.a(this));
                if (!this.aX()) {
                    this.dO().a((EntityHuman)null, this.L, this.M, this.N, SoundEffects.io, this.de(), 1.0f, 1.0f);
                    this.a(SoundEffects.io, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect v() {
        return this.gl() ? SoundEffects.im : SoundEffects.ij;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.il;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.ik;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        IBlockData iblockdata = this.gk();
        if (iblockdata != null) {
            ItemStack itemstack = new ItemStack(Items.pj);
            EnchantmentManager.a(itemstack, worldserver.H_(), VanillaEnchantmentProviders.g, worldserver.d_(this.do()), this.dR());
            LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dO()).a(LootContextParameters.f, this.dm()).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, this);
            List<ItemStack> list = iblockdata.a(lootparams_a);
            for (ItemStack itemstack1 : list) {
                this.b(itemstack1);
            }
        }
    }

    public void c(@Nullable IBlockData iblockdata) {
        this.ao.a(cd, Optional.ofNullable(iblockdata));
    }

    @Nullable
    public IBlockData gk() {
        return this.ao.a(cd).orElse(null);
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        boolean flag = damagesource.c() instanceof EntityPotion;
        if (!damagesource.a(DamageTypeTags.j) && !flag) {
            boolean flag1 = super.a(damagesource, f2);
            if (!this.dO().x_() && !(damagesource.d() instanceof EntityLiving) && this.ah.a(10) != 0) {
                this.x();
            }
            return flag1;
        }
        boolean flag1 = flag && this.a(damagesource, (EntityPotion)damagesource.c(), f2);
        for (int i2 = 0; i2 < 64; ++i2) {
            if (!this.x()) continue;
            return true;
        }
        return flag1;
    }

    private boolean a(DamageSource damagesource, EntityPotion entitypotion, float f2) {
        ItemStack itemstack = entitypotion.p();
        PotionContents potioncontents = itemstack.a(DataComponents.G, PotionContents.a);
        return potioncontents.a(Potions.a) ? super.a(damagesource, f2) : false;
    }

    public boolean gl() {
        return this.ao.a(ce);
    }

    public boolean gm() {
        return this.ao.a(cf);
    }

    public void gn() {
        this.ao.a(cf, true);
    }

    @Override
    public boolean Y() {
        return super.Y() || this.gk() != null;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman entityenderman) {
            this.a = entityenderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.b = this.a.p();
            if (!(this.b instanceof EntityHuman)) {
                return false;
            }
            double d0 = this.b.g((Entity)this.a);
            return d0 > 256.0 ? false : this.a.f((EntityHuman)this.b);
        }

        @Override
        public void d() {
            this.a.N().n();
        }

        @Override
        public void a() {
            this.a.I().a(this.b.dt(), this.b.dx(), this.b.dz());
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean b() {
            return this.a.gk() == null ? false : (!this.a.dO().ab().b(GameRules.c) ? false : this.a.dR().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void a() {
            RandomSource randomsource = this.a.dR();
            World world = this.a.dO();
            int i2 = MathHelper.a(this.a.dt() - 1.0 + randomsource.j() * 2.0);
            int j2 = MathHelper.a(this.a.dv() + randomsource.j() * 2.0);
            int k2 = MathHelper.a(this.a.dz() - 1.0 + randomsource.j() * 2.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            BlockPosition blockposition1 = blockposition.e();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.gk();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, this.a.dO(), blockposition), iblockdata, iblockdata1, blockposition1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2)) {
                world.a(blockposition, iblockdata2, 3);
                world.a(GameEvent.i, blockposition, GameEvent.a.a(this.a, iblockdata2));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, IBlockData iblockdata2, BlockPosition blockposition1) {
            return iblockdata1.i() && !iblockdata2.i() && !iblockdata2.a(Blocks.F) && iblockdata2.r(world, blockposition1) && iblockdata.a((IWorldReader)world, blockposition) && world.a_(this.a, AxisAlignedBB.a(Vec3D.a(blockposition))).isEmpty();
        }
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean b() {
            return this.a.gk() != null ? false : (!this.a.dO().ab().b(GameRules.c) ? false : this.a.dR().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void a() {
            RandomSource randomsource = this.a.dR();
            World world = this.a.dO();
            int i2 = MathHelper.a(this.a.dt() - 2.0 + randomsource.j() * 4.0);
            int j2 = MathHelper.a(this.a.dv() + randomsource.j() * 3.0);
            int k2 = MathHelper.a(this.a.dz() - 2.0 + randomsource.j() * 4.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            Vec3D vec3d = new Vec3D((double)this.a.ds() + 0.5, (double)j2 + 0.5, (double)this.a.dy() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.a().equals(blockposition);
            if (iblockdata.a(TagsBlock.am) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, Blocks.a.o())) {
                world.a(blockposition, false);
                world.a(GameEvent.f, blockposition, GameEvent.a.a(this.a, iblockdata));
                this.a.c(iblockdata.b().o());
            }
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final Predicate<EntityLiving> o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman entityenderman, @Nullable Predicate<EntityLiving> predicate) {
            super(entityenderman, EntityHuman.class, 10, false, false, predicate);
            this.i = entityenderman;
            this.o = entityliving -> (entityenderman.f((EntityHuman)entityliving) || entityenderman.a_((EntityLiving)entityliving)) && !entityenderman.z((Entity)entityliving);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean b() {
            this.j = this.i.dO().a(this.m, this.i);
            return this.j != null;
        }

        @Override
        public void d() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gn();
        }

        @Override
        public void e() {
            this.j = null;
            super.e();
        }

        @Override
        public boolean c() {
            if (this.j != null) {
                if (!this.o.test(this.j)) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.z(this.c)) {
                    return false;
                }
                if (this.n.a(this.i, this.c)) {
                    return true;
                }
            }
            return super.c();
        }

        @Override
        public void a() {
            if (this.i.p() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.d();
                }
            } else {
                if (this.c != null && !this.i.bS()) {
                    if (this.i.f((EntityHuman)this.c)) {
                        if (this.c.g((Entity)this.i) < 16.0) {
                            this.i.x();
                        }
                        this.l = 0;
                    } else if (this.c.g((Entity)this.i) > 256.0 && this.l++ >= this.a(30) && this.i.c((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.a();
            }
        }
    }
}

