/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep e;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> entitytypes, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)entitytypes, world);
        this.bR = 10;
    }

    @Override
    protected void B() {
        super.B();
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(1, new b());
        this.bW.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.bW.a(4, new c());
        this.bW.a(5, new a());
        this.bW.a(6, new d());
        this.bW.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bW.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bW.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bX.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bX.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder t() {
        return EntityMonster.gq().a(GenericAttributes.v, 0.5).a(GenericAttributes.m, 12.0).a(GenericAttributes.s, 24.0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
    }

    @Override
    public SoundEffect ai_() {
        return SoundEffects.iz;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
    }

    @Override
    protected void ab() {
        super.ab();
    }

    @Override
    public boolean s(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.s(entity)) {
            return true;
        }
        if (entity instanceof EntityVex) {
            EntityVex entityvex = (EntityVex)entity;
            return this.s(entityvex.x());
        }
        return false;
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.ix;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.iA;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.iC;
    }

    void a(@Nullable EntitySheep entitysheep) {
        this.e = entitysheep;
    }

    @Nullable
    EntitySheep gF() {
        return this.e;
    }

    @Override
    protected SoundEffect gk() {
        return SoundEffects.iy;
    }

    @Override
    public void a(WorldServer worldserver, int i2, boolean flag) {
    }

    private class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void a() {
            if (EntityEvoker.this.p() != null) {
                EntityEvoker.this.I().a(EntityEvoker.this.p(), (float)EntityEvoker.this.ae(), (float)EntityEvoker.this.ac());
            } else if (EntityEvoker.this.gF() != null) {
                EntityEvoker.this.I().a(EntityEvoker.this.gF(), (float)EntityEvoker.this.ae(), (float)EntityEvoker.this.ac());
            }
        }
    }

    private class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        public boolean b() {
            if (!super.b()) {
                return false;
            }
            int i2 = EntityEvoker.this.dO().a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.cK().g(16.0)).size();
            return EntityEvoker.this.ah.a(8) + 1 > i2;
        }

        @Override
        protected int h() {
            return 100;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            WorldServer worldserver = (WorldServer)EntityEvoker.this.dO();
            ScoreboardTeam scoreboardteam = EntityEvoker.this.ck();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockposition = EntityEvoker.this.do().b(-2 + EntityEvoker.this.ah.a(5), 1, -2 + EntityEvoker.this.ah.a(5));
                EntityVex entityvex = EntityTypes.bi.a(EntityEvoker.this.dO());
                if (entityvex == null) continue;
                entityvex.a(blockposition, 0.0f, 0.0f);
                entityvex.a((WorldAccess)worldserver, EntityEvoker.this.dO().d_(blockposition), EnumMobSpawn.f, (GroupDataEntity)null);
                entityvex.a(EntityEvoker.this);
                entityvex.h(blockposition);
                entityvex.b(20 * (30 + EntityEvoker.this.ah.a(90)));
                if (scoreboardteam != null) {
                    worldserver.f().a(entityvex.cB(), scoreboardteam);
                }
                worldserver.addFreshEntityWithPassengers(entityvex, CreatureSpawnEvent.SpawnReason.SPELL);
                worldserver.a(GameEvent.t, blockposition, GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iE;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    private class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int h() {
            return 40;
        }

        @Override
        protected int i() {
            return 100;
        }

        @Override
        protected void k() {
            EntityLiving entityliving = EntityEvoker.this.p();
            double d0 = Math.min(entityliving.dv(), EntityEvoker.this.dv());
            double d1 = Math.max(entityliving.dv(), EntityEvoker.this.dv()) + 1.0;
            float f2 = (float)MathHelper.d(entityliving.dz() - EntityEvoker.this.dz(), entityliving.dt() - EntityEvoker.this.dt());
            if (EntityEvoker.this.g((Entity)entityliving) < 9.0) {
                float f1;
                int i2;
                for (i2 = 0; i2 < 5; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dt() + (double)MathHelper.b(f1) * 1.5, EntityEvoker.this.dz() + (double)MathHelper.a(f1) * 1.5, d0, d1, f1, 0);
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dt() + (double)MathHelper.b(f1) * 2.5, EntityEvoker.this.dz() + (double)MathHelper.a(f1) * 2.5, d0, d1, f1, 3);
                }
            } else {
                for (int i3 = 0; i3 < 16; ++i3) {
                    double d2 = 1.25 * (double)(i3 + 1);
                    int j2 = 1 * i3;
                    this.a(EntityEvoker.this.dt() + (double)MathHelper.b(f2) * d2, EntityEvoker.this.dz() + (double)MathHelper.a(f2) * d2, d0, d1, f2, j2);
                }
            }
        }

        private void a(double d0, double d1, double d2, double d3, float f2, int i2) {
            BlockPosition blockposition = BlockPosition.a(d0, d3, d1);
            boolean flag = false;
            double d4 = 0.0;
            do {
                IBlockData iblockdata1;
                VoxelShape voxelshape;
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = EntityEvoker.this.dO().a_(blockposition1);
                if (!iblockdata.d(EntityEvoker.this.dO(), blockposition1, EnumDirection.b)) continue;
                if (!EntityEvoker.this.dO().u(blockposition) && !(voxelshape = (iblockdata1 = EntityEvoker.this.dO().a_(blockposition)).k(EntityEvoker.this.dO(), blockposition)).c()) {
                    d4 = voxelshape.c(EnumDirection.EnumAxis.b);
                }
                flag = true;
                break;
            } while ((blockposition = blockposition.e()).v() >= MathHelper.a(d2) - 1);
            if (flag) {
                EntityEvoker.this.dO().b(new EntityEvokerFangs(EntityEvoker.this.dO(), d0, (double)blockposition.v() + d4, d1, f2, i2, EntityEvoker.this));
                EntityEvoker.this.dO().a(GameEvent.t, new Vec3D(d0, (double)blockposition.v() + d4, d1), GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iD;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving entityliving) -> ((EntitySheep)entityliving).t() == EnumColor.l);
        }

        @Override
        public boolean b() {
            if (EntityEvoker.this.p() != null) {
                return false;
            }
            if (EntityEvoker.this.gu()) {
                return false;
            }
            if (EntityEvoker.this.ai < this.c) {
                return false;
            }
            if (!EntityEvoker.this.dO().ab().b(GameRules.c)) {
                return false;
            }
            List<EntitySheep> list = EntityEvoker.this.dO().a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.cK().c(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(list.get(EntityEvoker.this.ah.a(list.size())));
            return true;
        }

        @Override
        public boolean c() {
            return EntityEvoker.this.gF() != null && this.b > 0;
        }

        @Override
        public void e() {
            super.e();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        protected void k() {
            EntitySheep entitysheep = EntityEvoker.this.gF();
            if (entitysheep != null && entitysheep.bE()) {
                entitysheep.b(EnumColor.o);
            }
        }

        @Override
        protected int n() {
            return 40;
        }

        @Override
        protected int h() {
            return 60;
        }

        @Override
        protected int i() {
            return 140;
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.iF;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

