/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> e = entity -> entity.bE() && !(entity instanceof EntityRavager);
    private static final double cc = 0.3;
    private static final double cd = 0.35;
    private static final int ce = 8356754;
    private static final float cf = 0.57254905f;
    private static final float cg = 0.5137255f;
    private static final float ch = 0.49803922f;
    private static final int ci = 10;
    public static final int b = 40;
    private int cj;
    private int ck;
    private int cl;

    public EntityRavager(EntityTypes<? extends EntityRavager> entitytypes, World world) {
        super((EntityTypes<? extends EntityRaider>)entitytypes, world);
        this.bR = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    protected void B() {
        super.B();
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bW.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.bW.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bW.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bX.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bX.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, entityliving -> !entityliving.o_()));
        this.bX.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void U() {
        boolean flag = !(this.cQ() instanceof EntityInsentient) || this.cQ().am().a(TagsEntity.c);
        boolean flag1 = !(this.dc() instanceof EntityBoat);
        this.bW.a(PathfinderGoal.Type.a, flag);
        this.bW.a(PathfinderGoal.Type.c, flag && flag1);
        this.bW.a(PathfinderGoal.Type.b, flag);
        this.bW.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gq().a(GenericAttributes.s, 100.0).a(GenericAttributes.v, 0.3).a(GenericAttributes.p, 0.75).a(GenericAttributes.c, 12.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.m, 32.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("AttackTick", this.cj);
        nbttagcompound.a("StunTick", this.ck);
        nbttagcompound.a("RoarTick", this.cl);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.cj = nbttagcompound.h("AttackTick");
        this.ck = nbttagcompound.h("StunTick");
        this.cl = nbttagcompound.h("RoarTick");
    }

    @Override
    public SoundEffect ai_() {
        return SoundEffects.vf;
    }

    @Override
    public int ae() {
        return 45;
    }

    @Override
    public void m_() {
        super.m_();
        if (this.bE()) {
            if (this.fc()) {
                this.f(GenericAttributes.v).a(0.0);
            } else {
                double d0 = this.p() != null ? 0.35 : 0.3;
                double d1 = this.f(GenericAttributes.v).b();
                this.f(GenericAttributes.v).a(MathHelper.d(0.1, d1, d0));
            }
            if (this.Q && this.dO().ab().b(GameRules.c)) {
                boolean flag = false;
                AxisAlignedBB axisalignedbb = this.cK().g(0.2);
                for (BlockPosition blockposition : BlockPosition.b(MathHelper.a(axisalignedbb.a), MathHelper.a(axisalignedbb.b), MathHelper.a(axisalignedbb.c), MathHelper.a(axisalignedbb.d), MathHelper.a(axisalignedbb.e), MathHelper.a(axisalignedbb.f))) {
                    IBlockData iblockdata = this.dO().a_(blockposition);
                    Block block = iblockdata.b();
                    if (!(block instanceof BlockLeaves) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.o())) continue;
                    flag = this.dO().a(blockposition, true, this) || flag;
                }
                if (!flag && this.aF()) {
                    this.ff();
                }
            }
            if (this.cl > 0) {
                --this.cl;
                if (this.cl == 10) {
                    this.gw();
                }
            }
            if (this.cj > 0) {
                --this.cj;
            }
            if (this.ck > 0) {
                --this.ck;
                this.gv();
                if (this.ck == 0) {
                    this.a(SoundEffects.vk, 1.0f, 1.0f);
                    this.cl = 20;
                }
            }
        }
    }

    private void gv() {
        if (this.ah.a(6) == 0) {
            double d0 = this.dt() - (double)this.dj() * Math.sin(this.aY * ((float)Math.PI / 180)) + (this.ah.j() * 0.6 - 0.3);
            double d1 = this.dv() + (double)this.dk() - 0.3;
            double d2 = this.dz() + (double)this.dj() * Math.cos(this.aY * ((float)Math.PI / 180)) + (this.ah.j() * 0.6 - 0.3);
            this.dO().a(ColorParticleOption.a(Particles.u, 0.49803922f, 0.5137255f, 0.57254905f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean fc() {
        return super.fc() || this.cj > 0 || this.ck > 0 || this.cl > 0;
    }

    @Override
    public boolean F(Entity entity) {
        return this.ck <= 0 && this.cl <= 0 ? super.F(entity) : false;
    }

    @Override
    protected void e(EntityLiving entityliving) {
        if (this.cl == 0) {
            if (this.ah.j() < 0.5) {
                this.ck = 40;
                this.a(SoundEffects.vj, 1.0f, 1.0f);
                this.dO().a((Entity)this, (byte)39);
                entityliving.h(this);
            } else {
                this.c((Entity)entityliving);
            }
            entityliving.U = true;
        }
    }

    private void gw() {
        if (this.bE()) {
            List<Entity> list = this.dO().a(EntityLiving.class, this.cK().g(4.0), e);
            for (EntityLiving entityLiving : list) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.a(this.dP().b(this), 6.0f);
                }
                this.c((Entity)entityLiving);
            }
            Vec3D vec3d = this.cK().f();
            for (int i2 = 0; i2 < 40; ++i2) {
                double d0 = this.ah.k() * 0.2;
                double d1 = this.ah.k() * 0.2;
                double d2 = this.ah.k() * 0.2;
                this.dO().a(Particles.ab, vec3d.c, vec3d.d, vec3d.e, d0, d1, d2);
            }
            ((Entity)this).a(GameEvent.u);
        }
    }

    private void c(Entity entity) {
        double d0 = entity.dt() - this.dt();
        double d1 = entity.dz() - this.dz();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.j(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.cj = 10;
            this.a(SoundEffects.ve, 1.0f, 1.0f);
        } else if (b0 == 39) {
            this.ck = 40;
        }
        super.b(b0);
    }

    public int t() {
        return this.cj;
    }

    public int gk() {
        return this.ck;
    }

    public int gu() {
        return this.cl;
    }

    @Override
    public boolean D(Entity entity) {
        this.cj = 10;
        this.dO().a((Entity)this, (byte)4);
        this.a(SoundEffects.ve, 1.0f, 1.0f);
        return super.D(entity);
    }

    @Override
    @Nullable
    protected SoundEffect v() {
        return SoundEffects.vd;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.vh;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.vg;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.vi, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return !iworldreader.d(this.cK());
    }

    @Override
    public void a(WorldServer worldserver, int i2, boolean flag) {
    }

    @Override
    public boolean gl() {
        return false;
    }

    @Override
    protected AxisAlignedBB gc() {
        AxisAlignedBB axisalignedbb = super.gc();
        return axisalignedbb.f(0.05, 0.0, 0.05);
    }
}

