/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int b = 1;
    public static final int c = 127;
    public static final int d = 4;
    public float e;
    public float cb;
    public float cc;
    private boolean ce;

    public EntitySlime(EntityTypes<? extends EntitySlime> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
        this.cG();
        this.bT = new ControllerMoveSlime(this);
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bW.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bW.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bW.a(5, new PathfinderGoalSlimeIdle(this));
        this.bX.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.dv() - this.dv()) <= 4.0));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cd, 1);
    }

    @VisibleForTesting
    public void a(int i2, boolean flag) {
        int j2 = MathHelper.a(i2, 1, 127);
        this.ao.a(cd, j2);
        this.av();
        this.i_();
        this.f(GenericAttributes.s).a(j2 * j2);
        this.f(GenericAttributes.v).a(0.2f + 0.1f * (float)j2);
        this.f(GenericAttributes.c).a(j2);
        if (flag) {
            this.v(this.eN());
        }
        this.bR = j2;
    }

    public int gl() {
        return this.ao.a(cd);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Size", this.gl() - 1);
        nbttagcompound.a("wasOnGround", this.ce);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.a(nbttagcompound.h("Size") + 1, false);
        super.a(nbttagcompound);
        this.ce = nbttagcompound.q("wasOnGround");
    }

    public boolean gm() {
        return this.gl() <= 1;
    }

    protected ParticleParam t() {
        return Particles.U;
    }

    @Override
    protected boolean Z() {
        return this.gl() > 0;
    }

    @Override
    public void l() {
        this.cb += (this.e - this.cb) * 0.5f;
        this.cc = this.cb;
        super.l();
        if (this.aF() && !this.ce) {
            float f2 = this.a(this.at()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.ah.i() * ((float)Math.PI * 2);
                float f3 = this.ah.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a(f22) * f1 * f3;
                float f5 = MathHelper.b(f22) * f1 * f3;
                this.dO().a(this.t(), this.dt() + (double)f4, this.dv(), this.dz() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gj(), this.fa(), ((this.ah.i() - this.ah.i()) * 0.2f + 1.0f) / 0.8f);
            this.e = -0.5f;
        } else if (!this.aF() && this.ce) {
            this.e = 1.0f;
        }
        this.ce = this.aF();
        this.gg();
    }

    protected void gg() {
        this.e *= 0.6f;
    }

    protected int x() {
        return this.ah.a(20) + 10;
    }

    @Override
    public void i_() {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        super.i_();
        this.a_(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cd.equals(datawatcherobject)) {
            this.i_();
            this.t(this.ba);
            this.aY = this.ba;
            if (this.bf() && this.ah.a(20) == 0) {
                this.bo();
            }
        }
        super.a(datawatcherobject);
    }

    public EntityTypes<? extends EntitySlime> am() {
        return super.am();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i2 = this.gl();
        if (!this.dO().B && i2 > 1 && this.ex()) {
            IChatBaseComponent ichatbasecomponent = this.aj();
            boolean flag = this.fZ();
            float f2 = this.a(this.at()).a();
            float f1 = f2 / 2.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.ah.a(3);
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f22 = ((float)(l2 % 2) - 0.5f) * f1;
                float f3 = ((float)(l2 / 2) - 0.5f) * f1;
                EntitySlime entityslime = this.am().a(this.dO());
                if (entityslime == null) continue;
                if (this.fT()) {
                    entityslime.fR();
                }
                entityslime.b(ichatbasecomponent);
                entityslime.u(flag);
                entityslime.n(this.cv());
                entityslime.a(j2, true);
                entityslime.b(this.dt() + (double)f22, this.dv() + 0.5, this.dz() + (double)f3, this.ah.i() * 360.0f, 0.0f);
                slimes.add(entityslime);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.dO().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gh()) {
            this.j((EntityLiving)entity);
        }
    }

    @Override
    public void b_(EntityHuman entityhuman) {
        if (this.gh()) {
            this.j(entityhuman);
        }
    }

    protected void j(EntityLiving entityliving) {
        DamageSource damagesource;
        if (this.bE() && this.i(entityliving) && this.F(entityliving) && entityliving.a(damagesource = this.dP().b(this), this.gi())) {
            this.a(SoundEffects.xp, 1.0f, (this.ah.i() - this.ah.i()) * 0.2f + 1.0f);
            World world = this.dO();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, (Entity)entityliving, damagesource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return new Vec3D(0.0, (double)entitysize.b() - 0.015625 * (double)this.gl() * (double)f2, 0.0);
    }

    protected boolean gh() {
        return !this.gm() && this.db();
    }

    protected float gi() {
        return (float)this.g(GenericAttributes.c);
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return this.gm() ? SoundEffects.yg : SoundEffects.xr;
    }

    @Override
    protected SoundEffect n_() {
        return this.gm() ? SoundEffects.yf : SoundEffects.xq;
    }

    protected SoundEffect gj() {
        return this.gm() ? SoundEffects.yi : SoundEffects.xt;
    }

    public static boolean c(EntityTypes<EntitySlime> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        if (EnumMobSpawn.a(enummobspawn)) {
            return EntitySlime.a(entitytypes, generatoraccess, enummobspawn, blockposition, randomsource);
        }
        if (generatoraccess.al() != EnumDifficulty.a) {
            boolean flag;
            if (enummobspawn == EnumMobSpawn.c) {
                return EntitySlime.a(entitytypes, generatoraccess, enummobspawn, blockposition, randomsource);
            }
            if (generatoraccess.t(blockposition).a(BiomeTags.aq) && blockposition.v() > 50 && blockposition.v() < 70 && randomsource.i() < 0.5f && randomsource.i() < generatoraccess.aq() && generatoraccess.A(blockposition) <= randomsource.a(8)) {
                return EntitySlime.a(entitytypes, generatoraccess, enummobspawn, blockposition, randomsource);
            }
            if (!(generatoraccess instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
            boolean bl = flag = SeededRandom.a(chunkcoordintpair.e, chunkcoordintpair.f, ((GeneratorAccessSeed)generatoraccess).C(), generatoraccess.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            if (randomsource.a(10) == 0 && flag && blockposition.v() < 40) {
                return EntitySlime.a(entitytypes, generatoraccess, enummobspawn, blockposition, randomsource);
            }
        }
        return false;
    }

    @Override
    protected float fa() {
        return 0.4f * (float)this.gl();
    }

    @Override
    public int ac() {
        return 0;
    }

    protected boolean gn() {
        return this.gl() > 0;
    }

    @Override
    public void ff() {
        Vec3D vec3d = this.dr();
        this.n(vec3d.c, this.fd(), vec3d.e);
        this.av = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.E_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficultydamagescaler.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    float s() {
        float f2 = this.gm() ? 1.4f : 0.8f;
        return ((this.ah.i() - this.ah.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gk() {
        return this.gm() ? SoundEffects.yh : SoundEffects.xs;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return super.e(entitypose).a(this.gl());
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime entityslime) {
            super(entityslime);
            this.n = entityslime;
            this.l = 180.0f * entityslime.dE() / (float)Math.PI;
        }

        public void a(float f2, boolean flag) {
            this.l = f2;
            this.o = flag;
        }

        public void a(double d0) {
            this.h = d0;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.t(this.a(this.d.dE(), this.l, 90.0f));
            this.d.ba = this.d.dE();
            this.d.aY = this.d.dE();
            if (this.k != ControllerMove.Operation.b) {
                this.d.E(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aF()) {
                    this.d.A((float)(this.h * this.d.g(GenericAttributes.v)));
                    if (this.m-- <= 0) {
                        this.m = this.n.x();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.L().a();
                        if (this.n.gn()) {
                            this.n.a(this.n.gk(), this.n.fa(), this.n.s());
                        }
                    } else {
                        this.n.bo = 0.0f;
                        this.n.bq = 0.0f;
                        this.d.A(0.0f);
                    }
                } else {
                    this.d.A((float)(this.h * this.d.g(GenericAttributes.v)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            entityslime.N().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.bf() || this.a.bt()) && this.a.J() instanceof ControllerMoveSlime;
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (this.a.dR().i() < 0.8f) {
                this.a.L().a();
            }
            if ((controllermove = this.a.J()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.p();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : this.a.J() instanceof ControllerMoveSlime);
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = this.a.p();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : --this.b > 0);
        }

        @Override
        public boolean V_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.p();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.J()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dE(), this.a.gh());
            }
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.p() == null && (this.a.aF() || this.a.bf() || this.a.bt() || this.a.b(MobEffects.y)) && this.a.J() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.dR().a(60));
                this.b = this.a.dR().a(360);
            }
            if ((controllermove = this.a.J()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.bS();
        }

        @Override
        public void a() {
            ControllerMove controllermove = this.a.J();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

