/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntitySpider
extends EntityMonster {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySpider.class, DataWatcherRegistry.a);
    private static final float c = 0.1f;

    public EntitySpider(EntityTypes<? extends EntitySpider> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalFloat(this));
        this.bW.a(2, new PathfinderGoalAvoidTarget<Armadillo>(this, Armadillo.class, 6.0f, 1.0, 1.2, entityliving -> !((Armadillo)entityliving).t()));
        this.bW.a(3, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bW.a(4, new PathfinderGoalSpiderMeleeAttack(this));
        this.bW.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bW.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(6, new PathfinderGoalRandomLookaround(this));
        this.bX.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bX.a(2, new PathfinderGoalSpiderNearestAttackableTarget<EntityHuman>(this, EntityHuman.class));
        this.bX.a(3, new PathfinderGoalSpiderNearestAttackableTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationSpider(this, world);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(b, (byte)0);
    }

    @Override
    public void l() {
        super.l();
        if (!this.dO().B) {
            this.x(this.Q);
        }
    }

    public static AttributeProvider.Builder t() {
        return EntityMonster.gq().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.3f);
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.yL;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.yN;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.yM;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.yO, 0.15f, 1.0f);
    }

    @Override
    public boolean p_() {
        return this.x();
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
        if (!iblockdata.a(Blocks.bs)) {
            super.a(iblockdata, vec3d);
        }
    }

    @Override
    public boolean c(MobEffect mobeffect) {
        return mobeffect.a(MobEffects.s) ? false : super.c(mobeffect);
    }

    public boolean x() {
        return (this.ao.a(b) & 1) != 0;
    }

    public void x(boolean flag) {
        byte b0 = this.ao.a(b);
        b0 = flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.ao.a(b, b0);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        EntitySkeleton entityskeleton;
        GroupDataEntity object = super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
        RandomSource randomsource = worldaccess.E_();
        if (randomsource.a(100) == 0 && (entityskeleton = EntityTypes.aN.a(this.dO())) != null) {
            entityskeleton.b(this.dt(), this.dv(), this.dz(), this.dE(), 0.0f);
            entityskeleton.a(worldaccess, difficultydamagescaler, enummobspawn, (GroupDataEntity)null);
            entityskeleton.n(this);
        }
        if (object == null) {
            object = new GroupDataSpider();
            if (worldaccess.al() == EnumDifficulty.d && randomsource.i() < 0.1f * difficultydamagescaler.d()) {
                ((GroupDataSpider)object).a(randomsource);
            }
        }
        if (object instanceof GroupDataSpider) {
            GroupDataSpider entityspider_groupdataspider = (GroupDataSpider)object;
            Holder<MobEffectList> holder = entityspider_groupdataspider.a;
            if (holder != null) {
                this.addEffect(new MobEffect(holder, -1), EntityPotionEffectEvent.Cause.SPIDER_SPAWN);
            }
        }
        return object;
    }

    @Override
    public Vec3D l(Entity entity) {
        return entity.dj() <= this.dj() ? new Vec3D(0.0, 0.3125 * (double)this.eb(), 0.0) : super.l(entity);
    }

    private static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntitySpider entityspider) {
            super(entityspider, 1.0, true);
        }

        @Override
        public boolean b() {
            return super.b() && !this.a.bT();
        }

        @Override
        public boolean c() {
            float f2 = this.a.bu();
            if (f2 >= 0.5f && this.a.dR().a(100) == 0) {
                this.a.h((EntityLiving)null);
                return false;
            }
            return super.c();
        }
    }

    private static class PathfinderGoalSpiderNearestAttackableTarget<T extends EntityLiving>
    extends PathfinderGoalNearestAttackableTarget<T> {
        public PathfinderGoalSpiderNearestAttackableTarget(EntitySpider entityspider, Class<T> oclass) {
            super((EntityInsentient)entityspider, oclass, true);
        }

        @Override
        public boolean b() {
            float f2 = this.e.bu();
            return f2 >= 0.5f ? false : super.b();
        }
    }

    public static class GroupDataSpider
    implements GroupDataEntity {
        @Nullable
        public Holder<MobEffectList> a;

        public void a(RandomSource randomsource) {
            int i2 = randomsource.a(5);
            if (i2 <= 1) {
                this.a = MobEffects.a;
            } else if (i2 <= 2) {
                this.a = MobEffects.e;
            } else if (i2 <= 3) {
                this.a = MobEffects.j;
            } else if (i2 <= 4) {
                this.a = MobEffects.n;
            }
        }
    }
}

