/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey b = MinecraftKey.b("baby");
    private static final AttributeModifier c = new AttributeModifier(b, 0.5, AttributeModifier.Operation.b);
    private static final MinecraftKey d = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cf = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cg = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey ch = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> ci = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cj = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> ck = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float e = 0.05f;
    public static final int cc = 50;
    public static final int cd = 40;
    public static final int ce = 7;
    private static final EntitySize cl = EntityTypes.bu.n().a(0.5f).b(0.93f);
    private static final float cm = 0.1f;
    private static final Predicate<EnumDifficulty> cn = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private final PathfinderGoalBreakDoor co;
    private boolean cp;
    private int cq;
    public int cr;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.co = new PathfinderGoalBreakDoor(this, cn);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bu, world);
    }

    @Override
    protected void B() {
        this.bW.a(4, new a((EntityCreature)this, 1.0, 3));
        this.bW.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(8, new PathfinderGoalRandomLookaround(this));
        this.t();
    }

    protected void t() {
        this.bW.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bW.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gs));
        this.bW.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bX.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bX.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dO().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bX.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.cc));
    }

    public static AttributeProvider.Builder go() {
        return EntityMonster.gq().a(GenericAttributes.m, 35.0).a(GenericAttributes.v, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.A);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(ci, false);
        datawatcher_a.a(cj, 0);
        datawatcher_a.a(ck, false);
    }

    public boolean gr() {
        return this.ar().a(ck);
    }

    public boolean gs() {
        return this.cp;
    }

    public void y(boolean flag) {
        if (this.x() && PathfinderGoalUtil.a(this)) {
            if (this.cp != flag) {
                this.cp = flag;
                ((Navigation)this.N()).b(flag);
                if (flag) {
                    this.bW.a(1, this.co);
                } else {
                    this.bW.a(this.co);
                }
            }
        } else if (this.cp) {
            this.bW.a(this.co);
            this.cp = false;
        }
    }

    protected boolean x() {
        return true;
    }

    @Override
    public boolean o_() {
        return this.ar().a(ci);
    }

    @Override
    protected int eg() {
        if (this.o_()) {
            this.bR = (int)((double)this.bR * 2.5);
        }
        return super.eg();
    }

    @Override
    public void a(boolean flag) {
        this.ar().a(ci, flag);
        if (this.dO() != null && !this.dO().B) {
            AttributeModifiable attributemodifiable = this.f(GenericAttributes.v);
            attributemodifiable.c(b);
            if (flag) {
                attributemodifiable.b(c);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (ci.equals(datawatcherobject)) {
            this.i_();
        }
        super.a(datawatcherobject);
    }

    protected boolean gm() {
        return true;
    }

    @Override
    public void l() {
        if (!this.dO().B && this.bE() && !this.fZ()) {
            if (this.gr()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.cr -= elapsedTicks;
                if (this.cr < 0) {
                    this.ag_();
                }
            } else if (this.gm()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cq;
                    if (this.cq >= 600) {
                        this.b(300);
                    }
                } else {
                    this.cq = -1;
                }
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void m_() {
        if (this.bE()) {
            boolean flag;
            boolean bl = flag = this.ah_() && this.ge();
            if (flag) {
                ItemStack itemstack = this.a(EnumItemSlot.f);
                if (!itemstack.e()) {
                    if (itemstack.l()) {
                        Item item = itemstack.g();
                        itemstack.b(itemstack.n() + this.ah.a(2));
                        if (itemstack.n() >= itemstack.o()) {
                            this.a(item, EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.l);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.d(8.0f);
                }
            }
        }
        super.m_();
    }

    public void b(int i2) {
        this.lastTick = MinecraftServer.currentTick;
        this.cr = i2;
        this.ar().a(ck, true);
    }

    protected void ag_() {
        this.b(EntityTypes.B);
        if (!this.aX()) {
            this.dO().a((EntityHuman)null, 1040, this.do(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entitytypes) {
        EntityZombie entityzombie = this.convertTo(entitytypes, true, EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (entityzombie != null) {
            entityzombie.H(entityzombie.dO().d_(entityzombie.do()).d());
            entityzombie.y(entityzombie.x() && this.gs());
        } else {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    protected boolean ah_() {
        return true;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (!super.a(damagesource, f2)) {
            return false;
        }
        if (!(this.dO() instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)this.dO();
        EntityLiving entityliving = this.p();
        if (entityliving == null && damagesource.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)damagesource.d();
        }
        if (entityliving != null && this.dO().al() == EnumDifficulty.d && (double)this.ah.i() < this.g(GenericAttributes.A) && this.dO().ab().b(GameRules.e)) {
            int i2 = MathHelper.a(this.dt());
            int j2 = MathHelper.a(this.dv());
            int k2 = MathHelper.a(this.dz());
            EntityZombie entityzombie = new EntityZombie(this.dO());
            for (int l2 = 0; l2 < 50; ++l2) {
                int i1 = i2 + MathHelper.a(this.ah, 7, 40) * MathHelper.a(this.ah, -1, 1);
                int j1 = j2 + MathHelper.a(this.ah, 7, 40) * MathHelper.a(this.ah, -1, 1);
                int k1 = k2 + MathHelper.a(this.ah, 7, 40) * MathHelper.a(this.ah, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1, k1);
                EntityTypes<?> entitytypes = entityzombie.am();
                if (!EntityPositionTypes.a(entitytypes, this.dO(), blockposition) || !EntityPositionTypes.a(entitytypes, worldserver, EnumMobSpawn.j, blockposition, this.dO().z)) continue;
                entityzombie.a_(i1, j1, k1);
                if (this.dO().a((double)i1, (double)j1, (double)k1, 7.0) || !this.dO().f(entityzombie) || !this.dO().g(entityzombie) || this.dO().d(entityzombie.cK())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a((WorldAccess)worldserver, this.dO().d_(entityzombie.do()), EnumMobSpawn.j, (GroupDataEntity)null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attributemodifiable = this.f(GenericAttributes.A);
                AttributeModifier attributemodifier = attributemodifiable.a(d);
                double d0 = attributemodifier != null ? attributemodifier.c() : 0.0;
                attributemodifiable.c(d);
                attributemodifiable.d(new AttributeModifier(d, d0 - 0.05, AttributeModifier.Operation.a));
                entityzombie.f(GenericAttributes.A).d(cf);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean D(Entity entity) {
        boolean flag = super.D(entity);
        if (flag) {
            float f2 = this.dO().d_(this.do()).b();
            if (this.eT().e() && this.bR() && this.ah.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), (float)(2 * (int)f2));
                this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.Dt;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.DD;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.Dy;
    }

    protected SoundEffect gk() {
        return SoundEffects.DJ;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.gk(), 0.15f, 1.0f);
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        float f2 = randomsource.i();
        float f3 = this.dO().al() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = randomsource.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.pb));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.pc));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsBaby", this.o_());
        nbttagcompound.a("CanBreakDoors", this.gs());
        nbttagcompound.a("InWaterTime", this.bf() ? this.cq : -1);
        nbttagcompound.a("DrownedConversionTime", this.gr() ? this.cr : -1);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a(nbttagcompound.q("IsBaby"));
        this.y(nbttagcompound.q("CanBreakDoors"));
        this.cq = nbttagcompound.h("InWaterTime");
        if (nbttagcompound.b("DrownedConversionTime", 99) && nbttagcompound.h("DrownedConversionTime") > -1) {
            this.b(nbttagcompound.h("DrownedConversionTime"));
        }
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        boolean flag = super.a(worldserver, entityliving);
        if ((worldserver.al() == EnumDifficulty.c || worldserver.al() == EnumDifficulty.d) && entityliving instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityliving;
            if (worldserver.al() != EnumDifficulty.d && this.ah.h()) {
                return flag;
            }
            flag = EntityZombie.zombifyVillager(worldserver, entityvillager, this.do(), this.aX(), CreatureSpawnEvent.SpawnReason.INFECTION) == null;
        }
        return flag;
    }

    public static EntityZombieVillager zombifyVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.bw, false, EntityTransformEvent.TransformReason.INFECTION, spawnReason);
        if (entityzombievillager != null) {
            entityzombievillager.a((WorldAccess)worldserver, worldserver.d_(entityzombievillager.do()), EnumMobSpawn.i, new GroupDataZombie(false, true));
            entityzombievillager.a(entityvillager.gv());
            entityzombievillager.a(entityvillager.gF().a(DynamicOpsNBT.a));
            entityzombievillager.a(entityvillager.gm().a());
            entityzombievillager.b(entityvillager.t());
            if (!silent) {
                worldserver.a((EntityHuman)null, 1026, blockPosition, 0);
            }
        }
        return entityzombievillager;
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.o_() ? cl : super.e(entitypose);
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(Items.qR) && this.o_() && this.bS() ? false : super.j(itemstack);
    }

    @Override
    public boolean k(ItemStack itemstack) {
        return itemstack.a(Items.rg) ? false : super.k(itemstack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.E_();
        GroupDataEntity object = super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
        float f2 = difficultydamagescaler.d();
        this.a_(randomsource.i() < 0.55f * f2);
        if (object == null) {
            object = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (object instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)object;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = worldaccess.a(EntityChicken.class, this.cK().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.x(true);
                            this.n(entitychicken);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.t.a(this.dO())) != null) {
                        entitychicken1.b(this.dt(), this.dv(), this.dz(), this.dE(), 0.0f);
                        entitychicken1.a(worldaccess, difficultydamagescaler, EnumMobSpawn.g, (GroupDataEntity)null);
                        entitychicken1.x(true);
                        this.n(entitychicken1);
                        worldaccess.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.y(this.x() && randomsource.i() < f2 * 0.1f);
            this.a(randomsource, difficultydamagescaler);
            this.a(worldaccess, randomsource, difficultydamagescaler);
        }
        if (this.a(EnumItemSlot.f).e()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.ef : Blocks.ee));
                this.bZ[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        this.H(f2);
        return object;
    }

    public static boolean a(RandomSource randomsource) {
        return randomsource.i() < 0.05f;
    }

    protected void H(float f2) {
        this.gt();
        this.f(GenericAttributes.p).c(new AttributeModifier(bP, this.ah.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.ah.j() * 1.5 * (double)f2;
        if (d0 > 1.0) {
            this.f(GenericAttributes.m).c(new AttributeModifier(ch, d0, AttributeModifier.Operation.c));
        }
        if (this.ah.i() < f2 * 0.05f) {
            this.f(GenericAttributes.A).c(new AttributeModifier(cg, this.ah.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.f(GenericAttributes.s).c(new AttributeModifier(cg, this.ah.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(this.x());
        }
    }

    protected void gt() {
        this.f(GenericAttributes.A).a(this.ah.j() * (double)0.1f);
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(worldserver, damagesource, flag);
        Entity entity = damagesource.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gl() && !(itemstack = this.gl()).e()) {
            entitycreeper.gm();
            this.b(itemstack);
        }
    }

    protected ItemStack gl() {
        return new ItemStack(Items.uo);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature entitycreature, double d0, int i2) {
            super(Blocks.mf, entitycreature, d0, i2);
        }

        @Override
        public void a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            generatoraccess.a((EntityHuman)null, blockposition, SoundEffects.Dz, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ah.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition blockposition) {
            world.a((EntityHuman)null, blockposition, SoundEffects.Ai, SoundCategory.e, 0.7f, 0.9f + world.z.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean flag, boolean flag1) {
            this.a = flag;
            this.b = flag1;
        }
    }
}

