/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final Logger ce = LogUtils.getLogger();
    private static final int cf = 40;
    private static final int cg = 200;
    private static final int ch = 500;
    private static final float ci = 0.3f;
    private static final float cj = 1.0f;
    private static final float ck = 1.5f;
    private static final int cl = 30;
    private static final DataWatcherObject<Integer> cm = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int cn = 200;
    private static final int co = 260;
    private static final int cp = 20;
    private static final int cq = 120;
    private static final int cr = 20;
    private static final int cs = 35;
    private static final int ct = 10;
    private static final int cu = 20;
    private static final int cv = 100;
    private static final int cw = 20;
    private static final int cx = 30;
    private static final float cy = 4.5f;
    private static final float cz = 0.7f;
    private static final int cA = 30;
    private int cB;
    private int cD;
    private int cE;
    private int cF;
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState cc = new AnimationState();
    public AnimationState cd = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cG = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cH = new a();
    private VibrationSystem.a cI = new VibrationSystem.a();
    AngerManagement cJ = new AngerManagement(this::c, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> entitytypes, World world) {
        super(entitytypes, world);
        this.bR = 5;
        this.N().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (packetplayoutspawnentity.p() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return super.a(iworldreader) && iworldreader.a((Entity)this, this.am().n().a(this.dm()));
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return this.go() && !damagesource.a(DamageTypeTags.d) ? true : super.b(damagesource);
    }

    boolean go() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean fK() {
        return true;
    }

    @Override
    protected float aP() {
        return this.aa + 0.55f;
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gq().a(GenericAttributes.s, 500.0).a(GenericAttributes.v, 0.3f).a(GenericAttributes.p, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0);
    }

    @Override
    public boolean bd() {
        return true;
    }

    @Override
    protected float fa() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect v() {
        return !this.c(EntityPose.l) && !this.go() ? this.x().b() : null;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.BO;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.BK;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.BY, 10.0f, 1.0f);
    }

    @Override
    public boolean D(Entity entity) {
        this.dO().a((Entity)this, (byte)4);
        this.a(SoundEffects.BJ, 10.0f, this.fb());
        SonicBoom.a((EntityLiving)this, 40);
        return super.D(entity);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cm, 0);
    }

    public int t() {
        return this.ao.a(cm);
    }

    private void gr() {
        this.ao.a(cm, this.gu());
    }

    @Override
    public void l() {
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cI, this.cH);
            if (this.fT() || this.Y()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.l();
        if (this.dO().x_()) {
            if (this.ai % this.gs() == 0) {
                this.cE = 10;
                if (!this.aX()) {
                    this.dO().a(this.dt(), this.dv(), this.dz(), SoundEffects.BN, this.de(), 5.0f, this.fb(), false);
                }
            }
            this.cD = this.cB;
            if (this.cB > 0) {
                --this.cB;
            }
            this.cF = this.cE;
            if (this.cE > 0) {
                --this.cE;
            }
            switch (this.at()) {
                case n: {
                    this.a(this.d);
                    break;
                }
                case o: {
                    this.a(this.e);
                }
            }
        }
    }

    @Override
    protected void ab() {
        WorldServer worldserver = (WorldServer)this.dO();
        worldserver.ag().a("wardenBrain");
        this.dT().a(worldserver, this);
        this.dO().ag().c();
        super.ab();
        if ((this.ai + this.an()) % 120 == 0) {
            Warden.a(worldserver, this.dm(), this, 20);
        }
        if (this.ai % 20 == 0) {
            this.cJ.a(worldserver, this::c);
            this.gr();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.b.a();
            this.cc.a(this.ai);
        } else if (b0 == 61) {
            this.cB = 10;
        } else if (b0 == 62) {
            this.cd.a(this.ai);
        } else {
            super.b(b0);
        }
    }

    private int gs() {
        float f2 = (float)this.t() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float H(float f2) {
        return MathHelper.i(f2, this.cD, this.cB) / 10.0f;
    }

    public float I(float f2) {
        return MathHelper.i(f2, this.cF, this.cE) / 10.0f;
    }

    private void a(AnimationState animationstate) {
        if ((float)animationstate.b() < 4500.0f) {
            RandomSource randomsource = this.dR();
            IBlockData iblockdata = this.bq();
            if (iblockdata.l() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dt() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dv();
                    double d2 = this.dz() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.dO().a(new ParticleParamBlock(Particles.b, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (at.equals(datawatcherobject)) {
            switch (this.at()) {
                case n: {
                    this.d.a(this.ai);
                    break;
                }
                case o: {
                    this.e.a(this.ai);
                    break;
                }
                case l: {
                    this.b.a(this.ai);
                    break;
                }
                case m: {
                    this.c.a(this.ai);
                }
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.go();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> dT() {
        return super.dT();
    }

    @Override
    protected void aa() {
        super.aa();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            biconsumer.accept(this.cG, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean c(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.dO() == entity.dO() && IEntitySelector.e.test(entity) && !this.s(entity) && entityliving.am() != EntityTypes.d && entityliving.am() != EntityTypes.bm && !entityliving.cv() && !entityliving.ex() && this.dO().C_().a(entityliving.cK())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer worldserver, Vec3D vec3d, @Nullable Entity entity, int i2) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(worldserver, entity, vec3d, i2, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        RegistryOps<NBTBase> registryops = this.dQ().a(DynamicOpsNBT.a);
        AngerManagement.a(this::c).encodeStart(registryops, (Object)this.cJ).resultOrPartial(s2 -> ce.error("Failed to encode anger state for Warden: '{}'", s2)).ifPresent(nbtbase -> nbttagcompound.a("anger", (NBTBase)nbtbase));
        VibrationSystem.a.a.encodeStart(registryops, (Object)this.cI).resultOrPartial(s2 -> ce.error("Failed to encode vibration listener for Warden: '{}'", s2)).ifPresent(nbtbase -> nbttagcompound.a("listener", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        RegistryOps<NBTBase> registryops = this.dQ().a(DynamicOpsNBT.a);
        if (nbttagcompound.e("anger")) {
            AngerManagement.a(this::c).parse(registryops, (Object)nbttagcompound.c("anger")).resultOrPartial(s2 -> ce.error("Failed to parse anger state for Warden: '{}'", s2)).ifPresent(angermanagement -> {
                this.cJ = angermanagement;
            });
            this.gr();
        }
        if (nbttagcompound.b("listener", 10)) {
            VibrationSystem.a.a.parse(registryops, (Object)nbttagcompound.p("listener")).resultOrPartial(s2 -> ce.error("Failed to parse vibration listener for Warden: '{}'", s2)).ifPresent(vibrationsystem_a -> {
                this.cI = vibrationsystem_a;
            });
        }
    }

    private void gt() {
        if (!this.c(EntityPose.l)) {
            this.a(this.x().c(), 10.0f, this.fb());
        }
    }

    public AngerLevel x() {
        return AngerLevel.a(this.gu());
    }

    private int gu() {
        return this.cJ.b(this.p());
    }

    public void d(Entity entity) {
        this.cJ.a(entity);
    }

    public void e(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int i2, boolean flag) {
        if (!this.fZ() && this.c(entity)) {
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.p() instanceof EntityHuman);
            int j2 = this.cJ.a(entity, i2);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.dT().b(MemoryModuleType.o);
            }
            if (flag) {
                this.gt();
            }
        }
    }

    public Optional<EntityLiving> gk() {
        return this.x().d() ? this.cJ.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving p() {
        return this.P();
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        this.dT().a(MemoryModuleType.aE, Unit.a, 1200L);
        if (enummobspawn == EnumMobSpawn.k) {
            this.b(EntityPose.n);
            this.dT().a(MemoryModuleType.aC, Unit.a, WardenAi.a);
            this.a(SoundEffects.BG, 5.0f, 1.0f);
        }
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        boolean flag = super.a(damagesource, f2);
        if (!(this.dO().B || this.fZ() || this.go())) {
            Entity entity = damagesource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bF.c(MemoryModuleType.o).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (damagesource.b() || this.a((Entity)entityliving, 5.0)) {
                    this.j(entityliving);
                }
            }
        }
        return flag;
    }

    public void j(EntityLiving entityliving) {
        this.dT().b(MemoryModuleType.ay);
        this.dT().a(MemoryModuleType.o, entityliving);
        this.dT().b(MemoryModuleType.E);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        EntitySize entitysize = super.e(entitypose);
        return this.go() ? EntitySize.c(entitysize.a(), 1.0f) : entitysize;
    }

    @Override
    public boolean bB() {
        return !this.go() && super.bB();
    }

    @Override
    protected void E(Entity entity) {
        if (!this.fZ() && !this.dT().a(MemoryModuleType.aH)) {
            this.dT().a(MemoryModuleType.aH, Unit.a, 20L);
            this.e(entity);
            WardenAi.a(this, entity.do());
        }
        super.E(entity);
    }

    @VisibleForTesting
    public AngerManagement gl() {
        return this.cJ;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, this, world){

            @Override
            protected Pathfinder a(int i2) {
                this.o = new PathfinderNormal();
                this.o.a(true);
                return new Pathfinder(this, this.o, i2){

                    @Override
                    protected float a(PathPoint pathpoint, PathPoint pathpoint1) {
                        return pathpoint.b(pathpoint1);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gm() {
        return this.cI;
    }

    @Override
    public VibrationSystem.d gn() {
        return this.cH;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cL());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, GameEvent.a gameevent_a) {
            if (!(Warden.this.fZ() || Warden.this.ex() || Warden.this.dT().a(MemoryModuleType.aI) || Warden.this.go() || !worldserver.C_().a(blockposition))) {
                EntityLiving entityliving;
                Entity entity = gameevent_a.a();
                if (entity instanceof EntityLiving && !Warden.this.c((Entity)(entityliving = (EntityLiving)entity))) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, @Nullable Entity entity, @Nullable Entity entity1, float f2) {
            if (!Warden.this.ex()) {
                Warden.this.bF.a(MemoryModuleType.aI, Unit.a, 40L);
                worldserver.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.BZ, 5.0f, Warden.this.fb());
                BlockPosition blockposition1 = blockposition;
                if (entity1 != null) {
                    if (Warden.this.a(entity1, 30.0)) {
                        if (Warden.this.dT().a(MemoryModuleType.aA)) {
                            if (Warden.this.c(entity1)) {
                                blockposition1 = entity1.do();
                            }
                            Warden.this.e(entity1);
                        } else {
                            Warden.this.a(entity1, 10, true);
                        }
                    }
                    Warden.this.dT().a(MemoryModuleType.aA, Unit.a, 100L);
                } else {
                    Warden.this.e(entity);
                }
                if (!Warden.this.x().d()) {
                    Optional<EntityLiving> optional = Warden.this.cJ.a();
                    if (entity1 != null || optional.isEmpty() || optional.get() == entity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

