/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.slf4j.Logger;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private static final DataWatcherObject<Integer> ce = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    private static final Logger cf = LogUtils.getLogger();
    public static final int cc = 300;
    private static final int cg = 8;
    @Nullable
    private EntityHuman ch;
    @Nullable
    protected MerchantRecipeList cd;
    private final InventorySubcontainer ci = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    public int s() {
        return this.ao.a(ce);
    }

    public void s(int i2) {
        this.ao.a(ce, i2);
    }

    @Override
    public int t() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(ce, 0);
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman) {
        this.ch = entityhuman;
    }

    @Override
    @Nullable
    public EntityHuman gk() {
        return this.ch;
    }

    public boolean gl() {
        return this.ch != null;
    }

    @Override
    public MerchantRecipeList gm() {
        if (this.dO().B) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.cd == null) {
            this.cd = new MerchantRecipeList();
            this.gr();
        }
        return this.cd;
    }

    @Override
    public void a(@Nullable MerchantRecipeList merchantrecipelist) {
    }

    @Override
    public void t(int i2) {
    }

    @Override
    public void a(MerchantRecipe merchantrecipe) {
        merchantrecipe.l();
        this.bQ = -this.R();
        this.b(merchantrecipe);
        if (this.ch instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.ch, this, merchantrecipe.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gn() {
        return true;
    }

    @Override
    public void n(ItemStack itemstack) {
        if (!this.dO().B && this.bQ > -this.R() + 20) {
            this.bQ = -this.R();
            this.b(this.x(!itemstack.e()));
        }
    }

    @Override
    public SoundEffect go() {
        return SoundEffects.AY;
    }

    protected SoundEffect x(boolean flag) {
        return flag ? SoundEffects.AY : SoundEffects.AW;
    }

    public void gp() {
        this.b(SoundEffects.AT);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        MerchantRecipeList merchantrecipelist;
        super.b(nbttagcompound);
        if (!this.dO().B && !(merchantrecipelist = this.gm()).isEmpty()) {
            nbttagcompound.a("Offers", (NBTBase)MerchantRecipeList.a.encodeStart(this.dQ().a(DynamicOpsNBT.a), (Object)merchantrecipelist).getOrThrow());
        }
        this.b(nbttagcompound, this.dQ());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.e("Offers")) {
            DataResult dataresult = MerchantRecipeList.a.parse(this.dQ().a(DynamicOpsNBT.a), (Object)nbttagcompound.c("Offers"));
            Logger logger = cf;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.a("Failed to load offers: ", arg_0 -> ((Logger)logger).warn(arg_0))).ifPresent(merchantrecipelist -> {
                this.cd = merchantrecipelist;
            });
        }
        this.a(nbttagcompound, this.dQ());
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition dimensiontransition) {
        this.gq();
        return super.a(dimensiontransition);
    }

    protected void gq() {
        this.a((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damagesource) {
        super.a(damagesource);
        this.gq();
    }

    protected void a(ParticleParam particleparam) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ah.k() * 0.02;
            double d1 = this.ah.k() * 0.02;
            double d2 = this.ah.k() * 0.02;
            this.dO().a(particleparam, this.d(1.0), this.dw() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean y() {
        return false;
    }

    @Override
    public InventorySubcontainer x() {
        return this.ci;
    }

    @Override
    public SlotAccess a_(int i2) {
        int j2 = i2 - 300;
        return j2 >= 0 && j2 < this.ci.b() ? SlotAccess.a(this.ci, j2) : super.a_(i2);
    }

    protected abstract void gr();

    protected void a(MerchantRecipeList merchantrecipelist, VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption, int i2) {
        ArrayList arraylist = Lists.newArrayList((Object[])avillagertrades_imerchantrecipeoption);
        int j2 = 0;
        while (j2 < i2 && !arraylist.isEmpty()) {
            MerchantRecipe merchantrecipe = ((VillagerTrades.IMerchantRecipeOption)arraylist.remove(this.ah.a(arraylist.size()))).a(this, this.ah);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                merchantrecipelist.add(CraftMerchantRecipe.fromBukkit(event.getRecipe()).toMinecraft());
            }
            ++j2;
        }
    }

    @Override
    public Vec3D s(float f2) {
        float f1 = MathHelper.i(f2, this.aZ, this.aY) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cK().c() - 1.0, 0.2);
        return this.m(f2).e(vec3d.b(-f1));
    }

    @Override
    public boolean gs() {
        return this.dO().B;
    }
}

