/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftItem;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double f = 2.0;
    private static final DataWatcherObject<Byte> g = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> h = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final int i = 1;
    private static final int j = 2;
    @Nullable
    private IBlockData k;
    public boolean b;
    protected int c;
    public PickupStatus d = PickupStatus.a;
    public int e;
    public int l;
    private double m = 2.0;
    private SoundEffect n = this.t();
    @Nullable
    private IntOpenHashSet o;
    @Nullable
    private List<Entity> p;
    public ItemStack q = this.x();
    @Nullable
    public ItemStack r = null;

    @Override
    public void inactiveTick() {
        if (this.b) {
            ++this.l;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, d0, d1, d2, world, itemstack, itemstack1, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, double d0, double d1, double d2, World world, ItemStack itemstack, @Nullable ItemStack itemstack1, @Nullable EntityLiving ownerEntity) {
        this(entitytypes, world);
        this.c(ownerEntity);
        this.q = itemstack.s();
        this.b(itemstack.a(DataComponents.g));
        Unit unit = itemstack.c(DataComponents.u);
        if (unit != null) {
            this.d = PickupStatus.c;
        }
        this.a_(d0, d1, d2);
        if (itemstack1 != null && world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack1.e()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.r = itemstack1.s();
            int i2 = EnchantmentManager.a(worldserver, itemstack1, this.q);
            if (i2 > 0) {
                this.a((byte)i2);
            }
            EnchantmentManager.a(worldserver, itemstack1, this, item -> {
                this.r = null;
            });
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> entitytypes, EntityLiving entityliving, World world, ItemStack itemstack, @Nullable ItemStack itemstack1) {
        this(entitytypes, entityliving.dt(), entityliving.dx() - (double)0.1f, entityliving.dz(), world, itemstack, itemstack1, entityliving);
    }

    public void b(SoundEffect soundeffect) {
        this.n = soundeffect;
    }

    @Override
    public boolean a(double d0) {
        double d1 = this.cK().a() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * EntityArrow.cD()) * d1;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(g, (byte)0);
        datawatcher_a.a(h, (byte)0);
    }

    @Override
    public void c(double d0, double d1, double d2, float f2, float f1) {
        super.c(d0, d1, d2, f2, f1);
        this.l = 0;
    }

    @Override
    public void a(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.a_(d0, d1, d2);
        this.a(f2, f1);
    }

    @Override
    public void l(double d0, double d1, double d2) {
        super.l(d0, d1, d2);
        this.l = 0;
    }

    @Override
    public void l() {
        Vec3D vec3d1;
        VoxelShape voxelshape;
        super.l();
        boolean flag = this.E();
        Vec3D vec3d = this.dr();
        if (this.P == 0.0f && this.O == 0.0f) {
            double d0 = vec3d.h();
            this.t((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
            this.u((float)(MathHelper.d(vec3d.d, d0) * 57.2957763671875));
            this.O = this.dE();
            this.P = this.dG();
        }
        BlockPosition blockposition = this.do();
        IBlockData iblockdata = this.dO().a_(blockposition);
        if (!(iblockdata.i() || flag || (voxelshape = iblockdata.k(this.dO(), blockposition)).c())) {
            vec3d1 = this.dm();
            for (AxisAlignedBB axisalignedbb : voxelshape.e()) {
                if (!axisalignedbb.a(blockposition).d(vec3d1)) continue;
                this.b = true;
                break;
            }
        }
        if (this.e > 0) {
            --this.e;
        }
        if (this.bg() || iblockdata.a(Blocks.qP)) {
            this.aD();
        }
        if (this.b && !flag) {
            if (this.k != iblockdata && this.F()) {
                this.J();
            } else if (!this.dO().B) {
                this.p();
            }
            ++this.c;
        } else {
            this.c = 0;
            Vec3D vec3d2 = this.dm();
            vec3d1 = vec3d2.e(vec3d);
            MovingObjectPosition object = this.dO().a(new RayTrace(vec3d2, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
            if (((MovingObjectPosition)object).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                vec3d1 = ((MovingObjectPosition)object).e();
            }
            while (!this.dJ()) {
                MovingObjectPositionEntity movingobjectpositionentity = this.a(vec3d2, vec3d1);
                if (movingobjectpositionentity != null) {
                    object = movingobjectpositionentity;
                }
                if (object != null && ((MovingObjectPosition)object).c() == MovingObjectPosition.EnumMovingObjectType.c) {
                    Entity entity = ((MovingObjectPositionEntity)object).a();
                    Entity entity1 = this.s();
                    if (entity instanceof EntityHuman && entity1 instanceof EntityHuman && !((EntityHuman)entity1).a((EntityHuman)entity)) {
                        object = null;
                        movingobjectpositionentity = null;
                    }
                }
                if (object != null && !flag) {
                    ProjectileDeflection projectiledeflection = this.preHitTargetOrDeflectSelf(object);
                    this.av = true;
                    if (projectiledeflection != ProjectileDeflection.a) break;
                }
                if (movingobjectpositionentity == null || this.C() <= 0) break;
                object = null;
            }
            vec3d = this.dr();
            double d1 = vec3d.c;
            double d2 = vec3d.d;
            double d3 = vec3d.e;
            if (this.A()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.dO().a(Particles.f, this.dt() + d1 * (double)i2 / 4.0, this.dv() + d2 * (double)i2 / 4.0, this.dz() + d3 * (double)i2 / 4.0, -d1, -d2 + 0.2, -d3);
                }
            }
            double d4 = this.dt() + d1;
            double d5 = this.dv() + d2;
            double d6 = this.dz() + d3;
            double d7 = vec3d.h();
            if (flag) {
                this.t((float)(MathHelper.d(-d1, -d3) * 57.2957763671875));
            } else {
                this.t((float)(MathHelper.d(d1, d3) * 57.2957763671875));
            }
            this.u((float)(MathHelper.d(d2, d7) * 57.2957763671875));
            this.u(EntityArrow.e(this.P, this.dG()));
            this.t(EntityArrow.e(this.O, this.dE()));
            float f2 = 0.99f;
            if (this.bf()) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    float f1 = 0.25f;
                    this.dO().a(Particles.d, d4 - d1 * 0.25, d5 - d2 * 0.25, d6 - d3 * 0.25, d1, d2, d3);
                }
                f2 = this.D();
            }
            this.i(vec3d.a((double)f2));
            if (!flag) {
                this.bb();
            }
            this.a_(d4, d5, d6);
            this.aT();
        }
    }

    @Override
    protected double aZ() {
        return 0.05;
    }

    private boolean F() {
        return this.b && this.dO().b(new AxisAlignedBB(this.dm(), this.dm()).g(0.06));
    }

    private void J() {
        this.b = false;
        Vec3D vec3d = this.dr();
        this.i(vec3d.d(this.ah.i() * 0.2f, this.ah.i() * 0.2f, this.ah.i() * 0.2f));
        this.l = 0;
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        super.a(enummovetype, vec3d);
        if (enummovetype != EnumMoveType.a && this.F()) {
            this.J();
        }
    }

    protected void p() {
        ++this.l;
        if (this.l >= (this instanceof EntityThrownTrident ? this.dO().spigotConfig.tridentDespawnRate : this.dO().spigotConfig.arrowDespawnRate)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void K() {
        if (this.p != null) {
            this.p.clear();
        }
        if (this.o != null) {
            this.o.clear();
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        World world;
        super.a(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.a();
        float f2 = (float)this.dr().f();
        double d0 = this.m;
        Entity entity1 = this.s();
        DamageSource damagesource = this.dP().a(this, entity1 != null ? entity1 : this);
        if (this.dS() != null && (world = this.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            d0 = EnchantmentManager.a(worldserver, this.dS(), entity, damagesource, (float)d0);
        }
        int i2 = MathHelper.c(MathHelper.a((double)f2 * d0, 0.0, 2.147483647E9));
        if (this.C() > 0) {
            if (this.o == null) {
                this.o = new IntOpenHashSet(5);
            }
            if (this.p == null) {
                this.p = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.o.size() >= this.C() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.o.add(entity.an());
        }
        if (this.A()) {
            long j2 = this.ah.a(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if (entity1 instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity1;
            entityliving.A(entity);
        }
        boolean flag = entity.am() == EntityTypes.H;
        int k2 = entity.aC();
        if (this.bR() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.igniteForSeconds(combustEvent.getDuration(), false);
            }
        }
        if (entity.a(damagesource, (float)i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                if (!this.dO().B && this.C() <= 0) {
                    entityliving1.p(entityliving1.eP() + 1);
                }
                this.a(entityliving1, damagesource);
                World world1 = this.dO();
                if (world1 instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world1;
                    EnchantmentManager.a(worldserver1, (Entity)entityliving1, damagesource, this.dS());
                }
                this.a(entityliving1);
                if (entityliving1 != entity1 && entityliving1 instanceof EntityHuman && entity1 instanceof EntityPlayer && !this.aX()) {
                    ((EntityPlayer)entity1).c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                }
                if (!entity.bE() && this.p != null) {
                    this.p.add(entityliving1);
                }
                if (!this.dO().B && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (this.p != null && this.B()) {
                        CriterionTriggers.H.a(entityplayer, this.p);
                    } else if (!entity.bE() && this.B()) {
                        CriterionTriggers.H.a(entityplayer, Arrays.asList(entity));
                    }
                }
            }
            this.a(this.n, 1.0f, 1.2f / (this.ah.i() * 0.2f + 0.9f));
            if (this.C() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(k2);
            this.a(ProjectileDeflection.b, entity, this.s(), false);
            this.i(this.dr().a(0.2));
            if (!this.dO().B && this.dr().g() < 1.0E-7) {
                if (this.d == PickupStatus.b) {
                    this.a(this.w(), 0.1f);
                }
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        }
    }

    protected void a(EntityLiving entityliving, DamageSource damagesource) {
        float f2;
        World world;
        if (this.r != null && (world = this.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f2 = EnchantmentManager.d(worldserver, this.r, entityliving, damagesource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d0 = f2;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - entityliving.g(GenericAttributes.p));
            Vec3D vec3d = this.dr().d(1.0, 0.0, 1.0).d().a(d0 * 0.6 * d1);
            if (vec3d.g() > 0.0) {
                entityliving.j(vec3d.c, 0.1, vec3d.e);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        this.k = this.dO().a_(movingobjectpositionblock.a());
        super.a(movingobjectpositionblock);
        Vec3D vec3d = movingobjectpositionblock.e().a(this.dt(), this.dv(), this.dz());
        this.i(vec3d);
        ItemStack itemstack = this.dS();
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (itemstack != null) {
                this.a(worldserver, movingobjectpositionblock, itemstack);
            }
        }
        Vec3D vec3d1 = vec3d.d().a((double)0.05f);
        this.o(this.dt() - vec3d1.c, this.dv() - vec3d1.d, this.dz() - vec3d1.e);
        this.a(this.v(), 1.0f, 1.2f / (this.ah.i() * 0.2f + 0.9f));
        this.b = true;
        this.e = 7;
        this.a(false);
        this.a((byte)0);
        this.b(SoundEffects.aE);
        this.K();
    }

    protected void a(WorldServer worldserver, MovingObjectPositionBlock movingobjectpositionblock, ItemStack itemstack) {
        EntityLiving entityliving1;
        Vec3D vec3d = movingobjectpositionblock.a().a(movingobjectpositionblock.e());
        Entity entity = this.s();
        EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
        EnchantmentManager.a(worldserver, itemstack, entityliving, this, (EnumItemSlot)null, vec3d, worldserver.a_(movingobjectpositionblock.a()), item -> {
            this.r = null;
        });
    }

    @Override
    public ItemStack dS() {
        return this.r;
    }

    protected SoundEffect t() {
        return SoundEffects.aE;
    }

    protected final SoundEffect v() {
        return this.n;
    }

    protected void a(EntityLiving entityliving) {
    }

    @Nullable
    protected MovingObjectPositionEntity a(Vec3D vec3d, Vec3D vec3d1) {
        return ProjectileHelper.a(this.dO(), this, vec3d, vec3d1, this.cK().b(this.dr()).g(1.0), this::b);
    }

    @Override
    protected boolean b(Entity entity) {
        return super.b(entity) && (this.o == null || !this.o.contains(entity.an()));
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("life", (short)this.l);
        if (this.k != null) {
            nbttagcompound.a("inBlockState", GameProfileSerializer.a(this.k));
        }
        nbttagcompound.a("shake", (byte)this.e);
        nbttagcompound.a("inGround", this.b);
        nbttagcompound.a("pickup", (byte)this.d.ordinal());
        nbttagcompound.a("damage", this.m);
        nbttagcompound.a("crit", this.A());
        nbttagcompound.a("PierceLevel", this.C());
        nbttagcompound.a("SoundEvent", BuiltInRegistries.b.b(this.n).toString());
        nbttagcompound.a("item", this.q.a(this.dQ()));
        if (this.r != null) {
            nbttagcompound.a("weapon", this.r.b(this.dQ(), new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.l = nbttagcompound.g("life");
        if (nbttagcompound.b("inBlockState", 10)) {
            this.k = GameProfileSerializer.a(this.dO().a(Registries.f), nbttagcompound.p("inBlockState"));
        }
        this.e = nbttagcompound.f("shake") & 0xFF;
        this.b = nbttagcompound.q("inGround");
        if (nbttagcompound.b("damage", 99)) {
            this.m = nbttagcompound.k("damage");
        }
        this.d = PickupStatus.a(nbttagcompound.f("pickup"));
        this.a(nbttagcompound.q("crit"));
        this.a(nbttagcompound.f("PierceLevel"));
        if (nbttagcompound.b("SoundEvent", 8)) {
            this.n = BuiltInRegistries.b.b(MinecraftKey.a(nbttagcompound.l("SoundEvent"))).orElse(this.t());
        }
        if (nbttagcompound.b("item", 10)) {
            this.a(ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound.p("item")).orElse(this.x()));
        } else {
            this.a(this.x());
        }
        this.r = nbttagcompound.b("weapon", 10) ? (ItemStack)ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound.p("weapon")).orElse(null) : null;
    }

    @Override
    public void c(@Nullable Entity entity) {
        super.c(entity);
        Entity entity1 = entity;
        boolean b0 = false;
        PickupStatus entityarrow_pickupstatus = this.d;
        Entity entity2 = entity1;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
            case 0: {
                EntityHuman entityhuman = (EntityHuman)entity2;
                if (this.d != PickupStatus.a) {
                    b0 = true;
                    break;
                }
                entityarrow_pickupstatus = PickupStatus.b;
                break;
            }
            case 1: {
                OminousItemSpawner ominousitemspawner = (OminousItemSpawner)entity2;
                entityarrow_pickupstatus = PickupStatus.a;
                break;
            }
            default: {
                entityarrow_pickupstatus = this.d;
                break;
            }
        }
        this.d = entityarrow_pickupstatus;
    }

    @Override
    public void b_(EntityHuman entityhuman) {
        if (!this.dO().B && (this.b || this.E()) && this.e <= 0) {
            ItemStack itemstack = this.w();
            if (this.d == PickupStatus.b && !itemstack.e() && entityhuman.fY().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.dO(), this.dt(), this.dv(), this.dz(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entityhuman.getBukkitEntity(), (Item)new CraftItem(this.dO().getCraftServer(), item), (AbstractArrow)this.getBukkitEntity());
                this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.p();
            }
            if (this.d == PickupStatus.b && entityhuman.fY().f(itemstack) || this.d == PickupStatus.c && entityhuman.fZ().d) {
                entityhuman.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman entityhuman) {
        return switch (this.d.ordinal()) {
            case 0 -> false;
            case 1 -> entityhuman.fY().f(this.w());
            case 2 -> entityhuman.fL();
            default -> throw new MatchException(null, null);
        };
    }

    protected ItemStack w() {
        return this.q.s();
    }

    protected abstract ItemStack x();

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    public ItemStack y() {
        return this.q;
    }

    public void h(double d0) {
        this.m = d0;
    }

    public double z() {
        return this.m;
    }

    @Override
    public boolean cu() {
        return this.am().a(TagsEntity.H);
    }

    public void a(boolean flag) {
        this.a(1, flag);
    }

    public void a(byte b0) {
        this.ao.a(h, b0);
    }

    private void a(int i2, boolean flag) {
        byte b0 = this.ao.a(g);
        if (flag) {
            this.ao.a(g, (byte)(b0 | i2));
        } else {
            this.ao.a(g, (byte)(b0 & ~i2));
        }
    }

    protected void a(ItemStack itemstack) {
        this.q = !itemstack.e() ? itemstack : this.x();
    }

    public boolean A() {
        byte b0 = this.ao.a(g);
        return (b0 & 1) != 0;
    }

    public boolean B() {
        return this.r != null && this.r.a(Items.vW);
    }

    public byte C() {
        return this.ao.a(h);
    }

    public void a(float f2) {
        this.h((double)(f2 * 2.0f) + this.ah.a((double)this.dO().al().a() * 0.11, 0.57425));
    }

    protected float D() {
        return 0.6f;
    }

    public void b(boolean flag) {
        this.ag = flag;
        this.a(2, flag);
    }

    public boolean E() {
        return !this.dO().B ? this.ag : (this.ao.a(g) & 2) != 0;
    }

    @Override
    public boolean bA() {
        return super.bA() && !this.b;
    }

    @Override
    public SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::y, this::a) : super.a_(i2);
    }

    public static enum PickupStatus {
        a,
        b,
        c;


        public static PickupStatus a(int i2) {
            if (i2 < 0 || i2 > PickupStatus.values().length) {
                i2 = 0;
            }
            return PickupStatus.values()[i2];
        }
    }
}

