/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class EntityPotion
extends EntityProjectileThrowable
implements ItemSupplier {
    public static final double b = 4.0;
    private static final double d = 16.0;
    public static final Predicate<EntityLiving> c = entityliving -> entityliving.fl() || entityliving.bR();

    public EntityPotion(EntityTypes<? extends EntityPotion> entitytypes, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entitytypes, world);
    }

    public EntityPotion(World world, EntityLiving entityliving) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aE, entityliving, world);
    }

    public EntityPotion(World world, double d0, double d1, double d2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aE, d0, d1, d2, world);
    }

    @Override
    protected Item t() {
        return Items.vo;
    }

    @Override
    protected double aZ() {
        return 0.05;
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        if (!this.dO().B) {
            ItemStack itemstack = this.p();
            EnumDirection enumdirection = movingobjectpositionblock.b();
            BlockPosition blockposition = movingobjectpositionblock.a();
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            PotionContents potioncontents = itemstack.a(DataComponents.G, PotionContents.a);
            if (potioncontents.a(Potions.a)) {
                this.a(blockposition1);
                this.a(blockposition1.a(enumdirection.g()));
                for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
                    this.a(blockposition1.a(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition movingobjectposition) {
        super.a(movingobjectposition);
        if (!this.dO().B) {
            ItemStack itemstack = this.p();
            PotionContents potioncontents = itemstack.a(DataComponents.G, PotionContents.a);
            if (potioncontents.a(Potions.a)) {
                this.v();
            } else if (this.w()) {
                this.makeAreaOfEffectCloud(potioncontents, movingobjectposition);
            } else {
                this.applySplash(potioncontents.a(), movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.c ? ((MovingObjectPositionEntity)movingobjectposition).a() : null, movingobjectposition);
            }
            int i2 = potioncontents.e().isPresent() && potioncontents.e().get().a().b() ? 2007 : 2002;
            this.dO().c(i2, this.do(), potioncontents.b());
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private void v() {
        AxisAlignedBB axisalignedbb = this.cK().c(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.dO().a(EntityLiving.class, axisalignedbb, c);
        for (EntityLiving entityliving : list) {
            double d0 = this.g(entityliving);
            if (!(d0 < 16.0)) continue;
            if (entityliving.fl()) {
                entityliving.a(this.dP().c((Entity)this, this.s()), 1.0f);
            }
            if (!entityliving.bR() || !entityliving.bE()) continue;
            entityliving.aI();
        }
        List<Axolotl> list1 = this.dO().a(Axolotl.class, axisalignedbb);
        for (Axolotl axolotl : list1) {
            axolotl.s();
        }
    }

    private void applySplash(Iterable<MobEffect> iterable, @Nullable Entity entity, MovingObjectPosition position) {
        PotionSplashEvent event;
        double d1;
        AxisAlignedBB axisalignedbb = this.cK().c(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.dO().a(EntityLiving.class, axisalignedbb);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list.isEmpty()) {
            Entity entity1 = this.H();
            for (EntityLiving entityliving : list) {
                double d0;
                if (!entityliving.fC() || !((d0 = this.g(entityliving)) < 16.0)) continue;
                d1 = entityliving == entity ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, position, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.H();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                EntityLiving entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffect mobeffect : iterable) {
                    MobEffectList mobeffectlist;
                    Holder<MobEffectList> holder = mobeffect.c();
                    if (!this.dO().pvpMode && this.s() instanceof EntityPlayer && entityliving instanceof EntityPlayer && entityliving != this.s() && ((mobeffectlist = holder.a()) == MobEffects.b || mobeffectlist == MobEffects.d || mobeffectlist == MobEffects.g || mobeffectlist == MobEffects.o || mobeffectlist == MobEffects.q || mobeffectlist == MobEffects.r || mobeffectlist == MobEffects.s)) continue;
                    if (holder.a().a()) {
                        holder.a().a(this, this.s(), entityliving, mobeffect.e(), d1);
                        continue;
                    }
                    int i2 = mobeffect.a(j2 -> (int)(d1 * (double)j2 + 0.5));
                    MobEffect mobeffect1 = new MobEffect(holder, i2, mobeffect.e(), mobeffect.f(), mobeffect.g());
                    if (mobeffect1.a(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents potioncontents, MovingObjectPosition position) {
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dO(), this.dt(), this.dv(), this.dz());
        Entity entity = this.s();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            entityareaeffectcloud.a(entityliving);
        }
        entityareaeffectcloud.a(3.0f);
        entityareaeffectcloud.b(-0.5f);
        entityareaeffectcloud.c(10);
        entityareaeffectcloud.c(-entityareaeffectcloud.g() / (float)entityareaeffectcloud.j());
        entityareaeffectcloud.a(potioncontents);
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, position, entityareaeffectcloud);
        if (!event.isCancelled() && !entityareaeffectcloud.dJ()) {
            this.dO().b(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.discard(null);
        }
    }

    public boolean w() {
        return this.p().a(Items.vr);
    }

    private void a(BlockPosition blockposition) {
        IBlockData iblockdata = this.dO().a_(blockposition);
        if (iblockdata.a(TagsBlock.aL)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.o())) {
                this.dO().a(blockposition, false, this);
            }
        } else if (AbstractCandleBlock.c(iblockdata)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (IBlockData)iblockdata.a(AbstractCandleBlock.b, false))) {
                AbstractCandleBlock.a((EntityHuman)null, iblockdata, (GeneratorAccess)this.dO(), blockposition);
            }
        } else if (BlockCampfire.g(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (IBlockData)iblockdata.a(BlockCampfire.c, false))) {
            this.dO().a((EntityHuman)null, 1009, blockposition, 0);
            BlockCampfire.a(this.s(), (GeneratorAccess)this.dO(), blockposition, iblockdata);
            this.dO().b(blockposition, (IBlockData)iblockdata.a(BlockCampfire.c, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = entityliving.dm().c - this.dm().c;
        double d1 = entityliving.dm().e - this.dm().e;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

