/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    @Nullable
    private UUID b;
    @Nullable
    private Entity c;
    private boolean d;
    private boolean e;
    @Nullable
    private Entity f;
    private boolean hitCancelled = false;

    IProjectile(EntityTypes<? extends IProjectile> entitytypes, World world) {
        super(entitytypes, world);
    }

    public void c(@Nullable Entity entity) {
        if (entity != null) {
            this.b = entity.cz();
            this.c = entity;
        }
        this.projectileSource = entity != null && entity.getBukkitEntity() instanceof ProjectileSource ? (ProjectileSource)entity.getBukkitEntity() : null;
    }

    @Override
    @Nullable
    public Entity s() {
        World world;
        if (this.c != null && !this.c.dJ()) {
            return this.c;
        }
        if (this.b != null && (world = this.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.c = worldserver.a(this.b);
            return this.c;
        }
        return null;
    }

    public Entity H() {
        return (Entity)MoreObjects.firstNonNull((Object)this.s(), (Object)this);
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        if (this.b != null) {
            nbttagcompound.a("Owner", this.b);
        }
        if (this.d) {
            nbttagcompound.a("LeftOwner", true);
        }
        nbttagcompound.a("HasBeenShot", this.e);
    }

    protected boolean e(Entity entity) {
        return entity.cz().equals(this.b);
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.b("Owner")) {
            this.b = nbttagcompound.a("Owner");
            this.c = null;
        }
        this.d = nbttagcompound.q("LeftOwner");
        this.e = nbttagcompound.q("HasBeenShot");
    }

    @Override
    public void w(Entity entity) {
        super.w(entity);
        if (entity instanceof IProjectile) {
            IProjectile iprojectile = (IProjectile)entity;
            this.c = iprojectile.c;
        }
    }

    @Override
    public void l() {
        if (!this.e) {
            this.a(GameEvent.K, this.s());
            this.e = true;
        }
        if (!this.d) {
            this.d = this.t();
        }
        super.l();
    }

    private boolean t() {
        Entity entity = this.s();
        if (entity != null) {
            for (Entity entity12 : this.dO().a((Entity)this, this.cK().b(this.dr()).g(1.0), (? super Entity entity1) -> !entity1.R_() && entity1.bA())) {
                if (entity12.cZ() != entity.cZ()) continue;
                return false;
            }
        }
        return true;
    }

    public Vec3D d(double d0, double d1, double d2, float f2, float f1) {
        return new Vec3D(d0, d1, d2).d().b(this.ah.a(0.0, 0.0172275 * (double)f1), this.ah.a(0.0, 0.0172275 * (double)f1), this.ah.a(0.0, 0.0172275 * (double)f1)).a((double)f2);
    }

    public void c(double d0, double d1, double d2, float f2, float f1) {
        Vec3D vec3d = this.d(d0, d1, d2, f2, f1);
        this.i(vec3d);
        this.av = true;
        double d3 = vec3d.h();
        this.t((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
        this.u((float)(MathHelper.d(vec3d.d, d3) * 57.2957763671875));
        this.O = this.dE();
        this.P = this.dG();
    }

    public void a(Entity entity, float f2, float f1, float f22, float f3, float f4) {
        float f5 = -MathHelper.a(f1 * ((float)Math.PI / 180)) * MathHelper.b(f2 * ((float)Math.PI / 180));
        float f6 = -MathHelper.a((f2 + f22) * ((float)Math.PI / 180));
        float f7 = MathHelper.b(f1 * ((float)Math.PI / 180)) * MathHelper.b(f2 * ((float)Math.PI / 180));
        this.c(f5, f6, f7, f3, f4);
        Vec3D vec3d = entity.ag();
        this.i(this.dr().b(vec3d.c, entity.aF() ? 0.0 : vec3d.d, vec3d.e));
    }

    protected ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            return this.b(movingobjectposition);
        }
        return ProjectileDeflection.a;
    }

    protected ProjectileDeflection b(MovingObjectPosition movingobjectposition) {
        MovingObjectPositionEntity movingobjectpositionentity;
        Entity entity;
        ProjectileDeflection projectiledeflection;
        if (movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.c && (projectiledeflection = (entity = (movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition).a()).a(this)) != ProjectileDeflection.a) {
            if (entity != this.f && this.a(projectiledeflection, entity, this.s(), false)) {
                this.f = entity;
            }
            return projectiledeflection;
        }
        this.a(movingobjectposition);
        return ProjectileDeflection.a;
    }

    public boolean a(ProjectileDeflection projectiledeflection, @Nullable Entity entity, @Nullable Entity entity1, boolean flag) {
        if (!this.dO().B) {
            projectiledeflection.deflect(this, entity, this.ah);
            this.c(entity1);
            this.b(entity, flag);
        }
        return true;
    }

    protected void b(@Nullable Entity entity, boolean flag) {
    }

    protected void a(MovingObjectPosition movingobjectposition) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = movingobjectposition.c();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity movingobjectpositionentity = (MovingObjectPositionEntity)movingobjectposition;
            Entity entity = movingobjectpositionentity.a();
            if (entity.am().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                iprojectile.a(ProjectileDeflection.c, this.s(), this.s(), true);
            }
            this.a(movingobjectpositionentity);
            this.dO().a(GameEvent.J, movingobjectposition.e(), GameEvent.a.a(this, null));
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock movingobjectpositionblock = (MovingObjectPositionBlock)movingobjectposition;
            this.a(movingobjectpositionblock);
            BlockPosition blockposition = movingobjectpositionblock.a();
            this.dO().a(GameEvent.J, blockposition, GameEvent.a.a(this, this.dO().a_(blockposition)));
        }
    }

    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
    }

    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.dO().a_(movingobjectpositionblock.a());
        iblockdata.a(this.dO(), iblockdata, movingobjectpositionblock, this);
    }

    @Override
    public void l(double d0, double d1, double d2) {
        this.n(d0, d1, d2);
        if (this.P == 0.0f && this.O == 0.0f) {
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            this.u((float)(MathHelper.d(d1, d3) * 57.2957763671875));
            this.t((float)(MathHelper.d(d0, d2) * 57.2957763671875));
            this.P = this.dG();
            this.O = this.dE();
            this.b(this.dt(), this.dv(), this.dz(), this.dE(), this.dG());
        }
    }

    protected boolean b(Entity entity) {
        if (!entity.bz()) {
            return false;
        }
        Entity entity1 = this.s();
        return entity1 == null || this.d || !entity1.y(entity);
    }

    protected void I() {
        Vec3D vec3d = this.dr();
        double d0 = vec3d.h();
        this.u(IProjectile.e(this.P, (float)(MathHelper.d(vec3d.d, d0) * 57.2957763671875)));
        this.t(IProjectile.e(this.O, (float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875)));
    }

    protected static float e(float f2, float f1) {
        while (f1 - f2 < -180.0f) {
            f2 -= 360.0f;
        }
        while (f1 - f2 >= 180.0f) {
            f2 += 360.0f;
        }
        return MathHelper.i(0.2f, f2, f1);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        Entity entity = this.s();
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, entity == null ? 0 : entity.an());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        Entity entity = this.dO().a(packetplayoutspawnentity.p());
        if (entity != null) {
            this.c(entity);
        }
    }

    @Override
    public boolean a(World world, BlockPosition blockposition) {
        Entity entity = this.s();
        return entity instanceof EntityHuman ? entity.a(world, blockposition) : entity == null || world.ab().b(GameRules.c);
    }

    public boolean b(World world) {
        return this.am().a(TagsEntity.g) && world.ab().b(GameRules.g);
    }

    @Override
    public boolean bA() {
        return this.am().a(TagsEntity.H);
    }

    @Override
    public float bL() {
        return this.bA() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair a_(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = this.dr().c;
        double d1 = this.dr().e;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

