/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    public static final Codec<Holder<Item>> a = BuiltInRegistries.g.s().validate(holder -> holder.a(Items.a.o()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)holder));
    public static final Codec<ItemStack> b = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)a.fieldOf("id").forGetter(ItemStack::h), (App)ExtraCodecs.a(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::H), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.r.f())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> c = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)a.fieldOf("id").forGetter(ItemStack::h), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(itemstack -> itemstack.r.f())).apply((Applicative)instance, (holder, datacomponentpatch) -> new ItemStack((Holder<Item>)holder, 1, (DataComponentPatch)datacomponentpatch))));
    public static final Codec<ItemStack> d = b.validate(ItemStack::b);
    public static final Codec<ItemStack> e = c.validate(ItemStack::b);
    public static final Codec<ItemStack> f = ExtraCodecs.e(b).xmap(optional -> optional.orElse(l), itemstack -> itemstack.e() ? Optional.empty() : Optional.of(itemstack));
    public static final Codec<ItemStack> g = a.xmap(ItemStack::new, ItemStack::h);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> h = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> a = ByteBufCodecs.b(Registries.K);

        public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            int i2 = registryfriendlybytebuf.l();
            if (i2 <= 0) {
                return l;
            }
            Holder holder = (Holder)a.decode(registryfriendlybytebuf);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.c.decode(registryfriendlybytebuf);
            ItemStack itemstack = new ItemStack(holder, i2, datacomponentpatch);
            if (!datacomponentpatch.d()) {
                CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
            }
            return itemstack;
        }

        public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.e() || itemstack.g() == null) {
                registryfriendlybytebuf.c(0);
            } else {
                registryfriendlybytebuf.c(itemstack.H());
                itemstack = itemstack.s();
                CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
                a.encode(registryfriendlybytebuf, itemstack.h());
                DataComponentPatch.c.encode(registryfriendlybytebuf, itemstack.r.f());
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> i = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            ItemStack itemstack = (ItemStack)h.decode(registryfriendlybytebuf);
            if (itemstack.e()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemstack;
        }

        public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.e()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            h.encode(registryfriendlybytebuf, itemstack);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> j = h.a(ByteBufCodecs.a(NonNullList::a));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> k = i.a(ByteBufCodecs.a(NonNullList::a));
    private static final Logger m = LogUtils.getLogger();
    public static final ItemStack l = new ItemStack((Void)null);
    private static final IChatBaseComponent n = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private int o;
    private int p;
    @Deprecated
    @Nullable
    private Item q;
    final PatchedDataComponentMap r;
    @Nullable
    private Entity s;

    private static DataResult<ItemStack> b(ItemStack itemstack) {
        DataResult<Unit> dataresult = ItemStack.a(itemstack.a());
        return dataresult.isError() ? dataresult.map(unit -> itemstack) : (itemstack.H() > itemstack.j() ? DataResult.error(() -> {
            int i2 = itemstack.H();
            return "Item stack with stack size of " + i2 + " was larger than maximum: " + itemstack.j();
        }) : DataResult.success((Object)itemstack));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> a(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> streamcodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)streamcodec.decode(registryfriendlybytebuf);
                if (!itemstack.e()) {
                    RegistryOps<Unit> registryops = registryfriendlybytebuf.G().a(NullOps.a);
                    b.encodeStart(registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                streamcodec.encode(registryfriendlybytebuf, itemstack);
            }
        };
    }

    public Optional<TooltipComponent> b() {
        return this.g().g(this);
    }

    @Override
    public DataComponentMap a() {
        return !this.e() ? this.r : DataComponentMap.a;
    }

    public DataComponentMap c() {
        return !this.e() ? this.g().p() : DataComponentMap.a;
    }

    public DataComponentPatch d() {
        return !this.e() ? this.r.f() : DataComponentPatch.a;
    }

    public ItemStack(IMaterial imaterial) {
        this(imaterial, 1);
    }

    public ItemStack(Holder<Item> holder) {
        this(holder.a(), 1);
    }

    public ItemStack(Holder<Item> holder, int i2, DataComponentPatch datacomponentpatch) {
        this(holder.a(), i2, PatchedDataComponentMap.a(holder.a().p(), datacomponentpatch));
    }

    public ItemStack(Holder<Item> holder, int i2) {
        this(holder.a(), i2);
    }

    public ItemStack(IMaterial imaterial, int i2) {
        this(imaterial, i2, new PatchedDataComponentMap(imaterial.r().p()));
    }

    private ItemStack(IMaterial imaterial, int i2, PatchedDataComponentMap patcheddatacomponentmap) {
        this.q = imaterial.r();
        this.o = i2;
        this.r = patcheddatacomponentmap;
        this.g().m(this);
    }

    private ItemStack(@Nullable Void ovoid) {
        this.q = null;
        this.r = new PatchedDataComponentMap(DataComponentMap.a);
    }

    public static DataResult<Unit> a(DataComponentMap datacomponentmap) {
        int j2;
        ItemStack itemstack;
        int i2;
        if (datacomponentmap.b(DataComponents.d) && datacomponentmap.a(DataComponents.c, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = datacomponentmap.a(DataComponents.ab, ItemContainerContents.a);
        Iterator<ItemStack> iterator = itemcontainercontents.d().iterator();
        do {
            if (iterator.hasNext()) continue;
            return DataResult.success((Object)((Object)Unit.a));
        } while ((i2 = (itemstack = iterator.next()).H()) <= (j2 = itemstack.j()));
        int finalI = i2;
        int finalJ = j2;
        return DataResult.error(() -> "Item stack with count of " + finalI + " was larger than maximum: " + finalJ);
    }

    public static Optional<ItemStack> a(HolderLookup.a holderlookup_a, NBTBase nbtbase) {
        return b.parse(holderlookup_a.a(DynamicOpsNBT.a), (Object)nbtbase).resultOrPartial(s2 -> m.error("Tried to load invalid item: '{}'", s2));
    }

    public static ItemStack a(HolderLookup.a holderlookup_a, NBTTagCompound nbttagcompound) {
        return nbttagcompound.g() ? l : ItemStack.a(holderlookup_a, (NBTBase)nbttagcompound).orElse(l);
    }

    public boolean e() {
        return this == l || this.q == Items.a || this.o <= 0;
    }

    public boolean a(FeatureFlagSet featureflagset) {
        return this.e() || this.g().a(featureflagset);
    }

    public ItemStack a(int i2) {
        int j2 = Math.min(i2, this.H());
        ItemStack itemstack = this.c(j2);
        this.h(j2);
        return itemstack;
    }

    public ItemStack f() {
        if (this.e()) {
            return l;
        }
        ItemStack itemstack = this.s();
        this.e(0);
        return itemstack;
    }

    public Item g() {
        return this.e() ? Items.a : this.q;
    }

    public Holder<Item> h() {
        return this.g().o();
    }

    public boolean a(TagKey<Item> tagkey) {
        return this.g().o().a(tagkey);
    }

    public boolean a(Item item) {
        return this.g() == item;
    }

    public boolean a(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.g().o());
    }

    public boolean a(Holder<Item> holder) {
        return this.g().o() == holder;
    }

    public boolean a(HolderSet<Item> holderset) {
        return holderset.a(this.h());
    }

    public Stream<TagKey<Item>> i() {
        return this.g().o().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext itemactioncontext) {
        EnumInteractionResult enuminteractionresult;
        EntityHuman entityhuman = itemactioncontext.o();
        BlockPosition blockposition = itemactioncontext.a();
        if (entityhuman != null && !entityhuman.fZ().e && !this.a(new ShapeDetectorBlock(itemactioncontext.q(), blockposition, false))) {
            return EnumInteractionResult.e;
        }
        Item item = this.g();
        DataComponentPatch oldData = this.r.f();
        int oldCount = this.H();
        WorldServer world = (WorldServer)itemactioncontext.q();
        if (!(item instanceof ItemBucket) && !(item instanceof SolidBucketItem)) {
            world.captureBlockStates = true;
            if (item == Items.ry) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.a(itemactioncontext);
        }
        finally {
            world.captureBlockStates = false;
        }
        DataComponentPatch newData = this.r.f();
        int newCount = this.H();
        this.e(oldCount);
        this.restorePatch(oldData);
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean bl = this.g() == Items.ry;
                structureEvent = new StructureGrowEvent(location, treeType, bl, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent blockFertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            blockFertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)blockFertilizeEvent);
            if (!blockFertilizeEvent.isCancelled()) {
                if (this.H() == oldCount && Objects.equals(this.r.f(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.c()) {
            EnumHand enumhand = itemactioncontext.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.f;
                placeEvent.getPlayer().updateInventory();
                world.preventPoiUpdated = true;
                for (BlockState blockState : blocks) {
                    blockState.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPosition placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                for (EnumDirection dir : EnumDirection.values()) {
                    ((EntityPlayer)entityhuman).c.b(new PacketPlayOutBlockChange(world, placedPos.a(dir)));
                }
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData iBlockData;
                if (this.H() == oldCount && Objects.equals(this.r.f(), oldData)) {
                    this.restorePatch(newData);
                    this.e(newCount);
                }
                for (Map.Entry entry : world.capturedTileEntities.entrySet()) {
                    world.a((TileEntity)entry.getValue());
                }
                for (BlockState blockState : blocks) {
                    int updateFlag = ((CraftBlockState)blockState).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockState).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockState).getPosition();
                    IBlockData block = world.a_(newblockposition);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.onPlace(world, newblockposition, oldBlock, true, itemactioncontext);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.a_(newblockposition), updateFlag, 512);
                }
                if (this.q == Items.um) {
                    TileEntity tileEntity;
                    BlockPosition bp = blockposition;
                    if (!world.a_(blockposition).r()) {
                        bp = !world.a_(blockposition).e() ? null : bp.a(itemactioncontext.k());
                    }
                    if (bp != null && (tileEntity = world.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, bp, (TileEntitySkull)tileEntity);
                    }
                }
                if (this.q instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        TileEntity tileEntity = world.c_(ItemSign.openSign);
                        if (tileEntity instanceof TileEntitySign) {
                            TileEntitySign tileentitysign = (TileEntitySign)tileEntity;
                            Block block = world.a_(ItemSign.openSign).b();
                            if (block instanceof BlockSign) {
                                BlockSign blockSign = (BlockSign)block;
                                blockSign.openTextEdit(entityhuman, tileentitysign, true, PlayerSignOpenEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.q instanceof ItemBed && (iBlockData = world.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    world.b(position, Blocks.a);
                    iBlockData.a((GeneratorAccess)world, position, 3);
                }
                if (this.q instanceof ItemBlock) {
                    SoundEffectType soundeffecttype = ((ItemBlock)this.q).d().o().w();
                    world.a(entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData iblockdata) {
        return this.g().a(this, iblockdata);
    }

    public InteractionResultWrapper<ItemStack> a(net.minecraft.world.level.World world, EntityHuman entityhuman, EnumHand enumhand) {
        return this.g().a(world, entityhuman, enumhand);
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving entityliving) {
        return this.g().a(this, world, entityliving);
    }

    public NBTBase b(HolderLookup.a holderlookup_a, NBTBase nbtbase) {
        if (this.e()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)b.encode((Object)this, holderlookup_a.a(DynamicOpsNBT.a), (Object)nbtbase).getOrThrow();
    }

    public NBTBase a(HolderLookup.a holderlookup_a) {
        if (this.e()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)b.encodeStart(holderlookup_a.a(DynamicOpsNBT.a), (Object)this).getOrThrow();
    }

    public NBTBase b(HolderLookup.a holderlookup_a) {
        return this.e() ? new NBTTagCompound() : this.b(holderlookup_a, new NBTTagCompound());
    }

    public int j() {
        return this.a(DataComponents.c, Integer.valueOf(1));
    }

    public boolean k() {
        return this.j() > 1 && (!this.l() || !this.m());
    }

    public boolean l() {
        return this.b(DataComponents.d) && !this.b(DataComponents.f) && this.b(DataComponents.e);
    }

    public boolean m() {
        return this.l() && this.n() > 0;
    }

    public int n() {
        return MathHelper.a((int)this.a(DataComponents.e, Integer.valueOf(0)), 0, this.o());
    }

    public void b(int i2) {
        this.b(DataComponents.e, Integer.valueOf(MathHelper.a(i2, 0, this.o())));
    }

    public int o() {
        return this.a(DataComponents.d, Integer.valueOf(0));
    }

    public void a(int i2, WorldServer worldserver, @Nullable EntityPlayer entityplayer, Consumer<Item> consumer) {
        if (this.l() && (entityplayer == null || !entityplayer.fL())) {
            if (i2 > 0) {
                i2 = EnchantmentManager.a(worldserver, this, i2);
                if (entityplayer != null) {
                    PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)entityplayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2);
                    event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                    if (i2 != event.getDamage() || event.isCancelled()) {
                        event.getPlayer().updateInventory();
                    }
                    if (event.isCancelled()) {
                        return;
                    }
                    i2 = event.getDamage();
                }
                if (i2 <= 0) {
                    return;
                }
            }
            if (entityplayer != null && i2 != 0) {
                CriterionTriggers.u.a(entityplayer, this, this.n() + i2);
            }
            int j2 = this.n() + i2;
            this.b(j2);
            if (j2 >= this.o()) {
                Item item = this.g();
                if (this.o == 1 && entityplayer != null) {
                    CraftEventFactory.callPlayerItemBreakEvent(entityplayer, this);
                }
                this.h(1);
                consumer.accept(item);
            }
        }
    }

    public void a(int i2, EntityLiving entityliving, EnumItemSlot enumitemslot) {
        net.minecraft.world.level.World world = entityliving.dO();
        if (world instanceof WorldServer) {
            EntityPlayer entityplayer1;
            WorldServer worldserver = (WorldServer)world;
            EntityPlayer entityplayer = entityliving instanceof EntityPlayer ? (entityplayer1 = (EntityPlayer)entityliving) : null;
            this.a(i2, worldserver, entityplayer, (Item item) -> entityliving.a((Item)item, enumitemslot));
        }
    }

    public ItemStack a(int i2, IMaterial imaterial, EntityLiving entityliving, EnumItemSlot enumitemslot) {
        this.a(i2, entityliving, enumitemslot);
        if (this.e()) {
            ItemStack itemstack = this.b(imaterial, 1);
            if (itemstack.l()) {
                itemstack.b(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean p() {
        return this.g().d(this);
    }

    public int q() {
        return this.g().e(this);
    }

    public int r() {
        return this.g().f(this);
    }

    public boolean a(Slot slot, ClickAction clickaction, EntityHuman entityhuman) {
        return this.g().a(this, slot, clickaction, entityhuman);
    }

    public boolean a(ItemStack itemstack, Slot slot, ClickAction clickaction, EntityHuman entityhuman, SlotAccess slotaccess) {
        return this.g().a(this, itemstack, slot, clickaction, entityhuman, slotaccess);
    }

    public boolean a(EntityLiving entityliving, EntityHuman entityhuman) {
        Item item = this.g();
        if (item.a(this, entityliving, (EntityLiving)entityhuman)) {
            entityhuman.b(StatisticList.c.b(item));
            return true;
        }
        return false;
    }

    public void b(EntityLiving entityliving, EntityHuman entityhuman) {
        this.g().b(this, entityliving, (EntityLiving)entityhuman);
    }

    public void a(net.minecraft.world.level.World world, IBlockData iblockdata, BlockPosition blockposition, EntityHuman entityhuman) {
        Item item = this.g();
        if (item.a(this, world, iblockdata, blockposition, entityhuman)) {
            entityhuman.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData iblockdata) {
        return this.g().b(this, iblockdata);
    }

    public EnumInteractionResult a(EntityHuman entityhuman, EntityLiving entityliving, EnumHand enumhand) {
        return this.g().a(this, entityhuman, entityliving, enumhand);
    }

    public ItemStack s() {
        if (this.e()) {
            return l;
        }
        ItemStack itemstack = new ItemStack(this.g(), this.o, this.r.g());
        itemstack.d(this.G());
        return itemstack;
    }

    public ItemStack c(int i2) {
        if (this.e()) {
            return l;
        }
        ItemStack itemstack = this.s();
        itemstack.e(i2);
        return itemstack;
    }

    public ItemStack a(IMaterial imaterial) {
        return this.a(imaterial, this.H());
    }

    public ItemStack a(IMaterial imaterial, int i2) {
        return this.e() ? l : this.b(imaterial, i2);
    }

    private ItemStack b(IMaterial imaterial, int i2) {
        return new ItemStack(imaterial.r().o(), i2, this.r.f());
    }

    public static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack == itemstack1 ? true : (itemstack.H() != itemstack1.H() ? false : ItemStack.c(itemstack, itemstack1));
    }

    @Deprecated
    public static boolean a(List<ItemStack> list, List<ItemStack> list1) {
        if (list.size() != list1.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (ItemStack.a(list.get(i2), list1.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.a(itemstack1.g());
    }

    public static boolean c(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.a(itemstack1.g()) ? false : (itemstack.e() && itemstack1.e() ? true : Objects.equals(itemstack.r, itemstack1.r));
    }

    public static MapCodec<ItemStack> a(String s2) {
        return b.lenientOptionalFieldOf(s2).xmap(optional -> optional.orElse(l), itemstack -> itemstack.e() ? Optional.empty() : Optional.of(itemstack));
    }

    public static int a(@Nullable ItemStack itemstack) {
        if (itemstack != null) {
            int i2 = 31 + itemstack.g().hashCode();
            return 31 * i2 + itemstack.a().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int a(List<ItemStack> list) {
        int i2 = 0;
        for (ItemStack itemstack : list) {
            i2 = i2 * 31 + ItemStack.a(itemstack);
        }
        return i2;
    }

    public String t() {
        return this.g().h(this);
    }

    public String toString() {
        int i2 = this.H();
        return i2 + " " + String.valueOf(this.g());
    }

    public void a(net.minecraft.world.level.World world, Entity entity, int i2, boolean flag) {
        if (this.p > 0) {
            --this.p;
        }
        if (this.g() != null) {
            this.g().a(this, world, entity, i2, flag);
        }
    }

    public void a(net.minecraft.world.level.World world, EntityHuman entityhuman, int i2) {
        entityhuman.a(StatisticList.b.b(this.g()), i2);
        this.g().b(this, world, entityhuman);
    }

    public void a(net.minecraft.world.level.World world) {
        this.g().a(this, world);
    }

    public int a(EntityLiving entityliving) {
        return this.g().a(this, entityliving);
    }

    public EnumAnimation u() {
        return this.g().b(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        this.g().a(this, world, entityliving, i2);
    }

    public boolean v() {
        return this.g().l(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.r.b(datacomponentpatch);
    }

    @Nullable
    public <T> T b(DataComponentType<? super T> datacomponenttype, @Nullable T t0) {
        return this.r.b(datacomponenttype, t0);
    }

    @Nullable
    public <T, U> T a(DataComponentType<T> datacomponenttype, T t0, U u0, BiFunction<T, U, T> bifunction) {
        return this.b(datacomponenttype, bifunction.apply(this.a(datacomponenttype, t0), u0));
    }

    @Nullable
    public <T> T a(DataComponentType<T> datacomponenttype, T t0, UnaryOperator<T> unaryoperator) {
        T t1 = this.a(datacomponenttype, t0);
        return this.b(datacomponenttype, unaryoperator.apply(t1));
    }

    @Nullable
    public <T> T c(DataComponentType<? extends T> datacomponenttype) {
        return this.r.d(datacomponenttype);
    }

    public void a(DataComponentPatch datacomponentpatch) {
        DataComponentPatch datacomponentpatch1 = this.r.f();
        this.r.a(datacomponentpatch);
        Optional optional = ItemStack.b(this).error();
        if (optional.isPresent()) {
            m.error("Failed to apply component patch '{}' to item: '{}'", (Object)datacomponentpatch, (Object)((DataResult.Error)optional.get()).message());
            this.r.b(datacomponentpatch1);
        } else {
            this.g().m(this);
        }
    }

    public void b(DataComponentPatch datacomponentpatch) {
        this.r.a(datacomponentpatch);
        this.g().m(this);
    }

    public void b(DataComponentMap datacomponentmap) {
        this.r.a(datacomponentmap);
        this.g().m(this);
    }

    public IChatBaseComponent w() {
        IChatBaseComponent ichatbasecomponent = this.a(DataComponents.g);
        if (ichatbasecomponent != null) {
            return ichatbasecomponent;
        }
        IChatBaseComponent ichatbasecomponent1 = this.a(DataComponents.h);
        return ichatbasecomponent1 != null ? ichatbasecomponent1 : this.g().n(this);
    }

    private <T extends TooltipProvider> void a(DataComponentType<T> datacomponenttype, Item.b item_b, Consumer<IChatBaseComponent> consumer, TooltipFlag tooltipflag) {
        TooltipProvider t0 = (TooltipProvider)this.a(datacomponenttype);
        if (t0 != null) {
            t0.a(item_b, consumer, tooltipflag);
        }
    }

    public List<IChatBaseComponent> a(Item.b item_b, @Nullable EntityHuman entityhuman, TooltipFlag tooltipflag) {
        AdventureModePredicate adventuremodepredicate1;
        MapId mapid;
        if (!tooltipflag.b() && this.b(DataComponents.q)) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.w()).a(this.y().a());
        if (this.b(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        list.add(ichatmutablecomponent);
        if (!tooltipflag.a() && !this.b(DataComponents.g) && this.a(Items.rU) && (mapid = this.a(DataComponents.B)) != null) {
            list.add(ItemWorldMap.a(mapid));
        }
        Objects.requireNonNull(list);
        Consumer<IChatBaseComponent> consumer = list::add;
        if (!this.b(DataComponents.p)) {
            this.g().a(this, item_b, list, tooltipflag);
        }
        this.a(DataComponents.R, item_b, consumer, tooltipflag);
        this.a(DataComponents.K, item_b, consumer, tooltipflag);
        this.a(DataComponents.y, item_b, consumer, tooltipflag);
        this.a(DataComponents.k, item_b, consumer, tooltipflag);
        this.a(DataComponents.z, item_b, consumer, tooltipflag);
        this.a(DataComponents.i, item_b, consumer, tooltipflag);
        this.a(consumer, entityhuman);
        this.a(DataComponents.f, item_b, consumer, tooltipflag);
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.m);
        if (adventuremodepredicate != null && adventuremodepredicate.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.c);
            adventuremodepredicate.a(consumer);
        }
        if ((adventuremodepredicate1 = this.a(DataComponents.l)) != null && adventuremodepredicate1.a()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(AdventureModePredicate.d);
            adventuremodepredicate1.a(consumer);
        }
        if (tooltipflag.a()) {
            if (this.m()) {
                list.add(IChatBaseComponent.a("item.durability", this.o() - this.n(), this.o()));
            }
            list.add(IChatBaseComponent.b(BuiltInRegistries.g.b(this.g()).toString()).a(EnumChatFormat.i));
            int i2 = this.r.d();
            if (i2 > 0) {
                list.add(IChatBaseComponent.a("item.components", i2).a(EnumChatFormat.i));
            }
        }
        if (entityhuman != null && !this.g().a(entityhuman.dO().J())) {
            list.add(n);
        }
        return list;
    }

    private void a(Consumer<IChatBaseComponent> consumer, @Nullable EntityHuman entityhuman) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.n, ItemAttributeModifiers.a);
        if (itemattributemodifiers.c()) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.a(equipmentslotgroup, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    if (mutableboolean.isTrue()) {
                        consumer.accept(CommonComponents.a);
                        consumer.accept(IChatBaseComponent.c("item.modifiers." + equipmentslotgroup.c()).a(EnumChatFormat.h));
                        mutableboolean.setFalse();
                    }
                    this.a(consumer, entityhuman, (Holder<AttributeBase>)holder, (AttributeModifier)attributemodifier);
                });
            }
        }
    }

    private void a(Consumer<IChatBaseComponent> consumer, @Nullable EntityHuman entityhuman, Holder<AttributeBase> holder, AttributeModifier attributemodifier) {
        double d0 = attributemodifier.c();
        boolean flag = false;
        if (entityhuman != null) {
            if (attributemodifier.a(Item.e)) {
                d0 += entityhuman.h(GenericAttributes.c);
                flag = true;
            } else if (attributemodifier.a(Item.f)) {
                d0 += entityhuman.h(GenericAttributes.e);
                flag = true;
            }
        }
        double d1 = attributemodifier.d() != AttributeModifier.Operation.b && attributemodifier.d() != AttributeModifier.Operation.c ? (holder.a(GenericAttributes.p) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (flag) {
            consumer.accept(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + attributemodifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(holder.a().c())})).a(EnumChatFormat.c));
        } else if (d0 > 0.0) {
            consumer.accept(IChatBaseComponent.a("attribute.modifier.plus." + attributemodifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(holder.a().c())}).a(holder.a().b(true)));
        } else if (d0 < 0.0) {
            consumer.accept(IChatBaseComponent.a("attribute.modifier.take." + attributemodifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(-d1), IChatBaseComponent.c(holder.a().c())}).a(holder.a().b(false)));
        }
    }

    public boolean x() {
        Boolean obool = this.a(DataComponents.t);
        return obool != null ? obool.booleanValue() : this.g().d_(this);
    }

    public EnumItemRarity y() {
        EnumItemRarity enumitemrarity = this.a(DataComponents.j, EnumItemRarity.a);
        if (!this.A()) {
            return enumitemrarity;
        }
        return switch (enumitemrarity) {
            case EnumItemRarity.a, EnumItemRarity.b -> EnumItemRarity.c;
            case EnumItemRarity.c -> EnumItemRarity.d;
            default -> enumitemrarity;
        };
    }

    public boolean z() {
        if (!this.g().a(this)) {
            return false;
        }
        ItemEnchantments itemenchantments = this.a(DataComponents.k);
        return itemenchantments != null && itemenchantments.d();
    }

    public void a(Holder<Enchantment> holder, int i2) {
        EnchantmentManager.a(this, (ItemEnchantments.a itemenchantments_a) -> itemenchantments_a.b(holder, i2));
    }

    public boolean A() {
        return !this.a(DataComponents.k, ItemEnchantments.a).d();
    }

    public ItemEnchantments B() {
        return this.a(DataComponents.k, ItemEnchantments.a);
    }

    public boolean C() {
        return this.s instanceof EntityItemFrame;
    }

    public void a(@Nullable Entity entity) {
        if (!this.e()) {
            this.s = entity;
        }
    }

    @Nullable
    public EntityItemFrame D() {
        return this.s instanceof EntityItemFrame ? (EntityItemFrame)this.E() : null;
    }

    @Nullable
    public Entity E() {
        return !this.e() ? this.s : null;
    }

    public void a(EquipmentSlotGroup equipmentslotgroup, BiConsumer<Holder<AttributeBase>, AttributeModifier> biconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.n, ItemAttributeModifiers.a);
        if (!itemattributemodifiers.b().isEmpty()) {
            itemattributemodifiers.a(equipmentslotgroup, biconsumer);
        } else {
            this.g().j().a(equipmentslotgroup, biconsumer);
        }
        EnchantmentManager.a(this, equipmentslotgroup, biconsumer);
    }

    public void a(EnumItemSlot enumitemslot, BiConsumer<Holder<AttributeBase>, AttributeModifier> biconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.a(DataComponents.n, ItemAttributeModifiers.a);
        if (!itemattributemodifiers.b().isEmpty()) {
            itemattributemodifiers.a(enumitemslot, biconsumer);
        } else {
            this.g().j().a(enumitemslot, biconsumer);
        }
        EnchantmentManager.a(this, enumitemslot, biconsumer);
    }

    @Deprecated
    public void setItem(Item item) {
        this.q = item;
    }

    public IChatBaseComponent F() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.w());
        if (this.b(DataComponents.g)) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.e()) {
            ichatmutablecomponent1.a(this.y().a()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(ShapeDetectorBlock shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.l);
        return adventuremodepredicate != null && adventuremodepredicate.a(shapedetectorblock);
    }

    public boolean b(ShapeDetectorBlock shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.a(DataComponents.m);
        return adventuremodepredicate != null && adventuremodepredicate.a(shapedetectorblock);
    }

    public int G() {
        return this.p;
    }

    public void d(int i2) {
        this.p = i2;
    }

    public int H() {
        return this.e() ? 0 : this.o;
    }

    public void e(int i2) {
        this.o = i2;
    }

    public void f(int i2) {
        if (!this.e() && this.H() > i2) {
            this.e(i2);
        }
    }

    public void g(int i2) {
        this.e(this.H() + i2);
    }

    public void h(int i2) {
        this.g(-i2);
    }

    public void a(int i2, @Nullable EntityLiving entityliving) {
        if (!(entityliving != null && entityliving.fL() || this == l)) {
            this.h(i2);
        }
    }

    public ItemStack b(int i2, @Nullable EntityLiving entityliving) {
        ItemStack itemstack = this.c(i2);
        this.a(i2, entityliving);
        return itemstack;
    }

    public void b(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        this.g().a(world, entityliving, this, i2);
    }

    public void a(EntityItem entityitem) {
        this.g().a(entityitem);
    }

    public SoundEffect I() {
        return this.g().ap_();
    }

    public SoundEffect J() {
        return this.g().aq_();
    }

    public SoundEffect K() {
        return this.g().e();
    }

    public boolean a(DamageSource damagesource) {
        return !this.b(DataComponents.w) || !damagesource.a(DamageTypeTags.i);
    }
}

