/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    public static final String b = "SpawnData";
    private static final Logger a = LogUtils.getLogger();
    private static final int c = 1;
    public int d = 20;
    public SimpleWeightedRandomList<MobSpawnerData> e = SimpleWeightedRandomList.b();
    @Nullable
    public MobSpawnerData f;
    private double g;
    private double h;
    public int i = 200;
    public int j = 800;
    public int k = 4;
    @Nullable
    private Entity l;
    public int m = 6;
    public int n = 16;
    public int o = 4;

    public void a(EntityTypes<?> entitytypes, @Nullable World world, RandomSource randomsource, BlockPosition blockposition) {
        this.a(world, randomsource, blockposition).a().a("id", BuiltInRegistries.f.b(entitytypes).toString());
        this.e = SimpleWeightedRandomList.b();
    }

    private boolean c(World world, BlockPosition blockposition) {
        return world.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, (double)this.n);
    }

    public void a(World world, BlockPosition blockposition) {
        if (!this.c(world, blockposition)) {
            this.h = this.g;
        } else if (this.l != null) {
            RandomSource randomsource = world.E_();
            double d0 = (double)blockposition.u() + randomsource.j();
            double d1 = (double)blockposition.v() + randomsource.j();
            double d2 = (double)blockposition.w() + randomsource.j();
            world.a(Particles.ae, d0, d1, d2, 0.0, 0.0, 0.0);
            world.a(Particles.F, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.d > 0) {
                --this.d;
            }
            this.h = this.g;
            this.g = (this.g + (double)(1000.0f / ((float)this.d + 200.0f))) % 360.0;
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition) {
        if (this.c(worldserver, blockposition)) {
            if (this.d == -1) {
                this.d(worldserver, blockposition);
            }
            if (this.d > 0) {
                --this.d;
            } else {
                boolean flag = false;
                RandomSource randomsource = worldserver.E_();
                MobSpawnerData mobspawnerdata = this.a((World)worldserver, randomsource, blockposition);
                for (int i2 = 0; i2 < this.k; ++i2) {
                    MobSpawnerData.a mobspawnerdata_a;
                    double d2;
                    NBTTagCompound nbttagcompound = mobspawnerdata.a();
                    Optional<EntityTypes<?>> optional = EntityTypes.a(nbttagcompound);
                    if (optional.isEmpty()) {
                        this.d(worldserver, blockposition);
                        return;
                    }
                    NBTTagList nbttaglist = nbttagcompound.c("Pos", 6);
                    int j2 = nbttaglist.size();
                    double d0 = j2 >= 1 ? nbttaglist.h(0) : (double)blockposition.u() + (randomsource.j() - randomsource.j()) * (double)this.o + 0.5;
                    double d1 = j2 >= 2 ? nbttaglist.h(1) : (double)(blockposition.v() + randomsource.a(3) - 1);
                    double d3 = d2 = j2 >= 3 ? nbttaglist.h(2) : (double)blockposition.w() + (randomsource.j() - randomsource.j()) * (double)this.o + 0.5;
                    if (!worldserver.b(optional.get().a(d0, d1, d2))) continue;
                    BlockPosition blockposition1 = BlockPosition.a(d0, d1, d2);
                    if (!mobspawnerdata.b().isPresent() ? !EntityPositionTypes.a(optional.get(), worldserver, EnumMobSpawn.c, blockposition1, worldserver.E_()) : !optional.get().f().d() && worldserver.al() == EnumDifficulty.a || !(mobspawnerdata_a = mobspawnerdata.b().get()).a(blockposition1, worldserver)) continue;
                    Entity entity = EntityTypes.a(nbttagcompound, worldserver, entity1 -> {
                        entity1.b(d0, d1, d2, entity1.dE(), entity1.dG());
                        return entity1;
                    });
                    if (entity == null) {
                        this.d(worldserver, blockposition);
                        return;
                    }
                    int k2 = worldserver.a(EntityTypeTest.b(entity.getClass()), new AxisAlignedBB(blockposition.u(), blockposition.v(), blockposition.w(), blockposition.u() + 1, blockposition.v() + 1, blockposition.w() + 1).g(this.o), IEntitySelector.f).size();
                    if (k2 >= this.m) {
                        this.d(worldserver, blockposition);
                        return;
                    }
                    entity.b(entity.dt(), entity.dv(), entity.dz(), randomsource.i() * 360.0f, 0.0f);
                    if (entity instanceof EntityInsentient) {
                        boolean flag1;
                        EntityInsentient entityinsentient = (EntityInsentient)entity;
                        if (mobspawnerdata.b().isEmpty() && !entityinsentient.a((GeneratorAccess)worldserver, EnumMobSpawn.c) || !entityinsentient.a((IWorldReader)worldserver)) continue;
                        boolean bl = flag1 = mobspawnerdata.a().f() == 1 && mobspawnerdata.a().b("id", 8);
                        if (flag1) {
                            ((EntityInsentient)entity).a((WorldAccess)worldserver, worldserver.d_(entity.do()), EnumMobSpawn.c, (GroupDataEntity)null);
                        }
                        Optional<EquipmentTable> optional1 = mobspawnerdata.c();
                        Objects.requireNonNull(entityinsentient);
                        optional1.ifPresent(entityinsentient::a);
                        if (entityinsentient.dO().spigotConfig.nerfSpawnerMobs) {
                            entityinsentient.aware = false;
                        }
                    }
                    if (CraftEventFactory.callSpawnerSpawnEvent(entity, blockposition).isCancelled()) continue;
                    if (!worldserver.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.d(worldserver, blockposition);
                        return;
                    }
                    worldserver.c(2004, blockposition, 0);
                    worldserver.a(entity, GameEvent.t, blockposition1);
                    if (entity instanceof EntityInsentient) {
                        ((EntityInsentient)entity).T();
                    }
                    flag = true;
                }
                if (flag) {
                    this.d(worldserver, blockposition);
                }
            }
        }
    }

    private void d(World world, BlockPosition blockposition) {
        RandomSource randomsource = world.z;
        this.d = this.j <= this.i ? this.i : this.i + randomsource.a(this.j - this.i);
        this.e.b(randomsource).ifPresent(weightedentry_b -> this.a(world, blockposition, (MobSpawnerData)weightedentry_b.b()));
        this.a(world, blockposition, 1);
    }

    public void a(@Nullable World world, BlockPosition blockposition, NBTTagCompound nbttagcompound) {
        boolean flag1;
        this.d = nbttagcompound.g("Delay");
        boolean flag = nbttagcompound.b(b, 10);
        if (flag) {
            MobSpawnerData mobspawnerdata = MobSpawnerData.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.p(b)).resultOrPartial(s2 -> a.warn("Invalid SpawnData: {}", s2)).orElseGet(MobSpawnerData::new);
            this.a(world, blockposition, mobspawnerdata);
        }
        if (flag1 = nbttagcompound.b("SpawnPotentials", 9)) {
            NBTTagList nbttaglist = nbttagcompound.c("SpawnPotentials", 10);
            this.e = MobSpawnerData.c.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttaglist).resultOrPartial(s2 -> a.warn("Invalid SpawnPotentials list: {}", s2)).orElseGet(SimpleWeightedRandomList::b);
        } else {
            this.e = SimpleWeightedRandomList.a(this.f != null ? this.f : new MobSpawnerData());
        }
        if (nbttagcompound.b("MinSpawnDelay", 99)) {
            this.i = nbttagcompound.g("MinSpawnDelay");
            this.j = nbttagcompound.g("MaxSpawnDelay");
            this.k = nbttagcompound.g("SpawnCount");
        }
        if (nbttagcompound.b("MaxNearbyEntities", 99)) {
            this.m = nbttagcompound.g("MaxNearbyEntities");
            this.n = nbttagcompound.g("RequiredPlayerRange");
        }
        if (nbttagcompound.b("SpawnRange", 99)) {
            this.o = nbttagcompound.g("SpawnRange");
        }
        this.l = null;
    }

    public NBTTagCompound a(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Delay", (short)this.d);
        nbttagcompound.a("MinSpawnDelay", (short)this.i);
        nbttagcompound.a("MaxSpawnDelay", (short)this.j);
        nbttagcompound.a("SpawnCount", (short)this.k);
        nbttagcompound.a("MaxNearbyEntities", (short)this.m);
        nbttagcompound.a("RequiredPlayerRange", (short)this.n);
        nbttagcompound.a("SpawnRange", (short)this.o);
        if (this.f != null) {
            nbttagcompound.a(b, (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f).getOrThrow(s2 -> new IllegalStateException("Invalid SpawnData: " + s2)));
        }
        nbttagcompound.a("SpawnPotentials", (NBTBase)MobSpawnerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, this.e).getOrThrow());
        return nbttagcompound;
    }

    @Nullable
    public Entity b(World world, BlockPosition blockposition) {
        if (this.l == null) {
            NBTTagCompound nbttagcompound = this.a(world, world.E_(), blockposition).a();
            if (!nbttagcompound.b("id", 8)) {
                return null;
            }
            this.l = EntityTypes.a(nbttagcompound, world, Function.identity());
            if (nbttagcompound.f() != 1 || this.l instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.l;
    }

    public boolean a(World world, int i2) {
        if (i2 == 1) {
            if (world.B) {
                this.d = this.i;
            }
            return true;
        }
        return false;
    }

    protected void a(@Nullable World world, BlockPosition blockposition, MobSpawnerData mobspawnerdata) {
        this.f = mobspawnerdata;
    }

    private MobSpawnerData a(@Nullable World world, RandomSource randomsource, BlockPosition blockposition) {
        if (this.f != null) {
            return this.f;
        }
        this.a(world, blockposition, this.e.b(randomsource).map(WeightedEntry.b::b).orElseGet(MobSpawnerData::new));
        return this.f;
    }

    public abstract void a(World var1, BlockPosition var2, int var3);

    public double a() {
        return this.g;
    }

    public double b() {
        return this.h;
    }
}

