/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> g = ResourceKey.a(Registries.ba);
    public static final ResourceKey<World> h = ResourceKey.a(Registries.ba, MinecraftKey.b("overworld"));
    public static final ResourceKey<World> i = ResourceKey.a(Registries.ba, MinecraftKey.b("the_nether"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.ba, MinecraftKey.b("the_end"));
    public static final int k = 30000000;
    public static final int l = 512;
    public static final int m = 32;
    public static final int n = 15;
    public static final int o = 24000;
    public static final int p = 20000000;
    public static final int q = -20000000;
    protected final List<TickingBlockEntity> r = Lists.newArrayList();
    protected final NeighborUpdater s;
    private final List<TickingBlockEntity> a = Lists.newArrayList();
    private boolean b;
    public final Thread c;
    private final boolean d;
    private int e;
    protected int t = RandomSource.a().f();
    protected final int u = 1013904223;
    protected float v;
    public float w;
    protected float x;
    public float y;
    public final RandomSource z = RandomSource.a();
    @Deprecated
    private final RandomSource f = RandomSource.b();
    private final Holder<DimensionManager> D;
    public final WorldDataMutable A;
    private final Supplier<GameProfilerFiller> E;
    public final boolean B;
    private final WorldBorder F;
    private final BiomeManager G;
    private final ResourceKey<World> H;
    private final IRegistryCustom I;
    private final DamageSources J;
    private long K;
    private final CraftWorld world;
    public boolean pvpMode;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CapturedBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new HashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    public final SpigotTimings.WorldTimingsHandler timings;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, Supplier<GameProfilerFiller> supplier, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).e());
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
        this.E = supplier;
        this.A = worlddatamutable;
        this.D = holder;
        DimensionManager dimensionmanager = holder.a();
        this.H = resourcekey;
        this.B = flag;
        this.F = dimensionmanager.k() != 1.0 ? new WorldBorder(this){

            @Override
            public double a() {
                return super.a();
            }

            @Override
            public double b() {
                return super.b();
            }
        } : new WorldBorder();
        this.c = Thread.currentThread();
        this.G = new BiomeManager(this, i2);
        this.d = flag1;
        this.s = new CollectingNeighborUpdater(this, j2);
        this.I = iregistrycustom;
        this.J = new DamageSources(iregistrycustom);
        this.C_().world = (WorldServer)this;
        this.C_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder worldborder, double d0) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1, long i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, double d0) {
            }

            @Override
            public void c(WorldBorder worldborder, double d0) {
            }
        });
        this.timings = new SpigotTimings.WorldTimingsHandler(this);
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
    }

    @Override
    public boolean x_() {
        return this.B;
    }

    @Override
    @Nullable
    public MinecraftServer o() {
        return null;
    }

    public boolean k(BlockPosition blockposition) {
        return !this.s(blockposition) && World.g(blockposition);
    }

    public static boolean l(BlockPosition blockposition) {
        return !World.b(blockposition.v()) && World.g(blockposition);
    }

    private static boolean g(BlockPosition blockposition) {
        return blockposition.u() >= -30000000 && blockposition.w() >= -30000000 && blockposition.u() < 30000000 && blockposition.w() < 30000000;
    }

    private static boolean b(int i2) {
        return i2 < -20000000 || i2 >= 20000000;
    }

    public Chunk m(BlockPosition blockposition) {
        return this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public Chunk d(int i2, int j2) {
        return (Chunk)this.a(i2, j2, ChunkStatus.n);
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess = this.N().a(i2, j2, chunkstatus, flag);
        if (ichunkaccess == null && flag) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2) {
        return this.a(blockposition, iblockdata, i2, 512);
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        IBlockData iblockdata1;
        if (this.captureTreeGeneration) {
            CapturedBlockState blockstate = this.capturedBlockStates.get(blockposition);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, blockposition, i2);
                this.capturedBlockStates.put(blockposition.j(), blockstate);
            }
            blockstate.setData(iblockdata);
            blockstate.setFlag(i2);
            return true;
        }
        if (this.s(blockposition)) {
            return false;
        }
        if (!this.B && this.ai()) {
            return false;
        }
        Chunk chunk = this.m(blockposition);
        Block block = iblockdata.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(blockposition)) {
            CapturedBlockState blockstate = CapturedBlockState.getBlockState(this, blockposition, i2);
            this.capturedBlockStates.put(blockposition.j(), blockstate);
            captured = true;
        }
        if ((iblockdata1 = chunk.setBlockState(blockposition, iblockdata, (i2 & 0x40) != 0, (i2 & 0x400) == 0)) == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(blockposition);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(blockposition);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(blockposition, chunk, iblockdata1, iblockdata, iblockdata2, i2, j2);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(blockposition);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.B || (i2 & 4) == 0) && (this.B || chunk == null || chunk.D() != null && chunk.D().a(FullChunkStatus.c))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            }
            if ((i2 & 1) != 0) {
                this.b(blockposition, iblockdata1.b());
                if (!this.B && iblockdata.n()) {
                    this.c(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                iblockdata.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        Fluid fluid = this.b_(blockposition);
        return this.a(blockposition, fluid.g(), 3 | (flag ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        boolean flag1;
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.i()) {
            return false;
        }
        Fluid fluid = this.b_(blockposition);
        if (!(iblockdata.b() instanceof BlockFireAbstract)) {
            this.c(2001, blockposition, Block.i(iblockdata));
        }
        if (flag) {
            TileEntity tileentity = iblockdata.t() ? this.c_(blockposition) : null;
            Block.a(iblockdata, this, blockposition, tileentity, entity, ItemStack.l);
        }
        if (flag1 = this.a(blockposition, fluid.g(), 3, i2)) {
            this.a(GameEvent.f, blockposition, GameEvent.a.a(entity, iblockdata));
        }
        return flag1;
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata) {
    }

    public boolean b(BlockPosition blockposition, IBlockData iblockdata) {
        return this.a(blockposition, iblockdata, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void b(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    public void a(BlockPosition blockposition, Block block) {
    }

    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection) {
    }

    public void a(BlockPosition blockposition, Block block, BlockPosition blockposition1) {
    }

    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
    }

    @Override
    public void a(EnumDirection enumdirection, IBlockData iblockdata, BlockPosition blockposition, BlockPosition blockposition1, int i2, int j2) {
        this.s.a(enumdirection, iblockdata, blockposition, blockposition1, i2, j2);
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        int k2 = i2 >= -30000000 && j2 >= -30000000 && i2 < 30000000 && j2 < 30000000 ? (this.b(SectionPosition.a(i2), SectionPosition.a(j2)) ? this.d(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1 : this.I_()) : this.z_() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine y_() {
        return this.N().p();
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        CapturedBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (this.s(blockposition)) {
            return Blocks.nb.o();
        }
        Chunk chunk = this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
        return chunk.a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        if (this.s(blockposition)) {
            return FluidTypes.a.g();
        }
        Chunk chunk = this.m(blockposition);
        return chunk.b_(blockposition);
    }

    public boolean R() {
        return !this.D_().a() && this.e < 4;
    }

    public boolean S() {
        return !this.D_().a() && !this.R();
    }

    public void a(@Nullable Entity entity, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        EntityHuman entityhuman1;
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        this.a(entityhuman, blockposition, soundeffect, soundcategory, f2, f1);
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entityhuman, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1);
    }

    public abstract void a(@Nullable EntityHuman var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.a(entityhuman, d0, d1, d2, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, i2);
    }

    public abstract void a(@Nullable EntityHuman var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory) {
        this.a(entityhuman, d0, d1, d2, soundeffect, soundcategory, 1.0f, 1.0f);
    }

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entityhuman, d0, d1, d2, soundeffect, soundcategory, f2, f1, this.f.g());
    }

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1) {
        this.a(entityhuman, d0, d1, d2, holder, soundcategory, f2, f1, this.f.g());
    }

    public void a(@Nullable EntityHuman entityhuman, Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entityhuman, entity, BuiltInRegistries.b.e(soundeffect), soundcategory, f2, f1, this.f.g());
    }

    public void a(BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
        this.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1, flag);
    }

    public void a(Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    public void a(double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void b(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void b(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public float a(float f2) {
        float f1 = this.f(f2);
        return f1 * ((float)Math.PI * 2);
    }

    public void a(TickingBlockEntity tickingblockentity) {
        (this.b ? this.a : this.r).add(tickingblockentity);
    }

    protected void T() {
        GameProfilerFiller gameprofilerfiller = this.ag();
        gameprofilerfiller.a("blockEntities");
        this.timings.tileEntityPending.startTiming();
        this.b = true;
        if (!this.a.isEmpty()) {
            this.r.addAll(this.a);
            this.a.clear();
        }
        this.timings.tileEntityPending.stopTiming();
        this.timings.tileEntityTick.startTiming();
        boolean flag = this.s().i();
        this.tileLimiter.initTick();
        for (int tilesThisCycle = 0; tilesThisCycle < this.r.size() && (tilesThisCycle % 10 != 0 || this.tileLimiter.shouldContinue()); ++tilesThisCycle) {
            this.tileTickPosition = this.tileTickPosition < this.r.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.r.get(this.tileTickPosition);
            if (tickingblockentity.b()) {
                --tilesThisCycle;
                this.r.remove(this.tileTickPosition--);
            } else if (flag && this.n(tickingblockentity.c())) {
                tickingblockentity.a();
            }
            ++this.tileTickPosition;
        }
        this.timings.tileEntityTick.stopTiming();
        this.b = false;
        gameprofilerfiller.c();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends Entity> void a(Consumer<T> consumer, T t0) {
        try {
            SpigotTimings.tickEntityTimer.startTiming();
            consumer.accept(t0);
            SpigotTimings.tickEntityTimer.stopTiming();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking entity");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being ticked");
            t0.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    public boolean h(Entity entity) {
        return true;
    }

    public boolean a(long i2) {
        return true;
    }

    public boolean n(BlockPosition blockposition) {
        return this.a(ChunkCoordIntPair.a(blockposition));
    }

    public Explosion a(@Nullable Entity entity, double d0, double d1, double d2, float f2, a world_a) {
        return this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, false, world_a, Particles.w, Particles.v, SoundEffects.ke);
    }

    public Explosion a(@Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        return this.a(entity, Explosion.a(this, entity), null, d0, d1, d2, f2, flag, world_a, Particles.w, Particles.v, SoundEffects.ke);
    }

    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3D vec3d, float f2, boolean flag, a world_a) {
        return this.a(entity, damagesource, explosiondamagecalculator, vec3d.a(), vec3d.b(), vec3d.c(), f2, flag, world_a, Particles.w, Particles.v, SoundEffects.ke);
    }

    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        return this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, Particles.w, Particles.v, SoundEffects.ke);
    }

    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        return this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, true, particleparam, particleparam1, holder);
    }

    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a, boolean flag1, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        Explosion.Effect explosion_effect1 = switch (world_a.ordinal()) {
            case 0 -> Explosion.Effect.a;
            case 1 -> this.a(GameRules.Q);
            case 2 -> this.ab().b(GameRules.c) ? this.a(GameRules.R) : Explosion.Effect.a;
            case 3 -> this.a(GameRules.S);
            case 4 -> Explosion.Effect.d;
            case 5 -> Explosion.Effect.b;
            default -> throw new MatchException(null, null);
        };
        Explosion explosion = new Explosion(this, entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, explosion_effect1, particleparam, particleparam1, holder);
        explosion.c();
        explosion.a(flag1);
        return explosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> gamerules_gamerulekey) {
        return this.ab().b(gamerules_gamerulekey) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    public abstract String I();

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        return this.getBlockEntity(blockposition, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        if (this.capturedTileEntities.containsKey(blockposition)) {
            return this.capturedTileEntities.get(blockposition);
        }
        return this.s(blockposition) ? null : (!this.B && Thread.currentThread() != this.c ? null : this.m(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void a(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.aD_();
        if (!this.s(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.j(), tileentity);
                return;
            }
            this.m(blockposition).b(tileentity);
        }
    }

    public void o(BlockPosition blockposition) {
        if (!this.s(blockposition)) {
            this.m(blockposition).d(blockposition);
        }
    }

    public boolean p(BlockPosition blockposition) {
        return this.s(blockposition) ? false : this.N().b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public boolean a(BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
        if (this.s(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()), ChunkStatus.n, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(blockposition).a((IBlockAccess)this, blockposition, entity, enumdirection);
    }

    public boolean a(BlockPosition blockposition, Entity entity) {
        return this.a(blockposition, entity, EnumDirection.b);
    }

    public void U() {
        double d0 = 1.0 - (double)(this.d(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.b(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.a((double)MathHelper.b(this.f(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.e = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void b(boolean flag, boolean flag1) {
        this.N().a(flag, flag1);
    }

    public BlockPosition V() {
        BlockPosition blockposition = this.A.a();
        if (!this.C_().a(blockposition)) {
            blockposition = this.a(HeightMap.Type.e, BlockPosition.a(this.C_().a(), 0.0, this.C_().b()));
        }
        return blockposition;
    }

    public float W() {
        return this.A.b();
    }

    protected void X() {
        if (this.A.i()) {
            this.w = 1.0f;
            if (this.A.g()) {
                this.y = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.N().close();
    }

    @Override
    @Nullable
    public IBlockAccess c(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.n, false);
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, Predicate<? super Entity> predicate) {
        this.ag().d("getEntities");
        ArrayList list = Lists.newArrayList();
        this.G().a(axisalignedbb, (T entity1) -> {
            if (entity1 != entity && predicate.test((Entity)entity1)) {
                list.add(entity1);
            }
            if (entity1 instanceof EntityEnderDragon) {
                for (EntityComplexPart entitycomplexpart : ((EntityEnderDragon)entity1).gg()) {
                    if (entity1 == entity || !predicate.test(entitycomplexpart)) continue;
                    list.add(entitycomplexpart);
                }
            }
        });
        return list;
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, axisalignedbb, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, axisalignedbb, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.ag().d("getEntities");
        this.G().a(entitytypetest, axisalignedbb, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gg()) {
                    Entity t0 = (Entity)entitytypetest.a(entitycomplexpart);
                    if (t0 == null || !predicate.test(t0)) continue;
                    list.add((Object)t0);
                    if (list.size() < i2) continue;
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    @Nullable
    public abstract Entity a(int var1);

    public void q(BlockPosition blockposition) {
        if (this.B(blockposition)) {
            this.m(blockposition).a(true);
        }
    }

    @Override
    public int z_() {
        return 63;
    }

    public void Y() {
    }

    public long Z() {
        return this.A.c();
    }

    public long aa() {
        return this.A.d();
    }

    public boolean a(EntityHuman entityhuman, BlockPosition blockposition) {
        return true;
    }

    public void a(Entity entity, byte b0) {
    }

    public void a(Entity entity, DamageSource damagesource) {
    }

    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.a_(blockposition).a(this, blockposition, i2, j2);
    }

    @Override
    public WorldData A_() {
        return this.A;
    }

    public GameRules ab() {
        return this.A.o();
    }

    public abstract TickRateManager s();

    public float b(float f2) {
        return MathHelper.i(f2, this.x, this.y) * this.d(f2);
    }

    public void c(float f2) {
        float f1;
        this.x = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.y = f1;
    }

    public float d(float f2) {
        return MathHelper.i(f2, this.v, this.w);
    }

    public void e(float f2) {
        float f1;
        this.v = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.w = f1;
    }

    public boolean ac() {
        return this.D_().g() && !this.D_().h() ? (double)this.b(1.0f) > 0.9 : false;
    }

    public boolean ad() {
        return (double)this.d(1.0f) > 0.2;
    }

    public boolean r(BlockPosition blockposition) {
        if (!this.ad()) {
            return false;
        }
        if (!this.h(blockposition)) {
            return false;
        }
        if (this.a(HeightMap.Type.e, blockposition).v() > blockposition.v()) {
            return false;
        }
        BiomeBase biomebase = this.t(blockposition).a();
        return biomebase.a(blockposition) == BiomeBase.Precipitation.b;
    }

    @Nullable
    public abstract WorldMap a(MapId var1);

    public abstract void a(MapId var1, WorldMap var2);

    public abstract MapId v();

    public void b(int i2, BlockPosition blockposition, int j2) {
    }

    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            int i2 = this.x().size();
            return i2 + " total; " + String.valueOf(this.x());
        });
        IChunkProvider ichunkprovider = this.N();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.af().a().toString());
        try {
            this.A.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double d0, double d1, double d2, double d3, double d4, double d5, List<FireworkExplosion> list) {
    }

    public abstract Scoreboard M();

    public void c(BlockPosition blockposition, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (!this.B(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.gY)) {
                this.a(iblockdata, blockposition1, block, blockposition, false);
                continue;
            }
            if (!iblockdata.g(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.gY)) continue;
            this.a(iblockdata, blockposition1, block, blockposition, false);
        }
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition blockposition) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.B(blockposition)) {
            f2 = this.aq();
            i2 = this.m(blockposition).u();
        }
        return new DifficultyDamageScaler(this.al(), this.aa(), i2, f2);
    }

    @Override
    public int B_() {
        return this.e;
    }

    public void c(int i2) {
    }

    @Override
    public WorldBorder C_() {
        return this.F;
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager D_() {
        return this.D.a();
    }

    public Holder<DimensionManager> ae() {
        return this.D;
    }

    public ResourceKey<World> af() {
        return this.H;
    }

    @Override
    public RandomSource E_() {
        return this.z;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    public abstract CraftingManager r();

    public BlockPosition a(int i2, int j2, int k2, int l2) {
        this.t = this.t * 3 + 1013904223;
        int i1 = this.t >> 2;
        return new BlockPosition(i2 + (i1 & 0xF), j2 + (i1 >> 16 & l2), k2 + (i1 >> 8 & 0xF));
    }

    public boolean t() {
        return false;
    }

    public GameProfilerFiller ag() {
        return this.E.get();
    }

    public Supplier<GameProfilerFiller> ah() {
        return this.E;
    }

    @Override
    public BiomeManager F_() {
        return this.G;
    }

    public final boolean ai() {
        return this.d;
    }

    public abstract LevelEntityGetter<Entity> G();

    @Override
    public long G_() {
        return this.K++;
    }

    @Override
    public IRegistryCustom H_() {
        return this.I;
    }

    public DamageSources aj() {
        return this.J;
    }

    public abstract PotionBrewer K();

    public static enum a implements INamable
    {
        a("none"),
        b("block"),
        c("mob"),
        d("tnt"),
        e("trigger"),
        STANDARD("standard");

        public static final Codec<a> f;
        private final String g;

        private a(String s2) {
            this.g = s2;
        }

        @Override
        public String c() {
            return this.g;
        }

        static {
            f = INamable.a(a::values);
        }
    }
}

