/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockCampfire
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<BlockCampfire> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(blockcampfire -> blockcampfire.i), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(blockcampfire -> blockcampfire.j), BlockCampfire.u()).apply((Applicative)instance, BlockCampfire::new));
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BlockStateBoolean c = BlockProperties.r;
    public static final BlockStateBoolean d = BlockProperties.y;
    public static final BlockStateBoolean e = BlockProperties.C;
    public static final BlockStateDirection f = BlockProperties.R;
    private static final VoxelShape g = Block.a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);
    private static final int h = 5;
    private final boolean i;
    private final int j;

    public MapCodec<BlockCampfire> a() {
        return a;
    }

    public BlockCampfire(boolean flag, int i2, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.i = flag;
        this.j = i2;
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(c, true)).a(d, false)).a(e, false)).a(f, EnumDirection.c));
    }

    @Override
    protected ItemInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        ItemStack itemstack1;
        TileEntityCampfire tileentitycampfire;
        Optional<RecipeHolder<RecipeCampfire>> optional;
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof TileEntityCampfire && (optional = (tileentitycampfire = (TileEntityCampfire)tileentity).b(itemstack1 = entityhuman.b(enumhand))).isPresent()) {
            if (!world.B && tileentitycampfire.a(entityhuman, itemstack1, optional.get().b().d())) {
                entityhuman.a(StatisticList.av);
                return ItemInteractionResult.a;
            }
            return ItemInteractionResult.b;
        }
        return ItemInteractionResult.d;
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
        if (iblockdata.c(c).booleanValue() && entity instanceof EntityLiving) {
            entity.a(world.aj().b().directBlock(world, blockposition), (float)this.j);
        }
        super.a(iblockdata, world, blockposition, entity);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.a(iblockdata1.b())) {
            TileEntity tileentity = world.c_(blockposition);
            if (tileentity instanceof TileEntityCampfire) {
                InventoryUtils.a(world, blockposition, ((TileEntityCampfire)tileentity).b());
            }
            super.a(iblockdata, world, blockposition, iblockdata1, flag);
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        BlockPosition blockposition;
        World world = blockactioncontext.q();
        boolean flag = world.b_(blockposition = blockactioncontext.a()).a() == FluidTypes.c;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.o().a(e, flag)).a(d, this.m(world.a_(blockposition.e())))).a(c, !flag)).a(f, blockactioncontext.g());
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(e).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        return enumdirection == EnumDirection.a ? (IBlockData)iblockdata.a(d, this.m(iblockdata1)) : super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    private boolean m(IBlockData iblockdata) {
        return iblockdata.a(Blocks.ij);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return b;
    }

    @Override
    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.c;
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(c).booleanValue()) {
            if (randomsource.a(10) == 0) {
                world.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.dI, SoundCategory.e, 0.5f + randomsource.i(), randomsource.i() * 0.7f + 0.6f, false);
            }
            if (this.i && randomsource.a(5) == 0) {
                for (int i2 = 0; i2 < randomsource.a(1) + 1; ++i2) {
                    world.a(Particles.Y, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, (double)(randomsource.i() / 2.0f), 5.0E-5, randomsource.i() / 2.0f);
                }
            }
        }
    }

    public static void a(@Nullable Entity entity, GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileentity;
        if (generatoraccess.x_()) {
            for (int i2 = 0; i2 < 20; ++i2) {
                BlockCampfire.a((World)generatoraccess, blockposition, iblockdata.c(d), true);
            }
        }
        if ((tileentity = generatoraccess.c_(blockposition)) instanceof TileEntityCampfire) {
            ((TileEntityCampfire)tileentity).d();
        }
        generatoraccess.a(entity, GameEvent.c, blockposition);
    }

    @Override
    public boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid) {
        if (!iblockdata.c(BlockProperties.C).booleanValue() && fluid.a() == FluidTypes.c) {
            boolean flag = iblockdata.c(c);
            if (flag) {
                if (!generatoraccess.x_()) {
                    generatoraccess.a((EntityHuman)null, blockposition, SoundEffects.kf, SoundCategory.e, 1.0f, 1.0f);
                }
                BlockCampfire.a((Entity)null, generatoraccess, blockposition, iblockdata);
            }
            generatoraccess.a(blockposition, (IBlockData)((IBlockData)iblockdata.a(e, true)).a(c, false), 3);
            generatoraccess.a(blockposition, fluid.a(), fluid.a().a(generatoraccess));
            return true;
        }
        return false;
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        BlockPosition blockposition = movingobjectpositionblock.a();
        if (!world.B && iprojectile.bR() && iprojectile.a(world, blockposition) && !iblockdata.c(c).booleanValue() && !iblockdata.c(e).booleanValue()) {
            if (CraftEventFactory.callBlockIgniteEvent(world, blockposition, iprojectile).isCancelled()) {
                return;
            }
            world.a(blockposition, (IBlockData)iblockdata.a(BlockProperties.r, true), 11);
        }
    }

    public static void a(World world, BlockPosition blockposition, boolean flag, boolean flag1) {
        RandomSource randomsource = world.E_();
        ParticleType particletype = flag ? Particles.au : Particles.at;
        world.b(particletype, true, (double)blockposition.u() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), (double)blockposition.v() + randomsource.j() + randomsource.j(), (double)blockposition.w() + 0.5 + randomsource.j() / 3.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.07, 0.0);
        if (flag1) {
            world.a(Particles.ae, (double)blockposition.u() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), (double)blockposition.v() + 0.4, (double)blockposition.w() + 0.5 + randomsource.j() / 4.0 * (double)(randomsource.h() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean a(World world, BlockPosition blockposition) {
        for (int i2 = 1; i2 <= 5; ++i2) {
            BlockPosition blockposition1 = blockposition.c(i2);
            IBlockData iblockdata = world.a_(blockposition1);
            if (BlockCampfire.g(iblockdata)) {
                return true;
            }
            boolean flag = VoxelShapes.c(g, iblockdata.b((IBlockAccess)world, blockposition, VoxelShapeCollision.a()), OperatorBoolean.i);
            if (!flag) continue;
            IBlockData iblockdata1 = world.a_(blockposition1.e());
            return BlockCampfire.g(iblockdata1);
        }
        return false;
    }

    public static boolean g(IBlockData iblockdata) {
        return iblockdata.b(c) && iblockdata.a(TagsBlock.aW) && iblockdata.c(c) != false;
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(e) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.a(f, enumblockrotation.a(iblockdata.c(f)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a(iblockdata.c(f)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(c, d, e, f);
    }

    @Override
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityCampfire(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return world.B ? (iblockdata.c(c).booleanValue() ? BlockCampfire.a(tileentitytypes, TileEntityTypes.G, TileEntityCampfire::c) : null) : (iblockdata.c(c) != false ? BlockCampfire.a(tileentitytypes, TileEntityTypes.G, TileEntityCampfire::a) : BlockCampfire.a(tileentitytypes, TileEntityTypes.G, TileEntityCampfire::b));
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    public static boolean h(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.aW, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(e) && blockbase_blockdata.b(c)) && iblockdata.c(e) == false && iblockdata.c(c) == false;
    }
}

