/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockChest
extends BlockChestAbstract<TileEntityChest>
implements IBlockWaterlogged {
    public static final MapCodec<BlockChest> b = BlockChest.b(blockbase_info -> new BlockChest((BlockBase.Info)blockbase_info, () -> TileEntityTypes.b));
    public static final BlockStateDirection c = BlockFacingHorizontal.aE;
    public static final BlockStateEnum<BlockPropertyChestType> d = BlockProperties.bc;
    public static final BlockStateBoolean e = BlockProperties.C;
    public static final int f = 1;
    protected static final int g = 1;
    protected static final int h = 14;
    protected static final VoxelShape i = Block.a(1.0, 0.0, 0.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape j = Block.a(1.0, 0.0, 1.0, 15.0, 14.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape l = Block.a(1.0, 0.0, 1.0, 16.0, 14.0, 15.0);
    protected static final VoxelShape m = Block.a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>> n = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>>(){

        @Override
        public Optional<IInventory> a(TileEntityChest tileentitychest, TileEntityChest tileentitychest1) {
            return Optional.of(new InventoryLargeChest(tileentitychest, tileentitychest1));
        }

        @Override
        public Optional<IInventory> a(TileEntityChest tileentitychest) {
            return Optional.of(tileentitychest);
        }

        public Optional<IInventory> a() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>> o = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>>(){

        @Override
        public Optional<ITileInventory> a(TileEntityChest tileentitychest, TileEntityChest tileentitychest1) {
            InventoryLargeChest inventorylargechest = new InventoryLargeChest(tileentitychest, tileentitychest1);
            return Optional.of(new DoubleInventory(tileentitychest, tileentitychest1, inventorylargechest));
        }

        @Override
        public Optional<ITileInventory> a(TileEntityChest tileentitychest) {
            return Optional.of(tileentitychest);
        }

        public Optional<ITileInventory> a() {
            return Optional.empty();
        }
    };

    @Override
    public MapCodec<? extends BlockChest> a() {
        return b;
    }

    protected BlockChest(BlockBase.Info blockbase_info, Supplier<TileEntityTypes<? extends TileEntityChest>> supplier) {
        super(blockbase_info, supplier);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(c, EnumDirection.c)).a(d, BlockPropertyChestType.a)).a(e, false));
    }

    public static DoubleBlockFinder.BlockType g(IBlockData iblockdata) {
        BlockPropertyChestType blockpropertychesttype = iblockdata.c(d);
        return blockpropertychesttype == BlockPropertyChestType.a ? DoubleBlockFinder.BlockType.a : (blockpropertychesttype == BlockPropertyChestType.c ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c);
    }

    @Override
    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.b;
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(e).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        if (iblockdata1.a(this) && enumdirection.o().d()) {
            BlockPropertyChestType blockpropertychesttype = iblockdata1.c(d);
            if (iblockdata.c(d) == BlockPropertyChestType.a && blockpropertychesttype != BlockPropertyChestType.a && iblockdata.c(c) == iblockdata1.c(c) && BlockChest.h(iblockdata1) == enumdirection.g()) {
                return (IBlockData)iblockdata.a(d, blockpropertychesttype.a());
            }
        } else if (BlockChest.h(iblockdata) == enumdirection) {
            return (IBlockData)iblockdata.a(d, BlockPropertyChestType.a);
        }
        return super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        if (iblockdata.c(d) == BlockPropertyChestType.a) {
            return m;
        }
        switch (BlockChest.h(iblockdata)) {
            default: {
                return i;
            }
            case d: {
                return j;
            }
            case e: {
                return k;
            }
            case f: 
        }
        return l;
    }

    public static EnumDirection h(IBlockData iblockdata) {
        EnumDirection enumdirection = iblockdata.c(c);
        return iblockdata.c(d) == BlockPropertyChestType.b ? enumdirection.h() : enumdirection.i();
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection2;
        BlockPropertyChestType blockpropertychesttype = BlockPropertyChestType.a;
        EnumDirection enumdirection = blockactioncontext.g().g();
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        boolean flag = blockactioncontext.h();
        EnumDirection enumdirection1 = blockactioncontext.k();
        if (enumdirection1.o().d() && flag && (enumdirection2 = this.a(blockactioncontext, enumdirection1.g())) != null && enumdirection2.o() != enumdirection1.o()) {
            enumdirection = enumdirection2;
            BlockPropertyChestType blockPropertyChestType = blockpropertychesttype = enumdirection2.i() == enumdirection1.g() ? BlockPropertyChestType.c : BlockPropertyChestType.b;
        }
        if (blockpropertychesttype == BlockPropertyChestType.a && !flag) {
            if (enumdirection == this.a(blockactioncontext, enumdirection.h())) {
                blockpropertychesttype = BlockPropertyChestType.b;
            } else if (enumdirection == this.a(blockactioncontext, enumdirection.i())) {
                blockpropertychesttype = BlockPropertyChestType.c;
            }
        }
        return (IBlockData)((IBlockData)((IBlockData)this.o().a(c, enumdirection)).a(d, blockpropertychesttype)).a(e, fluid.a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(e) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Nullable
    private EnumDirection a(BlockActionContext blockactioncontext, EnumDirection enumdirection) {
        IBlockData iblockdata = blockactioncontext.q().a_(blockactioncontext.a().a(enumdirection));
        return iblockdata.a(this) && iblockdata.c(d) == BlockPropertyChestType.a ? iblockdata.c(c) : null;
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        InventoryUtils.a(iblockdata, iblockdata1, world, blockposition);
        super.a(iblockdata, world, blockposition, iblockdata1, flag);
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        ITileInventory itileinventory = this.b(iblockdata, world, blockposition);
        if (itileinventory != null) {
            entityhuman.a(itileinventory);
            entityhuman.b(this.c());
            PiglinAI.a(entityhuman, true);
        }
        return EnumInteractionResult.c;
    }

    protected Statistic<MinecraftKey> c() {
        return StatisticList.i.b(StatisticList.ao);
    }

    public TileEntityTypes<? extends TileEntityChest> d() {
        return (TileEntityTypes)this.a.get();
    }

    @Nullable
    public static IInventory a(BlockChest blockchest, IBlockData iblockdata, World world, BlockPosition blockposition, boolean flag) {
        return blockchest.a(iblockdata, world, blockposition, flag).apply(n).orElse(null);
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> a(IBlockData iblockdata, World world, BlockPosition blockposition, boolean flag) {
        BiPredicate<GeneratorAccess, BlockPosition> bipredicate = flag ? (generatoraccess, blockposition1) -> false : BlockChest::a;
        return DoubleBlockFinder.a((TileEntityTypes)this.a.get(), BlockChest::g, BlockChest::h, c, iblockdata, world, blockposition, bipredicate);
    }

    @Override
    @Nullable
    protected ITileInventory b(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return this.getMenuProvider(iblockdata, world, blockposition, false);
    }

    @Nullable
    public ITileInventory getMenuProvider(IBlockData iblockdata, World world, BlockPosition blockposition, boolean ignoreObstructions) {
        return this.a(iblockdata, world, blockposition, ignoreObstructions).apply(o).orElse(null);
    }

    public static DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction> a(final LidBlockEntity lidblockentity) {
        return new DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction a(TileEntityChest tileentitychest, TileEntityChest tileentitychest1) {
                return f2 -> Math.max(tileentitychest.a(f2), tileentitychest1.a(f2));
            }

            @Override
            public Float2FloatFunction a(TileEntityChest tileentitychest) {
                Objects.requireNonNull(tileentitychest);
                return tileentitychest::a;
            }

            public Float2FloatFunction a() {
                LidBlockEntity lidblockentity1 = lidblockentity;
                Objects.requireNonNull(lidblockentity);
                return lidblockentity1::a;
            }
        };
    }

    @Override
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityChest(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return world.B ? BlockChest.a(tileentitytypes, this.d(), TileEntityChest::a) : null;
    }

    public static boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        return BlockChest.a((IBlockAccess)generatoraccess, blockposition) || BlockChest.b(generatoraccess, blockposition);
    }

    private static boolean a(IBlockAccess iblockaccess, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.d();
        return iblockaccess.a_(blockposition1).g(iblockaccess, blockposition1);
    }

    private static boolean b(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        List<EntityCat> list = generatoraccess.a(EntityCat.class, new AxisAlignedBB(blockposition.u(), blockposition.v() + 1, blockposition.w(), blockposition.u() + 1, blockposition.v() + 2, blockposition.w() + 1));
        if (!list.isEmpty()) {
            for (EntityCat entitycat : list) {
                if (!entitycat.x()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean c_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return Container.b(BlockChest.a(this, iblockdata, world, blockposition, false));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.a(c, enumblockrotation.a(iblockdata.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a(iblockdata.c(c)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(c, d, e);
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        TileEntity tileentity = worldserver.c_(blockposition);
        if (tileentity instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).l();
        }
    }

    public static class DoubleInventory
    implements ITileInventory {
        private final TileEntityChest tileentitychest;
        private final TileEntityChest tileentitychest1;
        public final InventoryLargeChest inventorylargechest;

        public DoubleInventory(TileEntityChest tileentitychest, TileEntityChest tileentitychest1, InventoryLargeChest inventorylargechest) {
            this.tileentitychest = tileentitychest;
            this.tileentitychest1 = tileentitychest1;
            this.inventorylargechest = inventorylargechest;
        }

        @Override
        @Nullable
        public Container createMenu(int i2, PlayerInventory playerinventory, EntityHuman entityhuman) {
            if (this.tileentitychest.d(entityhuman) && this.tileentitychest1.d(entityhuman)) {
                this.tileentitychest.e_(playerinventory.l);
                this.tileentitychest1.e_(playerinventory.l);
                return ContainerChest.b(i2, playerinventory, this.inventorylargechest);
            }
            return null;
        }

        @Override
        public IChatBaseComponent S_() {
            return this.tileentitychest.ai() ? this.tileentitychest.S_() : (this.tileentitychest1.ai() ? this.tileentitychest1.S_() : IChatBaseComponent.c("container.chestDouble"));
        }
    }
}

