/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockSoulFire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BlockFireAbstract
extends Block {
    private static final int c = 8;
    private final float d;
    protected static final float a = 1.0f;
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BlockFireAbstract(BlockBase.Info blockbase_info, float f2) {
        super(blockbase_info);
        this.d = f2;
    }

    protected abstract MapCodec<? extends BlockFireAbstract> a();

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        return BlockFireAbstract.a(blockactioncontext.q(), blockactioncontext.a());
    }

    public static IBlockData a(IBlockAccess iblockaccess, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata = iblockaccess.a_(blockposition1);
        return BlockSoulFire.m(iblockdata) ? Blocks.cs.o() : ((BlockFire)Blocks.cr).b(iblockaccess, blockposition);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return b;
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        block12: {
            block11: {
                double d2;
                double d1;
                double d0;
                int i2;
                BlockPosition blockposition1;
                IBlockData iblockdata1;
                if (randomsource.a(24) == 0) {
                    world.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.iT, SoundCategory.e, 1.0f + randomsource.i(), randomsource.i() * 0.7f + 0.3f, false);
                }
                if (this.f(iblockdata1 = world.a_(blockposition1 = blockposition.e())) || iblockdata1.d(world, blockposition1, EnumDirection.b)) break block11;
                if (this.f(world.a_(blockposition.h()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)blockposition.u() + randomsource.j() * (double)0.1f;
                        d1 = (double)blockposition.v() + randomsource.j();
                        d2 = (double)blockposition.w() + randomsource.j();
                        world.a(Particles.X, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.f(world.a_(blockposition.i()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)(blockposition.u() + 1) - randomsource.j() * (double)0.1f;
                        d1 = (double)blockposition.v() + randomsource.j();
                        d2 = (double)blockposition.w() + randomsource.j();
                        world.a(Particles.X, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.f(world.a_(blockposition.f()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)blockposition.u() + randomsource.j();
                        d1 = (double)blockposition.v() + randomsource.j();
                        d2 = (double)blockposition.w() + randomsource.j() * (double)0.1f;
                        world.a(Particles.X, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.f(world.a_(blockposition.g()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)blockposition.u() + randomsource.j();
                        d1 = (double)blockposition.v() + randomsource.j();
                        d2 = (double)(blockposition.w() + 1) - randomsource.j() * (double)0.1f;
                        world.a(Particles.X, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.f(world.a_(blockposition.d()))) break block12;
                for (i2 = 0; i2 < 2; ++i2) {
                    d0 = (double)blockposition.u() + randomsource.j();
                    d1 = (double)(blockposition.v() + 1) - randomsource.j() * (double)0.1f;
                    d2 = (double)blockposition.w() + randomsource.j();
                    world.a(Particles.X, d0, d1, d2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i3 = 0; i3 < 3; ++i3) {
                double d0 = (double)blockposition.u() + randomsource.j();
                double d1 = (double)blockposition.v() + randomsource.j() * 0.5 + 0.5;
                double d2 = (double)blockposition.w() + randomsource.j();
                world.a(Particles.X, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean f(IBlockData var1);

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (!entity.be()) {
            entity.h(entity.aC() + 1);
            if (entity.aC() == 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Entity)entity.getBukkitEntity(), 8.0f);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        entity.a(world.aj().a(), this.d);
        super.a(iblockdata, world, blockposition, entity);
    }

    @Override
    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext context) {
        if (!iblockdata1.a(iblockdata.b())) {
            Optional<BlockPortalShape> optional;
            if (BlockFireAbstract.a(world) && (optional = BlockPortalShape.a(world, blockposition, EnumDirection.EnumAxis.a)).isPresent()) {
                optional.get().createPortalBlocks(context == null ? null : context.o());
                return;
            }
            if (!iblockdata.a((IWorldReader)world, blockposition)) {
                this.fireExtinguished(world, blockposition);
            }
        }
    }

    private static boolean a(World world) {
        return world.getTypeKey() == WorldDimension.b || world.getTypeKey() == WorldDimension.c;
    }

    @Override
    protected void a(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata) {
    }

    @Override
    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        if (!world.x_()) {
            world.a((EntityHuman)null, 1009, blockposition, 0);
        }
        return super.a(world, blockposition, iblockdata, entityhuman);
    }

    public static boolean a(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        IBlockData iblockdata = world.a_(blockposition);
        return !iblockdata.i() ? false : BlockFireAbstract.a(world, blockposition).a((IWorldReader)world, blockposition) || BlockFireAbstract.b(world, blockposition, enumdirection);
    }

    private static boolean b(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        if (!BlockFireAbstract.a(world)) {
            return false;
        }
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        boolean flag = false;
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (!world.a_(blockposition_mutableblockposition.g(blockposition).c(enumdirection1)).a(Blocks.co)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o().d() ? enumdirection.i().o() : EnumDirection.EnumDirectionLimit.a.b(world.z);
        return BlockPortalShape.a(world, blockposition, enumdirection_enumaxis).isPresent();
    }

    protected void fireExtinguished(GeneratorAccess world, BlockPosition position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.a.o()).isCancelled()) {
            world.a(position, false);
        }
    }
}

