/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.TreeType;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockMushroom
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockMushroom> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.aI).fieldOf("feature").forGetter(blockmushroom -> blockmushroom.d), BlockMushroom.u()).apply((Applicative)instance, BlockMushroom::new));
    protected static final float b = 3.0f;
    protected static final VoxelShape c = Block.a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final ResourceKey<WorldGenFeatureConfigured<?, ?>> d;

    public MapCodec<BlockMushroom> a() {
        return a;
    }

    public BlockMushroom(ResourceKey<WorldGenFeatureConfigured<?, ?>> resourcekey, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.d = resourcekey;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return c;
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (randomsource.i() < (float)worldserver.spigotConfig.mushroomModifier / 2500.0f) {
            int i2 = 5;
            boolean flag = true;
            for (BlockPosition blockposition1 : BlockPosition.c(blockposition.b(-4, -1, -4), blockposition.b(4, 1, 4))) {
                if (!worldserver.a_(blockposition1).a(this) || --i2 > 0) continue;
                return;
            }
            BlockPosition blockposition2 = blockposition.b(randomsource.a(3) - 1, randomsource.a(2) - randomsource.a(2), randomsource.a(3) - 1);
            for (int j2 = 0; j2 < 4; ++j2) {
                if (worldserver.u(blockposition2) && iblockdata.a((IWorldReader)worldserver, blockposition2)) {
                    blockposition = blockposition2;
                }
                blockposition2 = blockposition.b(randomsource.a(3) - 1, randomsource.a(2) - randomsource.a(2), randomsource.a(3) - 1);
            }
            if (worldserver.u(blockposition2) && iblockdata.a((IWorldReader)worldserver, blockposition2)) {
                CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition2, iblockdata, 2);
            }
        }
    }

    @Override
    protected boolean b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.i(iblockaccess, blockposition);
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata1 = iworldreader.a_(blockposition1);
        return iblockdata1.a(TagsBlock.bb) ? true : iworldreader.b(blockposition, 0) < 13 && this.b(iblockdata1, iworldreader, blockposition1);
    }

    public boolean a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, RandomSource randomsource) {
        Optional<Holder.c<WorldGenFeatureConfigured<?, ?>>> optional = worldserver.H_().d(Registries.aI).b(this.d);
        if (optional.isEmpty()) {
            return false;
        }
        worldserver.a(blockposition, false);
        TreeType treeType = BlockSapling.treeType = this == Blocks.cf ? TreeType.BROWN_MUSHROOM : TreeType.RED_MUSHROOM;
        if (((WorldGenFeatureConfigured)((Holder)optional.get()).a()).a(worldserver, worldserver.l().g(), randomsource, blockposition)) {
            return true;
        }
        worldserver.a(blockposition, iblockdata, 3);
        return false;
    }

    @Override
    public boolean b(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public boolean a(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return (double)randomsource.i() < 0.4;
    }

    @Override
    public void a(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        this.a(worldserver, blockposition, iblockdata, randomsource);
    }
}

