/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<BlockTrapdoor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(blocktrapdoor -> blocktrapdoor.m), BlockTrapdoor.u()).apply((Applicative)instance, BlockTrapdoor::new));
    public static final BlockStateBoolean b = BlockProperties.u;
    public static final BlockStateEnum<BlockPropertyHalf> c = BlockProperties.af;
    public static final BlockStateBoolean d = BlockProperties.w;
    public static final BlockStateBoolean e = BlockProperties.C;
    protected static final int f = 3;
    protected static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape h = Block.a(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape l = Block.a(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private final BlockSetType m;

    public MapCodec<? extends BlockTrapdoor> a() {
        return a;
    }

    protected BlockTrapdoor(BlockSetType blocksettype, BlockBase.Info blockbase_info) {
        super(blockbase_info.a(blocksettype.g()));
        this.m = blocksettype;
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(aE, EnumDirection.c)).a(b, false)).a(c, BlockPropertyHalf.b)).a(d, false)).a(e, false));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        if (!iblockdata.c(b).booleanValue()) {
            return iblockdata.c(c) == BlockPropertyHalf.a ? l : k;
        }
        switch (iblockdata.c(aE)) {
            default: {
                return j;
            }
            case d: {
                return i;
            }
            case e: {
                return h;
            }
            case f: 
        }
        return g;
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        switch (pathmode) {
            case a: {
                return iblockdata.c(b);
            }
            case b: {
                return iblockdata.c(e);
            }
            case c: {
                return iblockdata.c(b);
            }
        }
        return false;
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (!this.m.c()) {
            return EnumInteractionResult.e;
        }
        this.b(iblockdata, world, blockposition, entityhuman);
        return EnumInteractionResult.a(world.B);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.n() && this.m.d() && !iblockdata.c(d).booleanValue()) {
            this.b(iblockdata, world, blockposition, (EntityHuman)null);
        }
        super.a(iblockdata, world, blockposition, explosion, biconsumer);
    }

    private void b(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable EntityHuman entityhuman) {
        IBlockData iblockdata1 = (IBlockData)iblockdata.a(b);
        world.a(blockposition, iblockdata1, 2);
        if (iblockdata1.c(e).booleanValue()) {
            world.a(blockposition, FluidTypes.c, FluidTypes.c.a((IWorldReader)world));
        }
        this.a(entityhuman, world, blockposition, iblockdata1.c(b));
    }

    protected void a(@Nullable EntityHuman entityhuman, World world, BlockPosition blockposition, boolean flag) {
        world.a(entityhuman, blockposition, flag ? this.m.k() : this.m.j(), SoundCategory.e, 1.0f, world.E_().i() * 0.1f + 0.9f);
        world.a((Entity)entityhuman, flag ? GameEvent.h : GameEvent.d, blockposition);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        boolean flag1;
        if (!world.B && (flag1 = world.C(blockposition)) != iblockdata.c(d)) {
            CraftWorld bworld = world.getWorld();
            org.bukkit.block.Block bblock = bworld.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            int power = bblock.getBlockPower();
            int oldPower = iblockdata.c(b) != false ? 15 : 0;
            if (oldPower == 0 ^ power == 0 || block.o().m()) {
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bblock, oldPower, power);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (iblockdata.c(b) != flag1) {
                iblockdata = (IBlockData)iblockdata.a(b, flag1);
                this.a((EntityHuman)null, world, blockposition, flag1);
            }
            world.a(blockposition, (IBlockData)iblockdata.a(d, flag1), 2);
            if (iblockdata.c(e).booleanValue()) {
                world.a(blockposition, FluidTypes.c, FluidTypes.c.a((IWorldReader)world));
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = this.o();
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        EnumDirection enumdirection = blockactioncontext.k();
        iblockdata = !blockactioncontext.c() && enumdirection.o().d() ? (IBlockData)((IBlockData)iblockdata.a(aE, enumdirection)).a(c, blockactioncontext.l().d - (double)blockactioncontext.a().v() > 0.5 ? BlockPropertyHalf.a : BlockPropertyHalf.b) : (IBlockData)((IBlockData)iblockdata.a(aE, blockactioncontext.g().g())).a(c, enumdirection == EnumDirection.b ? BlockPropertyHalf.b : BlockPropertyHalf.a);
        if (blockactioncontext.q().C(blockactioncontext.a())) {
            iblockdata = (IBlockData)((IBlockData)iblockdata.a(b, true)).a(d, true);
        }
        return (IBlockData)iblockdata.a(e, fluid.a() == FluidTypes.c);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(aE, b, c, d, e);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(e) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(e).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        return super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    protected BlockSetType m() {
        return this.m;
    }
}

